/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.database.sqlite.SQLiteStatement;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.android.sqlite.KriptonDatabaseWrapper;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.exceptions.PropertyNotFoundException;
import com.abubusoft.kripton.processor.sqlite.GenericSQLHelper;
import com.abubusoft.kripton.processor.sqlite.ModifyBeanHelper;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.SqlModifyBuilder;
import com.abubusoft.kripton.processor.sqlite.SqlUtility;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplaceVariableStatementListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;

public class ModifyRawHelper
implements SqlModifyBuilder.ModifyCodeGenerator {
    @Override
    public void generate(TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, boolean updateMode, SQLiteModelMethod method, TypeName returnType) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        SQLiteEntity entity = method.getEntity();
        String whereCondition = ModifyRawHelper.extractWhereConditions(updateMode, method);
        SqlUtility.extractParametersFromString(method.jql.value, method, entity);
        Pair<String, List<Pair<String, TypeName>>> where = SqlUtility.extractParametersFromString(whereCondition, method, entity);
        List<Pair<String, TypeName>> methodParams = method.getParameters();
        List<Pair<String, TypeName>> updateableParams = new ArrayList<Pair<String, TypeName>>();
        ArrayList<Pair<String, TypeName>> whereParams = new ArrayList<Pair<String, TypeName>>();
        for (Pair<String, TypeName> pair : methodParams) {
            String name = method.findParameterAliasByName((String)pair.value0);
            if (method.isThisDynamicWhereConditionsName(name) || method.isThisDynamicWhereArgsName(name)) continue;
            if (((List)where.value1).contains(new Pair((Object)name, pair.value1))) {
                whereParams.add(pair);
                continue;
            }
            updateableParams.add(pair);
        }
        if (method.jql.hasDynamicParts() || method.jql.containsSelectOperation) {
            methodBuilder.addStatement("$T _contentValues=contentValuesForUpdate()", new Object[]{KriptonContentValues.class});
        } else {
            String psName = method.buildPreparedStatementName();
            classBuilder.addField(FieldSpec.builder((TypeName)TypeName.get(SQLiteStatement.class), (String)psName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build());
            methodBuilder.beginControlFlow("if ($L==null)", new Object[]{psName});
            SqlBuilderHelper.generateSQLForStaticQuery(method, methodBuilder);
            methodBuilder.addStatement("$L = $T.compile(_context, _sql)", new Object[]{psName, KriptonDatabaseWrapper.class});
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$T _contentValues=contentValuesForUpdate($L)", new Object[]{KriptonContentValues.class, psName});
        }
        if (method.jql.containsSelectOperation) {
            this.generateJavaDoc(method, methodBuilder, updateMode);
            GenericSQLHelper.generateGenericExecSQL(methodBuilder, method);
        } else {
            this.generateJavaDoc(method, methodBuilder, updateMode, whereCondition, where, methodParams);
            if (updateMode) {
                updateableParams = SqlBuilderHelper.orderContentValues(method, updateableParams);
                for (Pair pair : updateableParams) {
                    String resolvedParamName = method.findParameterAliasByName((String)pair.value0);
                    SQLProperty property = (SQLProperty)entity.get(resolvedParamName);
                    if (property == null) {
                        throw new PropertyNotFoundException(method, resolvedParamName, (TypeName)pair.value1);
                    }
                    TypeUtility.checkTypeCompatibility(method, (Pair<String, TypeName>)pair, property);
                    if (method.isLogEnabled()) {
                        methodBuilder.addCode("_contentValues.put($S, ", new Object[]{property.columnName});
                    } else {
                        methodBuilder.addCode("_contentValues.put(", new Object[0]);
                    }
                    SQLTransformer.javaMethodParam2ContentValues(methodBuilder, method, (String)pair.value0, TypeUtility.typeName(property.getElement()), property);
                    methodBuilder.addCode(");\n", new Object[0]);
                }
                methodBuilder.addCode("\n", new Object[0]);
            } else if (updateableParams.size() > 0) {
                String separator = "";
                StringBuilder stringBuilder = new StringBuilder();
                for (Pair<String, TypeName> item : updateableParams) {
                    String resolvedParamName = method.findParameterAliasByName((String)item.value0);
                    stringBuilder.append(separator + resolvedParamName);
                    separator = ", ";
                }
                if (updateableParams.size() > 1) {
                    throw new InvalidMethodSignException(method, " parameters " + stringBuilder.toString() + " are not used in where conditions");
                }
                throw new InvalidMethodSignException(method, " parameter " + stringBuilder.toString() + " is not used in where conditions");
            }
            ModifyRawHelper.generateWhereCondition(methodBuilder, method, where);
            methodBuilder.addCode("\n", new Object[0]);
            ModifyBeanHelper.generateModifyQueryCommonPart(method, classBuilder, methodBuilder);
            if (daoDefinition.hasLiveData()) {
                methodBuilder.addComment("support for livedata", new Object[0]);
                methodBuilder.addStatement("registryEvent(result)", new Object[0]);
            }
            if (returnType != TypeName.VOID) {
                if (ModifyRawHelper.isIn(returnType, Boolean.TYPE, Boolean.class)) {
                    methodBuilder.addStatement("return result!=0", new Object[0]);
                } else if (ModifyRawHelper.isIn(returnType, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class)) {
                    methodBuilder.addStatement("return result", new Object[0]);
                } else {
                    throw new InvalidMethodSignException(method, "invalid return type");
                }
            }
        }
    }

    private void generateJavaDoc(final SQLiteModelMethod method, MethodSpec.Builder methodBuilder, boolean updateMode) {
        TypeName returnType;
        List<Pair<String, TypeName>> methodParams = method.getParameters();
        final ArrayList updatedProperties = new ArrayList();
        final ArrayList methodParamsUsedAsParameter = new ArrayList();
        String sqlModify = JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnNameToUpdate(String columnName) {
                SQLProperty tempProperty = (SQLProperty)this.currentEntity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                updatedProperties.add(tempProperty);
                return tempProperty.columnName;
            }

            @Override
            public String onColumnName(String columnName) {
                SQLProperty tempProperty = (SQLProperty)this.currentEntity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                String resolvedParamName = method.findParameterNameByAlias(bindParameterName);
                AssertKripton.assertTrueOrUnknownParamInJQLException(resolvedParamName != null, method, bindParameterName);
                methodParamsUsedAsParameter.add(new Pair((Object)resolvedParamName, (Object)method.findParameterType(resolvedParamName)));
                return SqlAnalyzer.PARAM_PREFIX + bindParameterName + SqlAnalyzer.PARAM_SUFFIX;
            }
        });
        if (updateMode) {
            methodBuilder.addJavadoc("<h2>SQL update</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<pre>$L</pre>\n", new Object[]{sqlModify});
            methodBuilder.addJavadoc("\n", new Object[0]);
            methodBuilder.addJavadoc("<h2>Updated columns:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<ul>\n", new Object[0]);
            for (SQLProperty sQLProperty : updatedProperties) {
                methodBuilder.addJavadoc("\t<li>$L</li>\n", new Object[]{sQLProperty.columnName});
            }
            methodBuilder.addJavadoc("</ul>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        } else {
            methodBuilder.addJavadoc("<h2>SQL delete</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<pre>$L</pre>\n", new Object[]{sqlModify});
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        methodBuilder.addJavadoc("<h2>Parameters:</h2>\n", new Object[0]);
        methodBuilder.addJavadoc("<dl>\n", new Object[0]);
        for (Pair pair : methodParamsUsedAsParameter) {
            String rawName = method.findParameterNameByAlias((String)pair.value0);
            methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{SqlAnalyzer.PARAM_PREFIX + (String)pair.value0 + SqlAnalyzer.PARAM_SUFFIX});
            methodBuilder.addJavadoc("<dd>is mapped to method's parameter <strong>$L</strong></dd>\n", new Object[]{rawName});
        }
        methodBuilder.addJavadoc("</dl>", new Object[0]);
        methodBuilder.addJavadoc("\n\n", new Object[0]);
        if (method.hasDynamicWhereConditions()) {
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            methodBuilder.addJavadoc("<dt>$L</dt><dd>is part of where conditions resolved at runtime. In above SQL it is displayed as #{$L}</dd>", new Object[]{method.dynamicWhereParameterName, JQL.JQLDynamicStatementType.DYNAMIC_WHERE});
            methodBuilder.addJavadoc("\n</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (method.hasDynamicWhereConditions()) {
            methodBuilder.addJavadoc("<h2>Method's parameters and associated dynamic parts:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            if (method.hasDynamicWhereConditions()) {
                methodBuilder.addJavadoc("<dt>$L</dt><dd>is part of where conditions resolved at runtime. In above SQL it is displayed as #{$L}</dd>", new Object[]{method.dynamicWhereParameterName, JQL.JQLDynamicStatementType.DYNAMIC_WHERE});
            }
            methodBuilder.addJavadoc("</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (methodParams.size() > 0) {
            for (Pair pair : methodParams) {
                String resolvedName = method.findParameterAliasByName((String)pair.value0);
                methodBuilder.addJavadoc("@param $L", new Object[]{pair.value0});
                if (method.isThisDynamicWhereConditionsName((String)pair.value0)) {
                    methodBuilder.addJavadoc("\n\tis used as dynamic where conditions\n", new Object[0]);
                    continue;
                }
                methodBuilder.addJavadoc("\n\tis used as for parameter <strong>$L</strong>\n", new Object[]{resolvedName});
            }
        }
        if ((returnType = method.getReturnClass()) != TypeName.VOID) {
            methodBuilder.addJavadoc("\n", new Object[0]);
            if (ModifyRawHelper.isIn(returnType, Boolean.TYPE, Boolean.class)) {
                if (updateMode) {
                    methodBuilder.addJavadoc("@return <code>true</code> if record is updated, <code>false</code> otherwise", new Object[0]);
                } else {
                    methodBuilder.addJavadoc("@return <code>true</code> if record is deleted, <code>false</code> otherwise", new Object[0]);
                }
                methodBuilder.addCode("return result!=0;\n", new Object[0]);
            } else if (ModifyRawHelper.isIn(returnType, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class)) {
                if (updateMode) {
                    methodBuilder.addJavadoc("@return number of updated records", new Object[0]);
                } else {
                    methodBuilder.addJavadoc("@return number of deleted records", new Object[0]);
                }
            } else {
                throw new InvalidMethodSignException(method, "invalid return type");
            }
            methodBuilder.addJavadoc("\n", new Object[0]);
        }
    }

    static String extractWhereConditions(boolean updateMode, SQLiteModelMethod method) {
        final One whereCondition = new One((Object)"");
        final One found = new One(null);
        JQLChecker.getInstance().replaceVariableStatements(method, method.jql.value, new JQLReplaceVariableStatementListenerImpl(){

            @Override
            public String onWhere(String statement) {
                if (found.value0 == null) {
                    whereCondition.value0 = statement;
                    found.value0 = true;
                }
                return null;
            }
        });
        return StringUtils.ifNotEmptyAppend((String)((String)whereCondition.value0), (String)" ");
    }

    private void generateJavaDoc(final SQLiteModelMethod method, MethodSpec.Builder methodBuilder, boolean updateMode, String whereCondition, Pair<String, List<Pair<String, TypeName>>> where, List<Pair<String, TypeName>> methodParams) {
        TypeName returnType;
        final ArrayList updatedProperties = new ArrayList();
        final One onWhereStatement = new One((Object)false);
        String sqlModify = JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public void onWhereStatementBegin(JqlParser.Where_stmtContext ctx) {
                onWhereStatement.value0 = true;
            }

            @Override
            public void onWhereStatementEnd(JqlParser.Where_stmtContext ctx) {
                onWhereStatement.value0 = false;
            }

            @Override
            public String onColumnNameToUpdate(String columnName) {
                SQLProperty tempProperty = (SQLProperty)this.currentEntity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                updatedProperties.add(tempProperty);
                return tempProperty.columnName;
            }

            @Override
            public String onColumnName(String columnName) {
                SQLProperty tempProperty = (SQLProperty)this.currentEntity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                String resolvedParamName = method.findParameterNameByAlias(bindParameterName);
                AssertKripton.assertTrueOrUnknownParamInJQLException(resolvedParamName != null, method, bindParameterName);
                if (((Boolean)onWhereStatement.value0).booleanValue()) {
                    return SqlAnalyzer.PARAM_PREFIX + bindParameterName + SqlAnalyzer.PARAM_SUFFIX;
                }
                return SqlAnalyzer.PARAM_PREFIX + bindParameterName + SqlAnalyzer.PARAM_SUFFIX;
            }
        });
        if (updateMode) {
            methodBuilder.addJavadoc("<h2>SQL update</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<pre>$L</pre>\n", new Object[]{sqlModify});
            methodBuilder.addJavadoc("\n", new Object[0]);
            methodBuilder.addJavadoc("<h2>Updated columns:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<ul>\n", new Object[0]);
            for (SQLProperty sQLProperty : updatedProperties) {
                methodBuilder.addJavadoc("\t<li>$L</li>\n", new Object[]{sQLProperty.columnName});
            }
            methodBuilder.addJavadoc("</ul>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        } else {
            methodBuilder.addJavadoc("<h2>SQL delete</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<pre>$L</pre>", new Object[]{sqlModify});
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (((List)where.value1).size() > 0) {
            methodBuilder.addJavadoc("<h2>Where parameters:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            for (Pair pair : (List)where.value1) {
                String rawName = method.findParameterNameByAlias((String)pair.value0);
                methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{SqlAnalyzer.PARAM_PREFIX + (String)pair.value0 + SqlAnalyzer.PARAM_SUFFIX});
                methodBuilder.addJavadoc("<dd>is mapped to method's parameter <strong>$L</strong></dd>\n", new Object[]{rawName});
            }
            methodBuilder.addJavadoc("</dl>", new Object[0]);
        } else {
            methodBuilder.addJavadoc("<p>No where parameters were found.</p>", new Object[0]);
        }
        methodBuilder.addJavadoc("\n\n", new Object[0]);
        if (method.hasDynamicWhereConditions()) {
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            methodBuilder.addJavadoc("<dt>$L</dt><dd>is part of where conditions resolved at runtime. In above SQL it is displayed as #{$L}</dd>", new Object[]{method.dynamicWhereParameterName, JQL.JQLDynamicStatementType.DYNAMIC_WHERE});
            methodBuilder.addJavadoc("\n</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (method.hasDynamicWhereConditions()) {
            methodBuilder.addJavadoc("<h2>Method's parameters and associated dynamic parts:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            if (method.hasDynamicWhereConditions()) {
                methodBuilder.addJavadoc("<dt>$L</dt><dd>is part of where conditions resolved at runtime. In above SQL it is displayed as #{$L}</dd>", new Object[]{method.dynamicWhereParameterName, JQL.JQLDynamicStatementType.DYNAMIC_WHERE});
            }
            methodBuilder.addJavadoc("</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (methodParams.size() > 0) {
            for (Pair pair : methodParams) {
                String resolvedName = method.findParameterAliasByName((String)pair.value0);
                methodBuilder.addJavadoc("@param $L", new Object[]{pair.value0});
                if (method.isThisDynamicWhereConditionsName((String)pair.value0)) {
                    methodBuilder.addJavadoc("\n\tis used as dynamic where conditions\n", new Object[0]);
                    continue;
                }
                if (((List)where.value1).contains(new Pair((Object)resolvedName, pair.value1))) {
                    methodBuilder.addJavadoc("\n\tis used as where parameter <strong>$L</strong>\n", new Object[]{SqlAnalyzer.PARAM_PREFIX + resolvedName + SqlAnalyzer.PARAM_SUFFIX});
                    continue;
                }
                methodBuilder.addJavadoc("\n\tis used as updated field <strong>$L</strong>\n", new Object[]{resolvedName});
            }
        }
        if ((returnType = method.getReturnClass()) != TypeName.VOID) {
            methodBuilder.addJavadoc("\n", new Object[0]);
            if (ModifyRawHelper.isIn(returnType, Boolean.TYPE, Boolean.class)) {
                if (updateMode) {
                    methodBuilder.addJavadoc("@return <code>true</code> if record is updated, <code>false</code> otherwise", new Object[0]);
                } else {
                    methodBuilder.addJavadoc("@return <code>true</code> if record is deleted, <code>false</code> otherwise", new Object[0]);
                }
            } else if (ModifyRawHelper.isIn(returnType, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class)) {
                if (updateMode) {
                    methodBuilder.addJavadoc("@return number of updated records", new Object[0]);
                } else {
                    methodBuilder.addJavadoc("@return number of deleted records", new Object[0]);
                }
            } else {
                throw new InvalidMethodSignException(method, "invalid return type");
            }
            methodBuilder.addJavadoc("\n", new Object[0]);
        }
    }

    public static void generateWhereCondition(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, Pair<String, List<Pair<String, TypeName>>> where) {
        for (Pair item : (List)where.value1) {
            String resolvedParamName = method.findParameterNameByAlias((String)item.value0);
            methodBuilder.addCode("_contentValues.addWhereArgs(", new Object[0]);
            boolean nullable = TypeUtility.isNullable((TypeName)item.value1);
            if (nullable && !method.hasAdapterForParam((String)item.value0)) {
                methodBuilder.addCode("($L==null?\"\":", new Object[]{resolvedParamName});
            }
            TypeUtility.beginStringConversion(methodBuilder, (TypeName)item.value1);
            SQLTransformer.javaMethodParam2WhereConditions(methodBuilder, method, resolvedParamName, (TypeName)item.value1);
            TypeUtility.endStringConversion(methodBuilder, (TypeName)item.value1);
            if (nullable && !method.hasAdapterForParam((String)item.value0)) {
                methodBuilder.addCode(")", new Object[0]);
            }
            methodBuilder.addCode(");\n", new Object[0]);
        }
    }

    static boolean isIn(TypeName value, Class<?> ... classes) {
        for (Class<?> item : classes) {
            if (!value.toString().equals(TypeName.get(item).toString())) continue;
            return true;
        }
        return false;
    }
}

