/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.common.SQLTypeAdapterUtils;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractSelectCodeGenerator;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;

public class SelectBeanHelper
extends AbstractSelectCodeGenerator {
    @Override
    public void generateSpecializedPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, Set<JQLProjection> fieldList, boolean mapFields) {
        SQLProperty item;
        SQLiteEntity entity = method.getEntity();
        TypeName entityClass = TypeUtility.typeName(entity.getElement());
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("$T resultBean=null;\n", new Object[]{entityClass});
        if (entity.isImmutablePojo()) {
            methodBuilder.addCode("\n", new Object[0]);
            methodBuilder.addComment("initialize temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (_cursor.moveToFirst())", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        int i = 0;
        for (JQLProjection a : fieldList) {
            item = a.property;
            methodBuilder.addStatement("int index$L=_cursor.getColumnIndex($S)", new Object[]{i++, item.columnName});
            if (!item.hasTypeAdapter()) continue;
            methodBuilder.addStatement("$T $LAdapter=$T.getAdapter($T.class)", new Object[]{item.typeAdapter.getAdapterTypeName(), item.getName(), SQLTypeAdapterUtils.class, item.typeAdapter.getAdapterTypeName()});
        }
        methodBuilder.addCode("\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addComment("reset temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableVariableReset(entity, methodBuilder);
        } else {
            methodBuilder.addCode("resultBean=new $T();\n\n", new Object[]{entityClass});
        }
        i = 0;
        for (JQLProjection a : fieldList) {
            item = a.property;
            if (item.isNullable()) {
                methodBuilder.addCode("if (!_cursor.isNull(index$L)) { ", new Object[]{i});
            }
            SQLTransformer.cursor2Java(methodBuilder, entityClass, item, "resultBean", "_cursor", "index" + i + "");
            methodBuilder.addCode(";", new Object[0]);
            if (item.isNullable()) {
                methodBuilder.addCode(" }", new Object[0]);
            }
            methodBuilder.addCode("\n", new Object[0]);
            ++i;
        }
        this.generateSubQueries(methodBuilder, method);
        methodBuilder.addCode("\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addComment("define immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "resultBean", false);
        }
        methodBuilder.endControlFlow();
        methodBuilder.addCode("return resultBean;\n", new Object[0]);
        methodBuilder.endControlFlow();
    }
}

