/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.common.SQLTypeAdapterUtils;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractSelectCodeGenerator;
import com.abubusoft.kripton.processor.sqlite.SqlUtility;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Set;

public class SelectBeanListHelper
extends AbstractSelectCodeGenerator {
    @Override
    public void generateSpecializedPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, Set<JQLProjection> fieldList, boolean mapFields) {
        SQLProperty item;
        SQLiteEntity entity = method.getEntity();
        TypeName returnTypeName = method.getReturnClass();
        ParameterizedTypeName returnListName = (ParameterizedTypeName)returnTypeName;
        TypeName entityClass = TypeUtility.typeName(entity.getElement());
        ClassName returnRawListClazzName = returnListName.rawType;
        ClassName collectionClass = SqlUtility.defineCollection((TypeName)returnRawListClazzName);
        methodBuilder.addCode("\n", new Object[0]);
        if (TypeUtility.isTypeEquals((TypeName)collectionClass, TypeUtility.typeName(ArrayList.class))) {
            methodBuilder.addCode("$T<$T> resultList=new $T<$T>(_cursor.getCount());\n", new Object[]{collectionClass, entityClass, collectionClass, entityClass});
        } else {
            methodBuilder.addCode("$T<$T> resultList=new $T<$T>();\n", new Object[]{collectionClass, entityClass, collectionClass, entityClass});
        }
        methodBuilder.addStatement("$T resultBean=null", new Object[]{entityClass});
        if (entity.isImmutablePojo()) {
            methodBuilder.addCode("\n", new Object[0]);
            methodBuilder.addComment("initialize temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (_cursor.moveToFirst())", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        int i = 0;
        for (JQLProjection a : fieldList) {
            item = a.property;
            methodBuilder.addStatement("int index$L=_cursor.getColumnIndex($S)", new Object[]{i++, item.columnName});
            if (!item.hasTypeAdapter()) continue;
            methodBuilder.addStatement("$T $LAdapter=$T.getAdapter($T.class)", new Object[]{item.typeAdapter.getAdapterTypeName(), item.getName(), SQLTypeAdapterUtils.class, item.typeAdapter.getAdapterTypeName()});
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("do\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addComment("reset temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableVariableReset(entity, methodBuilder);
        } else {
            methodBuilder.addCode("resultBean=new $T();\n\n", new Object[]{entityClass});
        }
        i = 0;
        for (JQLProjection a : fieldList) {
            item = a.property;
            if (item.isNullable()) {
                methodBuilder.addCode("if (!_cursor.isNull(index$L)) { ", new Object[]{i});
            }
            SQLTransformer.cursor2Java(methodBuilder, TypeUtility.typeName(entity.getElement()), item, "resultBean", "_cursor", "index" + i + "");
            methodBuilder.addCode(";", new Object[0]);
            if (item.isNullable()) {
                methodBuilder.addCode(" }", new Object[0]);
            }
            methodBuilder.addCode("\n", new Object[0]);
            ++i;
        }
        this.generateSubQueries(methodBuilder, method);
        methodBuilder.addCode("\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addComment("define immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "resultBean", false);
        }
        methodBuilder.addCode("resultList.add(resultBean);\n", new Object[0]);
        methodBuilder.endControlFlow("while (_cursor.moveToNext())", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addCode("\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addCode("return ", new Object[0]);
            ImmutableUtility.generateImmutableCollectionIfPossible(entity, methodBuilder, "resultList", (TypeName)ParameterizedTypeName.get((ClassName)returnRawListClazzName, (TypeName[])new TypeName[]{entityClass}));
            methodBuilder.addCode(";\n", new Object[0]);
        } else {
            methodBuilder.addCode("return resultList;\n", new Object[0]);
        }
        methodBuilder.endControlFlow();
    }
}

