/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.sqlite.OnReadBeanListener;
import com.abubusoft.kripton.common.SQLTypeAdapterUtils;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.sqlite.AbstractSelectCodeGenerator;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.SqlSelectBuilder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class SelectBeanListenerHelper
extends AbstractSelectCodeGenerator {
    @Override
    public void generateSpecializedPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, Set<JQLProjection> fieldList, boolean mapFields) {
        SQLProperty item;
        SQLiteEntity entity = method.getEntity();
        ParameterizedTypeName listenerType = ParameterizedTypeName.get((ClassName)ClassName.get(OnReadBeanListener.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)((TypeElement)entity.getElement()).asType())});
        TypeName entityClass = TypeUtility.typeName(entity.getElement());
        int counter = SqlBuilderHelper.countParameterOfType(method, (TypeName)listenerType);
        if (counter == 0) {
            throw new InvalidMethodSignException(method, "there is no parameter of type \"ReadCursorListener\"");
        }
        if (counter > 1) {
            throw new InvalidMethodSignException(method, "there are more than one parameter of type \"ReadCursorListener\"");
        }
        String listenerName = SqlSelectBuilder.getNameParameterOfType(method, (TypeName)listenerType);
        if (entity.isImmutablePojo()) {
            methodBuilder.addStatement("$T resultBean=null", new Object[]{entityClass});
            methodBuilder.addCode("\n", new Object[0]);
            methodBuilder.addComment("initialize temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
        } else {
            methodBuilder.addStatement("$T resultBean=new $T()", new Object[]{entityClass, entityClass});
        }
        methodBuilder.beginControlFlow("if (_cursor.moveToFirst())", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        int i = 0;
        for (JQLProjection a : fieldList) {
            item = a.property;
            methodBuilder.addStatement("int index$L=_cursor.getColumnIndex($S)", new Object[]{i++, item.columnName});
            if (!item.hasTypeAdapter()) continue;
            methodBuilder.addStatement("$T $LAdapter=$T.getAdapter($T.class)", new Object[]{item.typeAdapter.getAdapterTypeName(), item.getName(), SQLTypeAdapterUtils.class, item.typeAdapter.getAdapterTypeName()});
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("int rowCount=_cursor.getCount();\n", new Object[0]);
        methodBuilder.beginControlFlow("do\n", new Object[0]);
        methodBuilder.addCode("// reset mapping\n", new Object[0]);
        i = 0;
        for (SQLProperty item2 : entity.getCollection()) {
            if (item2.isNullable()) {
                SQLTransformer.resetBean(methodBuilder, entityClass, "resultBean", item2, "_cursor", "index" + i + "");
                methodBuilder.addCode(";", new Object[0]);
                methodBuilder.addCode("\n", new Object[0]);
            } else {
                methodBuilder.addCode("// " + item2.getName() + " does not need reset (it will be taken from db)\n", new Object[0]);
            }
            ++i;
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("// generate mapping\n", new Object[0]);
        i = 0;
        for (JQLProjection a : fieldList) {
            item = a.property;
            if (item.isNullable()) {
                methodBuilder.addCode("if (!_cursor.isNull(index$L)) { ", new Object[]{i});
            }
            SQLTransformer.cursor2Java(methodBuilder, TypeUtility.typeName(entity.getElement()), item, "resultBean", "_cursor", "index" + i + "");
            methodBuilder.addCode(";", new Object[0]);
            if (item.isNullable()) {
                methodBuilder.addCode(" }", new Object[0]);
            }
            methodBuilder.addCode("\n", new Object[0]);
            ++i;
        }
        methodBuilder.addCode("\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addComment("define immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "resultBean", false);
        }
        methodBuilder.addCode("$L.onRead(resultBean, _cursor.getPosition(), rowCount);\n", new Object[]{listenerName});
        methodBuilder.endControlFlow("while (_cursor.moveToNext())", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
    }
}

