/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.Logger;
import com.abubusoft.kripton.android.annotation.BindSqlSelect;
import com.abubusoft.kripton.android.sqlite.PagedResultImpl;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.SQLTypeAdapterUtils;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractSelectCodeGenerator;
import com.abubusoft.kripton.processor.sqlite.BindDaoFactoryBuilder;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class SelectPaginatedResultHelper
extends AbstractSelectCodeGenerator {
    static int pagedResultCounter;

    @Override
    public void generate(TypeSpec.Builder classBuilder, boolean mapFields, SQLiteModelMethod method) {
        String pagedResultName = SelectPaginatedResultHelper.buildSpecializedPagedResultClass(classBuilder, method);
        Set<JQLProjection> fieldList = JQLChecker.getInstance().extractProjections(method, method.jql.value, method.getEntity());
        MethodSpec.Builder methodBuilder = this.generateMethodBuilder(method);
        SelectPaginatedResultHelper.createPagedResult(method, pagedResultName, methodBuilder);
        this.generateCommonPart(method, classBuilder, methodBuilder, fieldList, AbstractSelectCodeGenerator.GenerationType.NO_CONTENT, null, true, false, new AbstractSelectCodeGenerator.JavadocPart[0]);
        methodBuilder.addStatement("return paginatedResult", new Object[0]);
        if (!method.isPagedLiveData()) {
            classBuilder.addMethod(methodBuilder.build());
        }
        String selectTotalCountMethodName = method.getName() + "TotalCount";
        MethodSpec.Builder methodBuilder2 = MethodSpec.methodBuilder((String)method.getName()).addModifiers(new Modifier[]{Modifier.PRIVATE});
        this.generateMethodSignature(method, methodBuilder2, TypeUtility.parameterizedTypeName(TypeUtility.className(List.class), TypeUtility.typeName(method.getEntity().getElement())), ParameterSpec.builder((TypeName)TypeUtility.typeName(pagedResultName), (String)"paginatedResult", (Modifier[])new Modifier[0]).build());
        this.generateTotalCountUsage(method, methodBuilder2, "paginatedResult", selectTotalCountMethodName);
        this.generateCommonPart(method, classBuilder, methodBuilder2, fieldList, AbstractSelectCodeGenerator.GenerationType.NO_METHOD_SIGN, null, false, false, AbstractSelectCodeGenerator.JavadocPart.build(AbstractSelectCodeGenerator.JavadocPartType.ADD_PARAMETER, "paginatedResult", "handler of paginated result"), AbstractSelectCodeGenerator.JavadocPart.build(AbstractSelectCodeGenerator.JavadocPartType.RETURN, "", "result list"));
        methodBuilder2.addComment("Specialized part II - $L - BEGIN", new Object[]{this.getClass().getSimpleName()});
        this.generateSpecializedPart(method, classBuilder, methodBuilder2, fieldList, this.selectType.isMapFields());
        methodBuilder2.addComment("Specialized part II - $L - END", new Object[]{this.getClass().getSimpleName()});
        classBuilder.addMethod(methodBuilder2.build());
        HashSet<JQLProjection> countfields = new HashSet<JQLProjection>();
        countfields.add(JQLProjection.ProjectionBuilder.create().expression("count(*)").build());
        MethodSpec.Builder methodBuilder3 = MethodSpec.methodBuilder((String)selectTotalCountMethodName).addModifiers(new Modifier[]{Modifier.PRIVATE});
        this.generateMethodSignature(method, methodBuilder3, TypeName.INT, ParameterSpec.builder((TypeName)TypeUtility.typeName(pagedResultName), (String)"paginatedResult", (Modifier[])new Modifier[0]).build());
        this.generateCommonPart(method, classBuilder, methodBuilder3, countfields, AbstractSelectCodeGenerator.GenerationType.NO_METHOD_SIGN, TypeName.INT, false, true, AbstractSelectCodeGenerator.JavadocPart.build(AbstractSelectCodeGenerator.JavadocPartType.ADD_PARAMETER, "paginatedResult", "handler of paginated result"), AbstractSelectCodeGenerator.JavadocPart.build(AbstractSelectCodeGenerator.JavadocPartType.RETURN, "", "total row count"));
        methodBuilder3.addComment("Specialized part II - $L - BEGIN", new Object[]{this.getClass().getSimpleName()});
        this.generateTotalSpecializedPart(method, methodBuilder3);
        methodBuilder3.addComment("Specialized part II - $L - END", new Object[]{this.getClass().getSimpleName()});
        classBuilder.addMethod(methodBuilder3.build());
    }

    private void generateTotalCountUsage(SQLiteModelMethod method, MethodSpec.Builder methodBuilder, String paginatedResultName, String selectTotalCountMethodName) {
        methodBuilder.addComment("total count - BEGIN", new Object[0]);
        methodBuilder.addCode(paginatedResultName + ".setTotalElements(this." + selectTotalCountMethodName + "(", new Object[0]);
        method.getParameters().forEach(p -> methodBuilder.addCode((String)p.value0 + ", ", new Object[0]));
        methodBuilder.addCode(paginatedResultName + "));\n", new Object[0]);
        methodBuilder.addComment("total count - END", new Object[0]);
    }

    public static void createPagedResult(SQLiteModelMethod method, String pagedResultName, MethodSpec.Builder methodBuilder) {
        String separator = "";
        methodBuilder.addCode("final $L paginatedResult=new $L(", new Object[]{pagedResultName, pagedResultName});
        for (Pair<String, TypeName> item : method.getParameters()) {
            methodBuilder.addCode(separator + "$L", new Object[]{item.value0});
            separator = ", ";
        }
        methodBuilder.addCode(");\n", new Object[0]);
    }

    @Override
    public void generateSpecializedPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, Set<JQLProjection> fieldList, boolean mapFields) {
        SQLProperty item;
        SQLiteEntity entity = method.getEntity();
        ClassName returnRawListClazzName = ClassName.get(List.class);
        TypeName entityClass = TypeUtility.typeName(entity.getElement());
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addStatement("$T<$T> resultList=new $T<$T>(_cursor.getCount())", new Object[]{List.class, entityClass, ArrayList.class, entityClass});
        methodBuilder.addStatement("$T resultBean=null", new Object[]{entityClass});
        if (entity.isImmutablePojo()) {
            methodBuilder.addCode("\n", new Object[0]);
            methodBuilder.addComment("initialize temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (_cursor.moveToFirst())", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        int i = 0;
        for (JQLProjection a : fieldList) {
            item = a.property;
            methodBuilder.addStatement("int index$L=_cursor.getColumnIndex($S)", new Object[]{i++, item.columnName});
            if (!item.hasTypeAdapter()) continue;
            methodBuilder.addStatement("$T $LAdapter=$T.getAdapter($T.class)", new Object[]{item.typeAdapter.getAdapterTypeName(), item.getName(), SQLTypeAdapterUtils.class, item.typeAdapter.getAdapterTypeName()});
        }
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("do\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addComment("reset temporary variable for immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableVariableReset(entity, methodBuilder);
        } else {
            methodBuilder.addCode("resultBean=new $T();\n\n", new Object[]{entityClass});
        }
        i = 0;
        for (JQLProjection a : fieldList) {
            item = a.property;
            if (item.isNullable()) {
                methodBuilder.addCode("if (!_cursor.isNull(index$L)) { ", new Object[]{i});
            }
            SQLTransformer.cursor2Java(methodBuilder, TypeUtility.typeName(entity.getElement()), item, "resultBean", "_cursor", "index" + i + "");
            methodBuilder.addCode(";", new Object[0]);
            if (item.isNullable()) {
                methodBuilder.addCode(" }", new Object[0]);
            }
            methodBuilder.addCode("\n", new Object[0]);
            ++i;
        }
        methodBuilder.addCode("\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addComment("define immutable POJO", new Object[0]);
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "resultBean", false);
        }
        methodBuilder.addCode("resultList.add(resultBean);\n", new Object[0]);
        methodBuilder.endControlFlow("while (_cursor.moveToNext())", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addCode("\n", new Object[0]);
        if (entity.isImmutablePojo()) {
            methodBuilder.addCode("return ", new Object[0]);
            ImmutableUtility.generateImmutableCollectionIfPossible(entity, methodBuilder, "resultList", (TypeName)ParameterizedTypeName.get((ClassName)returnRawListClazzName, (TypeName[])new TypeName[]{entityClass}));
            methodBuilder.addCode(";\n", new Object[0]);
        } else {
            methodBuilder.addCode("return resultList;\n", new Object[0]);
        }
        methodBuilder.endControlFlow();
    }

    public void generateTotalSpecializedPart(SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        methodBuilder.addComment("manage query for total count eements", new Object[0]);
        methodBuilder.addStatement("int _result=-1", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (_cursor.moveToFirst())", new Object[0]);
        methodBuilder.addStatement("_result=_cursor.getInt(0)", new Object[0]);
        methodBuilder.endControlFlow();
        if (daoDefinition.isLogEnabled()) {
            methodBuilder.addComment("log section for select BEGIN", new Object[0]);
            methodBuilder.beginControlFlow("if (_context.isLogEnabled())", new Object[0]);
            methodBuilder.addComment("manage log", new Object[0]);
            SqlBuilderHelper.generateLogForWhereParameters(method, methodBuilder);
            methodBuilder.addStatement("$T.info($S, _result)", new Object[]{Logger.class, "Total elements found: %s"});
            methodBuilder.addComment("log section for select END", new Object[0]);
        }
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("return _result", new Object[0]);
        methodBuilder.endControlFlow();
    }

    public static String buildSpecializedPagedResultClass(TypeSpec.Builder classBuilder, SQLiteModelMethod method) {
        TypeName entityTypeName = TypeUtility.typeName(method.getEntity().getName());
        String pagedResultName = "PaginatedResult" + pagedResultCounter++;
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)pagedResultName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(TypeUtility.parameterizedTypeName(TypeUtility.className(PagedResultImpl.class), entityTypeName));
        MethodSpec.Builder setupBuilder = MethodSpec.constructorBuilder();
        MethodSpec.Builder executeBuilder = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeUtility.parameterizedTypeName(TypeUtility.className(List.class), entityTypeName));
        executeBuilder.addComment("Executor builder - BEGIN", new Object[0]);
        ClassName daoFactoryClassName = BindDaoFactoryBuilder.generateDaoFactoryClassName(method.getParent().getParent());
        MethodSpec.Builder executeWithDaoFactortBuilder = MethodSpec.methodBuilder((String)"execute").addParameter((TypeName)daoFactoryClassName, "daoFactory", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeUtility.parameterizedTypeName(TypeUtility.className(List.class), entityTypeName));
        executeWithDaoFactortBuilder.addCode("return daoFactory.get$L().$L(", new Object[]{method.getParentName(), method.getName()});
        if (!method.isPagedLiveData()) {
            executeBuilder.addCode("list=$T.this.$L(", new Object[]{TypeUtility.typeName((TypeElement)method.getParent().getElement(), "Impl"), method.getName()});
        }
        String separator = "";
        for (Pair<String, TypeName> item : method.getParameters()) {
            if (method.hasDynamicPageSizeConditions() && method.dynamicPageSizeName.equals(item.value0)) {
                setupBuilder.addStatement("this.pageSize=$L", new Object[]{item.value0});
            } else {
                typeBuilder.addField((TypeName)item.value1, (String)item.value0, new Modifier[0]);
                setupBuilder.addStatement("this.$L=$L", new Object[]{item.value0, item.value0});
            }
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)((TypeName)item.value1), (String)((String)item.value0), (Modifier[])new Modifier[0]).build();
            setupBuilder.addParameter(parameterSpec);
            if (method.dynamicPageSizeName != null && method.dynamicPageSizeName.equals(item.value0)) {
                if (!method.isPagedLiveData()) {
                    executeBuilder.addCode(separator + "this.pageSize", new Object[0]);
                }
                executeWithDaoFactortBuilder.addCode(separator + "this.pageSize", new Object[0]);
            } else {
                if (!method.isPagedLiveData()) {
                    executeBuilder.addCode(separator + (String)item.value0, new Object[0]);
                }
                executeWithDaoFactortBuilder.addCode(separator + (String)item.value0, new Object[0]);
            }
            separator = ", ";
        }
        if (method.isPagedLiveData()) {
            executeBuilder.addComment("paged result is used in live data, so this method must be empty", new Object[0]);
            executeBuilder.addStatement("return null", new Object[0]);
        } else {
            executeBuilder.addCode(separator + "this);\n", new Object[0]);
            executeBuilder.addStatement("return list", new Object[0]);
        }
        executeBuilder.addComment("Executor builder - END", new Object[0]);
        typeBuilder.addMethod(executeBuilder.build());
        if (!method.hasDynamicPageSizeConditions()) {
            ModelAnnotation annotation = method.getAnnotation(BindSqlSelect.class);
            int pageSize = annotation.getAttributeAsInt(AnnotationAttributeType.PAGE_SIZE);
            if (pageSize == 0) {
                pageSize = 20;
            }
            setupBuilder.addStatement("this.pageSize=$L", new Object[]{pageSize});
        }
        typeBuilder.addMethod(setupBuilder.build());
        executeWithDaoFactortBuilder.addCode(separator + "this);\n", new Object[0]);
        typeBuilder.addMethod(executeWithDaoFactortBuilder.build());
        classBuilder.addType(typeBuilder.build());
        return pagedResultName;
    }

    public static String getCurrentPagedResultClass() {
        return "PaginatedResult" + (pagedResultCounter - 1);
    }
}

