/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractSelectCodeGenerator;
import com.abubusoft.kripton.processor.sqlite.SqlUtility;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Set;

public class SelectScalarListHelper
extends AbstractSelectCodeGenerator {
    @Override
    public void generateSpecializedPart(SQLiteModelMethod method, TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, Set<JQLProjection> fieldList, boolean mapFields) {
        AssertKripton.assertTrueOrInvalidMethodSignException(fieldList.size() == 1, method, "only one field can be defined as result for this method", new Object[0]);
        ParameterizedTypeName returnListName = (ParameterizedTypeName)method.getReturnClass();
        ClassName listClazzName = returnListName.rawType;
        TypeName elementName = (TypeName)returnListName.typeArguments.get(0);
        ClassName collectionClass = SqlUtility.defineCollection((TypeName)listClazzName);
        methodBuilder.addCode("\n", new Object[0]);
        if (TypeUtility.isTypeEquals((TypeName)collectionClass, TypeUtility.typeName(ArrayList.class))) {
            methodBuilder.addStatement("$T<$T> resultList=new $T<$T>(_cursor.getCount())", new Object[]{collectionClass, elementName, collectionClass, elementName});
        } else {
            methodBuilder.addStatement("$T<$T> resultList=new $T<$T>()", new Object[]{collectionClass, elementName, collectionClass, elementName});
        }
        methodBuilder.addCode("\n", new Object[0]);
        SQLTransform t = SQLTransformer.lookup((TypeName)returnListName);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (_cursor.moveToFirst())", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("do\n", new Object[0]);
        methodBuilder.beginControlFlow("if (!_cursor.isNull(0))", new Object[0]);
        methodBuilder.addCode("resultList.add(", new Object[0]);
        t.generateReadValueFromCursor(methodBuilder, method.getParent(), elementName, "_cursor", "0");
        methodBuilder.addCode(");\n", new Object[0]);
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addCode("resultList.add(null);\n", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow("while (_cursor.moveToNext())", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addCode("return resultList;\n", new Object[0]);
        methodBuilder.endControlFlow();
    }
}

