/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import com.abubusoft.kripton.android.Logger;
import com.abubusoft.kripton.android.annotation.BindSqlDynamicWhere;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.android.sqlite.SpreadUtils;
import com.abubusoft.kripton.common.CollectionUtils;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.common.Triple;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelMethod;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.sqlite.OnColumnListener;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplaceVariableStatementListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.ContentUriPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public abstract class SqlBuilderHelper {
    public static String generateColumnCheckSet(TypeSpec.Builder builder, SQLiteModelMethod method, Set<String> columnNames) {
        String columnNameSet = method.contentProviderMethodName + "ColumnSet";
        StringBuilder initBuilder = new StringBuilder();
        String temp = "";
        for (String item : columnNames) {
            initBuilder.append(temp + "\"" + item + "\"");
            temp = ", ";
        }
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)ParameterizedTypeName.get(Set.class, (Type[])new Type[]{String.class}), (String)columnNameSet, (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PRIVATE, Modifier.FINAL});
        fieldBuilder.initializer("$T.asSet($T.class, $L)", new Object[]{CollectionUtils.class, String.class, initBuilder.toString()});
        builder.addField(fieldBuilder.build());
        return columnNameSet;
    }

    static void forEachColumnInContentValue(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, String columnSetString, boolean generateColumnNameCheck, OnColumnListener listener) {
        methodBuilder.beginControlFlow("for (String columnName:$L)", new Object[]{columnSetString});
        if (generateColumnNameCheck) {
            methodBuilder.beginControlFlow("if (!$L.contains(columnName))", new Object[]{method.contentProviderMethodName + "ColumnSet"});
            methodBuilder.addStatement("throw new $T(String.format(\"For URI '$L', column '%s' does not exists in table '%s' or can not be defined in this $L operation\", columnName, $S ))", new Object[]{KriptonRuntimeException.class, method.contentProviderUriTemplate, method.jql.operationType, method.getEntity().getTableName()});
            methodBuilder.endControlFlow();
        }
        if (listener != null) {
            listener.onColumnCheck(methodBuilder, "columnName");
        }
        methodBuilder.endControlFlow();
    }

    static List<JQLPlaceHolder> removeDynamicPlaceHolder(List<JQLPlaceHolder> placeHolders) {
        ArrayList<JQLPlaceHolder> result = new ArrayList<JQLPlaceHolder>();
        for (JQLPlaceHolder item : placeHolders) {
            if (item.type == JQLPlaceHolder.JQLPlaceHolderType.DYNAMIC_SQL) continue;
            result.add(item);
        }
        return result;
    }

    static boolean validate(String value, List<JQLPlaceHolder> placeHolders, int pos) {
        return placeHolders.get((int)pos).value.equals(value);
    }

    public static void generateJavaDocForContentProvider(final SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        String operation = method.jql.operationType.toString();
        methodBuilder.addJavadoc("<h1>Content provider URI ($L operation):</h1>\n", new Object[]{operation});
        methodBuilder.addJavadoc("<pre>$L</pre>\n\n", new Object[]{method.contentProviderUriTemplate.replace("*", "[*]")});
        methodBuilder.addJavadoc("<h2>JQL $L for Content Provider</h2>\n", new Object[]{operation});
        methodBuilder.addJavadoc("<pre>$L</pre>\n\n", new Object[]{method.jql.value});
        methodBuilder.addJavadoc("<h2>SQL $L for Content Provider</h2>\n", new Object[]{operation});
        String sql = JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnName(String columnName) {
                SQLProperty tempProperty = (SQLProperty)this.currentEntity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onColumnAlias(String alias) {
                SQLProperty tempProperty = (SQLProperty)this.currentEntity.findPropertyByName(alias);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, alias);
                return tempProperty.columnName;
            }
        });
        methodBuilder.addJavadoc("<pre>$L</pre>\n\n", new Object[]{sql});
        if (method.contentProviderUriVariables.size() > 0) {
            methodBuilder.addJavadoc("<h3>Path variables defined:</h3>\n<ul>\n", new Object[0]);
            for (ContentUriPlaceHolder variable : method.contentProviderUriVariables) {
                methodBuilder.addJavadoc("<li><strong>" + SqlAnalyzer.PARAM_PREFIX + "$L" + SqlAnalyzer.PARAM_SUFFIX + "</strong> at path segment $L</li>\n", new Object[]{variable.value, variable.pathSegmentIndex});
            }
            methodBuilder.addJavadoc("</ul>\n\n", new Object[0]);
        }
        if (!method.hasDynamicWhereConditions()) {
            methodBuilder.addJavadoc("<p><strong>Dynamic where statement is ignored, due no param with @$L was added.</strong></p>\n\n", new Object[]{BindSqlDynamicWhere.class.getSimpleName()});
        }
        methodBuilder.addJavadoc("<p><strong>In URI, * is replaced with [*] for javadoc rapresentation</strong></p>\n\n", new Object[0]);
    }

    public static void generateLogForContentValues(SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        methodBuilder.addCode("\n// log for content values -- BEGIN\n", new Object[0]);
        methodBuilder.addStatement("$T<String, Object, $T> _contentValue", new Object[]{Triple.class, KriptonContentValues.ParamType.class});
        methodBuilder.beginControlFlow("for (int i = 0; i < _contentValues.size(); i++)", new Object[0]);
        methodBuilder.addStatement("_contentValue = _contentValues.get(i)", new Object[0]);
        methodBuilder.beginControlFlow("if (_contentValue.value1==null)", new Object[0]);
        methodBuilder.addStatement("$T.info(\"==> :%s = <null>\", _contentValue.value0)", new Object[]{Logger.class});
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addStatement("$T.info(\"==> :%s = '%s' (%s)\", _contentValue.value0, $T.checkSize(_contentValue.value1), _contentValue.value1.getClass().getCanonicalName())", new Object[]{Logger.class, StringUtils.class});
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        methodBuilder.addCode("// log for content values -- END\n", new Object[0]);
    }

    public static void generateLogForWhereParameters(SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        if (method.getParent().getParent().generateLog) {
            methodBuilder.addCode("\n// log for where parameters -- BEGIN\n", new Object[0]);
            methodBuilder.addStatement("int _whereParamCounter=0", new Object[0]);
            methodBuilder.beginControlFlow("for (String _whereParamItem: _contentValues.whereArgs())", new Object[0]);
            methodBuilder.addStatement("$T.info(\"==> param%s: '%s'\",(_whereParamCounter++), $T.checkSize(_whereParamItem))", new Object[]{Logger.class, StringUtils.class});
            methodBuilder.endControlFlow();
            methodBuilder.addCode("// log for where parameters -- END\n", new Object[0]);
        }
    }

    static void generateLogForSQL(SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        if (method.getParent().getParent().generateLog) {
            methodBuilder.addCode("\n// manage log\n", new Object[0]);
            methodBuilder.addStatement("$T.info(_sql)", new Object[]{Logger.class});
        }
    }

    static void generateLogForContentProviderBeginning(SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        if (method.getParent().isLogEnabled()) {
            methodBuilder.addStatement("$T.info($S, uri.toString())", new Object[]{Logger.class, "Execute " + (Object)((Object)method.jql.operationType) + " for URI %s"});
        }
    }

    public static void forEachMethods(TypeElement typeElement, AnnotationUtility.MethodFoundListener listener) {
        Elements elementUtils = BaseProcessor.elementUtils;
        List<? extends Element> list = elementUtils.getAllMembers(typeElement);
        for (Element element : list) {
            if (element.getKind() != ElementKind.METHOD) continue;
            listener.onMethod((ExecutableElement)element);
        }
    }

    public static boolean hasParameterOfType(ModelMethod method, TypeName parameter) {
        return SqlBuilderHelper.countParameterOfType(method, parameter) > 0;
    }

    public static Pair<String, TypeName> searchInEachParameter(ModelMethod method, OnParameterListener listener) {
        for (Pair<String, TypeName> item : method.getParameters()) {
            if (!listener.onParameter(item)) continue;
            return item;
        }
        return null;
    }

    public static int countParameterOfType(ModelMethod method, TypeName parameter) {
        int counter = 0;
        for (Pair<String, TypeName> item : method.getParameters()) {
            if (!((TypeName)item.value1).equals((Object)parameter)) continue;
            ++counter;
        }
        return counter;
    }

    public static void generateWhereCondition(final MethodSpec.Builder methodBuilder, final SQLiteModelMethod method, boolean sqlWhereParamsAlreadyDefined) {
        JQL jql = method.jql;
        JQLChecker jqlChecker = JQLChecker.getInstance();
        if (jql.isWhereConditions()) {
            final One whereStatement = new One();
            final One alreadyFoundWhereStatement = new One((Object)false);
            jqlChecker.replaceVariableStatements(method, method.jql.value, new JQLReplaceVariableStatementListenerImpl(){

                @Override
                public String onWhere(String statement) {
                    if (!((Boolean)alreadyFoundWhereStatement.value0).booleanValue()) {
                        whereStatement.value0 = statement;
                        alreadyFoundWhereStatement.value0 = true;
                        return "";
                    }
                    return null;
                }
            });
            final StringBuilder dynamicCodeBlock = new StringBuilder();
            methodBuilder.addCode("\n// manage WHERE arguments -- BEGIN\n", new Object[0]);
            String sqlWhere = jqlChecker.replaceFromVariableStatement(method, (String)whereStatement.value0, new JQLReplacerListenerImpl(method){

                @Override
                public String onColumnName(String columnName) {
                    SQLProperty tempProperty = (SQLProperty)this.currentEntity.get(columnName);
                    AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                    return tempProperty.columnName;
                }

                @Override
                public String onDynamicSQL(JQL.JQLDynamicStatementType dynamicStatement) {
                    method.jql.dynamicReplace.put(dynamicStatement, "#{" + (Object)((Object)dynamicStatement) + "}");
                    return "";
                }

                @Override
                public String onBindParameter(String bindParameterName, boolean inStatement) {
                    if (!inStatement) {
                        return "?";
                    }
                    methodBuilder.addComment("need to use $T operations", new Object[]{SpreadUtils.class});
                    dynamicCodeBlock.append((dynamicCodeBlock.length() > 0 ? "," : "") + String.format("SpreadUtils.generateQuestion(%s)", method.findParameterNameByAlias(bindParameterName)));
                    return "%s";
                }
            });
            methodBuilder.addCode("\n// manage WHERE statement\n", new Object[0]);
            String value = sqlWhere;
            String valueToReplace = jql.dynamicReplace.get((Object)JQL.JQLDynamicStatementType.DYNAMIC_WHERE);
            if (method.jql.operationType == JQL.JQLType.SELECT) {
                String prefix = "";
                String suffix = "";
                if (jql.isDynamicSpreadConditions()) {
                    prefix = "String.format(";
                    suffix = String.format(",%s)", dynamicCodeBlock.toString());
                }
                if (jql.isStaticWhereConditions() && !jql.isDynamicWhereConditions()) {
                    methodBuilder.addStatement("String _sqlWhereStatement=" + prefix + "$S" + suffix, new Object[]{value});
                } else if (jql.isStaticWhereConditions() && jql.isDynamicWhereConditions()) {
                    methodBuilder.addStatement("String _sqlWhereStatement=" + prefix + "$S" + suffix + "+$T.ifNotEmptyAppend($L,\" $L \")", new Object[]{value.replace(valueToReplace, ""), StringUtils.class, "_sqlDynamicWhere", method.dynamicWherePrepend});
                } else if (!jql.isStaticWhereConditions() && jql.isDynamicWhereConditions()) {
                    methodBuilder.addStatement("String _sqlWhereStatement=$T.ifNotEmptyAppend($L, \" $L \")", new Object[]{StringUtils.class, "_sqlDynamicWhere", "WHERE"});
                }
            } else {
                value = value.replace(" WHERE", "");
                if (jql.isStaticWhereConditions() && !jql.isDynamicWhereConditions()) {
                    methodBuilder.addStatement("String _sqlWhereStatement=$S", new Object[]{value});
                } else if (jql.isStaticWhereConditions() && jql.isDynamicWhereConditions()) {
                    methodBuilder.addStatement("String _sqlWhereStatement=$S+$T.ifNotEmptyAppend($L,\" $L \")", new Object[]{value.replace(valueToReplace, ""), StringUtils.class, "_sqlDynamicWhere", method.dynamicWherePrepend});
                } else if (!jql.isStaticWhereConditions() && jql.isDynamicWhereConditions()) {
                    methodBuilder.addStatement("String _sqlWhereStatement=$T.ifNotEmptyAppend($L, \" \")", new Object[]{StringUtils.class, "_sqlDynamicWhere"});
                }
            }
            methodBuilder.addStatement("_sqlBuilder.append($L)", new Object[]{"_sqlWhereStatement"});
            methodBuilder.addCode("\n// manage WHERE arguments -- END\n", new Object[0]);
        } else {
            methodBuilder.addStatement("String _sqlWhereStatement=\"\"", new Object[0]);
        }
        if (method.hasDynamicWhereConditions() && method.hasDynamicWhereArgs()) {
            methodBuilder.beginControlFlow("if ($T.hasText(_sqlDynamicWhere) && _sqlDynamicWhereArgs!=null)", new Object[]{StringUtils.class});
            if (method.hasDynamicWhereConditions()) {
                methodBuilder.beginControlFlow("for (String _arg: _sqlDynamicWhereArgs)", new Object[0]);
                methodBuilder.addStatement("_contentValues.addWhereArgs(_arg)", new Object[0]);
                methodBuilder.endControlFlow();
            }
            methodBuilder.endControlFlow();
        }
    }

    public static void generateLog(SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        if (daoDefinition.isLogEnabled()) {
            methodBuilder.addComment("log section BEGIN", new Object[0]);
            methodBuilder.beginControlFlow("if (_context.isLogEnabled())", new Object[0]);
            methodBuilder.addCode("// log for insert -- BEGIN \n", new Object[0]);
            JQLChecker checker = JQLChecker.getInstance();
            final One inWhere = new One((Object)false);
            String sql = checker.replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

                @Override
                public String onBindParameter(String bindParameterName, boolean inStatement) {
                    if (((Boolean)inWhere.value0).booleanValue()) {
                        return "?";
                    }
                    return null;
                }

                @Override
                public void onWhereStatementBegin(JqlParser.Where_stmtContext ctx) {
                    super.onWhereStatementBegin(ctx);
                    inWhere.value0 = true;
                }

                @Override
                public void onWhereStatementEnd(JqlParser.Where_stmtContext ctx) {
                    super.onWhereStatementEnd(ctx);
                    inWhere.value0 = false;
                }
            });
            if (method.jql.containsSelectOperation) {
                methodBuilder.addCode("\n", new Object[0]);
                methodBuilder.addStatement("$T.info($S)", new Object[]{Logger.class, sql});
            } else {
                sql = checker.replaceVariableStatements(method, sql, new JQLReplaceVariableStatementListenerImpl(){

                    @Override
                    public String onColumnNameSet(String statement) {
                        return "%s";
                    }

                    @Override
                    public String onColumnValueSet(String statement) {
                        return "%s";
                    }
                });
                methodBuilder.addStatement("$T _columnNameBuffer=new $T()", new Object[]{StringBuffer.class, StringBuffer.class});
                methodBuilder.addStatement("$T _columnValueBuffer=new $T()", new Object[]{StringBuffer.class, StringBuffer.class});
                methodBuilder.addStatement("String _columnSeparator=$S", new Object[]{""});
                SqlBuilderHelper.forEachColumnInContentValue(methodBuilder, method, "_contentValues.keys()", false, new OnColumnListener(){

                    @Override
                    public void onColumnCheck(MethodSpec.Builder methodBuilder, String columNameVariable) {
                        methodBuilder.addStatement("_columnNameBuffer.append(_columnSeparator+$L)", new Object[]{columNameVariable});
                        methodBuilder.addStatement("_columnValueBuffer.append(_columnSeparator+$S+$L)", new Object[]{":", columNameVariable});
                        methodBuilder.addStatement("_columnSeparator=$S", new Object[]{", "});
                    }
                });
                methodBuilder.addStatement("$T.info($S, _columnNameBuffer.toString(), _columnValueBuffer.toString())", new Object[]{Logger.class, sql});
            }
            SqlBuilderHelper.generateLogForContentValues(method, methodBuilder);
            methodBuilder.addCode("// log for insert -- END \n\n", new Object[0]);
            SqlBuilderHelper.generateLogForWhereParameters(method, methodBuilder);
            methodBuilder.endControlFlow();
            methodBuilder.addComment("log section END", new Object[0]);
        }
    }

    public static void generateSQLForInsertDynamic(SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        methodBuilder.addComment("generate SQL for insert", new Object[0]);
        JQLChecker checker = JQLChecker.getInstance();
        String sql = checker.replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                return "?";
            }
        });
        final One counter = new One((Object)0);
        sql = checker.replaceVariableStatements(method, sql, new JQLReplaceVariableStatementListenerImpl(){

            @Override
            public String onColumnNameSet(String statement) {
                Integer n = (Integer)counter.value0;
                One one = counter;
                one.value0 = (Integer)one.value0 + 1;
                Integer n2 = one.value0;
                return "%s";
            }

            @Override
            public String onColumnValueSet(String statement) {
                Integer n = (Integer)counter.value0;
                One one = counter;
                one.value0 = (Integer)one.value0 + 1;
                Integer n2 = one.value0;
                return "%s";
            }
        });
        if ((Integer)counter.value0 == 2) {
            methodBuilder.addStatement("String _sql=String.format($S, _contentValues.keyList(), _contentValues.keyValueList())", new Object[]{sql});
        } else {
            methodBuilder.addStatement("String _sql=String.format($S, _contentValues.keyList())", new Object[]{sql});
        }
    }

    public static void generateSQLForStaticQuery(final SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        methodBuilder.addComment("generate static SQL for statement", new Object[0]);
        JQLChecker checker = JQLChecker.getInstance();
        String sql = checker.replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnNameToUpdate(String columnName) {
                return this.onColumnName(columnName);
            }

            @Override
            public String onColumnName(String columnName) {
                SQLProperty tempProperty = (SQLProperty)method.getEntity().get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                return "?";
            }
        });
        methodBuilder.addStatement("String _sql=$S", new Object[]{sql});
    }

    public static void generateLogForContentValuesContentProvider(SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        methodBuilder.addCode("\n// log for content values -- BEGIN\n", new Object[0]);
        methodBuilder.addStatement("Object _contentValue", new Object[0]);
        methodBuilder.beginControlFlow("for (String _contentKey:_contentValues.values().keySet())", new Object[0]);
        methodBuilder.addStatement("_contentValue=_contentValues.values().get(_contentKey)", new Object[0]);
        methodBuilder.beginControlFlow("if (_contentValue==null)", new Object[0]);
        methodBuilder.addStatement("$T.info(\"==> :%s = <null>\", _contentKey)", new Object[]{Logger.class});
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addStatement("$T.info(\"==> :%s = '%s' (%s)\", _contentKey, $T.checkSize(_contentValue), _contentValue.getClass().getCanonicalName())", new Object[]{Logger.class, StringUtils.class});
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        methodBuilder.addCode("// log for content values -- END\n", new Object[0]);
    }

    public static List<Pair<String, TypeName>> orderContentValues(final SQLiteModelMethod method, final List<Pair<String, TypeName>> updateableParams) {
        final ArrayList<Pair<String, TypeName>> result = new ArrayList<Pair<String, TypeName>>();
        JQLChecker checker = JQLChecker.getInstance();
        final One inserMode = new One((Object)false);
        checker.replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnNameToUpdate(String columnName) {
                String column = ((SQLProperty)this.currentEntity.findPropertyByName((String)columnName)).columnName;
                for (Pair item : updateableParams) {
                    String paramNameInQuery = method.findParameterAliasByName((String)item.value0);
                    if (!paramNameInQuery.equalsIgnoreCase(columnName)) continue;
                    result.add(item);
                    break;
                }
                return column;
            }

            @Override
            public void onColumnNameSetBegin(JqlParser.Column_name_setContext ctx) {
                inserMode.value0 = true;
            }

            @Override
            public void onColumnNameSetEnd(JqlParser.Column_name_setContext ctx) {
                inserMode.value0 = false;
            }

            @Override
            public String onColumnName(String columnName) {
                if (!((Boolean)inserMode.value0).booleanValue()) {
                    return columnName;
                }
                String column = ((SQLProperty)this.currentEntity.findPropertyByName((String)columnName)).columnName;
                for (Pair item : updateableParams) {
                    String paramNameInQuery = method.findParameterAliasByName((String)item.value0);
                    if (!paramNameInQuery.equalsIgnoreCase(columnName)) continue;
                    result.add(item);
                    break;
                }
                return column;
            }
        });
        return result;
    }

    public static interface OnParameterListener {
        public boolean onParameter(Pair<String, TypeName> var1);
    }
}

