/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.content.ContentValues;
import android.net.Uri;
import com.abubusoft.kripton.android.ColumnType;
import com.abubusoft.kripton.android.annotation.BindSqlInsert;
import com.abubusoft.kripton.android.sqlite.ConflictAlgorithmType;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.sqlite.GenericSQLHelper;
import com.abubusoft.kripton.processor.sqlite.InsertBeanHelper;
import com.abubusoft.kripton.processor.sqlite.InsertListBeanHelper;
import com.abubusoft.kripton.processor.sqlite.InsertRawHelper;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.ContentUriPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import javax.lang.model.element.Modifier;

public abstract class SqlInsertBuilder {
    public static void generate(TypeSpec.Builder classBuilder, SQLiteModelMethod method) {
        InsertType insertResultType = SqlInsertBuilder.detectInsertType(method);
        TypeName returnType = method.getReturnClass();
        AssertKripton.failWithInvalidMethodSignException(insertResultType == null, method);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.getName()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Pair<String, TypeName> item : method.getParameters()) {
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)((TypeName)item.value1), (String)((String)item.value0), (Modifier[])new Modifier[0]).build();
            methodBuilder.addParameter(parameterSpec);
        }
        methodBuilder.returns(returnType);
        methodBuilder.addComment("Specialized Insert - $L - BEGIN", new Object[]{((Object)((Object)insertResultType)).getClass().getSimpleName()});
        insertResultType.generate(classBuilder, methodBuilder, method, returnType);
        methodBuilder.addComment("Specialized Insert - $L - END", new Object[]{((Object)((Object)insertResultType)).getClass().getSimpleName()});
        MethodSpec methodSpec = methodBuilder.build();
        classBuilder.addMethod(methodSpec);
        if (method.contentProviderEntryPathEnabled) {
            SqlInsertBuilder.generateInsertForContentProvider(classBuilder, method, insertResultType);
        }
    }

    public static InsertType detectInsertType(SQLiteModelMethod method) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        SQLiteEntity entity = method.getEntity();
        TypeName beanTypeName = TypeUtility.typeName(entity.getElement());
        InsertType insertResultType = null;
        int beanCounter = 0;
        int beanCollectionCounter = 0;
        for (Pair<String, TypeName> param : method.getParameters()) {
            if (TypeUtility.isEquals((TypeName)param.value1, beanTypeName)) {
                ++beanCounter;
                continue;
            }
            if (!TypeUtility.isCollectionOfType((TypeName)param.value1, beanTypeName)) continue;
            ++beanCollectionCounter;
        }
        AssertKripton.failWithInvalidMethodSignException(method.getParameters().size() == 0, method, " INSERT operations require at least one parameter", new Object[0]);
        if (beanCounter == 0 && beanCollectionCounter == 0) {
            insertResultType = InsertType.INSERT_RAW;
            ModelAnnotation annotation = method.getAnnotation(BindSqlInsert.class);
            AssertKripton.failWithInvalidMethodSignException(AnnotationUtility.extractAsStringArray(method, annotation, AnnotationAttributeType.FIELDS).size() > 0, method, " can not use attribute %s in this kind of query definition", AnnotationAttributeType.FIELDS.getValue());
            AssertKripton.failWithInvalidMethodSignException(AnnotationUtility.extractAsStringArray(method, annotation, AnnotationAttributeType.EXCLUDED_FIELDS).size() > 0, method, " can not use attribute %s in this kind of query definition", AnnotationAttributeType.EXCLUDED_FIELDS.getValue());
            AssertKripton.failWithInvalidMethodSignException(method.getParameters().size() != 1 && TypeUtility.isEquals((TypeName)method.getParameters().get((int)0).value1, daoDefinition.getEntityClassName()), method);
            AssertKripton.failWithInvalidMethodSignException(annotation.getAttributeAsBoolean(AnnotationAttributeType.INCLUDE_PRIMARY_KEY), method, "attribute '%s' can not be used here", AnnotationAttributeType.INCLUDE_PRIMARY_KEY.getValue());
        } else if (beanCounter == 1) {
            insertResultType = InsertType.INSERT_BEAN;
            AssertKripton.failWithInvalidMethodSignException(method.getParameters().size() > 1, method, " aspected only one parameter of %s type", daoDefinition.getEntityClassName());
        } else if (beanCollectionCounter == 1) {
            insertResultType = InsertType.INSERT_LIST_BEAN;
            AssertKripton.failWithInvalidMethodSignException(method.getParameters().size() > 1, method, " aspected only one collection of %s type as parameter", daoDefinition.getEntityClassName());
            AssertKripton.assertTrueOrInvalidMethodSignException(TypeUtility.isCollectionOfType(method.getReturnClass(), beanTypeName) || TypeUtility.isEquals(method.getReturnClass(), TypeUtility.typeName(Void.TYPE)), method, " invalid return type for multiple insert method", daoDefinition.getEntityClassName());
        } else {
            throw new InvalidMethodSignException(method, "only one parameter of type " + TypeUtility.typeName(entity.getElement()) + " can be used");
        }
        return insertResultType;
    }

    private static void generateInsertForContentProvider(TypeSpec.Builder classBuilder, final SQLiteModelMethod method, InsertType insertResultType) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        final SQLiteEntity entity = method.getEntity();
        final LinkedHashSet<String> columns = new LinkedHashSet<String>();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.contentProviderMethodName);
        if (!method.getParent().hasSamePackageOfSchema()) {
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        ParameterSpec parameterSpec = ParameterSpec.builder(Uri.class, (String)"uri", (Modifier[])new Modifier[0]).build();
        methodBuilder.addParameter(parameterSpec);
        parameterSpec = ParameterSpec.builder(ContentValues.class, (String)"contentValues", (Modifier[])new Modifier[0]).build();
        methodBuilder.addParameter(parameterSpec);
        methodBuilder.returns(Long.TYPE);
        SqlBuilderHelper.generateLogForContentProviderBeginning(method, methodBuilder);
        JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnName(String columnName) {
                SQLProperty tempProperty = (SQLProperty)entity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                columns.add(tempProperty.columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onColumnFullyQualifiedName(String tableName, String columnName) {
                AssertKripton.fail("Inconsistent state", new Object[0]);
                return null;
            }
        });
        SqlBuilderHelper.generateColumnCheckSet(classBuilder, method, columns);
        methodBuilder.addStatement("$T _contentValues=contentValuesForContentProvider(contentValues)", new Object[]{KriptonContentValues.class});
        SqlBuilderHelper.forEachColumnInContentValue(methodBuilder, method, "_contentValues.values().keySet()", true, null);
        methodBuilder.addCode("\n", new Object[0]);
        String rxIdGetter = "result";
        for (ContentUriPlaceHolder variable : method.contentProviderUriVariables) {
            SQLProperty entityProperty = (SQLProperty)entity.get(variable.value);
            if (entityProperty != null) {
                methodBuilder.addCode("// Add parameter $L at path segment $L\n", new Object[]{variable.value, variable.pathSegmentIndex});
                TypeName entityPropertyType = entityProperty.getPropertyType().getTypeName();
                if (TypeUtility.isString(entityPropertyType)) {
                    methodBuilder.addStatement("contentValues.put($S, uri.getPathSegments().get($L))", new Object[]{entityProperty.columnName, variable.pathSegmentIndex});
                } else {
                    methodBuilder.addStatement("contentValues.put($S, Long.valueOf(uri.getPathSegments().get($L)))", new Object[]{entityProperty.columnName, variable.pathSegmentIndex});
                }
            }
            if (!entityProperty.isPrimaryKey()) continue;
            rxIdGetter = PropertyUtility.getter(entityProperty);
        }
        SqlBuilderHelper.generateLogForContentValuesContentProvider(method, methodBuilder);
        ConflictAlgorithmType conflictAlgorithmType = InsertBeanHelper.getConflictAlgorithmType(method);
        String conflictString1 = "";
        String conflictString2 = "";
        if (conflictAlgorithmType != ConflictAlgorithmType.NONE) {
            conflictString1 = "WithOnConflict";
            conflictString2 = ", " + conflictAlgorithmType.getConflictAlgorithm();
            methodBuilder.addCode("// conflict algorithm $L\n", new Object[]{method.jql.conflictAlgorithmType});
        }
        methodBuilder.addComment("insert operation", new Object[0]);
        methodBuilder.addStatement("long result = database().insert$L($S, null, _contentValues.values()$L)", new Object[]{conflictString1, entity.getTableName(), conflictString2});
        if (method.getParent().getParent().generateRx) {
            SQLProperty primaryKey = entity.getPrimaryKey();
            rxIdGetter = primaryKey.columnType == ColumnType.PRIMARY_KEY ? "result" : (primaryKey.isType(new Type[]{String.class}) ? String.format("contentValues.getAsString(\"%s\")", primaryKey.columnName) : String.format("contentValues.getAsLong(\"%s\")", primaryKey.columnName));
            GenericSQLHelper.generateSubjectNext(entity, methodBuilder, GenericSQLHelper.SubjectType.INSERT, rxIdGetter);
        }
        if (daoDefinition.hasLiveData()) {
            methodBuilder.addComment("support for livedata", new Object[0]);
            methodBuilder.addStatement("registryEvent(result>0?1:0)", new Object[0]);
        }
        methodBuilder.addStatement("return result", new Object[0]);
        SqlBuilderHelper.generateJavaDocForContentProvider(method, methodBuilder);
        methodBuilder.addJavadoc("@param uri $S\n", new Object[]{method.contentProviderUriTemplate.replace("*", "[*]")});
        methodBuilder.addJavadoc("@param contentValues content values\n", new Object[0]);
        methodBuilder.addJavadoc("@return new row's id\n", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
    }

    public static interface InsertCodeGenerator {
        public void generate(TypeSpec.Builder var1, MethodSpec.Builder var2, boolean var3, SQLiteModelMethod var4, TypeName var5);
    }

    public static enum InsertType {
        INSERT_BEAN(InsertBeanHelper.class, true),
        INSERT_LIST_BEAN(InsertListBeanHelper.class, true),
        INSERT_RAW(InsertRawHelper.class, false);

        private InsertCodeGenerator codeGenerator;
        private boolean mapFields;

        public boolean isMapFields() {
            return this.mapFields;
        }

        private InsertType(Class<? extends InsertCodeGenerator> codeGenerator, boolean mapFields) {
            try {
                this.mapFields = mapFields;
                this.codeGenerator = codeGenerator.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new KriptonRuntimeException((Throwable)e);
            }
        }

        public void generate(TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, SQLiteModelMethod method, TypeName returnType) {
            this.codeGenerator.generate(classBuilder, methodBuilder, this.isMapFields(), method, returnType);
        }
    }
}

