/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.content.ContentValues;
import android.net.Uri;
import com.abubusoft.kripton.android.Logger;
import com.abubusoft.kripton.android.annotation.BindSqlDelete;
import com.abubusoft.kripton.android.annotation.BindSqlUpdate;
import com.abubusoft.kripton.android.sqlite.ConflictAlgorithmType;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidMethodSignException;
import com.abubusoft.kripton.processor.sqlite.GenericSQLHelper;
import com.abubusoft.kripton.processor.sqlite.ModifyBeanHelper;
import com.abubusoft.kripton.processor.sqlite.ModifyRawHelper;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.core.GenerationPartMarks;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplaceVariableStatementListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.ContentUriPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;

public abstract class SqlModifyBuilder {
    public static void generate(TypeSpec.Builder classBuilder, SQLiteModelMethod method) {
        ModifyType updateResultType = SqlModifyBuilder.detectModifyType(method, method.jql.operationType);
        TypeName returnType = method.getReturnClass();
        if (updateResultType == null) {
            throw new InvalidMethodSignException(method);
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.getName()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Pair<String, TypeName> item : method.getParameters()) {
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)((TypeName)item.value1), (String)((String)item.value0), (Modifier[])new Modifier[0]).build();
            methodBuilder.addParameter(parameterSpec);
        }
        methodBuilder.returns(returnType);
        updateResultType.generate(classBuilder, methodBuilder, method, returnType);
        MethodSpec methodSpec = methodBuilder.build();
        classBuilder.addMethod(methodSpec);
        if (method.contentProviderEntryPathEnabled) {
            SqlModifyBuilder.generateModifierForContentProvider(BaseProcessor.elementUtils, classBuilder, method, updateResultType);
        }
    }

    public static ModifyType detectModifyType(SQLiteModelMethod method, JQL.JQLType jqlType) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        SQLiteEntity entity = method.getEntity();
        ModifyType updateResultType = null;
        int count = 0;
        for (Pair<String, TypeName> param : method.getParameters()) {
            if (method.isThisDynamicWhereConditionsName((String)param.value0) || !TypeUtility.isEquals((TypeName)param.value1, TypeUtility.typeName(entity.getElement()))) continue;
            ++count;
        }
        if (count == 0) {
            ModelAnnotation annotation;
            ModifyType modifyType = updateResultType = jqlType == JQL.JQLType.UPDATE ? ModifyType.UPDATE_RAW : ModifyType.DELETE_RAW;
            if (jqlType == JQL.JQLType.UPDATE) {
                annotation = method.getAnnotation(BindSqlUpdate.class);
                AssertKripton.assertTrueOrInvalidMethodSignException(AnnotationUtility.extractAsStringArray(method, annotation, AnnotationAttributeType.FIELDS).size() == 0, method, " can not use attribute %s in this kind of query definition", AnnotationAttributeType.FIELDS.getValue());
                AssertKripton.assertTrueOrInvalidMethodSignException(AnnotationUtility.extractAsStringArray(method, annotation, AnnotationAttributeType.EXCLUDED_FIELDS).size() == 0, method, " can not use attribute %s in this kind of query definition", AnnotationAttributeType.EXCLUDED_FIELDS.getValue());
            } else {
                annotation = method.getAnnotation(BindSqlDelete.class);
            }
            AssertKripton.failWithInvalidMethodSignException(method.getParameters().size() > 1 && TypeUtility.isEquals((TypeName)method.getParameters().get((int)0).value1, daoDefinition.getEntityClassName()), method);
        } else if (count == 1) {
            updateResultType = jqlType == JQL.JQLType.UPDATE ? ModifyType.UPDATE_BEAN : ModifyType.DELETE_BEAN;
            AssertKripton.assertTrueOrInvalidMethodSignException(method.getParameters().size() == 1 + (method.hasDynamicWhereConditions() ? 1 : 0) + (method.hasDynamicWhereArgs() ? 1 : 0), method, " expected only one parameter of %s type", daoDefinition.getEntityClassName());
        } else {
            throw new InvalidMethodSignException(method, "only one parameter of type " + TypeUtility.typeName(entity.getElement()) + " can be used");
        }
        return updateResultType;
    }

    private static void generateModifierForContentProvider(Elements elementUtils, TypeSpec.Builder builder, final SQLiteModelMethod method, ModifyType updateResultType) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        final SQLiteEntity entity = method.getEntity();
        final LinkedHashSet<String> columns = new LinkedHashSet<String>();
        JQLChecker jqlChecker = JQLChecker.getInstance();
        final One whereStatement = new One();
        if (method.jql.isWhereConditions()) {
            final One alreadyFoundWhereStatement = new One((Object)false);
            jqlChecker.replaceVariableStatements(method, method.jql.value, new JQLReplaceVariableStatementListenerImpl(){

                @Override
                public String onWhere(String statement) {
                    if (!((Boolean)alreadyFoundWhereStatement.value0).booleanValue()) {
                        whereStatement.value0 = statement;
                        alreadyFoundWhereStatement.value0 = true;
                        return "";
                    }
                    return null;
                }
            });
        }
        List<JQLPlaceHolder> placeHolders = jqlChecker.extractFromVariableStatement(method, (String)whereStatement.value0);
        placeHolders = SqlBuilderHelper.removeDynamicPlaceHolder(placeHolders);
        SqlModifyBuilder.checkContentProviderVarsAndArguments(method, placeHolders);
        jqlChecker.replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnNameToUpdate(String columnName) {
                SQLProperty tempProperty = (SQLProperty)entity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                columns.add(tempProperty.columnName);
                return null;
            }
        });
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.contentProviderMethodName);
        if (!method.getParent().hasSamePackageOfSchema()) {
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        methodBuilder.addParameter(ParameterSpec.builder(Uri.class, (String)"uri", (Modifier[])new Modifier[0]).build());
        if (updateResultType == ModifyType.UPDATE_BEAN || updateResultType == ModifyType.UPDATE_RAW) {
            methodBuilder.addParameter(ParameterSpec.builder(ContentValues.class, (String)"contentValues", (Modifier[])new Modifier[0]).build());
        }
        methodBuilder.addParameter(ParameterSpec.builder(String.class, (String)"selection", (Modifier[])new Modifier[0]).build());
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"selectionArgs", (Modifier[])new Modifier[0]).build());
        methodBuilder.returns(Integer.TYPE);
        if (updateResultType == ModifyType.UPDATE_BEAN || updateResultType == ModifyType.UPDATE_RAW) {
            methodBuilder.addStatement("$T _contentValues=contentValuesForContentProvider(contentValues)", new Object[]{KriptonContentValues.class});
        } else {
            methodBuilder.addStatement("$T _contentValues=contentValues()", new Object[]{KriptonContentValues.class});
        }
        SqlBuilderHelper.generateLogForContentProviderBeginning(method, methodBuilder);
        methodBuilder.addStatement("$T _sqlBuilder=sqlBuilder()", new Object[]{StringBuilder.class});
        SqlModifyBuilder.generateInitForDynamicWhereVariables(method, methodBuilder, "selection", "selectionArgs");
        SqlBuilderHelper.generateWhereCondition(methodBuilder, method, false);
        int i = 0;
        for (ContentUriPlaceHolder variable : method.contentProviderUriVariables) {
            AssertKripton.assertTrue(SqlBuilderHelper.validate(variable.value, placeHolders, i), "In '%s.%s' content provider URI path variables and variables in where conditions are different. If SQL uses parameters, they must be defined in URI path.", daoDefinition.getName(), method.getName());
            JQLChecker.JQLParameterName paramName = JQLChecker.JQLParameterName.parse(variable.value);
            SQLProperty entityProperty = (SQLProperty)entity.get(paramName.getValue());
            if (entityProperty != null) {
                methodBuilder.addCode("// Add parameter $L at path segment $L\n", new Object[]{variable.value, variable.pathSegmentIndex});
                methodBuilder.addStatement("_contentValues.addWhereArgs(uri.getPathSegments().get($L))", new Object[]{variable.pathSegmentIndex});
                AssertKripton.assertTrue(TypeUtility.isTypeIncludedIn(entityProperty.getPropertyType().getTypeName(), new Type[]{String.class, Long.class, Long.TYPE}), "In '%s.%s' content provider URI path variables %s must be String of Long type", daoDefinition.getName(), method.getName(), entityProperty.getName());
            }
            ++i;
        }
        if (method.hasDynamicWhereConditions() && method.hasDynamicWhereArgs()) {
            methodBuilder.beginControlFlow("if ($T.hasText(_sqlDynamicWhere) && _sqlDynamicWhereArgs!=null)", new Object[]{StringUtils.class});
            if (method.hasDynamicWhereConditions()) {
                methodBuilder.beginControlFlow("for (String _arg: _sqlDynamicWhereArgs)", new Object[0]);
                methodBuilder.addStatement("_contentValues.addWhereArgs(_arg)", new Object[0]);
                methodBuilder.endControlFlow();
            }
            methodBuilder.endControlFlow();
        }
        switch (updateResultType) {
            case UPDATE_BEAN: 
            case UPDATE_RAW: {
                SqlBuilderHelper.generateColumnCheckSet(builder, method, columns);
                SqlBuilderHelper.forEachColumnInContentValue(methodBuilder, method, "_contentValues.values().keySet()", true, null);
                break;
            }
        }
        methodBuilder.addComment("log section BEGIN", new Object[0]);
        methodBuilder.beginControlFlow("if (_context.isLogEnabled())", new Object[0]);
        SqlModifyBuilder.generateLogForModifiers(method, methodBuilder);
        if (method.jql.operationType == JQL.JQLType.UPDATE) {
            SqlBuilderHelper.generateLogForContentValues(method, methodBuilder);
        }
        SqlBuilderHelper.generateLogForWhereParameters(method, methodBuilder);
        methodBuilder.endControlFlow();
        methodBuilder.addComment("log section END", new Object[0]);
        methodBuilder.addCode("\n// execute SQL\n", new Object[0]);
        switch (updateResultType) {
            case DELETE_BEAN: 
            case DELETE_RAW: {
                methodBuilder.addStatement("int result = database().delete($S, _sqlWhereStatement, _contentValues.whereArgsAsArray())", new Object[]{entity.getTableName()});
                if (!method.getParent().getParent().generateRx) break;
                GenericSQLHelper.generateSubjectNext(entity, methodBuilder, GenericSQLHelper.SubjectType.DELETE, "result");
                break;
            }
            case UPDATE_BEAN: 
            case UPDATE_RAW: {
                if (method.jql.conflictAlgorithmType == ConflictAlgorithmType.NONE) {
                    methodBuilder.addStatement("int result = database().update($S, _contentValues.values(), _sqlWhereStatement, _contentValues.whereArgsAsArray())", new Object[]{entity.getTableName()});
                } else {
                    methodBuilder.addCode("// conflict algorithm $L\n", new Object[]{method.jql.conflictAlgorithmType});
                    methodBuilder.addStatement("int result = database().updateWithOnConflict($S, _contentValues.values(), _sqlWhereStatement, _contentValues.whereArgsAsArray()), $L)", new Object[]{entity.getTableName(), method.jql.conflictAlgorithmType.getConflictAlgorithm()});
                }
                if (!method.getParent().getParent().generateRx) break;
                GenericSQLHelper.generateSubjectNext(entity, methodBuilder, GenericSQLHelper.SubjectType.UPDATE, "result");
            }
        }
        if (daoDefinition.hasLiveData()) {
            methodBuilder.addComment("support for livedata", new Object[0]);
            methodBuilder.addStatement("registryEvent(result)", new Object[0]);
        }
        methodBuilder.addStatement("return result", new Object[0]);
        SqlBuilderHelper.generateJavaDocForContentProvider(method, methodBuilder);
        methodBuilder.addJavadoc("@param uri $S\n", new Object[]{method.contentProviderUriTemplate.replace("*", "[*]")});
        switch (updateResultType) {
            case UPDATE_BEAN: 
            case UPDATE_RAW: {
                methodBuilder.addJavadoc("@param contentValues content values\n", new Object[0]);
                break;
            }
        }
        methodBuilder.addJavadoc("@param selection dynamic part of <code>where</code> statement $L\n", new Object[]{method.hasDynamicWhereConditions() ? "" : "<b>NOT USED</b>"});
        methodBuilder.addJavadoc("@param selectionArgs arguments of dynamic part of <code>where</code> statement $L\n", new Object[]{method.hasDynamicWhereConditions() ? "" : "<b>NOT USED</b>"});
        methodBuilder.addJavadoc("@return number of effected rows\n", new Object[0]);
        builder.addMethod(methodBuilder.build());
    }

    public static void checkContentProviderVarsAndArguments(SQLiteModelMethod method, List<JQLPlaceHolder> placeHolders) {
        AssertKripton.assertTrue(placeHolders.size() == method.contentProviderUriVariables.size(), "In '%s.%s' content provider URI path variables and variables used in where conditions are different. If SQL uses parameters, they must be defined in URI path.", method.getParent().getName(), method.getName());
    }

    static void generateInitForDynamicWhereVariables(SQLiteModelMethod method, MethodSpec.Builder methodBuilder, String dynamiWhereName, String dynamicWhereArgsName) {
        GenerationPartMarks.begin(methodBuilder, GenerationPartMarks.CODE_001);
        if (method.hasDynamicWhereConditions()) {
            methodBuilder.addCode("// initialize dynamic where\n", new Object[0]);
            methodBuilder.addStatement("String _sqlDynamicWhere=$L", new Object[]{dynamiWhereName});
        }
        if (method.hasDynamicWhereArgs()) {
            methodBuilder.addCode("// initialize dynamic where args\n", new Object[0]);
            methodBuilder.addStatement("String[] _sqlDynamicWhereArgs=$L", new Object[]{dynamicWhereArgsName});
        }
        GenerationPartMarks.end(methodBuilder, GenerationPartMarks.CODE_001);
    }

    public static void generateLogForModifiers(final SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        JQLChecker jqlChecker = JQLChecker.getInstance();
        final One usedInWhere = new One((Object)false);
        methodBuilder.addCode("\n// display log\n", new Object[0]);
        String sqlForLog = jqlChecker.replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnNameToUpdate(String columnName) {
                return ((SQLProperty)this.currentEntity.findPropertyByName((String)columnName)).columnName;
            }

            @Override
            public String onColumnName(String columnName) {
                return this.currentSchema.findColumnNameByPropertyName(method, columnName);
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                SQLProperty property;
                String[] a;
                if (((Boolean)usedInWhere.value0).booleanValue()) {
                    return "?";
                }
                String paramName = bindParameterName;
                if (paramName.contains(".") && (a = paramName.split("\\.")).length == 2) {
                    paramName = a[1];
                }
                AssertKripton.assertTrueOrUnknownPropertyInJQLException((property = (SQLProperty)this.currentEntity.findPropertyByName(paramName)) != null, method, bindParameterName);
                return ":" + property.columnName;
            }

            @Override
            public void onWhereStatementBegin(JqlParser.Where_stmtContext ctx) {
                usedInWhere.value0 = true;
            }

            @Override
            public void onWhereStatementEnd(JqlParser.Where_stmtContext ctx) {
                usedInWhere.value0 = false;
            }
        });
        if (method.jql.dynamicReplace.containsKey((Object)JQL.JQLDynamicStatementType.DYNAMIC_WHERE)) {
            methodBuilder.addStatement("$T.info($S, $L)", new Object[]{Logger.class, sqlForLog.replace(method.jql.dynamicReplace.get((Object)JQL.JQLDynamicStatementType.DYNAMIC_WHERE), "%s"), "StringUtils.ifNotEmptyAppend(_sqlDynamicWhere,\" AND \")"});
        } else {
            methodBuilder.addStatement("$T.info($S)", new Object[]{Logger.class, sqlForLog});
        }
    }

    public static void generateSQL(final SQLiteModelMethod method, MethodSpec.Builder methodBuilder) {
        JQLChecker jqlChecker = JQLChecker.getInstance();
        methodBuilder.addCode("\n// generate sql\n", new Object[0]);
        String sql = jqlChecker.replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnNameToUpdate(String columnName) {
                return ((SQLProperty)this.currentEntity.findPropertyByName((String)columnName)).columnName;
            }

            @Override
            public String onColumnName(String columnName) {
                return this.currentSchema.findColumnNameByPropertyName(method, columnName);
            }

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                return "?";
            }
        });
        if (method.jql.dynamicReplace.containsKey((Object)JQL.JQLDynamicStatementType.DYNAMIC_WHERE)) {
            methodBuilder.addStatement("String _sql=String.format($S, $L)", new Object[]{sql.replace(method.jql.dynamicReplace.get((Object)JQL.JQLDynamicStatementType.DYNAMIC_WHERE), "%s"), "StringUtils.ifNotEmptyAppend(_sqlDynamicWhere,\" AND \")"});
        } else {
            methodBuilder.addStatement("String _sql=$S", new Object[]{sql});
        }
    }

    public static interface ModifyCodeGenerator {
        public void generate(TypeSpec.Builder var1, MethodSpec.Builder var2, boolean var3, SQLiteModelMethod var4, TypeName var5);
    }

    public static enum ModifyType {
        UPDATE_BEAN(ModifyBeanHelper.class, true),
        UPDATE_RAW(ModifyRawHelper.class, true),
        DELETE_BEAN(ModifyBeanHelper.class, false),
        DELETE_RAW(ModifyRawHelper.class, false);

        private ModifyCodeGenerator codeGenerator;
        private boolean update;

        public boolean isUpdate() {
            return this.update;
        }

        private ModifyType(Class<? extends ModifyCodeGenerator> codeGenerator, boolean updateValue) {
            try {
                this.update = updateValue;
                this.codeGenerator = codeGenerator.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new KriptonRuntimeException((Throwable)e);
            }
        }

        public void generate(TypeSpec.Builder classBuilder, MethodSpec.Builder methodBuilder, SQLiteModelMethod method, TypeName returnType) {
            this.codeGenerator.generate(classBuilder, methodBuilder, this.isUpdate(), method, returnType);
        }
    }
}

