/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite;

import android.database.Cursor;
import android.net.Uri;
import com.abubusoft.kripton.android.sqlite.KriptonContentValues;
import com.abubusoft.kripton.android.sqlite.SqlUtils;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelMethod;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.OnColumnListener;
import com.abubusoft.kripton.processor.sqlite.SelectBuilderUtility;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.SqlModifyBuilder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplaceVariableStatementListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.ContentUriPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public abstract class SqlSelectBuilder {
    public static String getNameParameterOfType(ModelMethod method, TypeName parameter) {
        for (Pair<String, TypeName> item : method.getParameters()) {
            if (!((TypeName)item.value1).equals((Object)parameter)) continue;
            return (String)item.value0;
        }
        return null;
    }

    public static void generateSelect(TypeSpec.Builder builder, SQLiteModelMethod method) throws ClassNotFoundException {
        SelectBuilderUtility.SelectType selectResultType = SelectBuilderUtility.detectSelectType(method);
        selectResultType.generate(builder, method);
        if (method.hasLiveData()) {
            selectResultType.generateLiveData(builder, method);
        }
        if (method.contentProviderEntryPathEnabled) {
            SqlSelectBuilder.generateSelectForContentProvider(builder, method, selectResultType);
        }
    }

    private static void generateSelectForContentProvider(TypeSpec.Builder builder, SQLiteModelMethod method, SelectBuilderUtility.SelectType selectResultType) {
        SQLiteDaoDefinition daoDefinition = method.getParent();
        SQLiteEntity entity = method.getEntity();
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.contentProviderMethodName);
        if (!method.getParent().hasSamePackageOfSchema()) {
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        methodBuilder.addParameter(ParameterSpec.builder(Uri.class, (String)"uri", (Modifier[])new Modifier[0]).build());
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"projection", (Modifier[])new Modifier[0]).build());
        methodBuilder.addParameter(ParameterSpec.builder(String.class, (String)"selection", (Modifier[])new Modifier[0]).build());
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)ArrayTypeName.of(String.class), (String)"selectionArgs", (Modifier[])new Modifier[0]).build());
        methodBuilder.addParameter(ParameterSpec.builder(String.class, (String)"sortOrder", (Modifier[])new Modifier[0]).build());
        methodBuilder.returns(Cursor.class);
        SqlBuilderHelper.generateLogForContentProviderBeginning(method, methodBuilder);
        JQLChecker jqlChecker = JQLChecker.getInstance();
        SplittedSql splittedSql = SqlSelectBuilder.generateSQL(method, methodBuilder, true);
        List<JQLPlaceHolder> placeHolders = jqlChecker.extractFromVariableStatement(method, splittedSql.sqlWhereStatement);
        placeHolders = SqlBuilderHelper.removeDynamicPlaceHolder(placeHolders);
        AssertKripton.assertTrue(placeHolders.size() == method.contentProviderUriVariables.size(), "In '%s.%s' content provider URI path variables and variables in where conditions are different. If SQL uses parameters, they must be defined in URI path.", daoDefinition.getName(), method.getName());
        Set<JQLProjection> projectedColumns = jqlChecker.extractProjections(method, method.jql.value, entity);
        for (JQLProjection item : projectedColumns) {
            if (item.type == JQLProjection.ProjectionType.COLUMN) {
                if (item.alias != null) {
                    columns.add(((SQLProperty)entity.get((String)item.alias.trim())).columnName);
                    continue;
                }
                columns.add(((SQLProperty)entity.get((String)item.column.trim())).columnName);
                continue;
            }
            columns.add(item.expression.trim());
        }
        methodBuilder.addStatement("$T _contentValues=contentValues()", new Object[]{KriptonContentValues.class});
        methodBuilder.addStatement("$T _sqlBuilder=sqlBuilder()", new Object[]{StringBuilder.class});
        SqlModifyBuilder.generateInitForDynamicWhereVariables(method, methodBuilder, "selection", "selectionArgs");
        methodBuilder.addStatement("$T _projectionBuffer=new $T()", new Object[]{StringBuilder.class, StringBuilder.class});
        if (method.jql.isOrderBy()) {
            methodBuilder.addStatement("String _sortOrder=sortOrder", new Object[0]);
        }
        methodBuilder.addStatement("_sqlBuilder.append($S)", new Object[]{splittedSql.sqlBasic});
        SqlBuilderHelper.generateWhereCondition(methodBuilder, method, false);
        SqlSelectBuilder.generateDynamicPartOfQuery(method, methodBuilder, splittedSql, false);
        methodBuilder.addCode("\n// manage projected columns\n", new Object[0]);
        methodBuilder.addStatement("String _columnSeparator=\"\"", new Object[0]);
        methodBuilder.beginControlFlow("if (projection!=null && projection.length>0)", new Object[0]);
        String columnCheckSetName = SqlBuilderHelper.generateColumnCheckSet(builder, method, columns);
        SqlBuilderHelper.forEachColumnInContentValue(methodBuilder, method, "projection", true, new OnColumnListener(){

            @Override
            public void onColumnCheck(MethodSpec.Builder methodBuilder, String projectedColumnVariable) {
                methodBuilder.addStatement("_projectionBuffer.append(_columnSeparator + $L)", new Object[]{projectedColumnVariable});
                methodBuilder.addStatement("_columnSeparator=\", \"", new Object[0]);
            }
        });
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.beginControlFlow("for (String column: $L)", new Object[]{columnCheckSetName});
        methodBuilder.addStatement("_projectionBuffer.append(_columnSeparator + column)", new Object[0]);
        methodBuilder.addStatement("_columnSeparator=\", \"", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        int i = 0;
        for (ContentUriPlaceHolder variable : method.contentProviderUriVariables) {
            AssertKripton.assertTrue(SqlBuilderHelper.validate(variable.value, placeHolders, i), "In '%s.%s' content provider URI path and where conditions must use same set of variables", daoDefinition.getName(), method.getName());
            SQLProperty entityProperty = (SQLProperty)entity.get(variable.value);
            TypeName methodParameterType = method.findParameterTypeByAliasOrName(variable.value);
            methodBuilder.addCode("// Add parameter $L at path segment $L\n", new Object[]{variable.value, variable.pathSegmentIndex});
            methodBuilder.addStatement("_contentValues.addWhereArgs(uri.getPathSegments().get($L))", new Object[]{variable.pathSegmentIndex});
            if (entityProperty != null) {
                AssertKripton.assertTrue(TypeUtility.isTypeIncludedIn(entityProperty.getPropertyType().getTypeName(), new Type[]{String.class, Long.class, Long.TYPE}), "In '%s.%s' content provider URI path variables %s must be String of Long type", daoDefinition.getName(), method.getName(), entityProperty.getName());
            } else if (methodParameterType != null) {
                AssertKripton.assertTrue(TypeUtility.isTypeIncludedIn(methodParameterType, new Type[]{String.class, Long.class, Long.TYPE}), "In '%s.%s' content provider URI path variables %s must be String of Long type", daoDefinition.getName(), method.getName(), method.findParameterNameByAlias(variable.value));
            }
            ++i;
        }
        methodBuilder.addStatement("String _sql=String.format(_sqlBuilder.toString(), _projectionBuffer.toString())", new Object[0]);
        SqlBuilderHelper.generateLogForSQL(method, methodBuilder);
        SqlBuilderHelper.generateLogForWhereParameters(method, methodBuilder);
        methodBuilder.addCode("\n// execute query\n", new Object[0]);
        methodBuilder.addStatement("Cursor _result = database().rawQuery(_sql, _contentValues.whereArgsAsArray())", new Object[0]);
        methodBuilder.addStatement("return _result", new Object[0]);
        SqlBuilderHelper.generateJavaDocForContentProvider(method, methodBuilder);
        methodBuilder.addJavadoc("@param uri $S\n", new Object[]{method.contentProviderUriTemplate.replace("*", "[*]")});
        methodBuilder.addJavadoc("@param selection dynamic part of <code>where</code> statement $L\n", new Object[]{method.hasDynamicWhereConditions() ? "" : "<b>NOT USED</b>"});
        methodBuilder.addJavadoc("@param selectionArgs arguments of dynamic part of <code>where</code> statement $L\n", new Object[]{method.hasDynamicWhereConditions() ? "" : "<b>NOT USED</b>"});
        methodBuilder.addJavadoc("@return number of effected rows\n", new Object[0]);
        builder.addMethod(methodBuilder.build());
    }

    public static void generateDynamicPartOfQuery(SQLiteModelMethod method, MethodSpec.Builder methodBuilder, SplittedSql splittedSql, boolean countQuery) {
        JQL jql = method.jql;
        if (StringUtils.hasText((String)splittedSql.sqlGroupStatement)) {
            methodBuilder.addCode("\n// manage GROUP BY statement\n", new Object[0]);
            methodBuilder.addStatement("String _sqlGroupByStatement=$S", new Object[]{splittedSql.sqlGroupStatement});
            methodBuilder.addStatement("_sqlBuilder.append($L)", new Object[]{"_sqlGroupByStatement"});
        }
        if (StringUtils.hasText((String)splittedSql.sqlHavingStatement)) {
            methodBuilder.addCode("\n// manage HAVING statement\n", new Object[0]);
            methodBuilder.addStatement("String _sqlHavingStatement=$S", new Object[]{splittedSql.sqlHavingStatement});
            methodBuilder.addStatement("_sqlBuilder.append($L)", new Object[]{"_sqlHavingStatement"});
        }
        if (!countQuery) {
            if (jql.isOrderBy()) {
                methodBuilder.addComment("generation order - BEGIN", new Object[0]);
                String value = splittedSql.sqlOrderByStatement;
                String valueToReplace = jql.dynamicReplace.get((Object)JQL.JQLDynamicStatementType.DYNAMIC_ORDER_BY);
                if (jql.isStaticOrderBy() && !jql.isDynamicOrderBy()) {
                    methodBuilder.addStatement("String _sqlOrderByStatement=$S", new Object[]{value});
                } else if (jql.isStaticOrderBy() && jql.isDynamicOrderBy()) {
                    methodBuilder.addStatement("String _sqlOrderByStatement=$S+$T.ifNotEmptyAppend($L, \", \")", new Object[]{value.replace(valueToReplace, ""), StringUtils.class, "_sortOrder"});
                } else if (!jql.isStaticOrderBy() && jql.isDynamicOrderBy()) {
                    methodBuilder.addStatement("String _sqlOrderByStatement=$T.ifNotEmptyAppend($L,\" $L \")", new Object[]{StringUtils.class, "_sortOrder", "ORDER BY"});
                }
                methodBuilder.addStatement("_sqlBuilder.append($L)", new Object[]{"_sqlOrderByStatement"});
                methodBuilder.addComment("generation order - END", new Object[0]);
                methodBuilder.addCode("\n", new Object[0]);
            }
            if (jql.dynamicReplace.containsKey((Object)JQL.JQLDynamicStatementType.DYNAMIC_PAGE_SIZE) || jql.annotatedPageSize) {
                methodBuilder.addComment("generation limit - BEGIN", new Object[0]);
                if (SelectBuilderUtility.detectSelectType(method) != SelectBuilderUtility.SelectType.PAGED_RESULT && !method.isPagedLiveData()) {
                    methodBuilder.addStatement("String _sqlLimitStatement=$S", new Object[]{splittedSql.sqlLimitStatement});
                } else if (jql.annotatedPageSize || method.isPagedLiveData()) {
                    methodBuilder.addStatement("String _sqlLimitStatement=\" LIMIT \"+$L", new Object[]{"paginatedResult.getPageSize()"});
                } else if (jql.hasParamPageSize()) {
                    methodBuilder.addStatement("String _sqlLimitStatement=$T.printIf($L>0, \" LIMIT \"+$L)", new Object[]{SqlUtils.class, "paginatedResult.getPageSize()", "paginatedResult.getPageSize()"});
                }
                methodBuilder.addStatement("_sqlBuilder.append($L)", new Object[]{"_sqlLimitStatement"});
                methodBuilder.addComment("generation limit - END", new Object[0]);
                methodBuilder.addCode("\n", new Object[0]);
            }
            if (jql.dynamicReplace.containsKey((Object)JQL.JQLDynamicStatementType.DYNAMIC_PAGE_OFFSET) && (SelectBuilderUtility.detectSelectType(method) == SelectBuilderUtility.SelectType.PAGED_RESULT || method.isPagedLiveData())) {
                methodBuilder.addComment("generation offset - BEGIN", new Object[0]);
                if (jql.annotatedPageSize || method.isPagedLiveData()) {
                    methodBuilder.addStatement("String _sqlOffsetStatement=\" OFFSET \"+paginatedResult.getOffset()", new Object[]{SqlUtils.class});
                } else if (jql.hasParamPageSize()) {
                    methodBuilder.addStatement("String _sqlOffsetStatement=$T.printIf($L>0 && paginatedResult.getOffset()>0, \" OFFSET \"+paginatedResult.getOffset())", new Object[]{SqlUtils.class, jql.paramPageSize});
                }
                methodBuilder.addStatement("_sqlBuilder.append($L)", new Object[]{"_sqlOffsetStatement"});
                methodBuilder.addComment("generation offset - END", new Object[0]);
                methodBuilder.addCode("\n", new Object[0]);
            }
        }
    }

    static SplittedSql generateSQL(SQLiteModelMethod method, MethodSpec.Builder methodBuilder, final boolean replaceProjectedColumns) {
        JQLChecker jqlChecker = JQLChecker.getInstance();
        final SplittedSql splittedSql = new SplittedSql();
        String sql = SqlSelectBuilder.convertJQL2SQL(method, false);
        splittedSql.sqlBasic = jqlChecker.replaceVariableStatements(method, sql, new JQLReplaceVariableStatementListenerImpl(){

            @Override
            public String onWhere(String statement) {
                splittedSql.sqlWhereStatement = statement;
                return "";
            }

            @Override
            public String onOrderBy(String statement) {
                splittedSql.sqlOrderByStatement = statement;
                return "";
            }

            @Override
            public String onOffset(String statement) {
                splittedSql.sqlOffsetStatement = statement;
                return "";
            }

            @Override
            public String onLimit(String statement) {
                splittedSql.sqlLimitStatement = statement;
                return "";
            }

            @Override
            public String onHaving(String statement) {
                splittedSql.sqlHavingStatement = statement;
                return "";
            }

            @Override
            public String onGroup(String statement) {
                splittedSql.sqlGroupStatement = statement;
                return "";
            }

            @Override
            public String onProjectedColumns(String statement) {
                if (replaceProjectedColumns) {
                    return "%s";
                }
                return null;
            }
        });
        return splittedSql;
    }

    public static String convertJQL2SQL(final SQLiteModelMethod method, final boolean replaceWithQuestion) {
        JQLChecker jqlChecker = JQLChecker.getInstance();
        String sql = jqlChecker.replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onBindParameter(String bindParameterName, boolean inStatement) {
                if (replaceWithQuestion) {
                    return "?";
                }
                return SqlAnalyzer.PARAM_PREFIX + bindParameterName + SqlAnalyzer.PARAM_SUFFIX;
            }

            @Override
            public String onColumnName(String columnName) {
                SQLProperty tempProperty = (SQLProperty)this.currentEntity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onColumnAlias(String alias) {
                SQLProperty tempProperty = (SQLProperty)this.currentEntity.get(alias);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, alias);
                return tempProperty.columnName;
            }
        });
        return sql;
    }

    public static class SplittedSql {
        public String sqlWhereStatement;
        public String sqlOrderByStatement;
        public String sqlOffsetStatement;
        public String sqlLimitStatement;
        public String sqlHavingStatement;
        public String sqlGroupStatement;
        public String sqlBasic;
    }
}

