/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class EntitySorter<E> {
    private List<E> input;
    private ArrayList<E> output;

    public EntitySorter(List<E> input) {
        this.input = input;
        this.output = new ArrayList();
    }

    public abstract Collection<E> getDependencies(E var1);

    public abstract void generateError(E var1);

    public List<E> order() {
        int index = 0;
        for (E item : this.input) {
            index = this.output.indexOf(item);
            if (index != -1) continue;
            this.insert(item, item);
        }
        return this.output;
    }

    private void insert(E master, E current) {
        Collection<E> dependencies = this.getDependencies(current);
        for (E item : dependencies) {
            if (item.equals(master)) {
                this.generateError(master);
            }
            this.insert(master, item);
        }
        if (this.output.indexOf(current) == -1) {
            this.output.add(current);
        }
    }
}

