/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.core;

import com.abubusoft.kripton.android.sqlite.OnReadBeanListener;
import com.abubusoft.kripton.android.sqlite.OnReadCursorListener;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.common.Triple;
import com.abubusoft.kripton.processor.BindDataSourceSubProcessor;
import com.abubusoft.kripton.processor.Version;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.AbstractSelectCodeGenerator;
import com.abubusoft.kripton.processor.sqlite.SelectBuilderUtility;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLContext;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLProjection;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLReplacerListenerImpl;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class JavadocUtility {
    public static void generateJavadocGeneratedBy(TypeSpec.Builder builder) {
        if (!BindDataSourceSubProcessor.JUNIT_TEST_MODE) {
            builder.addJavadoc("<p><strong>This class is generated by Kripton Annotation Processor - v. $L</strong></p>\n", new Object[]{Version.getVersion()});
            builder.addJavadoc("<p><strong>Generation-time: $L</strong></p>\n\n", new Object[]{new Date().toString()});
        }
    }

    public static void generateJavaDocForSelect(MethodSpec.Builder methodBuilder, List<String> sqlParams, final SQLiteModelMethod method, ModelAnnotation annotation, Set<JQLProjection> projectedColumns, SelectBuilderUtility.SelectType selectResultType, AbstractSelectCodeGenerator.JavadocPart ... javadocParts) {
        final SQLiteEntity entity = method.getEntity();
        TypeName beanTypeName = TypeName.get((TypeMirror)((TypeElement)entity.getElement()).asType());
        String sql = JQLChecker.getInstance().replace((JQLContext)method, method.jql, (JQLReplacerListener)new JQLReplacerListenerImpl(method){

            @Override
            public String onColumnName(String columnName) {
                SQLProperty tempProperty = (SQLProperty)entity.get(columnName);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, columnName);
                return tempProperty.columnName;
            }

            @Override
            public String onColumnAlias(String alias) {
                SQLProperty tempProperty = (SQLProperty)entity.findPropertyByName(alias);
                AssertKripton.assertTrueOrUnknownPropertyInJQLException(tempProperty != null, method, alias);
                return tempProperty.columnName;
            }
        });
        methodBuilder.addJavadoc("<h2>Select SQL:</h2>\n\n", new Object[]{annotation.getSimpleName()});
        methodBuilder.addJavadoc("<pre>$L</pre>", new Object[]{sql});
        methodBuilder.addJavadoc("\n\n", new Object[0]);
        methodBuilder.addJavadoc("<h2>Mapped class:</h2>\n", new Object[0]);
        methodBuilder.addJavadoc("{@link $T}", new Object[]{method.getEntity().getElement()});
        methodBuilder.addJavadoc("\n\n", new Object[0]);
        methodBuilder.addJavadoc("<h2>Projected columns:</h2>\n", new Object[0]);
        methodBuilder.addJavadoc("<dl>\n", new Object[0]);
        for (JQLProjection jQLProjection : projectedColumns) {
            if (jQLProjection.alias != null) {
                methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{jQLProjection.property.columnName});
                methodBuilder.addJavadoc("<dd>is associated to bean's property <strong>$L</strong></dd>", new Object[]{jQLProjection.alias});
            } else if (jQLProjection.column != null) {
                methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{jQLProjection.property.columnName});
                methodBuilder.addJavadoc("<dd>is associated to bean's property <strong>$L</strong></dd>", new Object[]{jQLProjection.column});
            } else {
                methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{jQLProjection.expression});
                methodBuilder.addJavadoc("<dd>no bean's property is associated</dd>", new Object[0]);
            }
            methodBuilder.addJavadoc("\n", new Object[0]);
        }
        methodBuilder.addJavadoc("</dl>", new Object[0]);
        methodBuilder.addJavadoc("\n\n", new Object[0]);
        if (method.hasChildrenSelects()) {
            methodBuilder.addJavadoc("<h2>Fields filled by subqueries:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            for (Triple triple : method.childrenSelects) {
                methodBuilder.addJavadoc("\t<dt>$L</dt>", new Object[]{triple.value0});
                methodBuilder.addJavadoc("<dd>filled by query {@link $L#$L}</dd>\n", new Object[]{((SQLiteModelMethod)triple.value2).getParent().getName(), ((SQLiteModelMethod)triple.value2).getName()});
            }
            methodBuilder.addJavadoc("</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (method.hasDynamicOrderByConditions() || method.hasDynamicWhereConditions() || method.hasDynamicPageSizeConditions()) {
            methodBuilder.addJavadoc("<h2>Method's parameters and associated dynamic parts:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            if (method.hasDynamicWhereConditions()) {
                methodBuilder.addJavadoc("<dt>$L</dt><dd>is part of where conditions resolved at runtime. In above SQL it is displayed as #{$L}</dd>\n", new Object[]{method.dynamicWhereParameterName, JQL.JQLDynamicStatementType.DYNAMIC_WHERE});
            }
            if (method.hasDynamicOrderByConditions()) {
                methodBuilder.addJavadoc("<dt>$L</dt>is part of order statement resolved at runtime. In above SQL it is displayed as #{$L}</dd>\n", new Object[]{method.dynamicOrderByParameterName, JQL.JQLDynamicStatementType.DYNAMIC_ORDER_BY});
            }
            if (method.hasDynamicPageSizeConditions()) {
                methodBuilder.addJavadoc("<dt>$L</dt>is part of limit statement resolved at runtime. In above SQL it is displayed as #{$L}</dd>\n", new Object[]{method.dynamicPageSizeName, JQL.JQLDynamicStatementType.DYNAMIC_PAGE_SIZE});
            }
            methodBuilder.addJavadoc("</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        if (sqlParams.size() > 0) {
            methodBuilder.addJavadoc("<h2>Query's parameters:</h2>\n", new Object[0]);
            methodBuilder.addJavadoc("<dl>\n", new Object[0]);
            for (String string : sqlParams) {
                methodBuilder.addJavadoc("\t<dt>$L</dt><dd>is binded to method's parameter <strong>$L</strong></dd>\n", new Object[]{SqlAnalyzer.PARAM_PREFIX + string + SqlAnalyzer.PARAM_SUFFIX, method.findParameterNameByAlias(string)});
            }
            methodBuilder.addJavadoc("</dl>", new Object[0]);
            methodBuilder.addJavadoc("\n\n", new Object[0]);
        }
        for (Pair<String, TypeName> item : method.getParameters()) {
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)((TypeName)item.value1), (String)((String)item.value0), (Modifier[])new Modifier[0]).build();
            methodBuilder.addJavadoc("@param $L\n", new Object[]{parameterSpec.name});
            if (beanTypeName.equals(item.value1)) {
                methodBuilder.addJavadoc("\tis used as <code>$L</code>\n", new Object[]{SqlAnalyzer.PARAM_PREFIX + method.findParameterAliasByName((String)item.value0) + SqlAnalyzer.PARAM_SUFFIX});
                continue;
            }
            if (TypeUtility.isTypeEquals((TypeName)item.value1, (TypeName)ParameterizedTypeName.get((ClassName)TypeUtility.className(OnReadBeanListener.class), (TypeName[])new TypeName[]{beanTypeName}))) {
                methodBuilder.addJavadoc("\tis the $T listener\n", new Object[]{beanTypeName});
                continue;
            }
            if (TypeUtility.isTypeEquals((TypeName)item.value1, (TypeName)TypeUtility.className(OnReadCursorListener.class))) {
                methodBuilder.addJavadoc("\tis the cursor listener\n", new Object[]{beanTypeName});
                continue;
            }
            if (((String)item.value0).equals(method.dynamicWhereParameterName)) {
                methodBuilder.addJavadoc("\tis used as <strong>dynamic WHERE statement</strong> and it is formatted by ({@link $T#format})\n", new Object[]{StringUtils.class});
                continue;
            }
            if (((String)item.value0).equals(method.dynamicOrderByParameterName)) {
                methodBuilder.addJavadoc("\tis used as <strong>dynamic ORDER BY statement</strong> and it is formatted by ({@link $T#format})\n", new Object[]{StringUtils.class});
                continue;
            }
            if (((String)item.value0).equals(method.dynamicPageSizeName)) {
                methodBuilder.addJavadoc("\tis used as <strong>dynamic LIMIT statement</strong> and it is formatted by ({@link $T#format})\n", new Object[]{StringUtils.class});
                continue;
            }
            methodBuilder.addJavadoc("\tis binded to <code>$L</code>\n", new Object[]{SqlAnalyzer.PARAM_PREFIX + method.findParameterAliasByName((String)item.value0) + SqlAnalyzer.PARAM_SUFFIX});
        }
        for (AbstractSelectCodeGenerator.JavadocPart item : javadocParts) {
            if (item.javadocPartType != AbstractSelectCodeGenerator.JavadocPartType.ADD_PARAMETER) continue;
            methodBuilder.addJavadoc("@param $L\n", new Object[]{item.name});
            methodBuilder.addJavadoc("\t$L\n", new Object[]{item.description});
        }
        for (AbstractSelectCodeGenerator.JavadocPart item : javadocParts) {
            if (item.javadocPartType != AbstractSelectCodeGenerator.JavadocPartType.RETURN) continue;
            methodBuilder.addJavadoc("@return $L\n", new Object[]{item.description});
            return;
        }
        switch (selectResultType) {
            case BEAN: {
                methodBuilder.addJavadoc("@return selected bean or <code>null</code>.\n", new Object[0]);
                break;
            }
            case CURSOR: {
                methodBuilder.addJavadoc("@return cursor. Closing the cursor is delegated to the calling code.\n", new Object[0]);
                break;
            }
            case LIST_BEAN: {
                if (entity.isImmutablePojo()) {
                    methodBuilder.addJavadoc("@return collection of bean or empty collection. If result type is List, it will be generated as <strong>immutable list</strong>.\n", new Object[0]);
                    break;
                }
                methodBuilder.addJavadoc("@return collection of bean or empty collection.\n", new Object[0]);
                break;
            }
            case LIST_SCALAR: {
                methodBuilder.addJavadoc("@return collection of single value extracted by query.\n", new Object[0]);
                break;
            }
            case SCALAR: {
                methodBuilder.addJavadoc("@return single value extracted by query.\n", new Object[0]);
                break;
            }
            case PAGED_RESULT: {
                methodBuilder.addJavadoc("@return paginated result.\n", new Object[0]);
                break;
            }
        }
    }
}

