/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.grammars.uri;

import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.Triple;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.ContentUriBaseErrorListener;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.ContentUriPlaceHolder;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.UriBaseListener;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.UriLexer;
import com.abubusoft.kripton.processor.sqlite.grammars.uri.UriParser;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class ContentUriChecker {
    protected static ContentUriChecker instance;
    public int pathSegmentIndex = -1;
    ParseTreeWalker walker = new ParseTreeWalker();

    public static final ContentUriChecker getInstance() {
        if (instance == null) {
            instance = new ContentUriChecker();
        }
        return instance;
    }

    private ContentUriChecker() {
    }

    private <L extends UriBaseListener> void analyzeInternal(String input, L listener) {
        this.pathSegmentIndex = -1;
        this.walker.walk(listener, (ParseTree)this.prepareUri((String)input).value0);
    }

    private <L extends UriBaseListener> void analyzePathInternal(String input, L listener) {
        this.pathSegmentIndex = -1;
        this.walker.walk(listener, (ParseTree)this.preparePath((String)input).value0);
    }

    public List<ContentUriPlaceHolder> extract(String input) {
        return this.extractPlaceHoldersFromURI(input, new ArrayList());
    }

    public Map<String, ContentUriPlaceHolder> extractAsMap(String input) {
        HashMap<String, ContentUriPlaceHolder> result = new HashMap<String, ContentUriPlaceHolder>();
        ArrayList list = this.extractPlaceHoldersFromURI(input, new ArrayList());
        for (ContentUriPlaceHolder item : list) {
            result.put(item.value, item);
        }
        return result;
    }

    public List<ContentUriPlaceHolder> extractFromPath(String input) {
        final ArrayList<ContentUriPlaceHolder> result = new ArrayList<ContentUriPlaceHolder>();
        One valid = new One();
        valid.value0 = false;
        this.analyzePathInternal(input, new UriBaseListener(){

            @Override
            public void enterBind_parameter(UriParser.Bind_parameterContext ctx) {
                result.add(new ContentUriPlaceHolder(ContentUriChecker.this.pathSegmentIndex, ctx.bind_parameter_name().getText()));
            }

            @Override
            public void enterPath_segment(UriParser.Path_segmentContext ctx) {
                ++ContentUriChecker.this.pathSegmentIndex;
            }
        });
        return result;
    }

    private <L extends Collection<ContentUriPlaceHolder>> L extractPlaceHoldersFromURI(String uri, final L result) {
        One valid = new One();
        valid.value0 = false;
        this.analyzeInternal(uri, new UriBaseListener(){

            @Override
            public void enterBind_parameter(UriParser.Bind_parameterContext ctx) {
                result.add(new ContentUriPlaceHolder(ContentUriChecker.this.pathSegmentIndex, ctx.bind_parameter_name().getText()));
            }

            @Override
            public void enterPath_segment(UriParser.Path_segmentContext ctx) {
                ++ContentUriChecker.this.pathSegmentIndex;
            }
        });
        return result;
    }

    private Pair<ParserRuleContext, CommonTokenStream> preparePath(final String input) {
        UriLexer lexer = new UriLexer((CharStream)CharStreams.fromString((String)input));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        UriParser parser = new UriParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ContentUriBaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                AssertKripton.assertTrue(false, "unespected char at pos %s of URI '%s'", charPositionInLine, input);
            }
        });
        UriParser.PathContext context = parser.path();
        return new Pair((Object)context, (Object)tokens);
    }

    private Pair<ParserRuleContext, CommonTokenStream> prepareUri(final String input) {
        UriLexer lexer = new UriLexer((CharStream)CharStreams.fromString((String)input));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        UriParser parser = new UriParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ContentUriBaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                AssertKripton.assertTrue(false, "unespected char at pos %s of URI '%s'", charPositionInLine, input);
            }

            @Override
            public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
                AssertKripton.assertTrue(false, "ambiguity syntax at pos %s of URI '%s'", startIndex, input);
            }

            @Override
            public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
                AssertKripton.assertTrue(false, "error at pos %s of URI '%s'", startIndex, input);
            }

            @Override
            public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
                AssertKripton.assertTrue(false, "context eror at pos %s of URI '%s'", startIndex, input);
            }
        });
        UriParser.UriContext context = parser.uri();
        return new Pair((Object)context, (Object)tokens);
    }

    private String replaceInternalFromUri(String input, List<Triple<Token, Token, String>> replace, UriBaseListener rewriterListener) {
        Pair<ParserRuleContext, CommonTokenStream> parser = this.prepareUri(input);
        this.pathSegmentIndex = -1;
        this.walker.walk((ParseTreeListener)rewriterListener, (ParseTree)parser.value0);
        TokenStreamRewriter rewriter = new TokenStreamRewriter((TokenStream)parser.value1);
        for (Triple<Token, Token, String> item : replace) {
            rewriter.replace((Token)item.value0, (Token)item.value1, item.value2);
        }
        return rewriter.getText();
    }

    public String replace(String input, final UriPlaceHolderReplacerListener listener) {
        final ArrayList<Triple<Token, Token, String>> replace = new ArrayList<Triple<Token, Token, String>>();
        UriBaseListener rewriterListener = new UriBaseListener(){

            @Override
            public void enterBind_parameter(UriParser.Bind_parameterContext ctx) {
                String value = listener.onParameterName(ContentUriChecker.this.pathSegmentIndex, ctx.bind_parameter_name().getText());
                replace.add(new Triple((Object)ctx.start, (Object)ctx.stop, (Object)value));
            }

            @Override
            public void enterPath_segment(UriParser.Path_segmentContext ctx) {
                ++ContentUriChecker.this.pathSegmentIndex;
            }
        };
        return this.replaceInternalFromUri(input, replace, rewriterListener);
    }

    public void verify(String input) {
        this.analyzeInternal(input, new UriBaseListener());
    }

    public static interface UriPlaceHolderReplacerListener {
        public String onParameterName(int var1, String var2);
    }
}

