/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.model;

import com.abubusoft.kripton.android.ColumnAffinityType;
import com.abubusoft.kripton.android.ColumnType;
import com.abubusoft.kripton.android.annotation.BindSqlAdapter;
import com.abubusoft.kripton.android.sqlite.ForeignKeyAction;
import com.abubusoft.kripton.android.sqlite.NoParentEntity;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.ManagedModelProperty;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.ModelType;
import com.abubusoft.kripton.processor.core.TypeAdapterHelper;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.IncompatibleAnnotationException;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransform;
import com.abubusoft.kripton.processor.sqlite.transform.SQLTransformer;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.Element;
import org.apache.commons.lang3.StringUtils;

public class SQLProperty
extends ManagedModelProperty {
    public String columnName;
    protected boolean nullable;
    protected boolean primaryKey;
    public ColumnType columnType;
    public ColumnAffinityType columnAffinityType;
    protected TypeName entityTypeName;
    public String foreignParentClassName;
    public ForeignKeyAction onDeleteAction;
    public ForeignKeyAction onUpdateAction;

    public boolean hasPropertyType() {
        return this.propertyType != null;
    }

    public void updatePropertyType(TypeName propertyTypeName) {
        this.propertyType = new ModelType(propertyTypeName);
    }

    public SQLProperty(String name, TypeName parentTypeName, TypeName propertyTypeName) {
        super((ModelEntity)null, (Element)null, (List<ModelAnnotation>)null);
        this.name = name;
        this.entityTypeName = parentTypeName;
        if (propertyTypeName != null) {
            this.propertyType = new ModelType(propertyTypeName);
        }
        this.onDeleteAction = ForeignKeyAction.NO_ACTION;
        this.onUpdateAction = ForeignKeyAction.NO_ACTION;
    }

    public SQLProperty(SQLiteEntity entity, Element element, List<ModelAnnotation> modelAnnotations) {
        super((ModelEntity)entity, element, modelAnnotations);
        this.entityTypeName = TypeUtility.className(this.getParent().getName());
        ModelAnnotation annotationBindAdapter = this.getAnnotation(BindSqlAdapter.class);
        if (annotationBindAdapter != null) {
            this.typeAdapter.adapterClazz = annotationBindAdapter.getAttributeAsClassName(AnnotationAttributeType.ADAPTER);
            this.typeAdapter.dataType = TypeAdapterHelper.detectDestinationType(entity.getElement(), this.typeAdapter.adapterClazz);
            SQLTransform transform = SQLTransformer.lookup(TypeUtility.typeName(this.typeAdapter.dataType));
            this.checkTypeAdapter(entity, element.asType(), this.typeAdapter, annotationBindAdapter);
            if (!transform.isTypeAdapterAware()) {
                String msg = String.format("In class '%s', property '%s' is of type '%s' and it can not be annotated with @%s", element.asType().toString(), this.getName(), this.getPropertyType().getTypeName(), BindSqlAdapter.class.getSimpleName());
                throw new IncompatibleAnnotationException(msg);
            }
        }
        String globalKey = element.asType().toString();
        if (!this.hasTypeAdapter() && entity.schema.globalSqlTypeAdapter.containsKey(globalKey)) {
            this.typeAdapter.adapterClazz = entity.schema.globalSqlTypeAdapter.get(globalKey);
            this.typeAdapter.dataType = TypeAdapterHelper.detectDestinationType(entity.getElement(), this.typeAdapter.adapterClazz);
        }
        this.onDeleteAction = ForeignKeyAction.NO_ACTION;
        this.onUpdateAction = ForeignKeyAction.NO_ACTION;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isForeignKey() {
        return !StringUtils.isEmpty((CharSequence)this.foreignParentClassName) && !NoParentEntity.class.getName().equals(this.foreignParentClassName);
    }

    public TypeName getEntityTypeName() {
        return this.entityTypeName;
    }
}

