/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.sqlite.transform;

import com.abubusoft.kripton.android.ColumnAffinityType;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.abubusoft.kripton.processor.sqlite.transform.AbstractSQLTransform;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.math.BigDecimal;

class BigDecimalSQLTransform
extends AbstractSQLTransform {
    BigDecimalSQLTransform() {
    }

    @Override
    public void generateWriteParam2WhereCondition(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, String paramName, TypeName paramTypeName) {
        methodBuilder.addCode("$L.toPlainString()", new Object[]{paramName});
    }

    @Override
    public void generateWriteParam2ContentValues(MethodSpec.Builder methodBuilder, SQLiteModelMethod method, String paramName, TypeName paramTypeName, ModelProperty property) {
        methodBuilder.addCode("$L", new Object[]{paramName});
    }

    @Override
    public void generateWriteProperty2ContentValues(MethodSpec.Builder methodBuilder, String beanName, TypeName beanClass, ModelProperty property) {
        methodBuilder.addCode("$L", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
    }

    @Override
    public void generateReadPropertyFromCursor(MethodSpec.Builder methodBuilder, TypeName beanClass, String beanName, ModelProperty property, String cursorName, String indexName) {
        methodBuilder.addCode(PropertyUtility.setter(beanClass, beanName, property, "new $T($L.getString($L))"), new Object[]{BigDecimal.class, cursorName, indexName});
    }

    @Override
    public void generateResetProperty(MethodSpec.Builder methodBuilder, TypeName beanClass, String beanName, ModelProperty property, String cursorName, String indexName) {
        methodBuilder.addCode(PropertyUtility.setter(beanClass, beanName, property, "null"), new Object[0]);
    }

    @Override
    public ColumnAffinityType getColumnType() {
        return ColumnAffinityType.TEXT;
    }
}

