/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.retrofit2;

import com.abubusoft.kripton.BinderContext;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import okhttp3.ResponseBody;
import retrofit2.Converter;

final class KriptonBinderResponseBodyCollectionConverter<T>
implements Converter<ResponseBody, T> {
    private Class<?> clazz;
    private Class<?> beanClazz;
    private BinderContext binderContext;

    KriptonBinderResponseBodyCollectionConverter(BinderContext binderContext, ParameterizedType collectionType) {
        this.binderContext = binderContext;
        this.clazz = (Class)collectionType.getRawType();
        this.beanClazz = (Class)collectionType.getActualTypeArguments()[0];
        this.clazz = this.replaceInterface(this.clazz);
    }

    private Class<?> replaceInterface(Class<?> clazz) {
        if (clazz.equals(List.class)) {
            return ArrayList.class;
        }
        if (clazz.equals(Set.class)) {
            return HashSet.class;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T convert(ResponseBody value) throws IOException {
        try {
            Collection collection = this.binderContext.parseCollection(value.byteStream(), (Collection)this.clazz.newInstance(), this.beanClazz);
            return (T)collection;
        }
        catch (Exception e) {
            e.printStackTrace();
            T t = null;
            return t;
        }
        finally {
            value.close();
        }
    }
}

