/*
 * Decompiled with CFR 0.152.
 */
package com.aceevo.ursus.example.simplehttpclient;

import com.aceevo.ursus.client.UrsusHttpClientBuilder;
import com.aceevo.ursus.config.UrsusHttpClientConfiguration;
import com.aceevo.ursus.example.simplehttpclient.Hello;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class SimpleHttpClientExample {
    public SimpleHttpClientExample(String configFile) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            UrsusHttpClientConfiguration ursusHttpClientConfiguration = (UrsusHttpClientConfiguration)mapper.readValue(this.open(configFile), UrsusHttpClientConfiguration.class);
            HttpClient httpClient = new UrsusHttpClientBuilder().build("example", ursusHttpClientConfiguration);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet("http://localhost:8080/hello"));
            Hello hello = (Hello)new ObjectMapper().readValue(httpResponse.getEntity().getContent(), Hello.class);
            System.out.println("Name is: " + hello.getName());
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing config file: " + e);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        if (args.length != 1) {
            System.err.printf("Usage: %s <config.yaml>%n", SimpleHttpClientExample.class.getName());
            System.exit(1);
        }
        new SimpleHttpClientExample(args[0]);
        if (Boolean.valueOf(System.getProperty("wait")).booleanValue()) {
            System.out.println("Press CTRL^C to exit..");
            Thread.currentThread().join();
        }
    }

    private InputStream open(String configurationFile) throws IOException {
        File file = new File(configurationFile);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file + " not found");
        }
        return new FileInputStream(file);
    }
}

