/*
 * Decompiled with CFR 0.152.
 */
package com.aceevo.ursus.client;

import com.aceevo.ursus.config.UrsusHttpClientConfiguration;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class UrsusHttpClientBuilder {
    private static final HttpRequestRetryHandler NO_RETRIES = new HttpRequestRetryHandler(){

        @Override
        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    };

    public HttpClient build(String name, UrsusHttpClientConfiguration configuration) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        this.setStrategiesForClient(httpClientBuilder, configuration);
        SocketConfig socketConfig = SocketConfig.copy(SocketConfig.DEFAULT).setSoTimeout(configuration.getTimeout()).setTcpNoDelay(true).setSoReuseAddress(true).build();
        ConnectionConfig connectionConfig = ConnectionConfig.copy(ConnectionConfig.DEFAULT).setBufferSize(configuration.getBufferSize()).build();
        httpClientBuilder.setDefaultSocketConfig(socketConfig);
        httpClientBuilder.setDefaultConnectionConfig(connectionConfig);
        return httpClientBuilder.build();
    }

    protected void setStrategiesForClient(HttpClientBuilder httpClientBuilder, UrsusHttpClientConfiguration configuration) {
        final long keepAlive = configuration.getKeepAlive();
        if (keepAlive == 0L) {
            httpClientBuilder.setConnectionReuseStrategy(new NoConnectionReuseStrategy());
        } else {
            httpClientBuilder.setConnectionReuseStrategy(new DefaultConnectionReuseStrategy());
            httpClientBuilder.setKeepAliveStrategy(new DefaultConnectionKeepAliveStrategy(){

                @Override
                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = super.getKeepAliveDuration(response, context);
                    return duration == -1L ? keepAlive : duration;
                }
            });
        }
        if (configuration.getRetries() == 0) {
            httpClientBuilder.setRetryHandler(NO_RETRIES);
        } else {
            httpClientBuilder.setRetryHandler(new DefaultHttpRequestRetryHandler(configuration.getRetries(), false));
        }
    }
}

