/*
 * Decompiled with CFR 0.152.
 */
package com.aceevo.ursus.client;

import com.aceevo.ursus.config.UrsusJerseyClientConfiguration;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;

public class UrsusJerseyClientBuilder {
    private UrsusJerseyClientConfiguration configuration = new UrsusJerseyClientConfiguration();

    public UrsusJerseyClientBuilder using(UrsusJerseyClientConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Client build() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.readTimeout", this.configuration.getReadTimeout());
        clientConfig.property("jersey.config.client.connectTimeout", this.configuration.getConnectTimeout());
        clientConfig.property("jersey.config.apache.client.handleCookies", true);
        PoolingClientConnectionManager poolingClientConnectionManager = new PoolingClientConnectionManager();
        poolingClientConnectionManager.setMaxTotal(this.configuration.getMaxTotalThread());
        poolingClientConnectionManager.setDefaultMaxPerRoute(this.configuration.getDefaultMaxPerRoute());
        clientConfig.property("jersey.config.apache.client.connectionManager", poolingClientConnectionManager);
        Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).withConfig(clientConfig).build();
        return client;
    }
}

