/*
 * Decompiled with CFR 0.152.
 */
package com.aceevo.ursus.config;

import com.aceevo.ursus.config.UrsusConfiguration;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class UrsusConfigurationFactory<T extends UrsusConfiguration> {
    private final String configurationFile;
    private final Class<T> clazz;
    private YAMLFactory yamlFactory = new YAMLFactory();
    private final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public UrsusConfigurationFactory(String configurationFile, Class<T> clazz) {
        this.configurationFile = configurationFile;
        this.clazz = clazz;
    }

    public T getConfiguration() {
        ObjectMapper mapper = new ObjectMapper(this.yamlFactory);
        try {
            UrsusConfiguration ursusHttpServerConfig = (UrsusConfiguration)mapper.readValue(this.open(this.configurationFile), this.clazz);
            return (T)this.validate(ursusHttpServerConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing: " + this.configurationFile, e);
        }
    }

    private T validate(T ursusHttpServerConfig) {
        Set<ConstraintViolation<T>> violationSet = this.validator.validate(ursusHttpServerConfig, new Class[0]);
        if (!violationSet.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ConstraintViolation<T> constraintViolation : violationSet) {
                stringBuilder.append(constraintViolation.getPropertyPath());
                stringBuilder.append(" ");
                stringBuilder.append(constraintViolation.getMessage() + "\n");
            }
            throw new RuntimeException(stringBuilder.substring(0, stringBuilder.length() - 1));
        }
        return ursusHttpServerConfig;
    }

    private InputStream open(String configurationFile) throws IOException {
        File file = new File(configurationFile);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file + " not found");
        }
        return new FileInputStream(file);
    }
}

