/*
 * Decompiled with CFR 0.152.
 */
package com.aceevo.ursus.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class UrsusHttpClientConfiguration {
    @JsonProperty
    private int timeout = 500;
    @JsonProperty
    private int connectionTimeout = 500;
    @JsonProperty
    private int timeToLive = 3600000;
    @JsonProperty
    private boolean cookiesEnabled = false;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    @JsonProperty
    private int maxConnections = 1024;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    @JsonProperty
    private int maxConnectionsPerRoute = 1024;
    @JsonProperty
    private int keepAlive = 2000;
    @Min(value=0L)
    @Max(value=1000L)
    @JsonProperty
    private int retries = 0;
    @JsonProperty
    private int bufferSize = 8192;

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isCookiesEnabled() {
        return this.cookiesEnabled;
    }

    public void setTimeout(int duration) {
        this.timeout = duration;
    }

    public void setConnectionTimeout(int duration) {
        this.connectionTimeout = duration;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setCookiesEnabled(boolean enabled) {
        this.cookiesEnabled = enabled;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

