/*
 * Decompiled with CFR 0.152.
 */
package com.aceevo.ursus.example.simplehttpclient;

import com.aceevo.ursus.client.UrsusHttpClientBuilder;
import com.aceevo.ursus.config.UrsusHttpClientConfiguration;
import com.aceevo.ursus.example.simplehttpclient.Hello;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

public class SimpleHttpClientExample {
    public SimpleHttpClientExample() {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            UrsusHttpClientConfiguration ursusHttpClientConfiguration = mapper.readValue(this.open("httpClient.yml"), UrsusHttpClientConfiguration.class);
            HttpClient httpClient = new UrsusHttpClientBuilder().build("example", ursusHttpClientConfiguration);
            HttpResponse httpResponse = httpClient.execute(new HttpGet("http://localhost:8080/hello"));
            Hello hello = new ObjectMapper().readValue(httpResponse.getEntity().getContent(), Hello.class);
            System.out.println("Name is: " + hello.getName());
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing config file: " + e);
        }
    }

    public static void main(String[] args) {
        new SimpleHttpClientExample();
    }

    private InputStream open(String configurationFile) throws IOException {
        File file = new File(configurationFile);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file + " not found");
        }
        return new FileInputStream(file);
    }
}

