/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;

public final class UTF8Reader
extends Reader {
    private static final int DEFAULT_BUFFER_SIZE = 8000;
    protected static final ThreadLocal<SoftReference<byte[][]>> _bufferRecycler = new ThreadLocal();
    protected final byte[][] _bufferHolder;
    private InputStream _inputSource;
    private final boolean _autoClose;
    protected byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected int _surrogate = -1;
    int _charCount = 0;
    int _byteCount = 0;
    private char[] _tmpBuffer = null;

    public UTF8Reader(InputStream inputStream, boolean bl) {
        super(inputStream);
        this._inputSource = inputStream;
        this._bufferHolder = UTF8Reader._findBufferHolder();
        byte[] byArray = this._bufferHolder[0];
        if (byArray == null) {
            byArray = new byte[8000];
            this._bufferHolder[0] = byArray;
        }
        this._inputBuffer = byArray;
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._autoClose = bl;
    }

    public UTF8Reader(byte[] byArray, int n, int n2, boolean bl) {
        super(UTF8Reader.bogusStream());
        this._inputSource = null;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n + n2;
        this._autoClose = bl;
        this._bufferHolder = null;
    }

    private static InputStream bogusStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
    }

    private static byte[][] _findBufferHolder() {
        Object object = null;
        SoftReference<byte[][]> softReference = _bufferRecycler.get();
        if (softReference != null) {
            object = softReference.get();
        }
        if (object == null) {
            object = new byte[1][];
            _bufferRecycler.set(new SoftReference<byte[][]>((byte[][])object));
        }
        return object;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this._inputSource;
        if (inputStream != null) {
            this._inputSource = null;
            if (this._autoClose) {
                inputStream.close();
            }
        }
        this.freeBuffers();
    }

    @Override
    public int read() throws IOException {
        if (this._tmpBuffer == null) {
            this._tmpBuffer = new char[1];
        }
        if (this.read(this._tmpBuffer, 0, 1) < 1) {
            return -1;
        }
        return this._tmpBuffer[0];
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(char[] var1_1, int var2_2, int var3_3) throws IOException {
        if (this._inputBuffer == null) {
            return -1;
        }
        var3_3 += var2_2;
        var4_4 = var2_2;
        if (this._surrogate >= 0) {
            var1_1[var4_4++] = (char)this._surrogate;
            this._surrogate = -1;
        } else {
            var5_5 = this._inputEnd - this._inputPtr;
            if (!(var5_5 >= 4 || var5_5 >= 1 && this._inputBuffer[this._inputPtr] >= 0 || this.loadMore(var5_5))) {
                return -1;
            }
        }
        var5_6 = this._inputBuffer;
        var6_7 = this._inputPtr;
        var7_8 = this._inputEnd;
        block0: while (var4_4 < var3_3) {
            if ((var8_9 = var5_6[var6_7++]) < 0) ** GOTO lbl25
            var1_1[var4_4++] = (char)var8_9;
            var10_11 = var7_8 - var6_7;
            var9_10 = var3_3 - var4_4;
            var11_12 = var6_7 + (var10_11 < var9_10 ? var10_11 : var9_10);
            while (var6_7 < var11_12) {
                if ((var8_9 = var5_6[var6_7++]) >= 0) {
                    var1_1[var4_4++] = (char)var8_9;
                    continue;
                }
lbl25:
                // 3 sources

                if ((var8_9 & 224) == 192) {
                    var8_9 &= 31;
                    var9_10 = 1;
                } else if ((var8_9 & 240) == 224) {
                    var8_9 &= 15;
                    var9_10 = 2;
                } else if ((var8_9 & 248) == 240) {
                    var8_9 &= 15;
                    var9_10 = 3;
                } else {
                    this.reportInvalidInitial(var8_9 & 255, var4_4 - var2_2);
                    var9_10 = 1;
                }
                if (var7_8 - var6_7 < var9_10) {
                    --var6_7;
                    break block0;
                }
                if (((var10_11 = var5_6[var6_7++]) & 192) != 128) {
                    this.reportInvalidOther(var10_11 & 255, var4_4 - var2_2);
                }
                var8_9 = var8_9 << 6 | var10_11 & 63;
                if (var9_10 > 1) {
                    if (((var10_11 = var5_6[var6_7++]) & 192) != 128) {
                        this.reportInvalidOther(var10_11 & 255, var4_4 - var2_2);
                    }
                    var8_9 = var8_9 << 6 | var10_11 & 63;
                    if (var9_10 > 2) {
                        if (((var10_11 = var5_6[var6_7++]) & 192) != 128) {
                            this.reportInvalidOther(var10_11 & 255, var4_4 - var2_2);
                        }
                        var8_9 = var8_9 << 6 | var10_11 & 63;
                        var1_1[var4_4++] = (char)(55296 + ((var8_9 -= 65536) >> 10));
                        var8_9 = 56320 | var8_9 & 1023;
                        if (var4_4 >= var3_3) {
                            this._surrogate = var8_9;
                            break block0;
                        }
                    }
                }
                var1_1[var4_4++] = (char)var8_9;
                if (var6_7 < var7_8) continue block0;
                break block0;
            }
            break block0;
        }
        this._inputPtr = var6_7;
        var3_3 = var4_4 - var2_2;
        this._charCount += var3_3;
        return var3_3;
    }

    protected final InputStream getStream() {
        return this._inputSource;
    }

    protected final int readBytes() throws IOException {
        this._inputPtr = 0;
        this._inputEnd = 0;
        if (this._inputSource != null) {
            int n = this._inputSource.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                this._inputEnd = n;
            }
            return n;
        }
        return -1;
    }

    protected final int readBytesAt(int n) throws IOException {
        if (this._inputSource != null) {
            int n2 = this._inputSource.read(this._inputBuffer, n, this._inputBuffer.length - n);
            if (n2 > 0) {
                this._inputEnd += n2;
            }
            return n2;
        }
        return -1;
    }

    public final void freeBuffers() {
        byte[] byArray;
        if (this._bufferHolder != null && (byArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._bufferHolder[0] = byArray;
        }
    }

    private void reportInvalidInitial(int n, int n2) throws IOException {
        int n3 = this._byteCount + this._inputPtr - 1;
        int n4 = this._charCount + n2 + 1;
        throw new CharConversionException("Invalid UTF-8 start byte 0x" + Integer.toHexString(n) + " (at char #" + n4 + ", byte #" + n3 + ")");
    }

    private void reportInvalidOther(int n, int n2) throws IOException {
        int n3 = this._byteCount + this._inputPtr - 1;
        int n4 = this._charCount + n2;
        throw new CharConversionException("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n) + " (at char #" + n4 + ", byte #" + n3 + ")");
    }

    private void reportUnexpectedEOF(int n, int n2) throws IOException {
        int n3 = this._byteCount + n;
        int n4 = this._charCount;
        throw new CharConversionException("Unexpected EOF in the middle of a multi-byte char: got " + n + ", needed " + n2 + ", at char #" + n4 + ", byte #" + n3 + ")");
    }

    private boolean loadMore(int n) throws IOException {
        int n2;
        int n3;
        this._byteCount += this._inputEnd - n;
        if (n > 0) {
            if (this._inputPtr > 0) {
                if (this._bufferHolder == null) {
                    throw new IllegalStateException("Internal error: need to move partially decoded character; buffer not modifiable");
                }
                for (n3 = 0; n3 < n; ++n3) {
                    this._inputBuffer[n3] = this._inputBuffer[this._inputPtr + n3];
                }
                this._inputPtr = 0;
                this._inputEnd = n;
            }
        } else {
            n3 = this.readBytes();
            if (n3 < 1) {
                this.freeBuffers();
                if (n3 < 0) {
                    return false;
                }
                this.reportStrangeStream();
            }
        }
        if ((n3 = this._inputBuffer[this._inputPtr]) >= 0) {
            return true;
        }
        if ((n3 & 0xE0) == 192) {
            n2 = 2;
        } else if ((n3 & 0xF0) == 224) {
            n2 = 3;
        } else if ((n3 & 0xF8) == 240) {
            n2 = 4;
        } else {
            this.reportInvalidInitial(n3 & 0xFF, 0);
            n2 = 1;
        }
        while (this._inputPtr + n2 > this._inputEnd) {
            int n4 = this.readBytesAt(this._inputEnd);
            if (n4 >= 1) continue;
            if (n4 < 0) {
                this.freeBuffers();
                this.reportUnexpectedEOF(this._inputEnd, n2);
            }
            this.reportStrangeStream();
        }
        return true;
    }

    protected void reportBounds(char[] cArray, int n, int n2) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n + "," + n2 + "), cbuf[" + cArray.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

