/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;

public class DataHandlerJsonDeserializer
extends StdScalarDeserializer<DataHandler> {
    private static final long serialVersionUID = 1L;

    public DataHandlerJsonDeserializer() {
        super(DataHandler.class);
    }

    @Override
    public DataHandler deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        final byte[] byArray = jsonParser.getBinaryValue();
        return new DataHandler(new DataSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(byArray);
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException();
            }

            public String getContentType() {
                return "application/octet-stream";
            }

            public String getName() {
                return "json-binary-data";
            }
        });
    }
}

