/*
 * Decompiled with CFR 0.152.
 */
package com.aceevo.ursus.example.websocketclient;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class SimpleWebSocketClient {
    private CountDownLatch messageLatch;
    private static final String SENT_MESSAGE = "Hello WebSocket";
    final Logger logger = LoggerFactory.getLogger(SimpleWebSocketClient.class);

    public SimpleWebSocketClient() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        this.logger.info("starting");
    }

    public static void main(String[] args) throws InterruptedException {
        SimpleWebSocketClient simpleWebSocketClient = new SimpleWebSocketClient();
        if (args.length > 0 && "annotated".equals(args[0])) {
            simpleWebSocketClient.run("ws://localhost:8080/annotatedEcho");
        } else {
            simpleWebSocketClient.run("ws://localhost:8080/echo");
        }
        if (Boolean.valueOf(System.getProperty("wait")).booleanValue()) {
            System.out.println("Press CTRL^C to exit..");
            Thread.currentThread().join();
        }
    }

    public void run(String uri) {
        try {
            this.messageLatch = new CountDownLatch(1);
            ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
            ClientManager client = ClientManager.createClient();
            client.connectToServer(new Endpoint(){

                public void onOpen(final Session session, EndpointConfig config) {
                    try {
                        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                            public void onMessage(String message) {
                                SimpleWebSocketClient.this.logger.info("Server replied with : " + message);
                                try {
                                    session.close();
                                    SimpleWebSocketClient.this.messageLatch.countDown();
                                }
                                catch (IOException ex) {
                                    SimpleWebSocketClient.this.logger.debug(ex.getMessage(), (Throwable)ex);
                                }
                            }
                        });
                        session.getBasicRemote().sendText(SimpleWebSocketClient.SENT_MESSAGE);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, cec, new URI(uri));
            this.messageLatch.await(100L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

