(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'acornui-acornui-utils', 'acornui-acornui-core', 'kotlinx-coroutines-core', 'kotlinx-serialization-kotlinx-serialization-runtime'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('acornui-acornui-utils'), require('acornui-acornui-core'), require('kotlinx-coroutines-core'), require('kotlinx-serialization-kotlinx-serialization-runtime'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'acornui-acornui-game'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'acornui-acornui-game'.");
    }if (typeof this['acornui-acornui-utils'] === 'undefined') {
      throw new Error("Error loading module 'acornui-acornui-game'. Its dependency 'acornui-acornui-utils' was not found. Please, check whether 'acornui-acornui-utils' is loaded prior to 'acornui-acornui-game'.");
    }if (typeof this['acornui-acornui-core'] === 'undefined') {
      throw new Error("Error loading module 'acornui-acornui-game'. Its dependency 'acornui-acornui-core' was not found. Please, check whether 'acornui-acornui-core' is loaded prior to 'acornui-acornui-game'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'acornui-acornui-game'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'acornui-acornui-game'.");
    }if (typeof this['kotlinx-serialization-kotlinx-serialization-runtime'] === 'undefined') {
      throw new Error("Error loading module 'acornui-acornui-game'. Its dependency 'kotlinx-serialization-kotlinx-serialization-runtime' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-runtime' is loaded prior to 'acornui-acornui-game'.");
    }root['acornui-acornui-game'] = factory(typeof this['acornui-acornui-game'] === 'undefined' ? {} : this['acornui-acornui-game'], kotlin, this['acornui-acornui-utils'], this['acornui-acornui-core'], this['kotlinx-coroutines-core'], this['kotlinx-serialization-kotlinx-serialization-runtime']);
  }
}(this, function (_, Kotlin, $module$acornui_acornui_utils, $module$acornui_acornui_core, $module$kotlinx_coroutines_core, $module$kotlinx_serialization_kotlinx_serialization_runtime) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Unit = Kotlin.kotlin.Unit;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Disposable = $module$acornui_acornui_utils.com.acornui.Disposable;
  var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_m7z4lg$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var CommandType = $module$acornui_acornui_core.com.acornui.mvc.CommandType;
  var Command = $module$acornui_acornui_core.com.acornui.mvc.Command;
  var get_lastIndex_0 = Kotlin.kotlin.collections.get_lastIndex_55thoc$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var invokeCommand = $module$acornui_acornui_core.com.acornui.mvc.invokeCommand_2aqu1l$;
  var acornui = $module$acornui_acornui_core.com.acornui;
  var equals = Kotlin.equals;
  var Exception_init = Kotlin.kotlin.Exception_init_pdl1vj$;
  var throwCCE = Kotlin.throwCCE;
  var HashMap_init = Kotlin.kotlin.collections.HashMap_init_bwtc7$;
  var copy = $module$acornui_acornui_utils.com.acornui.collection.copy_4c7yge$;
  var MinMax = $module$acornui_acornui_utils.com.acornui.math.MinMax;
  var ensureNotNull = Kotlin.ensureNotNull;
  var kotlin_js_internal_FloatCompanionObject = Kotlin.kotlin.js.internal.FloatCompanionObject;
  var math = $module$acornui_acornui_utils.com.acornui.math;
  var sort = Kotlin.kotlin.collections.sort_pbinho$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Vector2 = $module$acornui_acornui_utils.com.acornui.math.Vector2;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var Comparable = Kotlin.kotlin.Comparable;
  var Array_0 = Array;
  var Math_0 = Math;
  var Clearable = $module$acornui_acornui_utils.com.acornui.recycle.Clearable;
  var TextureTarget = $module$acornui_acornui_core.com.acornui.gl.core.TextureTarget;
  var logging = $module$acornui_acornui_utils.com.acornui.logging;
  var TextureMinFilter = $module$acornui_acornui_core.com.acornui.gl.core.TextureMinFilter;
  var GlTextureBase = $module$acornui_acornui_core.com.acornui.gl.core.GlTextureBase;
  var TextureMagFilter = $module$acornui_acornui_core.com.acornui.gl.core.TextureMagFilter;
  var TextureWrapMode = $module$acornui_acornui_core.com.acornui.gl.core.TextureWrapMode;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var Pair = Kotlin.kotlin.Pair;
  var Color = $module$acornui_acornui_utils.com.acornui.graphic.Color;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var loadTexture = $module$acornui_acornui_core.com.acornui.asset.loadTexture_ot45lr$;
  var IntRectangle = $module$acornui_acornui_utils.com.acornui.math.IntRectangle;
  var cacheSet = $module$acornui_acornui_core.com.acornui.asset.cacheSet_lno18r$;
  var TextureAtlasData = $module$acornui_acornui_core.com.acornui.graphic.TextureAtlasData;
  var loadAndCacheJson = $module$acornui_acornui_core.com.acornui.asset.loadAndCacheJson_uscmwb$;
  var loadAndCacheAtlasPage = $module$acornui_acornui_core.com.acornui.graphic.loadAndCacheAtlasPage_6hrjkv$;
  var clearAndReset = $module$acornui_acornui_core.com.acornui.gl.core.clearAndReset_ygs78z$;
  var useCamera = $module$acornui_acornui_core.com.acornui.gl.core.useCamera_y64o3z$;
  var bindTexture = $module$acornui_acornui_core.com.acornui.gl.core.bindTexture_xdnztu$;
  var put = $module$acornui_acornui_core.com.acornui.gl.core.put_tn7k9r$;
  var putOptional = $module$acornui_acornui_core.com.acornui.gl.core.putOptional_tn7k9r$;
  var putRgb = $module$acornui_acornui_core.com.acornui.gl.core.putRgb_vfxvaa$;
  var ContextImpl_init = $module$acornui_acornui_core.com.acornui.di.ContextImpl_init_2zmyxw$;
  var CachedGl20 = $module$acornui_acornui_core.com.acornui.gl.core.CachedGl20;
  var own = $module$acornui_acornui_core.com.acornui.di.own_hplixr$;
  var Window = $module$acornui_acornui_core.com.acornui.graphic.Window;
  var framebuffer = $module$acornui_acornui_core.com.acornui.gl.core.framebuffer_5nlv59$;
  var Matrix4 = $module$acornui_acornui_utils.com.acornui.math.Matrix4;
  var BufferTexture = $module$acornui_acornui_core.com.acornui.gl.core.BufferTexture;
  var ContextImpl = $module$acornui_acornui_core.com.acornui.di.ContextImpl;
  var core = $module$acornui_acornui_core.com.acornui.gl.core;
  var ShaderProgramBase = $module$acornui_acornui_core.com.acornui.gl.core.ShaderProgramBase;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var mapOf = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var async = $module$kotlinx_coroutines_core.kotlinx.coroutines.async_pda6u4$;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var UiComponentImpl = $module$acornui_acornui_core.com.acornui.component.UiComponentImpl;
  var BlendMode = $module$acornui_acornui_core.com.acornui.graphic.BlendMode;
  var Vector3 = $module$acornui_acornui_utils.com.acornui.math.Vector3;
  var floatBuffer = $module$acornui_acornui_utils.com.acornui.io.floatBuffer_za3lpa$;
  var put_0 = $module$acornui_acornui_utils.com.acornui.io.put_too058$;
  var InteractivityMode = $module$acornui_acornui_core.com.acornui.component.InteractivityMode;
  var ModTagWatch = $module$acornui_acornui_utils.com.acornui.observe.ModTagWatch;
  var hashMapOf = Kotlin.kotlin.collections.hashMapOf_qfcya0$;
  var contentEquals = Kotlin.arrayEquals;
  var Box = $module$acornui_acornui_utils.com.acornui.math.Box;
  var PerspectiveCamera = $module$acornui_acornui_core.com.acornui.graphic.PerspectiveCamera;
  var Random = Kotlin.kotlin.random.Random;
  var SerialClassDescImpl = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.SerialClassDescImpl;
  var UnknownFieldException = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.UnknownFieldException;
  var internal = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal;
  var GeneratedSerializer = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.GeneratedSerializer;
  var ArrayListSerializer = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.ArrayListSerializer;
  var MissingFieldException = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.MissingFieldException;
  var graphic = $module$acornui_acornui_core.com.acornui.graphic;
  var getCallableRef = Kotlin.getCallableRef;
  var onTick = $module$acornui_acornui_core.com.acornui.time.onTick_1ilr4g$;
  var Updatable = $module$acornui_acornui_core.com.acornui.Updatable;
  var loadAndCacheJsonAsync = $module$acornui_acornui_core.com.acornui.asset.loadAndCacheJsonAsync_uscmwb$;
  var endsWith = Kotlin.kotlin.text.endsWith_7epoxm$;
  var loadBinary = $module$acornui_acornui_core.com.acornui.asset.loadBinary_ot45lr$;
  var binaryParse = $module$acornui_acornui_utils.com.acornui.serialization.binaryParse_zyvbh$;
  var loadText = $module$acornui_acornui_core.com.acornui.asset.loadText_ot45lr$;
  var jsonParse = $module$acornui_acornui_utils.com.acornui.serialization.jsonParse_awif5v$;
  var Sprite = $module$acornui_acornui_core.com.acornui.component.Sprite;
  var FrameDriverRo = $module$acornui_acornui_core.com.acornui.time.FrameDriverRo;
  var numberToInt = Kotlin.numberToInt;
  var fill = Kotlin.kotlin.collections.fill_nwy378$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
  var getOrNull = Kotlin.kotlin.collections.getOrNull_yzln2o$;
  var Quaternion = $module$acornui_acornui_utils.com.acornui.math.Quaternion;
  var LifecycleBase = $module$acornui_acornui_core.com.acornui.LifecycleBase;
  var getInsertionIndex = $module$acornui_acornui_utils.com.acornui.collection.getInsertionIndex_7kha0k$;
  var closeTo = $module$acornui_acornui_utils.com.acornui.closeTo_wj6e7o$;
  var abs = Kotlin.kotlin.math.abs_za3lpa$;
  var BinaryHeapNode = $module$acornui_acornui_utils.com.acornui.collection.BinaryHeapNode;
  var BinaryHeap = $module$acornui_acornui_utils.com.acornui.collection.BinaryHeap;
  var Matrix3 = $module$acornui_acornui_utils.com.acornui.math.Matrix3;
  var commander = $module$acornui_acornui_core.com.acornui.mvc.commander;
  UnknownComponent.prototype = Object.create(ComponentBase.prototype);
  UnknownComponent.prototype.constructor = UnknownComponent;
  CubeMap.prototype = Object.create(GlTextureBase.prototype);
  CubeMap.prototype.constructor = CubeMap;
  LightingRenderer.prototype = Object.create(ContextImpl.prototype);
  LightingRenderer.prototype.constructor = LightingRenderer;
  LightingShader.prototype = Object.create(ShaderProgramBase.prototype);
  LightingShader.prototype.constructor = LightingShader;
  PointShadowShader.prototype = Object.create(ShaderProgramBase.prototype);
  PointShadowShader.prototype.constructor = PointShadowShader;
  DirectionalShadowShader.prototype = Object.create(ShaderProgramBase.prototype);
  DirectionalShadowShader.prototype.constructor = DirectionalShadowShader;
  LightingShaderWithNormalMap.prototype = Object.create(ShaderProgramBase.prototype);
  LightingShaderWithNormalMap.prototype.constructor = LightingShaderWithNormalMap;
  Skybox.prototype = Object.create(UiComponentImpl.prototype);
  Skybox.prototype.constructor = Skybox;
  SkyboxShader.prototype = Object.create(ShaderProgramBase.prototype);
  SkyboxShader.prototype.constructor = SkyboxShader;
  ParticleEffectComponent.prototype = Object.create(UiComponentImpl.prototype);
  ParticleEffectComponent.prototype.constructor = ParticleEffectComponent;
  ParticleEmitterRenderer2d.prototype = Object.create(LifecycleBase.prototype);
  ParticleEmitterRenderer2d.prototype.constructor = ParticleEmitterRenderer2d;
  AStar$PathNode.prototype = Object.create(BinaryHeapNode.prototype);
  AStar$PathNode.prototype.constructor = AStar$PathNode;
  Physics.prototype = Object.create(ComponentBase.prototype);
  Physics.prototype.constructor = Physics;
  Perimeter.prototype = Object.create(ComponentBase.prototype);
  Perimeter.prototype.constructor = Perimeter;
  function Component() {
  }
  Component.prototype.getSibling_7soe6u$ = function (type) {
    var tmp$;
    return (tmp$ = this.parentEntity) != null ? tmp$.getComponent_7soe6u$(type) : null;
  };
  Component.prototype.remove = function () {
    var tmp$;
    (tmp$ = this.parentEntity) != null ? (tmp$.removeComponent_si0cee$(this), Unit) : null;
  };
  Component.prototype.dispose = function () {
    this.remove();
  };
  Component.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Component',
    interfaces: [Disposable]
  };
  function ComponentBase() {
    this.parentEntity_rokxpy$_0 = null;
    this.requiredSiblings_z71xbh$_0 = [];
  }
  Object.defineProperty(ComponentBase.prototype, 'parentEntity', {
    get: function () {
      return this.parentEntity_rokxpy$_0;
    },
    set: function (parentEntity) {
      this.parentEntity_rokxpy$_0 = parentEntity;
    }
  });
  Object.defineProperty(ComponentBase.prototype, 'requiredSiblings', {
    get: function () {
      return this.requiredSiblings_z71xbh$_0;
    }
  });
  ComponentBase.prototype.assertValid = function () {
    var tmp$;
    tmp$ = get_lastIndex(this.requiredSiblings);
    for (var i = 0; i <= tmp$; i++) {
      var requiredSibling = this.requiredSiblings[i];
      if (!(this.getSibling_7soe6u$(requiredSibling) != null)) {
        var message = this.type.toString() + ' is missing sibling: ' + requiredSibling;
        throw IllegalStateException_init(message.toString());
      }}
    return true;
  };
  ComponentBase.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ComponentBase',
    interfaces: [Component]
  };
  function ComponentType() {
  }
  ComponentType.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ComponentType',
    interfaces: []
  };
  function UnknownComponent(originalType) {
    UnknownComponent$Companion_getInstance();
    ComponentBase.call(this);
    this.originalType = originalType;
    this.type_eatpoc$_0 = UnknownComponent$Companion_getInstance();
  }
  Object.defineProperty(UnknownComponent.prototype, 'type', {
    get: function () {
      return this.type_eatpoc$_0;
    }
  });
  function UnknownComponent$Companion() {
    UnknownComponent$Companion_instance = this;
  }
  UnknownComponent$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [ComponentType]
  };
  var UnknownComponent$Companion_instance = null;
  function UnknownComponent$Companion_getInstance() {
    if (UnknownComponent$Companion_instance === null) {
      new UnknownComponent$Companion();
    }return UnknownComponent$Companion_instance;
  }
  UnknownComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnknownComponent',
    interfaces: [ComponentBase]
  };
  function watchEntities$lambda(closure$initEntity) {
    return function (it) {
      closure$initEntity(it.entity);
      return Unit;
    };
  }
  function watchEntities$lambda_0(closure$disposeEntity) {
    return function (it) {
      closure$disposeEntity(it.entity);
      return Unit;
    };
  }
  function AddEntity(entity) {
    AddEntity$Companion_getInstance();
    this.entity = entity;
    this.type_wt4kov$_0 = AddEntity$Companion_getInstance();
  }
  Object.defineProperty(AddEntity.prototype, 'type', {
    get: function () {
      return this.type_wt4kov$_0;
    }
  });
  function AddEntity$Companion() {
    AddEntity$Companion_instance = this;
  }
  AddEntity$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [CommandType]
  };
  var AddEntity$Companion_instance = null;
  function AddEntity$Companion_getInstance() {
    if (AddEntity$Companion_instance === null) {
      new AddEntity$Companion();
    }return AddEntity$Companion_instance;
  }
  AddEntity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AddEntity',
    interfaces: [Command]
  };
  function RemoveEntity(entity) {
    RemoveEntity$Companion_getInstance();
    this.entity = entity;
    this.type_47a0ls$_0 = RemoveEntity$Companion_getInstance();
  }
  Object.defineProperty(RemoveEntity.prototype, 'type', {
    get: function () {
      return this.type_47a0ls$_0;
    }
  });
  function RemoveEntity$Companion() {
    RemoveEntity$Companion_instance = this;
  }
  RemoveEntity$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [CommandType]
  };
  var RemoveEntity$Companion_instance = null;
  function RemoveEntity$Companion_getInstance() {
    if (RemoveEntity$Companion_instance === null) {
      new RemoveEntity$Companion();
    }return RemoveEntity$Companion_instance;
  }
  RemoveEntity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RemoveEntity',
    interfaces: [Command]
  };
  var watchEntities = defineInlineFunction('acornui-acornui-game.com.acornui.ecs.watchEntities_lit54b$', wrapFunction(function () {
    var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_55thoc$;
    var AddEntity = _.com.acornui.ecs.AddEntity;
    var Unit = Kotlin.kotlin.Unit;
    var RemoveEntity = _.com.acornui.ecs.RemoveEntity;
    function watchEntities$lambda(closure$initEntity) {
      return function (it) {
        closure$initEntity(it.entity);
        return Unit;
      };
    }
    function watchEntities$lambda_0(closure$disposeEntity) {
      return function (it) {
        closure$disposeEntity(it.entity);
        return Unit;
      };
    }
    return function (entities, cmd, initEntity, disposeEntity) {
      var tmp$;
      tmp$ = get_lastIndex(entities);
      for (var i = 0; i <= tmp$; i++) {
        var e = entities.get_za3lpa$(i);
        initEntity(e);
      }
      cmd.onCommandInvoked_ht4yxz$(AddEntity.Companion, watchEntities$lambda(initEntity));
      cmd.onCommandInvoked_ht4yxz$(RemoveEntity.Companion, watchEntities$lambda_0(disposeEntity));
    };
  }));
  function addEntity($receiver, e) {
    invokeCommand(new AddEntity(e));
  }
  function addEntity_0($receiver, init) {
    var e = entity();
    init(e);
    invokeCommand(new AddEntity(e));
  }
  function removeEntity($receiver, e) {
    invokeCommand(new RemoveEntity(e));
  }
  function entitiesList$lambda(closure$componentType, closure$filtered) {
    return function (it) {
      if (it.containsComponent_3fm5ps$(closure$componentType)) {
        closure$filtered.add_11rb$(it);
      }return Unit;
    };
  }
  function entitiesList$lambda_0(closure$componentType, closure$filtered) {
    return function (it) {
      if (it.containsComponent_3fm5ps$(closure$componentType)) {
        closure$filtered.remove_11rb$(it);
      }return Unit;
    };
  }
  function entitiesList(entities, cmd, filtered, componentType) {
    var tmp$;
    tmp$ = get_lastIndex_0(entities);
    for (var i = 0; i <= tmp$; i++) {
      var e = entities.get_za3lpa$(i);
      entitiesList$lambda(componentType, filtered)(e);
    }
    cmd.onCommandInvoked_ht4yxz$(AddEntity.Companion, watchEntities$lambda(entitiesList$lambda(componentType, filtered)));
    cmd.onCommandInvoked_ht4yxz$(RemoveEntity.Companion, watchEntities$lambda_0(entitiesList$lambda_0(componentType, filtered)));
  }
  function componentList$lambda(closure$componentType, closure$filtered) {
    return function (it) {
      if (it.containsComponent_3fm5ps$(closure$componentType)) {
        closure$filtered.add_11rb$(it.getComponent_7soe6u$(closure$componentType));
      }return Unit;
    };
  }
  function componentList$lambda_0(closure$componentType, closure$filtered) {
    return function (it) {
      if (it.containsComponent_3fm5ps$(closure$componentType)) {
        closure$filtered.remove_11rb$(it.getComponent_7soe6u$(closure$componentType));
      }return Unit;
    };
  }
  function componentList(entities, cmd, filtered, componentType) {
    var tmp$;
    tmp$ = get_lastIndex_0(entities);
    for (var i = 0; i <= tmp$; i++) {
      var e = entities.get_za3lpa$(i);
      componentList$lambda(componentType, filtered)(e);
    }
    cmd.onCommandInvoked_ht4yxz$(AddEntity.Companion, watchEntities$lambda(componentList$lambda(componentType, filtered)));
    cmd.onCommandInvoked_ht4yxz$(RemoveEntity.Companion, watchEntities$lambda_0(componentList$lambda_0(componentType, filtered)));
  }
  function Entity(id) {
    Entity$Companion_getInstance();
    if (id === void 0)
      id = acornui.UidUtil.createUid();
    this.id = id;
    this._components_0 = HashMap_init(16);
  }
  Object.defineProperty(Entity.prototype, 'components', {
    get: function () {
      return this._components_0;
    }
  });
  Entity.prototype.assertValid = function () {
    var tmp$;
    if (!acornui.assertionsEnabled)
      return true;
    if (!!this.components.isEmpty()) {
      var message = 'Entity is empty.';
      throw IllegalStateException_init(message.toString());
    }tmp$ = this.components.entries.iterator();
    while (tmp$.hasNext()) {
      var entry = tmp$.next();
      entry.value.assertValid();
    }
    return true;
  };
  Entity.prototype.addComponents_5vc8pp$ = function (components) {
    var tmp$;
    tmp$ = get_lastIndex(components);
    for (var i = 0; i <= tmp$; i++) {
      this.addComponent_si0cee$(components[i]);
    }
    return this;
  };
  Entity.prototype.addComponents_wcq6ol$ = function (components) {
    var tmp$;
    tmp$ = get_lastIndex_0(components);
    for (var i = 0; i <= tmp$; i++) {
      this.addComponent_si0cee$(components.get_za3lpa$(i));
    }
    return this;
  };
  Entity.prototype.addComponent_si0cee$ = function (component) {
    if (!(component.parentEntity == null)) {
      var message = 'Component must be removed first.';
      throw IllegalStateException_init(message.toString());
    }component.parentEntity = this;
    var $receiver = this._components_0;
    var key = component.type;
    $receiver.put_xwzc9p$(key, component);
    return this;
  };
  Entity.prototype.removeComponent_si0cee$ = function (component) {
    if (equals(component.parentEntity, this)) {
      component.parentEntity = null;
      this._components_0.remove_11rb$(component.type);
    }};
  Entity.prototype.getComponent_7soe6u$ = function (type) {
    var tmp$;
    tmp$ = this.getOptionalComponent_7soe6u$(type);
    if (tmp$ == null) {
      throw Exception_init('Does not contain component of type ' + type);
    }return tmp$;
  };
  Entity.prototype.getOptionalComponent_7soe6u$ = function (type) {
    var tmp$;
    return (tmp$ = this._components_0.get_11rb$(type)) == null || Kotlin.isType(tmp$, Component) ? tmp$ : throwCCE();
  };
  Entity.prototype.containsComponent_si0cee$ = function (component) {
    return component.parentEntity === this;
  };
  Entity.prototype.containsComponent_3fm5ps$ = function (type) {
    return this._components_0.containsKey_11rb$(type);
  };
  Entity.prototype.unaryPlus_hm1umj$ = function ($receiver) {
    this.addComponent_si0cee$($receiver);
    return $receiver;
  };
  Entity.prototype.unaryPlus_8iyzh8$ = function ($receiver) {
    this.addComponents_wcq6ol$($receiver);
  };
  Entity.prototype.unaryMinus_v4y0q1$ = function ($receiver) {
    this.removeComponent_si0cee$($receiver);
  };
  Entity.prototype.dispose = function () {
    var tmp$;
    tmp$ = this.components.entries.iterator();
    while (tmp$.hasNext()) {
      var entry = tmp$.next();
      entry.value.parentEntity = null;
      entry.value.dispose();
    }
    this._components_0.clear();
  };
  function Entity$Companion() {
    Entity$Companion_instance = this;
  }
  Entity$Companion.prototype.fromComponents_5vc8pp$ = function (components) {
    var entity = new Entity();
    entity.addComponents_5vc8pp$(components.slice());
    return entity;
  };
  Entity$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Entity$Companion_instance = null;
  function Entity$Companion_getInstance() {
    if (Entity$Companion_instance === null) {
      new Entity$Companion();
    }return Entity$Companion_instance;
  }
  Entity.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Entity',
    interfaces: []
  };
  function entity$lambda($receiver) {
    return Unit;
  }
  function entity(init) {
    if (init === void 0)
      init = entity$lambda;
    var e = new Entity();
    init(e);
    return e;
  }
  function Polygon2Ro() {
  }
  Polygon2Ro.prototype.intersects_j3rlwr$ = function (other, mTd, callback$default) {
    if (mTd === void 0)
      mTd = null;
    return callback$default ? callback$default(other, mTd) : this.intersects_j3rlwr$$default(other, mTd);
  };
  Polygon2Ro.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Polygon2Ro',
    interfaces: []
  };
  function Polygon2(initialCapacity) {
    Polygon2$Companion_getInstance();
    if (initialCapacity === void 0)
      initialCapacity = 16;
    this.vertices_7fxxs1$_0 = ArrayList_init_0(initialCapacity);
    this._bounds_0 = null;
  }
  Object.defineProperty(Polygon2.prototype, 'vertices', {
    get: function () {
      return this.vertices_7fxxs1$_0;
    }
  });
  Polygon2.prototype.invalidate = function () {
    this._bounds_0 = null;
    return this;
  };
  Polygon2.prototype.copy = function () {
    return Polygon2_init(copy(this.vertices));
  };
  Object.defineProperty(Polygon2.prototype, 'bounds', {
    get: function () {
      var tmp$;
      if (this._bounds_0 == null) {
        var b = new MinMax();
        tmp$ = get_lastIndex_0(this.vertices);
        for (var i = 0; i <= tmp$; i += 2) {
          b.ext_dleff0$(this.vertices.get_za3lpa$(i), this.vertices.get_za3lpa$(i + 1 | 0));
        }
        this._bounds_0 = b;
      }return ensureNotNull(this._bounds_0);
    }
  });
  Polygon2.prototype.intersects_j3rlwr$$default = function (other, mTd) {
    mTd != null ? (mTd.clear(), Unit) : null;
    if (!this.bounds.intersects_jhujlw$(other.bounds))
      return false;
    if (!Polygon2$Companion_getInstance().sat_oyzttn$(other.vertices, this.vertices, kotlin_js_internal_FloatCompanionObject.MAX_VALUE, mTd)) {
      mTd != null ? (mTd.clear(), Unit) : null;
      return false;
    }mTd != null ? mTd.scl_mx4ult$(-1.0) : null;
    if (!Polygon2$Companion_getInstance().sat_oyzttn$(this.vertices, other.vertices, mTd == null ? kotlin_js_internal_FloatCompanionObject.MAX_VALUE : mTd.len(), mTd)) {
      mTd != null ? (mTd.clear(), Unit) : null;
      return false;
    }return true;
  };
  Polygon2.prototype.add_1fv2cb$ = function (vertex) {
    this.vertices.add_11rb$(vertex.x);
    this.vertices.add_11rb$(vertex.y);
  };
  Polygon2.prototype.add_1fv330$ = function (vertex) {
    this.vertices.add_11rb$(vertex.x);
    this.vertices.add_11rb$(vertex.y);
  };
  Polygon2.prototype.add_dleff0$ = function (x, y) {
    this.vertices.add_11rb$(x);
    this.vertices.add_11rb$(y);
  };
  Polygon2.prototype.set_14o8gn$ = function (other) {
    this.vertices.clear();
    this.vertices.addAll_brywnq$(other.vertices);
    return this;
  };
  Polygon2.prototype.setVertices_hcyabg$ = function (newVertices) {
    this.vertices.clear();
    this.vertices.addAll_brywnq$(newVertices);
    return this;
  };
  Polygon2.prototype.mul_pekfyx$ = function (mat) {
    var tmp$;
    var values = mat.values;
    var m0 = values[0];
    var m1 = values[1];
    var m3 = values[3];
    var m4 = values[4];
    var m6 = values[6];
    var m7 = values[7];
    tmp$ = get_lastIndex_0(this.vertices);
    for (var i = 0; i <= tmp$; i += 2) {
      var x = this.vertices.get_za3lpa$(i);
      var y = this.vertices.get_za3lpa$(i + 1 | 0);
      this.vertices.set_wxm5ur$(i, x * m0 + y * m3 + m6);
      this.vertices.set_wxm5ur$(i + 1 | 0, x * m1 + y * m4 + m7);
    }
    return this;
  };
  Polygon2.prototype.trn_dleff0$ = function (xD, yD) {
    var tmp$;
    tmp$ = get_lastIndex_0(this.vertices);
    for (var i = 0; i <= tmp$; i += 2) {
      this.vertices.set_wxm5ur$(i, this.vertices.get_za3lpa$(i) + xD);
      this.vertices.set_wxm5ur$(i + 1 | 0, this.vertices.get_za3lpa$(i + 1 | 0) + yD);
    }
    return this;
  };
  Polygon2.prototype.scl_dleff0$ = function (vX, vY) {
    var tmp$;
    tmp$ = get_lastIndex_0(this.vertices);
    for (var i = 0; i <= tmp$; i += 2) {
      this.vertices.set_wxm5ur$(i, this.vertices.get_za3lpa$(i) * vX);
      this.vertices.set_wxm5ur$(i + 1 | 0, this.vertices.get_za3lpa$(i + 1 | 0) * vY);
    }
    return this;
  };
  Polygon2.prototype.getContactInfo_1gkzbj$ = function (other, mTd, collisionInfo) {
    Polygon2$Companion_getInstance().mTd2_0.set_1fv330$(mTd).scl_mx4ult$(-1.0);
    var nA = Polygon2$Companion_getInstance().getSupportPoints_0(this.vertices, Polygon2$Companion_getInstance().mTd2_0, Polygon2$Companion_getInstance().supportA_0);
    var nB = Polygon2$Companion_getInstance().getSupportPoints_0(other.vertices, mTd, Polygon2$Companion_getInstance().supportB_0);
    this.getContactPoints_0(Polygon2$Companion_getInstance().supportA_0, nA, Polygon2$Companion_getInstance().supportB_0, nB, collisionInfo);
  };
  Polygon2.prototype.getContactPoints_0 = function (supportA, numA, supportB, numB, collisionInfo) {
    switch (numA + numB | 0) {
      case 2:
        collisionInfo.contactA.set_dleff0$(supportA[0], supportA[1]);
        collisionInfo.contactB.set_dleff0$(supportB[0], supportB[1]);
        collisionInfo.numPoints = 1;
        break;
      case 3:
        if (numA > numB) {
          this.getContactPointsEdgeVertex_0(supportA, supportB[0], supportB[1], collisionInfo);
        } else {
          this.getContactPointsEdgeVertex_0(supportB, supportA[0], supportA[1], collisionInfo);
          this.switch_0(collisionInfo);
        }

        break;
      case 4:
        this.getContactPointsEdgeEdge_0(supportA, supportB, collisionInfo);
        break;
      default:collisionInfo.numPoints = 0;
        break;
    }
    collisionInfo.midA.set_1fv330$(collisionInfo.contactA);
    collisionInfo.midB.set_1fv330$(collisionInfo.contactB);
    if (collisionInfo.numPoints === 2) {
      collisionInfo.midA.lerp_hj2y21$(collisionInfo.contactA2, 0.5);
      collisionInfo.midB.lerp_hj2y21$(collisionInfo.contactB2, 0.5);
    }};
  Polygon2.prototype.getContactPointsEdgeVertex_0 = function (edge, x, y, collisionInfo) {
    this.getClosestPointToEdge_0(x, y, edge, collisionInfo.contactA);
    collisionInfo.contactB.set_dleff0$(x, y);
    collisionInfo.numPoints = 1;
  };
  Polygon2.prototype.getClosestPointToEdge_0 = function (x, y, edge, out) {
    return math.GeomUtils.getClosestPointToEdge_r2rsrr$(x, y, edge[0], edge[1], edge[2], edge[3], out);
  };
  Polygon2.prototype.getContactPointsEdgeEdge_0 = function (supportA, supportB, collisionInfo) {
    var dirX = supportA[2] - supportA[0];
    var dirY = supportA[3] - supportA[1];
    Polygon2$Companion_getInstance().sortedEdgeVertices_0[0].set_r7h88x$(supportA[0], supportA[1], supportA[0] * dirX + supportA[1] * dirY, 0);
    Polygon2$Companion_getInstance().sortedEdgeVertices_0[1].set_r7h88x$(supportA[2], supportA[3], supportA[2] * dirX + supportA[3] * dirY, 0);
    Polygon2$Companion_getInstance().sortedEdgeVertices_0[2].set_r7h88x$(supportB[0], supportB[1], supportB[0] * dirX + supportB[1] * dirY, 1);
    Polygon2$Companion_getInstance().sortedEdgeVertices_0[3].set_r7h88x$(supportB[2], supportB[3], supportB[2] * dirX + supportB[3] * dirY, 1);
    sort(Polygon2$Companion_getInstance().sortedEdgeVertices_0);
    for (var i = 1; i <= 2; i++) {
      var vertex = Polygon2$Companion_getInstance().sortedEdgeVertices_0[i];
      var contactA = i === 1 ? collisionInfo.contactA : collisionInfo.contactA2;
      var contactB = i === 1 ? collisionInfo.contactB : collisionInfo.contactB2;
      if (vertex.whichEdge === 0) {
        contactA.set_dleff0$(vertex.x, vertex.y);
        this.getClosestPointToEdge_0(vertex.x, vertex.y, supportB, contactB);
      } else {
        this.getClosestPointToEdge_0(vertex.x, vertex.y, supportA, contactA);
        contactB.set_dleff0$(vertex.x, vertex.y);
      }
    }
    collisionInfo.numPoints = 2;
  };
  Polygon2.prototype.switch_0 = function ($receiver) {
    Polygon2$Companion_getInstance().tmp_0.set_1fv330$($receiver.contactA);
    $receiver.contactA.set_1fv330$($receiver.contactB);
    $receiver.contactB.set_1fv330$(Polygon2$Companion_getInstance().tmp_0);
  };
  function Polygon2$Companion() {
    Polygon2$Companion_instance = this;
    this.tmp_0 = new Vector2();
    this.mTd2_0 = new Vector2();
    this.supportA_0 = new Float32Array(4);
    this.supportB_0 = new Float32Array(4);
    var array = Array_0(4);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = new SortedPoint();
    }
    this.sortedEdgeVertices_0 = array;
    this.vAxis_0 = new Vector2();
  }
  Polygon2$Companion.prototype.sat_oyzttn$ = function (pA, pB, shortestDistAbs, mTd) {
    var tmp$, tmp$_0, tmp$_1;
    var shortestDistAbs_0 = shortestDistAbs;
    tmp$ = get_lastIndex_0(pA);
    for (var i = 0; i <= tmp$; i += 2) {
      this.getNormal_0(pA, i, this.vAxis_0);
      var min0 = kotlin_js_internal_FloatCompanionObject.POSITIVE_INFINITY;
      var max0 = kotlin_js_internal_FloatCompanionObject.NEGATIVE_INFINITY;
      tmp$_0 = get_lastIndex_0(pA);
      for (var j = 0; j <= tmp$_0; j += 2) {
        var t = this.vAxis_0.dot_dleff0$(pA.get_za3lpa$(j), pA.get_za3lpa$(j + 1 | 0));
        if (t < min0)
          min0 = t;
        if (t > max0)
          max0 = t;
      }
      var min1 = kotlin_js_internal_FloatCompanionObject.POSITIVE_INFINITY;
      var max1 = kotlin_js_internal_FloatCompanionObject.NEGATIVE_INFINITY;
      tmp$_1 = get_lastIndex_0(pB);
      for (var j_0 = 0; j_0 <= tmp$_1; j_0 += 2) {
        var t_0 = this.vAxis_0.dot_dleff0$(pB.get_za3lpa$(j_0), pB.get_za3lpa$(j_0 + 1 | 0));
        if (t_0 < min1)
          min1 = t_0;
        if (t_0 > max1)
          max1 = t_0;
      }
      if (min0 > max1 || max0 < min1) {
        return false;
      }if (mTd != null) {
        var dist = min0 - max1;
        var distAbs = Math_0.abs(dist);
        if (distAbs < shortestDistAbs_0) {
          shortestDistAbs_0 = distAbs;
          mTd.set_1fv330$(this.vAxis_0).scl_mx4ult$(dist);
        }}}
    return true;
  };
  Polygon2$Companion.prototype.getNormal_0 = function (pA, i, out) {
    var x1 = pA.get_za3lpa$(i);
    var y1 = pA.get_za3lpa$(i + 1 | 0);
    var n = pA.size;
    var x2 = pA.get_za3lpa$((i + 2 | 0) % n);
    var y2 = pA.get_za3lpa$((i + 3 | 0) % n);
    out.set_dleff0$(-(y2 - y1), x2 - x1);
    out.nor();
  };
  Polygon2$Companion.prototype.getSupportPoints_0 = function (vertices, dir, out) {
    var tmp$, tmp$_0;
    if (!!vertices.isEmpty()) {
      var message = 'Assertion failed';
      throw IllegalStateException_init(message.toString());
    }var minD = kotlin_js_internal_FloatCompanionObject.MAX_VALUE;
    tmp$ = get_lastIndex_0(vertices);
    for (var i = 0; i <= tmp$; i += 2) {
      var d = vertices.get_za3lpa$(i) * dir.x + vertices.get_za3lpa$(i + 1 | 0) * dir.y;
      if (d < minD) {
        minD = d;
      }}
    var count = 0;
    var threshold = 1.0E-8;
    var minD2 = minD + threshold;
    tmp$_0 = get_lastIndex_0(vertices);
    for (var i_0 = 0; i_0 <= tmp$_0; i_0 += 2) {
      var d_0 = vertices.get_za3lpa$(i_0) * dir.x + vertices.get_za3lpa$(i_0 + 1 | 0) * dir.y;
      if (d_0 <= minD2) {
        out[count * 2 | 0] = vertices.get_za3lpa$(i_0);
        out[(count * 2 | 0) + 1 | 0] = vertices.get_za3lpa$(i_0 + 1 | 0);
        count = count + 1 | 0;
        if (count >= 2)
          return count;
      }}
    return count;
  };
  Polygon2$Companion.prototype.simplifyShape_aik8as$ = function (vertices, stride, offset) {
    if (stride === void 0)
      stride = 2;
    if (offset === void 0)
      offset = 0;
    var tmp$, tmp$_0;
    if (vertices.isEmpty())
      return emptyList();
    var out = ArrayList_init();
    var n = vertices.size / stride | 0;
    var i = 0;
    var wasOnline = false;
    var couldSimplify = false;
    while (i < n) {
      var x = vertices.get_za3lpa$(Kotlin.imul(i, stride) + offset | 0);
      var y = vertices.get_za3lpa$(Kotlin.imul(i, stride) + offset + 1 | 0);
      var isOnLine = false;
      if (!wasOnline && i > 0 && i < (n - 1 | 0)) {
        var x1 = vertices.get_za3lpa$(Kotlin.imul(i - 1 | 0, stride) + offset | 0);
        var y1 = vertices.get_za3lpa$(Kotlin.imul(i - 1 | 0, stride) + offset + 1 | 0);
        var x2 = vertices.get_za3lpa$(Kotlin.imul(i + 1 | 0, stride) + offset | 0);
        var y2 = vertices.get_za3lpa$(Kotlin.imul(i + 1 | 0, stride) + offset + 1 | 0);
        var dst1 = Vector2.Companion.len_dleff0$(x2 - x1, y2 - y1);
        var x_0 = (x2 - x1) * (y - y1) - (y2 - y1) * (x - x1);
        isOnLine = Math_0.abs(x_0) / dst1 < 0.8;
      }if (!isOnLine) {
        tmp$ = Kotlin.imul(i, stride);
        tmp$_0 = Kotlin.imul(i + 1 | 0, stride);
        for (var j = tmp$; j < tmp$_0; j++) {
          out.add_11rb$(vertices.get_za3lpa$(j));
        }
      } else {
        couldSimplify = true;
      }
      wasOnline = isOnLine;
      i = i + 1 | 0;
    }
    return couldSimplify ? this.simplifyShape_aik8as$(out, stride, offset) : out;
  };
  Polygon2$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Polygon2$Companion_instance = null;
  function Polygon2$Companion_getInstance() {
    if (Polygon2$Companion_instance === null) {
      new Polygon2$Companion();
    }return Polygon2$Companion_instance;
  }
  Polygon2.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Polygon2',
    interfaces: [Polygon2Ro]
  };
  function Polygon2_init(vertices, $this) {
    $this = $this || Object.create(Polygon2.prototype);
    Polygon2.call($this, vertices.size);
    $this.vertices.addAll_brywnq$(vertices);
    return $this;
  }
  function basicPolygon(sides, radius) {
    if (sides === void 0)
      sides = 3;
    if (radius === void 0)
      radius = 100.0;
    var tmp$;
    if (sides < 3)
      throw Exception_init('Needs at least 3 sides');
    var rot = math.PI2 / sides;
    var poly = new Polygon2(sides * 2 | 0);
    var vertices = poly.vertices;
    tmp$ = sides - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      var theta = i * rot + (math.PI - rot) * 0.5;
      vertices.add_11rb$(Math_0.cos(theta) * radius);
      vertices.add_11rb$(Math_0.sin(theta) * radius);
    }
    return poly;
  }
  function CollisionInfoRo() {
  }
  CollisionInfoRo.prototype.copy = function () {
    var info = new CollisionInfo(this.contactA.copy_dleff0$(), this.contactA2.copy_dleff0$(), this.contactB.copy_dleff0$(), this.contactB2.copy_dleff0$(), this.numPoints);
    info.midA.set_1fv330$(this.midA);
    info.midB.set_1fv330$(this.midB);
    return info;
  };
  CollisionInfoRo.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CollisionInfoRo',
    interfaces: []
  };
  function CollisionInfo(contactA, contactA2, contactB, contactB2, numPoints) {
    if (contactA === void 0)
      contactA = new Vector2();
    if (contactA2 === void 0)
      contactA2 = new Vector2();
    if (contactB === void 0)
      contactB = new Vector2();
    if (contactB2 === void 0)
      contactB2 = new Vector2();
    if (numPoints === void 0)
      numPoints = 0;
    this.contactA_5jgrlj$_0 = contactA;
    this.contactA2_tp7nfv$_0 = contactA2;
    this.contactB_5jgrme$_0 = contactB;
    this.contactB2_tp7o6k$_0 = contactB2;
    this.numPoints_pldist$_0 = numPoints;
    this.midA_woxqsf$_0 = new Vector2();
    this.midB_woxqta$_0 = new Vector2();
  }
  Object.defineProperty(CollisionInfo.prototype, 'contactA', {
    get: function () {
      return this.contactA_5jgrlj$_0;
    }
  });
  Object.defineProperty(CollisionInfo.prototype, 'contactA2', {
    get: function () {
      return this.contactA2_tp7nfv$_0;
    }
  });
  Object.defineProperty(CollisionInfo.prototype, 'contactB', {
    get: function () {
      return this.contactB_5jgrme$_0;
    }
  });
  Object.defineProperty(CollisionInfo.prototype, 'contactB2', {
    get: function () {
      return this.contactB2_tp7o6k$_0;
    }
  });
  Object.defineProperty(CollisionInfo.prototype, 'numPoints', {
    get: function () {
      return this.numPoints_pldist$_0;
    },
    set: function (numPoints) {
      this.numPoints_pldist$_0 = numPoints;
    }
  });
  Object.defineProperty(CollisionInfo.prototype, 'midA', {
    get: function () {
      return this.midA_woxqsf$_0;
    }
  });
  Object.defineProperty(CollisionInfo.prototype, 'midB', {
    get: function () {
      return this.midB_woxqta$_0;
    }
  });
  CollisionInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CollisionInfo',
    interfaces: [CollisionInfoRo]
  };
  CollisionInfo.prototype.component1 = function () {
    return this.contactA;
  };
  CollisionInfo.prototype.component2 = function () {
    return this.contactA2;
  };
  CollisionInfo.prototype.component3 = function () {
    return this.contactB;
  };
  CollisionInfo.prototype.component4 = function () {
    return this.contactB2;
  };
  CollisionInfo.prototype.component5 = function () {
    return this.numPoints;
  };
  CollisionInfo.prototype.copy_y1r5um$ = function (contactA, contactA2, contactB, contactB2, numPoints) {
    return new CollisionInfo(contactA === void 0 ? this.contactA : contactA, contactA2 === void 0 ? this.contactA2 : contactA2, contactB === void 0 ? this.contactB : contactB, contactB2 === void 0 ? this.contactB2 : contactB2, numPoints === void 0 ? this.numPoints : numPoints);
  };
  CollisionInfo.prototype.toString = function () {
    return 'CollisionInfo(contactA=' + Kotlin.toString(this.contactA) + (', contactA2=' + Kotlin.toString(this.contactA2)) + (', contactB=' + Kotlin.toString(this.contactB)) + (', contactB2=' + Kotlin.toString(this.contactB2)) + (', numPoints=' + Kotlin.toString(this.numPoints)) + ')';
  };
  CollisionInfo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.contactA) | 0;
    result = result * 31 + Kotlin.hashCode(this.contactA2) | 0;
    result = result * 31 + Kotlin.hashCode(this.contactB) | 0;
    result = result * 31 + Kotlin.hashCode(this.contactB2) | 0;
    result = result * 31 + Kotlin.hashCode(this.numPoints) | 0;
    return result;
  };
  CollisionInfo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.contactA, other.contactA) && Kotlin.equals(this.contactA2, other.contactA2) && Kotlin.equals(this.contactB, other.contactB) && Kotlin.equals(this.contactB2, other.contactB2) && Kotlin.equals(this.numPoints, other.numPoints)))));
  };
  function SortedPoint(x, y, d, whichEdge) {
    if (x === void 0)
      x = 0.0;
    if (y === void 0)
      y = 0.0;
    if (d === void 0)
      d = 0.0;
    if (whichEdge === void 0)
      whichEdge = -1;
    this.x = x;
    this.y = y;
    this.d = d;
    this.whichEdge = whichEdge;
  }
  SortedPoint.prototype.set_r7h88x$ = function (x, y, d, whichEdge) {
    this.x = x;
    this.y = y;
    this.d = d;
    this.whichEdge = whichEdge;
    return this;
  };
  SortedPoint.prototype.compareTo_11rb$ = function (other) {
    return Kotlin.compareTo(this.d, other.d);
  };
  SortedPoint.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SortedPoint',
    interfaces: [Comparable]
  };
  SortedPoint.prototype.component1 = function () {
    return this.x;
  };
  SortedPoint.prototype.component2 = function () {
    return this.y;
  };
  SortedPoint.prototype.component3 = function () {
    return this.d;
  };
  SortedPoint.prototype.component4 = function () {
    return this.whichEdge;
  };
  SortedPoint.prototype.copy_r7h88x$ = function (x, y, d, whichEdge) {
    return new SortedPoint(x === void 0 ? this.x : x, y === void 0 ? this.y : y, d === void 0 ? this.d : d, whichEdge === void 0 ? this.whichEdge : whichEdge);
  };
  SortedPoint.prototype.toString = function () {
    return 'SortedPoint(x=' + Kotlin.toString(this.x) + (', y=' + Kotlin.toString(this.y)) + (', d=' + Kotlin.toString(this.d)) + (', whichEdge=' + Kotlin.toString(this.whichEdge)) + ')';
  };
  SortedPoint.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.x) | 0;
    result = result * 31 + Kotlin.hashCode(this.y) | 0;
    result = result * 31 + Kotlin.hashCode(this.d) | 0;
    result = result * 31 + Kotlin.hashCode(this.whichEdge) | 0;
    return result;
  };
  SortedPoint.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.x, other.x) && Kotlin.equals(this.y, other.y) && Kotlin.equals(this.d, other.d) && Kotlin.equals(this.whichEdge, other.whichEdge)))));
  };
  function BestSampler(count) {
    this.count = count;
    this.scores_0 = new Float32Array(this.count);
    this._data_0 = ArrayList_init_0(this.count);
    this.lowestIndex_0 = 0;
    this.highestValue_0 = 0.0;
    this.lowestValue_0 = 0.0;
    this.clear();
  }
  Object.defineProperty(BestSampler.prototype, 'data_0', {
    get: function () {
      return this._data_0;
    }
  });
  BestSampler.prototype.clear = function () {
    this._data_0.clear();
    this.lowestIndex_0 = this.count - 1 | 0;
    this.lowestValue_0 = kotlin_js_internal_FloatCompanionObject.POSITIVE_INFINITY;
    this.highestValue_0 = kotlin_js_internal_FloatCompanionObject.NEGATIVE_INFINITY;
  };
  BestSampler.prototype.sample_f6p79m$ = function (score, value) {
    var tmp$;
    if (!this.isFull) {
      if (score < this.lowestValue_0) {
        this.lowestValue_0 = score;
        this.lowestIndex_0 = this._data_0.size;
      }if (score > this.highestValue_0) {
        this.highestValue_0 = score;
      }this.scores_0[this._data_0.size] = score;
      this._data_0.add_11rb$(value);
    } else {
      if (score > this.lowestValue_0) {
        if (score > this.highestValue_0) {
          this.highestValue_0 = score;
        }this.scores_0[this.lowestIndex_0] = score;
        this._data_0.set_wxm5ur$(this.lowestIndex_0, value);
        this.lowestValue_0 = score;
        tmp$ = this.count - 1 | 0;
        for (var i = 0; i <= tmp$; i++) {
          var sample = this.scores_0[i];
          if (sample < this.lowestValue_0) {
            this.lowestIndex_0 = i;
            this.lowestValue_0 = sample;
          }}
      }}
  };
  Object.defineProperty(BestSampler.prototype, 'isFull', {
    get: function () {
      return this._data_0.size === this.count;
    }
  });
  BestSampler.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BestSampler',
    interfaces: [Clearable]
  };
  function CubeMap(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ, gl, writeMode, displayName) {
    if (writeMode === void 0)
      writeMode = false;
    if (displayName === void 0)
      displayName = null;
    GlTextureBase.call(this, gl, displayName);
    this.writeMode_0 = writeMode;
    this.sides_0 = [positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ];
    this._width_0 = 0;
    this._height_0 = 0;
    this._depth_0 = 0;
    this.firstSideOrdinal_0 = TextureTarget.TEXTURE_CUBE_MAP_POSITIVE_X.ordinal;
    this.target = TextureTarget.TEXTURE_CUBE_MAP;
    this.filterMin = TextureMinFilter.LINEAR;
    this.filterMag = TextureMagFilter.LINEAR;
    this.wrapS = TextureWrapMode.CLAMP_TO_EDGE;
    this.wrapT = TextureWrapMode.CLAMP_TO_EDGE;
    var w = 0;
    if (positiveZ.widthPixels > w)
      w = positiveZ.widthPixels;
    if (negativeZ.widthPixels > w)
      w = negativeZ.widthPixels;
    if (positiveY.widthPixels > w)
      w = positiveY.widthPixels;
    if (negativeY.widthPixels > w)
      w = negativeY.widthPixels;
    this._width_0 = w;
    var h = 0;
    if (positiveZ.heightPixels > h)
      h = positiveZ.heightPixels;
    if (negativeZ.heightPixels > h)
      h = negativeZ.heightPixels;
    if (positiveX.heightPixels > h)
      h = positiveX.heightPixels;
    if (negativeX.heightPixels > h)
      h = negativeX.heightPixels;
    this._height_0 = h;
    var d = 0;
    if (positiveX.widthPixels > d)
      d = positiveX.widthPixels;
    if (negativeX.widthPixels > d)
      d = negativeX.widthPixels;
    if (positiveY.heightPixels > d)
      d = positiveY.heightPixels;
    if (negativeY.heightPixels > d)
      d = negativeY.heightPixels;
    this._depth_0 = d;
  }
  CubeMap.prototype.uploadTexture = function () {
    var tmp$;
    tmp$ = get_lastIndex(this.sides_0);
    for (var i = 0; i <= tmp$; i++) {
      var side = this.sides_0[i];
      side.target = TextureTarget.Companion.VALUES[i + this.firstSideOrdinal_0 | 0];
      side.textureHandle = this.gl.createTexture();
      if (this.writeMode_0)
        this.gl.texImage2Db_npa8mn$(side.target.value, 0, this.pixelFormat.value, side.widthPixels, side.heightPixels, 0, this.pixelFormat.value, this.pixelType.value, null);
      else
        this.gl.texImage2D_uyx1eb$(side.target.value, 0, side.pixelFormat.value, side.pixelFormat.value, side.pixelType.value, side);
    }
    if (this.filterMin.useMipMap) {
      if (!this.supportsNpot() && (!math.MathUtils.isPowerOfTwo_za3lpa$(this.widthPixels) || !math.MathUtils.isPowerOfTwo_za3lpa$(this.heightPixels))) {
        logging.Log.warn_s8jyv4$('MipMaps cannot be generated for non power of two textures (' + this.widthPixels + 'x' + this.heightPixels + ')');
        this.gl.texParameteri_qt1dr2$(this.target.value, 10241, TextureMinFilter.LINEAR.value);
      } else {
        this.gl.generateMipmap_za3lpa$(this.target.value);
      }
    }};
  CubeMap.prototype.delete = function () {
    var tmp$;
    GlTextureBase.prototype.delete.call(this);
    tmp$ = get_lastIndex(this.sides_0);
    for (var i = 0; i <= tmp$; i++) {
      this.gl.deleteTexture_yq8m69$(ensureNotNull(this.sides_0[i].textureHandle));
      this.sides_0[i].textureHandle = null;
    }
  };
  CubeMap.prototype.getSide_i1zbpk$ = function (target) {
    return this.sides_0[target.ordinal - this.firstSideOrdinal_0 | 0];
  };
  Object.defineProperty(CubeMap.prototype, 'widthPixels', {
    get: function () {
      return this._width_0;
    }
  });
  Object.defineProperty(CubeMap.prototype, 'heightPixels', {
    get: function () {
      return this._height_0;
    }
  });
  Object.defineProperty(CubeMap.prototype, 'depth', {
    get: function () {
      return this._depth_0;
    }
  });
  CubeMap.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CubeMap',
    interfaces: [GlTextureBase]
  };
  function ExtrudeUtil() {
    ExtrudeUtil_instance = this;
    this.color_0 = new Color();
    this.checkDeltas_0 = new Int32Array([0, -1, 0, 0, -1, 0, -1, -1]);
  }
  function ExtrudeUtil$calculatePerimeter$lambda(closure$region, closure$rgbData, this$ExtrudeUtil, closure$alphaThreshold) {
    return function (x, y) {
      if (x < closure$region.left || y < closure$region.top || x >= closure$region.right || y >= closure$region.bottom) {
        return false;
      } else {
        return closure$rgbData.getPixel_burlz3$(x, y, this$ExtrudeUtil.color_0).a >= closure$alphaThreshold;
      }
    };
  }
  ExtrudeUtil.prototype.calculatePerimeter_pv5w23$ = function (texture, region, alphaThreshold) {
    if (alphaThreshold === void 0)
      alphaThreshold = 0.1;
    var tmp$, tmp$_0;
    var rgbData = ensureNotNull(texture.rgbData);
    tmp$ = this.getStartingLocation_0(rgbData, region, alphaThreshold);
    if (tmp$ == null) {
      return listOf([region.left, region.top, region.right, region.top, region.right, region.bottom, region.left, region.bottom, region.left, region.top]);
    }var start = tmp$;
    var check = ExtrudeUtil$calculatePerimeter$lambda(region, rgbData, this, alphaThreshold);
    var list = ArrayList_init();
    list.add_11rb$(start.first);
    list.add_11rb$(start.second);
    list.add_11rb$(start.first + 1 | 0);
    list.add_11rb$(start.second);
    var x = start.first + 1 | 0;
    var y = start.second;
    var lastDir = 0;
    do {
      tmp$_0 = lastDir + 4 | 0;
      for (var i = lastDir; i < tmp$_0; i++) {
        var d = math.MathUtils.mod_vux9f0$(i, 4);
        var xD = this.checkDeltas_0[d * 2 | 0];
        var yD = this.checkDeltas_0[(d * 2 | 0) + 1 | 0];
        if (check(x + xD | 0, y + yD | 0)) {
          lastDir = d - 1 | 0;
          switch (d) {
            case 0:
              y = y - 1 | 0;
              break;
            case 1:
              x = x + 1 | 0;
              break;
            case 2:
              y = y + 1 | 0;
              break;
            case 3:
              x = x - 1 | 0;
              break;
          }
          break;
        }}
      list.add_11rb$(x);
      list.add_11rb$(y);
      if (list.size > 10000)
        throw Exception_init('Endless loop detected');
    }
     while (x !== start.first || y !== start.second);
    return list;
  };
  ExtrudeUtil.prototype.getStartingLocation_0 = function (rgbData, region, alphaThreshold) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    tmp$ = region.left;
    tmp$_0 = region.right;
    for (var x = tmp$; x < tmp$_0; x++) {
      tmp$_1 = region.top;
      tmp$_2 = region.bottom;
      for (var y = tmp$_1; y < tmp$_2; y++) {
        var pixel = rgbData.getPixel_burlz3$(x, y, this.color_0);
        if (pixel.a >= alphaThreshold)
          return new Pair(x, y);
      }
    }
    return null;
  };
  ExtrudeUtil.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ExtrudeUtil',
    interfaces: []
  };
  var ExtrudeUtil_instance = null;
  function ExtrudeUtil_getInstance() {
    if (ExtrudeUtil_instance === null) {
      new ExtrudeUtil();
    }return ExtrudeUtil_instance;
  }
  function Coroutine$calculatePerimeter($receiver_0, path_0, alphaThreshold_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$path = path_0;
    this.local$alphaThreshold = alphaThreshold_0;
  }
  Coroutine$calculatePerimeter.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$calculatePerimeter.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$calculatePerimeter.prototype.constructor = Coroutine$calculatePerimeter;
  Coroutine$calculatePerimeter.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$alphaThreshold === void 0)
              this.local$alphaThreshold = 0.1;
            this.state_0 = 2;
            this.result_0 = loadTexture(this.local$$receiver, this.local$path, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var texture = this.result_0;
            return ExtrudeUtil_getInstance().calculatePerimeter_pv5w23$(texture, new IntRectangle(0, 0, texture.widthPixels, texture.heightPixels), this.local$alphaThreshold);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function calculatePerimeter($receiver_0, path_0, alphaThreshold_0, continuation_0, suspended) {
    var instance = new Coroutine$calculatePerimeter($receiver_0, path_0, alphaThreshold_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$calculatePerimeter_0($receiver_0, atlasPath_0, regionName_0, alphaThreshold_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$group = void 0;
    this.local$region = void 0;
    this.local$$receiver = $receiver_0;
    this.local$atlasPath = atlasPath_0;
    this.local$regionName = regionName_0;
    this.local$alphaThreshold = alphaThreshold_0;
  }
  Coroutine$calculatePerimeter_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$calculatePerimeter_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$calculatePerimeter_0.prototype.constructor = Coroutine$calculatePerimeter_0;
  Coroutine$calculatePerimeter_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$alphaThreshold === void 0)
              this.local$alphaThreshold = 0.1;
            var tmp$;
            this.local$group = cacheSet(this.local$$receiver);
            this.state_0 = 2;
            this.result_0 = loadAndCacheJson(this.local$$receiver, TextureAtlasData.Companion.serializer(), this.local$atlasPath, this.local$group, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var atlasData = this.result_0;
            tmp$ = atlasData.findRegion_61zpoe$(this.local$regionName);
            if (tmp$ == null) {
              throw Exception_init("Region '" + this.local$regionName + "' not found in atlas.");
            }
            var page = tmp$.component1();
            this.local$page = tmp$.component1(), this.local$region = tmp$.component2();
            this.state_0 = 3;
            this.result_0 = loadAndCacheAtlasPage(this.local$$receiver, this.local$atlasPath, page, this.local$group, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            var texture = this.result_0;
            return ExtrudeUtil_getInstance().calculatePerimeter_pv5w23$(texture, this.local$region.bounds, this.local$alphaThreshold);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function calculatePerimeter_0($receiver_0, atlasPath_0, regionName_0, alphaThreshold_0, continuation_0, suspended) {
    var instance = new Coroutine$calculatePerimeter_0($receiver_0, atlasPath_0, regionName_0, alphaThreshold_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function LightingRenderer(context, numPointLights, numShadowPointLights, directionalShadowMapShader, pointShadowMapShader, directionalShadowsResolution, pointShadowsResolution, hasStencil) {
    if (numPointLights === void 0)
      numPointLights = 10;
    if (numShadowPointLights === void 0)
      numShadowPointLights = 3;
    if (directionalShadowMapShader === void 0)
      directionalShadowMapShader = null;
    if (pointShadowMapShader === void 0)
      pointShadowMapShader = null;
    if (directionalShadowsResolution === void 0)
      directionalShadowsResolution = 1024;
    if (pointShadowsResolution === void 0)
      pointShadowsResolution = 1024;
    if (hasStencil === void 0)
      hasStencil = false;
    ContextImpl_init(context, this);
    this.numPointLights = numPointLights;
    this.numShadowPointLights = numShadowPointLights;
    this.directionalShadowMapShader_0 = directionalShadowMapShader != null ? directionalShadowMapShader : own(this, new DirectionalShadowShader(context.inject_af3212$(CachedGl20.Companion)));
    this.pointShadowMapShader_0 = pointShadowMapShader != null ? pointShadowMapShader : own(this, new PointShadowShader(context.inject_af3212$(CachedGl20.Companion)));
    this.directionalShadowUnit = 1;
    this.pointShadowUnit = 2;
    this.gl_0 = this.inject_af3212$(CachedGl20.Companion);
    this.window_0 = this.inject_af3212$(Window.Companion);
    this.directionalShadowsFbo_0 = own(this, framebuffer(this, directionalShadowsResolution, directionalShadowsResolution, true, hasStencil));
    this.directionalLightCamera = new DirectionalLightCamera();
    this.pointLightShadowMaps_0 = null;
    this.pointShadowsFbo_0 = own(this, framebuffer(this, pointShadowsResolution, pointShadowsResolution, true, hasStencil));
    this.pointLightCamera_0 = new PointLightCamera(this.window_0, pointShadowsResolution);
    var $receiver = new Matrix4();
    $receiver.scl_y2kzbl$(0.5, 0.5, 0.5);
    $receiver.translate_y2kzbl$(1.0, 1.0, 1.0);
    this.bias_0 = $receiver;
    this.allowShadows = true;
    this.pointShadowsFbo_0.begin();
    var array = Array_0(this.numShadowPointLights);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      var closure$pointShadowsResolution = pointShadowsResolution;
      var array_0 = Array_0(6);
      var tmp$_0;
      tmp$_0 = array_0.length - 1 | 0;
      for (var i_0 = 0; i_0 <= tmp$_0; i_0++) {
        array_0[i_0] = new BufferTexture(this.gl_0, closure$pointShadowsResolution, closure$pointShadowsResolution, 'LightingRendererShadows');
      }
      var sides = array_0;
      var cubeMap = new CubeMap(sides[0], sides[1], sides[2], sides[3], sides[4], sides[5], this.gl_0, true);
      cubeMap.refInc();
      array[i] = cubeMap;
    }
    this.pointLightShadowMaps_0 = array;
    this.pointShadowsFbo_0.end();
    this.u_directionalLightMvp_0 = new Matrix4();
  }
  LightingRenderer.prototype.renderOcclusion_3187gu$ = function (camera, directionalLight, pointLights, renderOcclusion) {
    if (!this.allowShadows)
      return;
    var previousProgram = this.gl_0.program;
    var previousBlendingEnabled = this.gl_0.isEnabled_za3lpa$(3042);
    this.gl_0.disable_za3lpa$(3042);
    this.gl_0.enable_za3lpa$(2929);
    this.gl_0.depthFunc_za3lpa$(513);
    this.directionalLightShadows_0(this.directionalShadowMapShader_0, camera, directionalLight, renderOcclusion);
    this.pointLightShadows_0(this.pointShadowMapShader_0, camera, pointLights, renderOcclusion);
    this.gl_0.disable_za3lpa$(2929);
    if (previousBlendingEnabled)
      this.gl_0.enable_za3lpa$(3042);
    this.gl_0.useProgram_15mccn$(previousProgram);
  };
  function LightingRenderer$directionalLightShadows$lambda(this$LightingRenderer, closure$directionalLight, closure$camera, closure$renderOcclusion) {
    return function () {
      var tmp$;
      this$LightingRenderer.directionalShadowsFbo_0.begin();
      clearAndReset(this$LightingRenderer.gl_0, Color.Companion.BLUE, 16640);
      if (!((tmp$ = closure$directionalLight.color) != null ? tmp$.equals(Color.Companion.BLACK) : null)) {
        var $receiver = this$LightingRenderer.gl_0;
        var width = this$LightingRenderer.directionalShadowsFbo_0.widthPixels - 2 | 0;
        var height = this$LightingRenderer.directionalShadowsFbo_0.heightPixels - 2 | 0;
        var oldScissor = $receiver.getParameteriv_aio0fn$(3088, new Int32Array(4));
        var oldEnabled = $receiver.isEnabled_za3lpa$(3089);
        $receiver.enable_za3lpa$(3089);
        $receiver.scissor_tjonv8$(1, 1, width, height);
        var this$LightingRenderer_0 = this$LightingRenderer;
        var closure$directionalLight_0 = closure$directionalLight;
        var closure$camera_0 = closure$camera;
        var closure$renderOcclusion_0 = closure$renderOcclusion;
        if (this$LightingRenderer_0.directionalLightCamera.update_q58r77$(closure$directionalLight_0.direction, closure$camera_0)) {
          this$LightingRenderer_0.gl_0.uniforms.put_3c7q8m$('u_directionalLightMvp', this$LightingRenderer_0.directionalLightCamera.combined);
        }closure$renderOcclusion_0();
        if (!oldEnabled)
          $receiver.disable_za3lpa$(3089);
        $receiver.scissor_tjonv8$(oldScissor[0], oldScissor[1], oldScissor[2], oldScissor[3]);
      }this$LightingRenderer.directionalShadowsFbo_0.end();
      return Unit;
    };
  }
  LightingRenderer.prototype.directionalLightShadows_0 = function (directionalShadowMapShader, camera, directionalLight, renderOcclusion) {
    this.gl_0.useProgram_15mccn$(directionalShadowMapShader.program);
    useCamera(this.gl_0.uniforms, camera, void 0, LightingRenderer$directionalLightShadows$lambda(this, directionalLight, camera, renderOcclusion));
  };
  function LightingRenderer$pointLightShadows$lambda(closure$uniforms, this$LightingRenderer, closure$pointLights, closure$renderOcclusion) {
    return function () {
      var tmp$;
      var u_pointLightMvp = closure$uniforms.getRequiredUniformLocation_61zpoe$('u_pointLightMvp');
      this$LightingRenderer.pointShadowsFbo_0.begin();
      clearAndReset(this$LightingRenderer.gl_0, Color.Companion.BLUE, 16640);
      var a = this$LightingRenderer.numShadowPointLights - 1 | 0;
      var b = get_lastIndex_0(closure$pointLights);
      tmp$ = Math_0.min(a, b);
      for (var i = 0; i <= tmp$; i++) {
        var pointLight = closure$pointLights.get_za3lpa$(i);
        var pointLightShadowMap = this$LightingRenderer.pointLightShadowMaps_0[i];
        bindTexture(this$LightingRenderer.gl_0, pointLightShadowMap, this$LightingRenderer.pointShadowUnit + i | 0);
        put(closure$uniforms, 'u_lightPosition', pointLight.position);
        closure$uniforms.put_9sobi5$('u_lightRadius', pointLight.radius);
        if (pointLight.radius > 1.0) {
          for (var j = 0; j <= 5; j++) {
            this$LightingRenderer.gl_0.framebufferTexture2D_sivm59$(36160, 36064, 34069 + j | 0, ensureNotNull(pointLightShadowMap.textureHandle), 0);
            this$LightingRenderer.gl_0.clear_za3lpa$(16640);
            if (pointLight.shadowSidesEnabled[j]) {
              this$LightingRenderer.pointLightCamera_0.update_w5n7je$(pointLight, j);
              closure$uniforms.put_3o3vmn$(u_pointLightMvp, this$LightingRenderer.pointLightCamera_0.camera.combined);
              closure$renderOcclusion();
              this$LightingRenderer.gl_0.batch.flush();
            }}
        }}
      this$LightingRenderer.pointShadowsFbo_0.end();
      return Unit;
    };
  }
  LightingRenderer.prototype.pointLightShadows_0 = function (pointShadowMapShader, camera, pointLights, renderOcclusion) {
    this.gl_0.useProgram_15mccn$(pointShadowMapShader.program);
    var uniforms = this.gl_0.uniforms;
    useCamera(uniforms, camera, void 0, LightingRenderer$pointLightShadows$lambda(uniforms, this, pointLights, renderOcclusion));
  };
  function LightingRenderer$renderWorld$lambda$lambda(closure$renderWorld) {
    return function () {
      closure$renderWorld();
      return Unit;
    };
  }
  LightingRenderer.prototype.renderWorld_5pcu7l$ = function (camera, lightingShader, ambientLight, directionalLight, pointLights, renderWorld) {
    var previousProgram = this.gl_0.program;
    this.gl_0.useProgram_15mccn$(lightingShader.program);
    var $receiver = this.gl_0.uniforms;
    var tmp$, tmp$_0;
    $receiver.put_9xt0da$('u_resolutionInv', 1.0 / this.directionalShadowsFbo_0.widthPixels, 1.0 / this.directionalShadowsFbo_0.heightPixels);
    $receiver.put_bm4lxs$('u_directionalShadowMap', this.directionalShadowUnit);
    tmp$ = this.numShadowPointLights;
    for (var i = 0; i < tmp$; i++) {
      $receiver.put_bm4lxs$('u_pointLightShadowMaps[' + i + ']', this.pointShadowUnit + i | 0);
    }
    this.pointLightUniforms_0($receiver, pointLights);
    bindTexture(this.gl_0, this.directionalShadowsFbo_0.texture, this.directionalShadowUnit);
    $receiver.put_3c7q8m$('u_directionalLightMvp', this.u_directionalLightMvp_0.set_pekf88$(this.bias_0).mul_pekf88$(this.directionalLightCamera.combined));
    if ((tmp$_0 = $receiver.getUniformLocation_61zpoe$('u_shadowsEnabled')) != null) {
      $receiver.put_y004uz$(tmp$_0, this.allowShadows ? 1 : 0);
    }$receiver.put_kjn4ou$('u_ambient', ambientLight.color.r, ambientLight.color.g, ambientLight.color.b, ambientLight.color.a);
    $receiver.put_kjn4ou$('u_directional', directionalLight.color.r, directionalLight.color.g, directionalLight.color.b, directionalLight.color.a);
    putOptional($receiver, 'u_directionalLightDir', directionalLight.direction);
    useCamera($receiver, camera, void 0, LightingRenderer$renderWorld$lambda$lambda(renderWorld));
    this.gl_0.useProgram_15mccn$(previousProgram);
  };
  LightingRenderer.prototype.pointLightUniforms_0 = function ($receiver, pointLights) {
    var tmp$;
    tmp$ = this.numPointLights;
    for (var i = 0; i < tmp$; i++) {
      var pointLight = i < pointLights.size ? pointLights.get_za3lpa$(i) : PointLight$Companion_getInstance().EMPTY_POINT_LIGHT;
      $receiver.put_9sobi5$('u_pointLights[' + i + '].radius', pointLight.radius);
      put($receiver, 'u_pointLights[' + i + '].position', pointLight.position);
      putRgb($receiver, 'u_pointLights[' + i + '].color', pointLight.color);
    }
  };
  LightingRenderer.prototype.dispose = function () {
    var tmp$;
    tmp$ = get_lastIndex(this.pointLightShadowMaps_0);
    for (var i = 0; i <= tmp$; i++) {
      this.pointLightShadowMaps_0[i].refDec();
    }
  };
  LightingRenderer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LightingRenderer',
    interfaces: [ContextImpl, Disposable]
  };
  var PACK_FLOAT;
  var UNPACK_FLOAT;
  function LightingShader(gl, numPointLights, numShadowPointLights) {
    ShaderProgramBase.call(this, gl, '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'attribute vec3 a_position;' + '\n' + 'attribute vec3 a_normal;' + '\n' + 'attribute vec4 a_colorTint;' + '\n' + 'attribute vec2 a_texCoord0;' + '\n' + '\n' + 'uniform mat4 u_projTrans;' + '\n' + 'uniform mat4 u_modelTrans;' + '\n' + 'uniform mat4 u_directionalLightMvp;' + '\n' + '\n' + 'varying vec4 v_worldPosition;' + '\n' + 'varying vec3 v_normal;' + '\n' + 'varying vec4 v_colorTint;' + '\n' + 'varying vec2 v_texCoord;' + '\n' + 'varying vec4 v_directionalShadowCoord;' + '\n' + '\n' + 'void main() {' + '\n' + '\tv_worldPosition = u_modelTrans * vec4(a_position, 1.0);' + '\n' + '\tv_normal = normalize(mat3(u_modelTrans) * a_normal);' + '\n' + '\tv_colorTint = a_colorTint;' + '\n' + '\tv_texCoord = a_texCoord0;' + '\n' + '\tgl_Position =  u_projTrans * v_worldPosition;' + '\n' + '\tv_directionalShadowCoord = u_directionalLightMvp * v_worldPosition;' + '\n' + '}' + '\n', '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'struct PointLight {' + '\n' + '\tfloat radius;' + '\n' + '\tvec3 position;' + '\n' + '\tvec3 color;' + '\n' + '};' + '\n' + '\n' + 'varying vec4 v_worldPosition;' + '\n' + 'varying vec3 v_normal;' + '\n' + 'varying vec4 v_colorTint;' + '\n' + 'varying vec4 v_directionalShadowCoord;' + '\n' + 'varying vec2 v_texCoord;' + '\n' + '\n' + 'uniform int u_shadowsEnabled;' + '\n' + 'uniform vec2 u_resolutionInv;' + '\n' + 'uniform vec4 u_ambient;' + '\n' + 'uniform vec4 u_directional;' + '\n' + 'uniform vec3 u_directionalLightDir;' + '\n' + 'uniform sampler2D u_texture;' + '\n' + 'uniform sampler2D u_directionalShadowMap;' + '\n' + '\n' + 'uniform bool u_useColorTrans;' + '\n' + 'uniform mat4 u_colorTrans;' + '\n' + 'uniform vec4 u_colorOffset;' + '\n' + '\n' + '\n' + '// Point lights' + '\n' + (numPointLights > 0 ? 'uniform PointLight u_pointLights[' + numPointLights + '];' : '') + '\n' + (numShadowPointLights > 0 ? 'uniform samplerCube u_pointLightShadowMaps[' + numShadowPointLights + '];' : '') + '\n' + '\n' + 'uniform vec2 u_poissonDisk[4];' + '\n' + '\n' + UNPACK_FLOAT + '\n' + '\n' + 'float getShadowDepth(const in vec2 coord) {' + '\n' + '\tvec4 c = texture2D(u_directionalShadowMap, coord);' + '\n' + '\treturn unpackFloat(c);' + '\n' + '}' + '\n' + '\n' + 'vec3 getDirectionalColor() {' + '\n' + '\tfloat cosTheta = clamp(dot(v_normal, -u_directionalLightDir), 0.05, 1.0);' + '\n' + '\tif (u_shadowsEnabled == 0 || u_directional.rgb == vec3(0.0)) return cosTheta * u_directional.rgb;' + '\n' + '\tfloat visibility = 0.0;' + '\n' + '\tfloat shadow = getShadowDepth(v_directionalShadowCoord.xy);' + '\n' + '\tfloat bias = 0.002;' + '\n' + '\tfloat testZ = v_directionalShadowCoord.z - bias;' + '\n' + '\tif (testZ >= unpackFloat(vec4(0.0, 0.0, 1.0, 1.0)))' + '\n' + '    \treturn cosTheta * u_directional.rgb;' + '\n' + '\n' + '\tif (shadow >= testZ) visibility += 0.2;' + '\n' + '\tfor (int i = 0; i < 4; i++) {' + '\n' + '\t\tshadow = getShadowDepth((v_directionalShadowCoord.xy + u_poissonDisk[i] * u_resolutionInv));' + '\n' + '\t\tif (shadow >= testZ) visibility += 0.2;' + '\n' + '\t}' + '\n' + '\n' + '\treturn visibility * cosTheta * u_directional.rgb;' + '\n' + '}' + '\n' + '\n' + 'vec3 getPointColor() {' + '\n' + (numPointLights > 0 ? '\n' + '\tvec3 pointColor = vec3(0.0);' + '\n' + '\tPointLight pointLight;' + '\n' + '\tvec3 lightToPixel;' + '\n' + '\tvec3 lightToPixelN;' + '\n' + '\tfloat attenuation;' + '\n' + '\tfloat distance;' + '\n' + '\tfloat shadow;' + '\n' + '\tfloat testZ;' + '\n' + '\n' + '\tfloat bias = -0.0005;' + '\n' + '\tfloat maxD = unpackFloat(vec4(0.0, 0.0, 1.0, 1.0));' + '\n' + '\n' + '\tfor (int i = 0; i < ' + numPointLights + '; i++) {' + '\n' + '\t\tpointLight = u_pointLights[i];' + '\n' + '\t\tif (pointLight.radius > 1.0) {' + '\n' + '\t\t\tlightToPixel = v_worldPosition.xyz - pointLight.position;' + '\n' + '\t\t\tlightToPixelN = normalize(lightToPixel);' + '\n' + '\t\t\tdistance = length(lightToPixel) / pointLight.radius;' + '\n' + '\t\t\ttestZ = distance - bias;' + '\n' + '\n' + '\t\t\tattenuation = 1.0 - clamp(distance, 0.0, 1.0);' + '\n' + '\t\t\tfloat cosTheta = clamp(dot(v_normal, -1.0 * lightToPixelN), 0.0, 1.0);' + '\n' + '\n' + '\t\t\tif (u_shadowsEnabled == 0 || i >= ' + numShadowPointLights + ') {' + '\n' + '\t\t\t\tpointColor += cosTheta * pointLight.color * attenuation * attenuation;' + '\n' + '\t\t\t} else {' + '\n' + '\t\t\t\t' + (numShadowPointLights > 0 ? '\n\t\t\t\tshadow = unpackFloat(textureCube(u_pointLightShadowMaps[i], lightToPixelN));\n\n\t\t\t\tif (testZ >= maxD || shadow >= testZ) {\n\t\t\t\t\tpointColor += cosTheta * pointLight.color * attenuation * attenuation;\n\t\t\t\t}\n\t\t\t\t' : '') + '\n' + '\t\t\t}' + '\n' + '\t\t}' + '\n' + '\t}' + '\n' + '\n' + '\treturn pointColor;' + '\n' + '\t' : 'return vec3(0.0);') + '\n' + '}' + '\n' + '\n' + 'void main() {' + '\n' + '\tvec3 directional = getDirectionalColor();' + '\n' + '\tvec3 point = getPointColor();' + '\n' + '\n' + '\tvec4 diffuseColor = v_colorTint * texture2D(u_texture, v_texCoord);' + '\n' + '\n' + '\tvec4 final = vec4(clamp(u_ambient.rgb + directional + point, 0.0, 1.3) * diffuseColor.rgb, diffuseColor.a);' + '\n' + '\tif (u_useColorTrans) {' + '\n' + '\t\tgl_FragColor = u_colorTrans * final + u_colorOffset;' + '\n' + '\t} else {' + '\n' + '\t\tgl_FragColor = final;' + '\n' + '\t}' + '\n' + '\n' + '\tif (gl_FragColor.a < 0.01) discard;' + '\n' + '}' + '\n' + '\n' + '\n');
  }
  LightingShader.prototype.initUniforms_qhalab$ = function (uniforms) {
    uniforms.put_9xt0da$('u_poissonDisk[0]', -0.94201624, -0.39906216);
    uniforms.put_9xt0da$('u_poissonDisk[1]', 0.9455861, -0.76890725);
    uniforms.put_9xt0da$('u_poissonDisk[2]', -0.0941841, -0.9293887);
    uniforms.put_9xt0da$('u_poissonDisk[3]', 0.34495938, 0.2938776);
  };
  LightingShader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LightingShader',
    interfaces: [ShaderProgramBase]
  };
  function PointShadowShader(gl) {
    ShaderProgramBase.call(this, gl, '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'attribute vec3 a_position;' + '\n' + 'attribute vec4 a_colorTint;' + '\n' + 'attribute vec2 a_texCoord0;' + '\n' + '\n' + 'uniform mat4 u_pointLightMvp;' + '\n' + 'uniform mat4 u_modelTrans;' + '\n' + '\n' + 'varying vec4 v_worldPosition;' + '\n' + 'varying vec4 v_colorTint;' + '\n' + 'varying vec2 v_texCoord;' + '\n' + '\n' + 'void main() {' + '\n' + '\tv_colorTint = a_colorTint;' + '\n' + '\tv_texCoord = a_texCoord0;' + '\n' + '\tv_worldPosition = u_modelTrans * vec4(a_position, 1.0);' + '\n' + '\tgl_Position = u_pointLightMvp * v_worldPosition;' + '\n' + '}' + '\n', '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'uniform vec3 u_lightPosition;' + '\n' + 'uniform float u_lightRadius;' + '\n' + 'varying vec4 v_colorTint;' + '\n' + 'varying vec2 v_texCoord;' + '\n' + '\n' + 'uniform sampler2D u_texture;' + '\n' + '\n' + 'varying vec4 v_worldPosition;' + '\n' + '\n' + PACK_FLOAT + '\n' + '\n' + 'void main() {' + '\n' + '\tvec4 diffuse = v_colorTint * texture2D(u_texture, v_texCoord);' + '\n' + '\tif (diffuse.a < 0.2) discard;' + '\n' + '\tgl_FragColor = packFloat(length(v_worldPosition.xyz - u_lightPosition) / u_lightRadius);' + '\n' + '}' + '\n' + '\n');
  }
  PointShadowShader.prototype.initUniforms_qhalab$ = function (uniforms) {
  };
  PointShadowShader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PointShadowShader',
    interfaces: [ShaderProgramBase]
  };
  function DirectionalShadowShader(gl) {
    ShaderProgramBase.call(this, gl, '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'attribute vec3 a_position;' + '\n' + 'attribute vec4 a_colorTint;' + '\n' + 'attribute vec2 a_texCoord0;' + '\n' + '\n' + 'uniform mat4 u_directionalLightMvp;' + '\n' + 'uniform mat4 u_modelTrans;' + '\n' + '\n' + 'varying vec4 v_colorTint;' + '\n' + 'varying vec2 v_texCoord;' + '\n' + '\n' + 'void main() {' + '\n' + '\tv_colorTint = a_colorTint;' + '\n' + '\tv_texCoord = a_texCoord0;' + '\n' + '\tvec4 worldPosition = u_modelTrans * vec4(a_position, 1.0);' + '\n' + '\tgl_Position = u_directionalLightMvp * worldPosition;' + '\n' + '}' + '\n', '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'varying vec4 v_colorTint;' + '\n' + 'varying vec2 v_texCoord;' + '\n' + '\n' + 'uniform sampler2D u_texture;' + '\n' + '\n' + PACK_FLOAT + '\n' + '\n' + 'void main() {' + '\n' + '\tvec4 diffuse = v_colorTint * texture2D(u_texture, v_texCoord);' + '\n' + '\tif (diffuse.a < 0.2) discard;' + '\n' + '\tgl_FragColor = packFloat(gl_FragCoord.z);' + '\n' + '}' + '\n' + '\n');
  }
  DirectionalShadowShader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DirectionalShadowShader',
    interfaces: [ShaderProgramBase]
  };
  function LightingShaderWithNormalMap(gl, numPointLights, numShadowPointLights) {
    ShaderProgramBase.call(this, gl, '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'struct PointLight {' + '\n' + '\tfloat radius;' + '\n' + '\tvec3 position;' + '\n' + '\tvec3 color;' + '\n' + '};' + '\n' + '\n' + 'attribute vec3 a_position;' + '\n' + 'attribute vec3 a_normal;' + '\n' + 'attribute vec3 a_tangent;' + '\n' + 'attribute vec3 a_bitangent;' + '\n' + 'attribute vec4 a_colorTint;' + '\n' + 'attribute vec2 a_texCoord0;' + '\n' + '\n' + 'uniform mat4 u_projTrans;' + '\n' + 'uniform mat3 u_normalTrans;' + '\n' + 'uniform mat4 u_modelTrans;' + '\n' + 'uniform mat4 u_directionalLightMvp;' + '\n' + 'uniform vec3 u_directionalLightDir;' + '\n' + 'uniform PointLight u_pointLights[' + numPointLights + '];' + '\n' + '\n' + 'varying vec4 v_worldPosition;' + '\n' + 'varying vec4 v_colorTint;' + '\n' + 'varying vec2 v_texCoord;' + '\n' + 'varying vec3 v_tsDirectionalLightDir;' + '\n' + 'varying vec4 v_directionalShadowCoord;' + '\n' + 'varying vec3 v_pointLightDirectionsTs[' + numPointLights + '];' + '\n' + '\n' + 'mat3 transpose(in mat3 mat) {' + '\n' + '    vec3 i0 = mat[0];' + '\n' + '    vec3 i1 = mat[1];' + '\n' + '    vec3 i2 = mat[2];' + '\n' + '\n' + '    return mat3(' + '\n' + '        vec3(i0.x, i1.x, i2.x),' + '\n' + '        vec3(i0.y, i1.y, i2.y),' + '\n' + '        vec3(i0.z, i1.z, i2.z)' + '\n' + '    );' + '\n' + '}' + '\n' + '\n' + 'void main() {' + '\n' + '\tv_colorTint = a_colorTint;' + '\n' + '\tv_texCoord = a_texCoord0;' + '\n' + '\tv_worldPosition = u_modelTrans * vec4(a_position, 1.0);' + '\n' + '\n' + '\tvec3 t = normalize(u_normalTrans * vec3(1.0, 0.0, 0.0));' + '\n' + '    vec3 b = normalize(u_normalTrans * vec3(0.0, 0.0, -1.0));' + '\n' + '    vec3 n = normalize(u_normalTrans * vec3(0.0, -1.0, 0.0));' + '\n' + '\n' + '\t//vec3 t = normalize(u_normalTrans * a_tangent);' + '\n' + '    //vec3 b = normalize(u_normalTrans * a_bitangent);' + '\n' + '    //vec3 n = normalize(u_normalTrans * a_normal);' + '\n' + '    mat3 tbn = transpose(mat3(t, b, n));' + '\n' + '\n' + '\tgl_Position =  u_projTrans * v_worldPosition;' + '\n' + '\tv_tsDirectionalLightDir = tbn * u_directionalLightDir;' + '\n' + '\tv_directionalShadowCoord = u_directionalLightMvp * v_worldPosition;' + '\n' + '\n' + '\tPointLight pointLight;' + '\n' + '\tfor (int i = 0; i < ' + numPointLights + '; i++) {' + '\n' + '\t\tpointLight = u_pointLights[i];' + '\n' + '\t\tif (pointLight.radius > 1.0) {' + '\n' + '\t\t\tv_pointLightDirectionsTs[i] = normalize(tbn * (pointLight.position - v_worldPosition.xyz));' + '\n' + '\t\t}' + '\n' + '\t}' + '\n' + '}' + '\n', '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'struct PointLight {' + '\n' + '\tfloat radius;' + '\n' + '\tvec3 position;' + '\n' + '\tvec3 color;' + '\n' + '};' + '\n' + '\n' + 'varying vec4 v_worldPosition;' + '\n' + 'varying vec4 v_colorTint;' + '\n' + 'varying vec2 v_texCoord;' + '\n' + 'varying vec3 v_tsDirectionalLightDir;' + '\n' + 'varying vec4 v_directionalShadowCoord;' + '\n' + 'varying vec3 v_pointLightDirectionsTs[' + numPointLights + '];' + '\n' + '\n' + 'uniform int u_shadowsEnabled;' + '\n' + 'uniform vec2 u_resolutionInv;' + '\n' + 'uniform vec4 u_ambient;' + '\n' + 'uniform vec4 u_directional;' + '\n' + 'uniform sampler2D u_texture;' + '\n' + 'uniform sampler2D u_textureNormal;' + '\n' + 'uniform sampler2D u_directionalShadowMap;' + '\n' + '\n' + 'uniform bool u_useColorTrans;' + '\n' + 'uniform mat4 u_colorTrans;' + '\n' + 'uniform vec4 u_colorOffset;' + '\n' + '\n' + '// Point lights' + '\n' + 'uniform PointLight u_pointLights[' + numPointLights + '];' + '\n' + (numShadowPointLights > 0 ? 'uniform samplerCube u_pointLightShadowMaps[' + numShadowPointLights + '];' : '') + '\n' + '\n' + 'uniform vec2 poissonDisk[4];' + '\n' + '\n' + UNPACK_FLOAT + '\n' + '\n' + 'float getShadowDepth(const in vec2 coord) {' + '\n' + '\tvec4 c = texture2D(u_directionalShadowMap, coord);' + '\n' + '\treturn unpackFloat(c);' + '\n' + '}' + '\n' + '\n' + 'vec3 getDirectionalColor(vec3 normal) {' + '\n' + '\tfloat cosTheta = clamp(dot(normal, -v_tsDirectionalLightDir), 0.05, 1.0);' + '\n' + '\tif (u_shadowsEnabled == 0 || u_directional.rgb == vec3(0.0)) return cosTheta * u_directional.rgb;' + '\n' + '\tfloat visibility = 0.0;' + '\n' + '\tfloat shadow = getShadowDepth(v_directionalShadowCoord.xy);' + '\n' + '\tfloat bias = 0.002;' + '\n' + '\tfloat testZ = v_directionalShadowCoord.z - bias;' + '\n' + '\tif (testZ >= unpackFloat(vec4(0.0, 0.0, 1.0, 1.0)))' + '\n' + '    \treturn cosTheta * u_directional.rgb;' + '\n' + '\n' + '\tif (shadow >= testZ) visibility += 0.2;' + '\n' + '\tfor (int i = 0; i < 4; i++) {' + '\n' + '\t\tshadow = getShadowDepth((v_directionalShadowCoord.xy + poissonDisk[i] * u_resolutionInv));' + '\n' + '\t\tif (shadow >= testZ) visibility += 0.2;' + '\n' + '\t}' + '\n' + '\n' + '\treturn visibility * cosTheta * u_directional.rgb;' + '\n' + '}' + '\n' + '\n' + 'vec3 getPointColor(vec3 normal) {' + '\n' + '\tvec3 pointColor = vec3(0.0);' + '\n' + '\tPointLight pointLight;' + '\n' + '\tvec3 lightToPixel;' + '\n' + '\tvec3 lightToPixelN;' + '\n' + '\tfloat attenuation;' + '\n' + '\tfloat distance;' + '\n' + '\tfloat shadow;' + '\n' + '\tfloat testZ;' + '\n' + '\n' + '\tfloat bias = -0.005;' + '\n' + '\tfloat maxD = unpackFloat(vec4(0.0, 0.0, 1.0, 1.0));' + '\n' + '\n' + '\tfor (int i = 0; i < ' + numPointLights + '; i++) {' + '\n' + '\t\tpointLight = u_pointLights[i];' + '\n' + '\t\tif (pointLight.radius > 1.0) {' + '\n' + '\t\t\tlightToPixel = v_worldPosition.xyz - pointLight.position;' + '\n' + '\t\t\tlightToPixelN = normalize(lightToPixel);' + '\n' + '\t\t\tdistance = length(lightToPixel) / pointLight.radius;' + '\n' + '\t\t\ttestZ = distance - bias;' + '\n' + '\n' + '\t\t\tattenuation = 1.0 - clamp(distance, 0.0, 1.0);' + '\n' + '\t\t\tfloat cosTheta = clamp(dot(normal, normalize(v_pointLightDirectionsTs[i])), 0.0, 1.0);' + '\n' + '\n' + '\t\t\tif (u_shadowsEnabled == 0 || i >= ' + numShadowPointLights + ') {' + '\n' + '\t\t\t\tpointColor += cosTheta * pointLight.color * attenuation * attenuation;' + '\n' + '\t\t\t} else {' + '\n' + '\t\t\t\t' + (numShadowPointLights > 0 ? '\n\t\t\t\tshadow = unpackFloat(textureCube(u_pointLightShadowMaps[i], lightToPixelN));\n\n\t\t\t\tif (testZ >= maxD || shadow >= testZ) {\n\t\t\t\t\tpointColor += cosTheta * pointLight.color * attenuation * attenuation;\n\t\t\t\t}\n\t\t\t\t' : '') + '\n' + '\t\t\t}' + '\n' + '\t\t}' + '\n' + '\t}' + '\n' + '\n' + '\treturn pointColor;' + '\n' + '}' + '\n' + '\n' + 'void main() {' + '\n' + '\tvec3 normal = normalize(texture2D(u_textureNormal, v_texCoord).rgb * 2.0 - 1.0);' + '\n' + '\tvec3 directional = getDirectionalColor(normal);' + '\n' + '\tvec3 point = getPointColor(normal);' + '\n' + '\n' + '\tvec4 diffuseColor = v_colorTint * texture2D(u_texture, v_texCoord);' + '\n' + '\n' + '\tvec4 final = vec4(clamp(u_ambient.rgb + directional + point, 0.0, 1.3) * diffuseColor.rgb, diffuseColor.a);' + '\n' + '\tif (u_useColorTrans) {' + '\n' + '\t\tgl_FragColor = u_colorTrans * final + u_colorOffset;' + '\n' + '\t} else {' + '\n' + '\t\tgl_FragColor = final;' + '\n' + '\t}' + '\n' + '\n' + '\tif (gl_FragColor.a < 0.01) discard;' + '\n' + '}' + '\n' + '\n' + '\n', mapOf([to(0, core.CommonShaderAttributes.A_POSITION), to(1, core.CommonShaderAttributes.A_NORMAL), to(4, core.CommonShaderAttributes.A_TANGENT), to(5, core.CommonShaderAttributes.A_BITANGENT), to(2, core.CommonShaderAttributes.A_COLOR_TINT), to(3, core.CommonShaderAttributes.A_TEXTURE_COORD + '0')]));
  }
  LightingShaderWithNormalMap.prototype.initUniforms_qhalab$ = function (uniforms) {
    uniforms.put_9xt0da$('poissonDisk[0]', -0.94201624, -0.39906216);
    uniforms.put_9xt0da$('poissonDisk[1]', 0.9455861, -0.76890725);
    uniforms.put_9xt0da$('poissonDisk[2]', -0.0941841, -0.9293887);
    uniforms.put_9xt0da$('poissonDisk[3]', 0.34495938, 0.2938776);
  };
  LightingShaderWithNormalMap.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LightingShaderWithNormalMap',
    interfaces: [ShaderProgramBase]
  };
  function Skybox(owner, camera) {
    UiComponentImpl.call(this, owner);
    this.camera_0 = camera;
    this.shader_0 = new SkyboxShader(this.gl);
    this.cubeMap_0 = null;
    this.vertices_0 = new Float32Array([-1.0, 1.0, -1.0, -1.0, -1.0, -1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, 1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, 1.0, -1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, 1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, 1.0, 1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, -1.0, 1.0]);
    this.vertexComponents_0 = floatBuffer(this.vertices_0.length);
    put_0(this.vertexComponents_0, this.vertices_0);
    this.interactivityMode = InteractivityMode.NONE;
    this.vertexComponentsBuffer_0 = null;
    this.viewProjection_0 = new Matrix4();
    this.modTag_0 = new ModTagWatch();
  }
  function Coroutine$Skybox$load$lambda$lambda(closure$positiveX_0, this$Skybox_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$positiveX = closure$positiveX_0;
    this.local$this$Skybox = this$Skybox_0;
  }
  Coroutine$Skybox$load$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$Skybox$load$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Skybox$load$lambda$lambda.prototype.constructor = Coroutine$Skybox$load$lambda$lambda;
  Coroutine$Skybox$load$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = loadTexture(this.local$this$Skybox, this.local$closure$positiveX, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function Skybox$load$lambda$lambda(closure$positiveX_0, this$Skybox_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$Skybox$load$lambda$lambda(closure$positiveX_0, this$Skybox_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$Skybox$load$lambda$lambda_0(closure$negativeX_0, this$Skybox_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$negativeX = closure$negativeX_0;
    this.local$this$Skybox = this$Skybox_0;
  }
  Coroutine$Skybox$load$lambda$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$Skybox$load$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Skybox$load$lambda$lambda_0.prototype.constructor = Coroutine$Skybox$load$lambda$lambda_0;
  Coroutine$Skybox$load$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = loadTexture(this.local$this$Skybox, this.local$closure$negativeX, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function Skybox$load$lambda$lambda_0(closure$negativeX_0, this$Skybox_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$Skybox$load$lambda$lambda_0(closure$negativeX_0, this$Skybox_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$Skybox$load$lambda$lambda_1(closure$positiveY_0, this$Skybox_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$positiveY = closure$positiveY_0;
    this.local$this$Skybox = this$Skybox_0;
  }
  Coroutine$Skybox$load$lambda$lambda_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$Skybox$load$lambda$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Skybox$load$lambda$lambda_1.prototype.constructor = Coroutine$Skybox$load$lambda$lambda_1;
  Coroutine$Skybox$load$lambda$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = loadTexture(this.local$this$Skybox, this.local$closure$positiveY, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function Skybox$load$lambda$lambda_1(closure$positiveY_0, this$Skybox_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$Skybox$load$lambda$lambda_1(closure$positiveY_0, this$Skybox_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$Skybox$load$lambda$lambda_2(closure$negativeY_0, this$Skybox_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$negativeY = closure$negativeY_0;
    this.local$this$Skybox = this$Skybox_0;
  }
  Coroutine$Skybox$load$lambda$lambda_2.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$Skybox$load$lambda$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Skybox$load$lambda$lambda_2.prototype.constructor = Coroutine$Skybox$load$lambda$lambda_2;
  Coroutine$Skybox$load$lambda$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = loadTexture(this.local$this$Skybox, this.local$closure$negativeY, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function Skybox$load$lambda$lambda_2(closure$negativeY_0, this$Skybox_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$Skybox$load$lambda$lambda_2(closure$negativeY_0, this$Skybox_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$Skybox$load$lambda$lambda_3(closure$positiveZ_0, this$Skybox_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$positiveZ = closure$positiveZ_0;
    this.local$this$Skybox = this$Skybox_0;
  }
  Coroutine$Skybox$load$lambda$lambda_3.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$Skybox$load$lambda$lambda_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Skybox$load$lambda$lambda_3.prototype.constructor = Coroutine$Skybox$load$lambda$lambda_3;
  Coroutine$Skybox$load$lambda$lambda_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = loadTexture(this.local$this$Skybox, this.local$closure$positiveZ, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function Skybox$load$lambda$lambda_3(closure$positiveZ_0, this$Skybox_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$Skybox$load$lambda$lambda_3(closure$positiveZ_0, this$Skybox_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$Skybox$load$lambda$lambda_4(closure$negativeZ_0, this$Skybox_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$negativeZ = closure$negativeZ_0;
    this.local$this$Skybox = this$Skybox_0;
  }
  Coroutine$Skybox$load$lambda$lambda_4.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$Skybox$load$lambda$lambda_4.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Skybox$load$lambda$lambda_4.prototype.constructor = Coroutine$Skybox$load$lambda$lambda_4;
  Coroutine$Skybox$load$lambda$lambda_4.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = loadTexture(this.local$this$Skybox, this.local$closure$negativeZ, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function Skybox$load$lambda$lambda_4(closure$negativeZ_0, this$Skybox_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$Skybox$load$lambda$lambda_4(closure$negativeZ_0, this$Skybox_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$Skybox$load$lambda(closure$positiveX_0, this$Skybox_0, closure$negativeX_0, closure$positiveY_0, closure$negativeY_0, closure$positiveZ_0, closure$negativeZ_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$positiveX = closure$positiveX_0;
    this.local$this$Skybox = this$Skybox_0;
    this.local$closure$negativeX = closure$negativeX_0;
    this.local$closure$positiveY = closure$positiveY_0;
    this.local$closure$negativeY = closure$negativeY_0;
    this.local$closure$positiveZ = closure$positiveZ_0;
    this.local$closure$negativeZ = closure$negativeZ_0;
    this.local$tmp$ = void 0;
    this.local$tmp$_0 = void 0;
    this.local$tmp$_1 = void 0;
    this.local$tmp$_2 = void 0;
    this.local$tmp$_3 = void 0;
    this.local$nX = void 0;
    this.local$pY = void 0;
    this.local$nY = void 0;
    this.local$pZ = void 0;
    this.local$nZ = void 0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$Skybox$load$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$Skybox$load$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$Skybox$load$lambda.prototype.constructor = Coroutine$Skybox$load$lambda;
  Coroutine$Skybox$load$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            var pX = async(this.local$$receiver, void 0, void 0, Skybox$load$lambda$lambda(this.local$closure$positiveX, this.local$this$Skybox));
            this.local$nX = async(this.local$$receiver, void 0, void 0, Skybox$load$lambda$lambda_0(this.local$closure$negativeX, this.local$this$Skybox));
            this.local$pY = async(this.local$$receiver, void 0, void 0, Skybox$load$lambda$lambda_1(this.local$closure$positiveY, this.local$this$Skybox));
            this.local$nY = async(this.local$$receiver, void 0, void 0, Skybox$load$lambda$lambda_2(this.local$closure$negativeY, this.local$this$Skybox));
            this.local$pZ = async(this.local$$receiver, void 0, void 0, Skybox$load$lambda$lambda_3(this.local$closure$positiveZ, this.local$this$Skybox));
            this.local$nZ = async(this.local$$receiver, void 0, void 0, Skybox$load$lambda$lambda_4(this.local$closure$negativeZ, this.local$this$Skybox));
            this.state_0 = 2;
            this.result_0 = pX.await(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$tmp$ = this.result_0;
            this.state_0 = 3;
            this.result_0 = this.local$nX.await(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.local$tmp$_0 = this.result_0;
            this.state_0 = 4;
            this.result_0 = this.local$pY.await(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            this.local$tmp$_1 = this.result_0;
            this.state_0 = 5;
            this.result_0 = this.local$nY.await(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 5:
            this.local$tmp$_2 = this.result_0;
            this.state_0 = 6;
            this.result_0 = this.local$pZ.await(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 6:
            this.local$tmp$_3 = this.result_0;
            this.state_0 = 7;
            this.result_0 = this.local$nZ.await(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 7:
            tmp$ = this.result_0;
            return this.local$this$Skybox.load_bs2o7m$(this.local$tmp$, this.local$tmp$_0, this.local$tmp$_1, this.local$tmp$_2, this.local$tmp$_3, tmp$), Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function Skybox$load$lambda(closure$positiveX_0, this$Skybox_0, closure$negativeX_0, closure$positiveY_0, closure$negativeY_0, closure$positiveZ_0, closure$negativeZ_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$Skybox$load$lambda(closure$positiveX_0, this$Skybox_0, closure$negativeX_0, closure$positiveY_0, closure$negativeY_0, closure$positiveZ_0, closure$negativeZ_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  Skybox.prototype.load_r3y0ew$ = function (positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ) {
    launch(this, void 0, void 0, Skybox$load$lambda(positiveX, this, negativeX, positiveY, negativeY, positiveZ, negativeZ));
  };
  Skybox.prototype.load_bs2o7m$ = function (positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ) {
    var cubeMap = new CubeMap(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ, this.gl);
    cubeMap.filterMin = TextureMinFilter.LINEAR_MIPMAP_LINEAR;
    cubeMap.refInc();
    this.cubeMap_0 = cubeMap;
  };
  Skybox.prototype.onActivated = function () {
    UiComponentImpl.prototype.onActivated.call(this);
    this.vertexComponentsBuffer_0 = this.gl.createBuffer();
    this.gl.bindBuffer_gtr22n$(34962, this.vertexComponentsBuffer_0);
    this.vertexComponents_0.flip();
    this.gl.bufferData_qt1dr2$(34962, this.vertexComponents_0.limit << 2, 35048);
    this.gl.bufferDatafv_j70xym$(34962, this.vertexComponents_0, 35048);
  };
  Skybox.prototype.onDeactivated = function () {
    UiComponentImpl.prototype.onDeactivated.call(this);
    this.gl.deleteBuffer_qv4l9y$(ensureNotNull(this.vertexComponentsBuffer_0));
    this.vertexComponentsBuffer_0 = null;
  };
  Skybox.prototype.draw = function () {
    var tmp$;
    tmp$ = this.cubeMap_0;
    if (tmp$ == null) {
      return;
    }var cubeMap = tmp$;
    var previousProgram = this.gl.program;
    this.gl.useProgram_15mccn$(this.shader_0.program);
    this.gl.batch.begin_nji62n$(cubeMap, BlendMode.Companion.NONE);
    if (this.modTag_0.set_i0o3f$(this.camera_0.modTag)) {
      this.viewProjection_0.idt();
      this.viewProjection_0.setToLookAt_uwler8$(this.camera_0.direction, new Vector3(this.camera_0.up.x, -this.camera_0.up.y, this.camera_0.up.z));
      var r = this.window.height / this.window.width;
      if (r > 1.0)
        this.viewProjection_0.scale_y2kzbl$(r, 1.0, 1.0);
      else
        this.viewProjection_0.scale_y2kzbl$(1.0, 1.0 / r, 1.0);
    }this.gl.enable_za3lpa$(2884);
    this.gl.frontFace_za3lpa$(2304);
    this.gl.cullFace_za3lpa$(1029);
    this.gl.uniforms.put_3c7q8m$(core.CommonShaderUniforms.U_PROJ_TRANS, this.viewProjection_0);
    this.gl.bindBuffer_gtr22n$(34962, this.vertexComponentsBuffer_0);
    this.gl.enableVertexAttribArray_za3lpa$(0);
    this.gl.vertexAttribPointer_owihk5$(0, 3, 5126, false, 12, 0);
    this.gl.drawArrays_qt1dr2$(4, 0, this.vertices_0.length / 3 | 0);
    this.gl.useProgram_15mccn$(previousProgram);
    this.gl.disableVertexAttribArray_za3lpa$(0);
    this.gl.bindBuffer_gtr22n$(34962, null);
    this.gl.disable_za3lpa$(2884);
  };
  Skybox.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Skybox',
    interfaces: [UiComponentImpl]
  };
  function SkyboxShader(gl) {
    ShaderProgramBase.call(this, gl, '\n' + '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'attribute vec3 a_position;' + '\n' + '\n' + 'varying vec3 v_texCoord;' + '\n' + '\n' + 'uniform mat4 u_projTrans;' + '\n' + '\n' + 'void main() {' + '\n' + '    v_texCoord = a_position;' + '\n' + '\tvec4 p = u_projTrans * vec4(a_position, 1.0);' + '\n' + '    gl_Position =  p.xyzz;' + '\n' + '}' + '\n' + '\n', '\n' + '\n' + core.DEFAULT_SHADER_HEADER + '\n' + '\n' + 'varying vec3 v_texCoord;' + '\n' + '\n' + 'uniform samplerCube u_texture;' + '\n' + '\n' + 'void main() {' + '\n' + '\tgl_FragColor = textureCube(u_texture, vec3(-v_texCoord.x, v_texCoord.y, -v_texCoord.z));' + '\n' + '}' + '\n' + '\n', hashMapOf([to(0, core.CommonShaderAttributes.A_POSITION)]));
  }
  SkyboxShader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SkyboxShader',
    interfaces: [ShaderProgramBase]
  };
  function AmbientLight() {
    this.color = Color.Companion.WHITE.copy();
  }
  AmbientLight.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AmbientLight',
    interfaces: []
  };
  function ambientLight$lambda($receiver) {
    return Unit;
  }
  function ambientLight(init) {
    if (init === void 0)
      init = ambientLight$lambda;
    var a = new AmbientLight();
    init(a);
    return a;
  }
  function DirectionalLight() {
    this.color = new Color();
    this.direction = new Vector3(0.0, 0.0, -1.0);
  }
  DirectionalLight.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DirectionalLight',
    interfaces: []
  };
  function directionalLight$lambda($receiver) {
    return Unit;
  }
  function directionalLight(init) {
    if (init === void 0)
      init = directionalLight$lambda;
    var d = new DirectionalLight();
    init(d);
    d.direction.nor();
    return d;
  }
  function DirectionalLightCamera() {
    this.clipSpace = [new Vector3(-1.0, -1.0, -1.0), new Vector3(1.0, -1.0, -1.0), new Vector3(1.0, 1.0, -1.0), new Vector3(-1.0, 1.0, -1.0), new Vector3(-1.0, -1.0, 1.0), new Vector3(1.0, -1.0, 1.0), new Vector3(1.0, 1.0, 1.0), new Vector3(-1.0, 1.0, 1.0)];
    this.viewCamWatch_0 = new ModTagWatch();
    this.view_0 = new Matrix4();
    this._combined_0 = new Matrix4();
    this.direction_0 = new Vector3(0.0, 0.0, 1.0);
    this.up_0 = new Vector3(0.0, -1.0, 0.0);
    var array = Array_0(8);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = new Vector3();
    }
    this.lastClipSpace_0 = array;
    this.bounds_0 = new Box();
    this.tmp_0 = new Vector3();
  }
  Object.defineProperty(DirectionalLightCamera.prototype, 'combined', {
    get: function () {
      return this._combined_0;
    }
  });
  DirectionalLightCamera.prototype.setClipSpaceFromWorld_jt4kw6$ = function (left, right, bottom, top, near, far, viewCamera) {
    var tmp$;
    this.setClipSpace_w8lrqs$(left, right, bottom, top, near, far);
    tmp$ = get_lastIndex(this.clipSpace);
    for (var i = 0; i <= tmp$; i++) {
      viewCamera.combined.prj_9wm29k$(this.clipSpace[i]);
    }
  };
  DirectionalLightCamera.prototype.setClipSpace_w8lrqs$ = function (left, right, bottom, top, near, far) {
    this.clipSpace[0].x = left;
    this.clipSpace[0].y = bottom;
    this.clipSpace[0].z = near;
    this.clipSpace[1].x = right;
    this.clipSpace[1].y = bottom;
    this.clipSpace[1].z = near;
    this.clipSpace[2].x = right;
    this.clipSpace[2].y = top;
    this.clipSpace[2].z = near;
    this.clipSpace[3].x = left;
    this.clipSpace[3].y = top;
    this.clipSpace[3].z = near;
    this.clipSpace[4].x = left;
    this.clipSpace[4].y = bottom;
    this.clipSpace[4].z = far;
    this.clipSpace[5].x = right;
    this.clipSpace[5].y = bottom;
    this.clipSpace[5].z = far;
    this.clipSpace[6].x = right;
    this.clipSpace[6].y = top;
    this.clipSpace[6].z = far;
    this.clipSpace[7].x = left;
    this.clipSpace[7].y = top;
    this.clipSpace[7].z = far;
  };
  DirectionalLightCamera.prototype.update_q58r77$ = function (newDirection, viewCam) {
    var tmp$, tmp$_0;
    if (!this.viewCamWatch_0.set_i0o3f$(viewCam.modTag) && ((tmp$ = this.direction_0) != null ? tmp$.equals(newDirection) : null) && contentEquals(this.lastClipSpace_0, this.clipSpace)) {
      return false;
    }if (!!newDirection.isZero()) {
      var message = 'Direction may not be zero.';
      throw IllegalStateException_init(message.toString());
    }this.setDirection_0(newDirection);
    this.view_0.setToLookAt_uwler8$(this.direction_0, this.up_0);
    this.bounds_0.inf();
    tmp$_0 = get_lastIndex(this.clipSpace);
    for (var i = 0; i <= tmp$_0; i++) {
      this.lastClipSpace_0[i].set_1fv2cb$(this.clipSpace[i]);
      viewCam.combinedInv.prj_9wm29k$(this.tmp_0.set_1fv2cb$(this.clipSpace[i]));
      this.view_0.prj_9wm29k$(this.tmp_0);
      this.bounds_0.ext_1fv2cb$(this.tmp_0);
    }
    this._combined_0.idt();
    this._combined_0.scl_y2kzbl$(2.0 / this.bounds_0.dimensions.x, 2.0 / this.bounds_0.dimensions.y, -2.0 / this.bounds_0.dimensions.z);
    this._combined_0.translate_y2kzbl$(-this.bounds_0.center.x, -this.bounds_0.center.y, -this.bounds_0.center.z);
    this._combined_0.mul_pekf88$(this.view_0);
    return true;
  };
  DirectionalLightCamera.prototype.setDirection_0 = function (newDirection) {
    this.tmp_0.set_1fv2cb$(newDirection);
    var dot = this.tmp_0.dot_1fv2cb$(this.up_0);
    if (math.MathUtils.isZero_dleff0$(dot - 1)) {
      this.up_0.set_1fv2cb$(this.direction_0).scl_mx4ult$(-1.0);
    } else if (math.MathUtils.isZero_dleff0$(dot + 1)) {
      this.up_0.set_1fv2cb$(this.direction_0);
    }this.direction_0.set_1fv2cb$(this.tmp_0);
    this.tmp_0.set_1fv2cb$(this.direction_0).crs_1fv2cb$(this.up_0).nor();
    this.up_0.set_1fv2cb$(this.tmp_0).crs_1fv2cb$(this.direction_0).nor();
  };
  DirectionalLightCamera.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DirectionalLightCamera',
    interfaces: []
  };
  function PointLight() {
    PointLight$Companion_getInstance();
    this.color = Color.Companion.WHITE.copy();
    this.position = new Vector3();
    this.radius = 0.0;
    this.shadowSidesEnabled = Kotlin.booleanArrayOf(true, true, true, true, true, true);
  }
  PointLight.prototype.set_xvy3hg$ = function (other) {
    this.color.set_8suw10$(other.color);
    this.position.set_1fv2cb$(other.position);
    this.radius = other.radius;
    return this;
  };
  PointLight.prototype.clear = function () {
    this.color.set_8suw10$(Color.Companion.WHITE);
    this.position.clear();
    this.radius = 0.0;
  };
  function PointLight$Companion() {
    PointLight$Companion_instance = this;
    this.EMPTY_POINT_LIGHT = new PointLight();
  }
  PointLight$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PointLight$Companion_instance = null;
  function PointLight$Companion_getInstance() {
    if (PointLight$Companion_instance === null) {
      new PointLight$Companion();
    }return PointLight$Companion_instance;
  }
  PointLight.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PointLight',
    interfaces: [Clearable]
  };
  function pointLight$lambda($receiver) {
    return Unit;
  }
  function pointLight(init) {
    if (init === void 0)
      init = pointLight$lambda;
    var p = new PointLight();
    init(p);
    return p;
  }
  function PointLightCamera(window_0, resolution) {
    PointLightCamera$Companion_getInstance();
    this.camera = new PerspectiveCamera();
    this.camera.fieldOfView = 90.0 * math.MathUtils.degRad;
    this.camera.viewportWidth = resolution;
    this.camera.viewportHeight = resolution;
  }
  PointLightCamera.prototype.update_w5n7je$ = function (pointLight, direction) {
    if (pointLight.radius < 1.0E-4)
      return;
    this.camera.setPosition_1fv2cb$(pointLight.position);
    this.camera.setDirection_esq9j2$(PointLightCamera$Companion_getInstance().CUBEMAP_DIRECTIONS_0[direction], false);
    this.camera.setUp_1fv2cb$(PointLightCamera$Companion_getInstance().CUBEMAP_UP_0[direction]);
  };
  function PointLightCamera$Companion() {
    PointLightCamera$Companion_instance = this;
    this.CUBEMAP_DIRECTIONS_0 = [new Vector3(1.0, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 0.0, 1.0), new Vector3(0.0, 0.0, -1.0)];
    this.CUBEMAP_UP_0 = [new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 0.0, 1.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, -1.0, 0.0)];
  }
  PointLightCamera$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PointLightCamera$Companion_instance = null;
  function PointLightCamera$Companion_getInstance() {
    if (PointLightCamera$Companion_instance === null) {
      new PointLightCamera$Companion();
    }return PointLightCamera$Companion_instance;
  }
  PointLightCamera.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PointLightCamera',
    interfaces: []
  };
  function FloatRange(min, max, easing) {
    FloatRange$Companion_getInstance();
    if (min === void 0)
      min = 0.0;
    if (max === void 0)
      max = 0.0;
    if (easing === void 0)
      easing = math.Easing.linear;
    this.min = min;
    this.max = max;
    this.easing = easing;
  }
  FloatRange.prototype.getValue = function () {
    return this.easing.apply_mx4ult$(Random.Default.nextFloat()) * (this.max - this.min) + this.min;
  };
  function FloatRange$Companion() {
    FloatRange$Companion_instance = this;
    this.ZERO = new FloatRange();
  }
  FloatRange$Companion.prototype.serializer = function () {
    return FloatRange$$serializer_getInstance();
  };
  FloatRange$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FloatRange$Companion_instance = null;
  function FloatRange$Companion_getInstance() {
    if (FloatRange$Companion_instance === null) {
      new FloatRange$Companion();
    }return FloatRange$Companion_instance;
  }
  function FloatRange$$serializer() {
    this.descriptor_jmwp4g$_0 = new SerialClassDescImpl('com.acornui.particle.FloatRange', this);
    this.descriptor.addElement_ivxn3r$('min', true);
    this.descriptor.addElement_ivxn3r$('max', true);
    this.descriptor.addElement_ivxn3r$('easing', true);
    FloatRange$$serializer_instance = this;
  }
  Object.defineProperty(FloatRange$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_jmwp4g$_0;
    }
  });
  FloatRange$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    if (!equals(obj.min, 0.0) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 0))
      output.encodeFloatElement_t7qhdx$(this.descriptor, 0, obj.min);
    if (!equals(obj.max, 0.0) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeFloatElement_t7qhdx$(this.descriptor, 1, obj.max);
    if (!equals(obj.easing, math.Easing.linear) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeSerializableElement_blecud$(this.descriptor, 2, math.InterpolationSerializer, obj.easing);
    output.endStructure_qatsm0$(this.descriptor);
  };
  FloatRange$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeFloatElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeFloatElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 2, math.InterpolationSerializer) : input.updateSerializableElement_ehubvl$(this.descriptor, 2, math.InterpolationSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return FloatRange_init(bitMask0, local0, local1, local2, null);
  };
  FloatRange$$serializer.prototype.childSerializers = function () {
    return [internal.FloatSerializer, internal.FloatSerializer, math.InterpolationSerializer];
  };
  FloatRange$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var FloatRange$$serializer_instance = null;
  function FloatRange$$serializer_getInstance() {
    if (FloatRange$$serializer_instance === null) {
      new FloatRange$$serializer();
    }return FloatRange$$serializer_instance;
  }
  function FloatRange_init(seen1, min, max, easing, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(FloatRange.prototype);
    if ((seen1 & 1) === 0)
      $this.min = 0.0;
    else
      $this.min = min;
    if ((seen1 & 2) === 0)
      $this.max = 0.0;
    else
      $this.max = max;
    if ((seen1 & 4) === 0)
      $this.easing = math.Easing.linear;
    else
      $this.easing = easing;
    return $this;
  }
  FloatRange.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FloatRange',
    interfaces: []
  };
  FloatRange.prototype.component1 = function () {
    return this.min;
  };
  FloatRange.prototype.component2 = function () {
    return this.max;
  };
  FloatRange.prototype.component3 = function () {
    return this.easing;
  };
  FloatRange.prototype.copy_r9tl6s$ = function (min, max, easing) {
    return new FloatRange(min === void 0 ? this.min : min, max === void 0 ? this.max : max, easing === void 0 ? this.easing : easing);
  };
  FloatRange.prototype.toString = function () {
    return 'FloatRange(min=' + Kotlin.toString(this.min) + (', max=' + Kotlin.toString(this.max)) + (', easing=' + Kotlin.toString(this.easing)) + ')';
  };
  FloatRange.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.min) | 0;
    result = result * 31 + Kotlin.hashCode(this.max) | 0;
    result = result * 31 + Kotlin.hashCode(this.easing) | 0;
    return result;
  };
  FloatRange.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.min, other.min) && Kotlin.equals(this.max, other.max) && Kotlin.equals(this.easing, other.easing)))));
  };
  function ParticleEffect(version, emitters) {
    ParticleEffect$Companion_getInstance();
    if (version === void 0)
      version = '0.4.0';
    this.version = version;
    this.emitters = emitters;
  }
  ParticleEffect.prototype.createInstance_mx4ult$ = function (maxParticlesScale) {
    var tmp$;
    var emitterInstances = ArrayList_init_0(this.emitters.size);
    tmp$ = get_lastIndex_0(this.emitters);
    for (var i = 0; i <= tmp$; i++) {
      var emitterInstance = this.emitters.get_za3lpa$(i).createInstance_mx4ult$(maxParticlesScale);
      emitterInstances.add_11rb$(emitterInstance);
    }
    return new ParticleEffectInstance(emitterInstances);
  };
  function ParticleEffect$Companion() {
    ParticleEffect$Companion_instance = this;
  }
  ParticleEffect$Companion.prototype.serializer = function () {
    return ParticleEffect$$serializer_getInstance();
  };
  ParticleEffect$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ParticleEffect$Companion_instance = null;
  function ParticleEffect$Companion_getInstance() {
    if (ParticleEffect$Companion_instance === null) {
      new ParticleEffect$Companion();
    }return ParticleEffect$Companion_instance;
  }
  function ParticleEffect$$serializer() {
    this.descriptor_mmdhoa$_0 = new SerialClassDescImpl('com.acornui.particle.ParticleEffect', this);
    this.descriptor.addElement_ivxn3r$('version', true);
    this.descriptor.addElement_ivxn3r$('emitters', false);
    ParticleEffect$$serializer_instance = this;
  }
  Object.defineProperty(ParticleEffect$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_mmdhoa$_0;
    }
  });
  ParticleEffect$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    if (!equals(obj.version, '0.4.0') || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 0))
      output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.version);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, new ArrayListSerializer(ParticleEmitter$$serializer_getInstance()), obj.emitters);
    output.endStructure_qatsm0$(this.descriptor);
  };
  ParticleEffect$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, new ArrayListSerializer(ParticleEmitter$$serializer_getInstance())) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, new ArrayListSerializer(ParticleEmitter$$serializer_getInstance()), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return ParticleEffect_init(bitMask0, local0, local1, null);
  };
  ParticleEffect$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, new ArrayListSerializer(ParticleEmitter$$serializer_getInstance())];
  };
  ParticleEffect$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var ParticleEffect$$serializer_instance = null;
  function ParticleEffect$$serializer_getInstance() {
    if (ParticleEffect$$serializer_instance === null) {
      new ParticleEffect$$serializer();
    }return ParticleEffect$$serializer_instance;
  }
  function ParticleEffect_init(seen1, version, emitters, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(ParticleEffect.prototype);
    if ((seen1 & 1) === 0)
      $this.version = '0.4.0';
    else
      $this.version = version;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('emitters');
    else
      $this.emitters = emitters;
    return $this;
  }
  ParticleEffect.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParticleEffect',
    interfaces: []
  };
  ParticleEffect.prototype.component1 = function () {
    return this.version;
  };
  ParticleEffect.prototype.component2 = function () {
    return this.emitters;
  };
  ParticleEffect.prototype.copy_w2f7j9$ = function (version, emitters) {
    return new ParticleEffect(version === void 0 ? this.version : version, emitters === void 0 ? this.emitters : emitters);
  };
  ParticleEffect.prototype.toString = function () {
    return 'ParticleEffect(version=' + Kotlin.toString(this.version) + (', emitters=' + Kotlin.toString(this.emitters)) + ')';
  };
  ParticleEffect.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.version) | 0;
    result = result * 31 + Kotlin.hashCode(this.emitters) | 0;
    return result;
  };
  ParticleEffect.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.version, other.version) && Kotlin.equals(this.emitters, other.emitters)))));
  };
  function ParticleEmitter(id, name, enabled, loops, duration, count, emissionRate, particleLifeExpectancy, blendMode, premultipliedAlpha, imageEntries, orientToForwardDirection, propertyTimelines) {
    ParticleEmitter$Companion_getInstance();
    if (id === void 0)
      id = acornui.UidUtil.createUid();
    this.id = id;
    this.name = name;
    this.enabled = enabled;
    this.loops = loops;
    this.duration = duration;
    this.count = count;
    this.emissionRate = emissionRate;
    this.particleLifeExpectancy = particleLifeExpectancy;
    this.blendMode = blendMode;
    this.premultipliedAlpha = premultipliedAlpha;
    this.imageEntries = imageEntries;
    this.orientToForwardDirection = orientToForwardDirection;
    this.propertyTimelines = propertyTimelines;
  }
  ParticleEmitter.prototype.createInstance_mx4ult$ = function (maxParticlesScale) {
    return new ParticleEmitterInstance(this, maxParticlesScale);
  };
  function ParticleEmitter$Companion() {
    ParticleEmitter$Companion_instance = this;
  }
  ParticleEmitter$Companion.prototype.serializer = function () {
    return ParticleEmitter$$serializer_getInstance();
  };
  ParticleEmitter$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ParticleEmitter$Companion_instance = null;
  function ParticleEmitter$Companion_getInstance() {
    if (ParticleEmitter$Companion_instance === null) {
      new ParticleEmitter$Companion();
    }return ParticleEmitter$Companion_instance;
  }
  function ParticleEmitter$$serializer() {
    this.descriptor_oy9tp$_0 = new SerialClassDescImpl('com.acornui.particle.ParticleEmitter', this);
    this.descriptor.addElement_ivxn3r$('id', true);
    this.descriptor.addElement_ivxn3r$('name', false);
    this.descriptor.addElement_ivxn3r$('enabled', false);
    this.descriptor.addElement_ivxn3r$('loops', false);
    this.descriptor.addElement_ivxn3r$('duration', false);
    this.descriptor.addElement_ivxn3r$('count', false);
    this.descriptor.addElement_ivxn3r$('emissionRate', false);
    this.descriptor.addElement_ivxn3r$('particleLifeExpectancy', false);
    this.descriptor.addElement_ivxn3r$('blendMode', false);
    this.descriptor.addElement_ivxn3r$('premultipliedAlpha', false);
    this.descriptor.addElement_ivxn3r$('imageEntries', false);
    this.descriptor.addElement_ivxn3r$('orientToForwardDirection', false);
    this.descriptor.addElement_ivxn3r$('propertyTimelines', false);
    ParticleEmitter$$serializer_instance = this;
  }
  Object.defineProperty(ParticleEmitter$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_oy9tp$_0;
    }
  });
  ParticleEmitter$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    if (!equals(obj.id, acornui.UidUtil.createUid()) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 0))
      output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.id);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.name);
    output.encodeBooleanElement_w1b0nl$(this.descriptor, 2, obj.enabled);
    output.encodeBooleanElement_w1b0nl$(this.descriptor, 3, obj.loops);
    output.encodeSerializableElement_blecud$(this.descriptor, 4, EmitterDuration$$serializer_getInstance(), obj.duration);
    output.encodeIntElement_4wpqag$(this.descriptor, 5, obj.count);
    output.encodeSerializableElement_blecud$(this.descriptor, 6, PropertyTimeline$$serializer_getInstance(), obj.emissionRate);
    output.encodeSerializableElement_blecud$(this.descriptor, 7, PropertyTimeline$$serializer_getInstance(), obj.particleLifeExpectancy);
    output.encodeSerializableElement_blecud$(this.descriptor, 8, graphic.BlendModeSerializer, obj.blendMode);
    output.encodeBooleanElement_w1b0nl$(this.descriptor, 9, obj.premultipliedAlpha);
    output.encodeSerializableElement_blecud$(this.descriptor, 10, new ArrayListSerializer(ParticleImageEntry$$serializer_getInstance()), obj.imageEntries);
    output.encodeBooleanElement_w1b0nl$(this.descriptor, 11, obj.orientToForwardDirection);
    output.encodeSerializableElement_blecud$(this.descriptor, 12, new ArrayListSerializer(PropertyTimeline$$serializer_getInstance()), obj.propertyTimelines);
    output.endStructure_qatsm0$(this.descriptor);
  };
  ParticleEmitter$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10
    , local11
    , local12;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 4, EmitterDuration$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 4, EmitterDuration$$serializer_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = input.decodeIntElement_3zr2iy$(this.descriptor, 5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 6, PropertyTimeline$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 6, PropertyTimeline$$serializer_getInstance(), local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 7, PropertyTimeline$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 7, PropertyTimeline$$serializer_getInstance(), local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 8, graphic.BlendModeSerializer) : input.updateSerializableElement_ehubvl$(this.descriptor, 8, graphic.BlendModeSerializer, local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = (bitMask0 & 1024) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 10, new ArrayListSerializer(ParticleImageEntry$$serializer_getInstance())) : input.updateSerializableElement_ehubvl$(this.descriptor, 10, new ArrayListSerializer(ParticleImageEntry$$serializer_getInstance()), local10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case 11:
          local11 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 11);
          bitMask0 |= 2048;
          if (!readAll)
            break;
        case 12:
          local12 = (bitMask0 & 4096) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 12, new ArrayListSerializer(PropertyTimeline$$serializer_getInstance())) : input.updateSerializableElement_ehubvl$(this.descriptor, 12, new ArrayListSerializer(PropertyTimeline$$serializer_getInstance()), local12);
          bitMask0 |= 4096;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return ParticleEmitter_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, local11, local12, null);
  };
  ParticleEmitter$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, internal.BooleanSerializer, internal.BooleanSerializer, EmitterDuration$$serializer_getInstance(), internal.IntSerializer, PropertyTimeline$$serializer_getInstance(), PropertyTimeline$$serializer_getInstance(), graphic.BlendModeSerializer, internal.BooleanSerializer, new ArrayListSerializer(ParticleImageEntry$$serializer_getInstance()), internal.BooleanSerializer, new ArrayListSerializer(PropertyTimeline$$serializer_getInstance())];
  };
  ParticleEmitter$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var ParticleEmitter$$serializer_instance = null;
  function ParticleEmitter$$serializer_getInstance() {
    if (ParticleEmitter$$serializer_instance === null) {
      new ParticleEmitter$$serializer();
    }return ParticleEmitter$$serializer_instance;
  }
  function ParticleEmitter_init(seen1, id, name, enabled, loops, duration, count, emissionRate, particleLifeExpectancy, blendMode, premultipliedAlpha, imageEntries, orientToForwardDirection, propertyTimelines, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(ParticleEmitter.prototype);
    if ((seen1 & 1) === 0)
      $this.id = acornui.UidUtil.createUid();
    else
      $this.id = id;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('name');
    else
      $this.name = name;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('enabled');
    else
      $this.enabled = enabled;
    if ((seen1 & 8) === 0)
      throw new MissingFieldException('loops');
    else
      $this.loops = loops;
    if ((seen1 & 16) === 0)
      throw new MissingFieldException('duration');
    else
      $this.duration = duration;
    if ((seen1 & 32) === 0)
      throw new MissingFieldException('count');
    else
      $this.count = count;
    if ((seen1 & 64) === 0)
      throw new MissingFieldException('emissionRate');
    else
      $this.emissionRate = emissionRate;
    if ((seen1 & 128) === 0)
      throw new MissingFieldException('particleLifeExpectancy');
    else
      $this.particleLifeExpectancy = particleLifeExpectancy;
    if ((seen1 & 256) === 0)
      throw new MissingFieldException('blendMode');
    else
      $this.blendMode = blendMode;
    if ((seen1 & 512) === 0)
      throw new MissingFieldException('premultipliedAlpha');
    else
      $this.premultipliedAlpha = premultipliedAlpha;
    if ((seen1 & 1024) === 0)
      throw new MissingFieldException('imageEntries');
    else
      $this.imageEntries = imageEntries;
    if ((seen1 & 2048) === 0)
      throw new MissingFieldException('orientToForwardDirection');
    else
      $this.orientToForwardDirection = orientToForwardDirection;
    if ((seen1 & 4096) === 0)
      throw new MissingFieldException('propertyTimelines');
    else
      $this.propertyTimelines = propertyTimelines;
    return $this;
  }
  ParticleEmitter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParticleEmitter',
    interfaces: []
  };
  ParticleEmitter.prototype.component1 = function () {
    return this.id;
  };
  ParticleEmitter.prototype.component2 = function () {
    return this.name;
  };
  ParticleEmitter.prototype.component3 = function () {
    return this.enabled;
  };
  ParticleEmitter.prototype.component4 = function () {
    return this.loops;
  };
  ParticleEmitter.prototype.component5 = function () {
    return this.duration;
  };
  ParticleEmitter.prototype.component6 = function () {
    return this.count;
  };
  ParticleEmitter.prototype.component7 = function () {
    return this.emissionRate;
  };
  ParticleEmitter.prototype.component8 = function () {
    return this.particleLifeExpectancy;
  };
  ParticleEmitter.prototype.component9 = function () {
    return this.blendMode;
  };
  ParticleEmitter.prototype.component10 = function () {
    return this.premultipliedAlpha;
  };
  ParticleEmitter.prototype.component11 = function () {
    return this.imageEntries;
  };
  ParticleEmitter.prototype.component12 = function () {
    return this.orientToForwardDirection;
  };
  ParticleEmitter.prototype.component13 = function () {
    return this.propertyTimelines;
  };
  ParticleEmitter.prototype.copy_9sbpoz$ = function (id, name, enabled, loops, duration, count, emissionRate, particleLifeExpectancy, blendMode, premultipliedAlpha, imageEntries, orientToForwardDirection, propertyTimelines) {
    return new ParticleEmitter(id === void 0 ? this.id : id, name === void 0 ? this.name : name, enabled === void 0 ? this.enabled : enabled, loops === void 0 ? this.loops : loops, duration === void 0 ? this.duration : duration, count === void 0 ? this.count : count, emissionRate === void 0 ? this.emissionRate : emissionRate, particleLifeExpectancy === void 0 ? this.particleLifeExpectancy : particleLifeExpectancy, blendMode === void 0 ? this.blendMode : blendMode, premultipliedAlpha === void 0 ? this.premultipliedAlpha : premultipliedAlpha, imageEntries === void 0 ? this.imageEntries : imageEntries, orientToForwardDirection === void 0 ? this.orientToForwardDirection : orientToForwardDirection, propertyTimelines === void 0 ? this.propertyTimelines : propertyTimelines);
  };
  ParticleEmitter.prototype.toString = function () {
    return 'ParticleEmitter(id=' + Kotlin.toString(this.id) + (', name=' + Kotlin.toString(this.name)) + (', enabled=' + Kotlin.toString(this.enabled)) + (', loops=' + Kotlin.toString(this.loops)) + (', duration=' + Kotlin.toString(this.duration)) + (', count=' + Kotlin.toString(this.count)) + (', emissionRate=' + Kotlin.toString(this.emissionRate)) + (', particleLifeExpectancy=' + Kotlin.toString(this.particleLifeExpectancy)) + (', blendMode=' + Kotlin.toString(this.blendMode)) + (', premultipliedAlpha=' + Kotlin.toString(this.premultipliedAlpha)) + (', imageEntries=' + Kotlin.toString(this.imageEntries)) + (', orientToForwardDirection=' + Kotlin.toString(this.orientToForwardDirection)) + (', propertyTimelines=' + Kotlin.toString(this.propertyTimelines)) + ')';
  };
  ParticleEmitter.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.enabled) | 0;
    result = result * 31 + Kotlin.hashCode(this.loops) | 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.count) | 0;
    result = result * 31 + Kotlin.hashCode(this.emissionRate) | 0;
    result = result * 31 + Kotlin.hashCode(this.particleLifeExpectancy) | 0;
    result = result * 31 + Kotlin.hashCode(this.blendMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.premultipliedAlpha) | 0;
    result = result * 31 + Kotlin.hashCode(this.imageEntries) | 0;
    result = result * 31 + Kotlin.hashCode(this.orientToForwardDirection) | 0;
    result = result * 31 + Kotlin.hashCode(this.propertyTimelines) | 0;
    return result;
  };
  ParticleEmitter.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.enabled, other.enabled) && Kotlin.equals(this.loops, other.loops) && Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.count, other.count) && Kotlin.equals(this.emissionRate, other.emissionRate) && Kotlin.equals(this.particleLifeExpectancy, other.particleLifeExpectancy) && Kotlin.equals(this.blendMode, other.blendMode) && Kotlin.equals(this.premultipliedAlpha, other.premultipliedAlpha) && Kotlin.equals(this.imageEntries, other.imageEntries) && Kotlin.equals(this.orientToForwardDirection, other.orientToForwardDirection) && Kotlin.equals(this.propertyTimelines, other.propertyTimelines)))));
  };
  function EmitterDuration(duration, delayBefore, delayAfter) {
    EmitterDuration$Companion_getInstance();
    this.duration = duration;
    this.delayBefore = delayBefore;
    this.delayAfter = delayAfter;
  }
  function EmitterDuration$Companion() {
    EmitterDuration$Companion_instance = this;
  }
  EmitterDuration$Companion.prototype.serializer = function () {
    return EmitterDuration$$serializer_getInstance();
  };
  EmitterDuration$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EmitterDuration$Companion_instance = null;
  function EmitterDuration$Companion_getInstance() {
    if (EmitterDuration$Companion_instance === null) {
      new EmitterDuration$Companion();
    }return EmitterDuration$Companion_instance;
  }
  function EmitterDuration$$serializer() {
    this.descriptor_l739r7$_0 = new SerialClassDescImpl('com.acornui.particle.EmitterDuration', this);
    this.descriptor.addElement_ivxn3r$('duration', false);
    this.descriptor.addElement_ivxn3r$('delayBefore', false);
    this.descriptor.addElement_ivxn3r$('delayAfter', false);
    EmitterDuration$$serializer_instance = this;
  }
  Object.defineProperty(EmitterDuration$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_l739r7$_0;
    }
  });
  EmitterDuration$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, FloatRange$$serializer_getInstance(), obj.duration);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, FloatRange$$serializer_getInstance(), obj.delayBefore);
    output.encodeSerializableElement_blecud$(this.descriptor, 2, FloatRange$$serializer_getInstance(), obj.delayAfter);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EmitterDuration$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, FloatRange$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, FloatRange$$serializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, FloatRange$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, FloatRange$$serializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 2, FloatRange$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 2, FloatRange$$serializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EmitterDuration_init(bitMask0, local0, local1, local2, null);
  };
  EmitterDuration$$serializer.prototype.childSerializers = function () {
    return [FloatRange$$serializer_getInstance(), FloatRange$$serializer_getInstance(), FloatRange$$serializer_getInstance()];
  };
  EmitterDuration$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EmitterDuration$$serializer_instance = null;
  function EmitterDuration$$serializer_getInstance() {
    if (EmitterDuration$$serializer_instance === null) {
      new EmitterDuration$$serializer();
    }return EmitterDuration$$serializer_instance;
  }
  function EmitterDuration_init(seen1, duration, delayBefore, delayAfter, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EmitterDuration.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('duration');
    else
      $this.duration = duration;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('delayBefore');
    else
      $this.delayBefore = delayBefore;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('delayAfter');
    else
      $this.delayAfter = delayAfter;
    return $this;
  }
  EmitterDuration.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EmitterDuration',
    interfaces: []
  };
  EmitterDuration.prototype.component1 = function () {
    return this.duration;
  };
  EmitterDuration.prototype.component2 = function () {
    return this.delayBefore;
  };
  EmitterDuration.prototype.component3 = function () {
    return this.delayAfter;
  };
  EmitterDuration.prototype.copy_b8aqa1$ = function (duration, delayBefore, delayAfter) {
    return new EmitterDuration(duration === void 0 ? this.duration : duration, delayBefore === void 0 ? this.delayBefore : delayBefore, delayAfter === void 0 ? this.delayAfter : delayAfter);
  };
  EmitterDuration.prototype.toString = function () {
    return 'EmitterDuration(duration=' + Kotlin.toString(this.duration) + (', delayBefore=' + Kotlin.toString(this.delayBefore)) + (', delayAfter=' + Kotlin.toString(this.delayAfter)) + ')';
  };
  EmitterDuration.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.delayBefore) | 0;
    result = result * 31 + Kotlin.hashCode(this.delayAfter) | 0;
    return result;
  };
  EmitterDuration.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.delayBefore, other.delayBefore) && Kotlin.equals(this.delayAfter, other.delayAfter)))));
  };
  function ParticleImageEntry(time, path) {
    ParticleImageEntry$Companion_getInstance();
    this.time = time;
    this.path = path;
  }
  function ParticleImageEntry$Companion() {
    ParticleImageEntry$Companion_instance = this;
  }
  ParticleImageEntry$Companion.prototype.serializer = function () {
    return ParticleImageEntry$$serializer_getInstance();
  };
  ParticleImageEntry$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ParticleImageEntry$Companion_instance = null;
  function ParticleImageEntry$Companion_getInstance() {
    if (ParticleImageEntry$Companion_instance === null) {
      new ParticleImageEntry$Companion();
    }return ParticleImageEntry$Companion_instance;
  }
  function ParticleImageEntry$$serializer() {
    this.descriptor_paoivg$_0 = new SerialClassDescImpl('com.acornui.particle.ParticleImageEntry', this);
    this.descriptor.addElement_ivxn3r$('time', false);
    this.descriptor.addElement_ivxn3r$('path', false);
    ParticleImageEntry$$serializer_instance = this;
  }
  Object.defineProperty(ParticleImageEntry$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_paoivg$_0;
    }
  });
  ParticleImageEntry$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeFloatElement_t7qhdx$(this.descriptor, 0, obj.time);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.path);
    output.endStructure_qatsm0$(this.descriptor);
  };
  ParticleImageEntry$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeFloatElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return ParticleImageEntry_init(bitMask0, local0, local1, null);
  };
  ParticleImageEntry$$serializer.prototype.childSerializers = function () {
    return [internal.FloatSerializer, internal.StringSerializer];
  };
  ParticleImageEntry$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var ParticleImageEntry$$serializer_instance = null;
  function ParticleImageEntry$$serializer_getInstance() {
    if (ParticleImageEntry$$serializer_instance === null) {
      new ParticleImageEntry$$serializer();
    }return ParticleImageEntry$$serializer_instance;
  }
  function ParticleImageEntry_init(seen1, time, path, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(ParticleImageEntry.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('time');
    else
      $this.time = time;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('path');
    else
      $this.path = path;
    return $this;
  }
  ParticleImageEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParticleImageEntry',
    interfaces: []
  };
  ParticleImageEntry.prototype.component1 = function () {
    return this.time;
  };
  ParticleImageEntry.prototype.component2 = function () {
    return this.path;
  };
  ParticleImageEntry.prototype.copy_1isgrl$ = function (time, path) {
    return new ParticleImageEntry(time === void 0 ? this.time : time, path === void 0 ? this.path : path);
  };
  ParticleImageEntry.prototype.toString = function () {
    return 'ParticleImageEntry(time=' + Kotlin.toString(this.time) + (', path=' + Kotlin.toString(this.path)) + ')';
  };
  ParticleImageEntry.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.time) | 0;
    result = result * 31 + Kotlin.hashCode(this.path) | 0;
    return result;
  };
  ParticleImageEntry.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.time, other.time) && Kotlin.equals(this.path, other.path)))));
  };
  function ParticleEffectComponent(owner) {
    UiComponentImpl.call(this, owner);
    this.autoPlay = true;
    this.interactivityMode = InteractivityMode.NONE;
    onTick(this, getCallableRef('tick', function ($receiver, dT) {
      return $receiver.tick_0(dT), Unit;
    }.bind(null, this)));
    this._effect_0 = null;
  }
  ParticleEffectComponent.prototype.tick_0 = function (dT) {
    var tmp$;
    (tmp$ = this._effect_0) != null ? (tmp$.update_mx4ult$(dT), Unit) : null;
  };
  function Coroutine$ParticleEffectComponent$load$lambda(this$ParticleEffectComponent_0, closure$pDataPath_0, closure$atlasPath_0, closure$maxParticlesScale_0, closure$disposeOld_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$ParticleEffectComponent = this$ParticleEffectComponent_0;
    this.local$closure$pDataPath = closure$pDataPath_0;
    this.local$closure$atlasPath = closure$atlasPath_0;
    this.local$closure$maxParticlesScale = closure$maxParticlesScale_0;
    this.local$closure$disposeOld = closure$disposeOld_0;
    this.local$oldEffect = void 0;
  }
  Coroutine$ParticleEffectComponent$load$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ParticleEffectComponent$load$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ParticleEffectComponent$load$lambda.prototype.constructor = Coroutine$ParticleEffectComponent$load$lambda;
  Coroutine$ParticleEffectComponent$load$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$oldEffect = this.local$this$ParticleEffectComponent._effect_0;
            this.state_0 = 2;
            this.result_0 = loadParticleEffect(this.local$this$ParticleEffectComponent, this.local$closure$pDataPath, this.local$closure$atlasPath, void 0, this.local$closure$maxParticlesScale, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.local$this$ParticleEffectComponent.effect_0 = this.result_0;
            if (this.local$closure$disposeOld)
              this.local$oldEffect != null ? (this.local$oldEffect.dispose(), Unit) : null;
            return ensureNotNull(this.local$this$ParticleEffectComponent.effect_0);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ParticleEffectComponent$load$lambda(this$ParticleEffectComponent_0, closure$pDataPath_0, closure$atlasPath_0, closure$maxParticlesScale_0, closure$disposeOld_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$ParticleEffectComponent$load$lambda(this$ParticleEffectComponent_0, closure$pDataPath_0, closure$atlasPath_0, closure$maxParticlesScale_0, closure$disposeOld_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ParticleEffectComponent.prototype.load_uh5gm4$ = function (pDataPath, atlasPath, disposeOld, maxParticlesScale) {
    if (disposeOld === void 0)
      disposeOld = true;
    if (maxParticlesScale === void 0)
      maxParticlesScale = 1.0;
    return async(this, void 0, void 0, ParticleEffectComponent$load$lambda(this, pDataPath, atlasPath, maxParticlesScale, disposeOld));
  };
  ParticleEffectComponent.prototype.onActivated = function () {
    var tmp$;
    UiComponentImpl.prototype.onActivated.call(this);
    (tmp$ = this._effect_0) != null ? (tmp$.refInc(), Unit) : null;
  };
  ParticleEffectComponent.prototype.onDeactivated = function () {
    var tmp$;
    UiComponentImpl.prototype.onDeactivated.call(this);
    (tmp$ = this._effect_0) != null ? (tmp$.refDec(), Unit) : null;
  };
  Object.defineProperty(ParticleEffectComponent.prototype, 'effect_0', {
    get: function () {
      return this._effect_0;
    },
    set: function (value) {
      var tmp$;
      var oldValue = this._effect_0;
      if (equals(oldValue, value))
        return;
      this._effect_0 = value;
      if (!this.autoPlay)
        (tmp$ = value != null ? value.effectInstance : null) != null ? (tmp$.stop_6taknv$(false), Unit) : null;
      if (this.isActive) {
        value != null ? (value.refInc(), Unit) : null;
        oldValue != null ? (oldValue.refDec(), Unit) : null;
      }}
  });
  ParticleEffectComponent.prototype.effect_9lnkgp$ = function (value) {
    this.effect_0 = value;
  };
  Object.defineProperty(ParticleEffectComponent.prototype, 'effectInstance', {
    get: function () {
      var tmp$;
      return (tmp$ = this._effect_0) != null ? tmp$.effectInstance : null;
    }
  });
  ParticleEffectComponent.prototype.draw = function () {
    var tmp$;
    tmp$ = this._effect_0;
    if (tmp$ == null) {
      return;
    }var effect = tmp$;
    effect.render_d6uf88$(this.transformGlobal, this.colorTintGlobal);
  };
  ParticleEffectComponent.prototype.dispose = function () {
    this.effect_0 = null;
    UiComponentImpl.prototype.dispose.call(this);
  };
  ParticleEffectComponent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParticleEffectComponent',
    interfaces: [UiComponentImpl]
  };
  function LoadedParticleEffect(frameDriver, effectInstance, renderers, cacheSet) {
    this.frameDriver_jjm6ul$_0 = frameDriver;
    this.effectInstance = effectInstance;
    this.renderers_0 = renderers;
    this.cacheSet_0 = cacheSet;
    this.emitterInstances_0 = this.effectInstance.emitterInstances;
  }
  Object.defineProperty(LoadedParticleEffect.prototype, 'frameDriver', {
    get: function () {
      return this.frameDriver_jjm6ul$_0;
    }
  });
  LoadedParticleEffect.prototype.refInc = function () {
    var tmp$;
    tmp$ = get_lastIndex_0(this.renderers_0);
    for (var i = 0; i <= tmp$; i++) {
      this.renderers_0.get_za3lpa$(i).refInc();
    }
  };
  LoadedParticleEffect.prototype.refDec = function () {
    var tmp$;
    tmp$ = get_lastIndex_0(this.renderers_0);
    for (var i = 0; i <= tmp$; i++) {
      this.renderers_0.get_za3lpa$(i).refDec();
    }
  };
  LoadedParticleEffect.prototype.update_mx4ult$ = function (dT) {
    var tmp$;
    tmp$ = get_lastIndex_0(this.emitterInstances_0);
    for (var i = 0; i <= tmp$; i++) {
      this.emitterInstances_0.get_za3lpa$(i).update_mx4ult$(dT);
    }
  };
  LoadedParticleEffect.prototype.dispose = function () {
    this.cacheSet_0.dispose();
  };
  LoadedParticleEffect.prototype.render_d6uf88$ = function (transform, tint) {
    var tmp$;
    tmp$ = get_lastIndex_0(this.renderers_0);
    for (var i = 0; i <= tmp$; i++) {
      this.renderers_0.get_za3lpa$(i).render_d6uf88$(transform, tint);
    }
  };
  LoadedParticleEffect.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LoadedParticleEffect',
    interfaces: [Disposable, Updatable]
  };
  function Coroutine$loadParticleEffect($receiver_0, pDataPath_0, atlasPath_0, cacheSet_0, maxParticlesScale_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$tmp$ = void 0;
    this.local$tmp$_0 = void 0;
    this.local$tmp$_1 = void 0;
    this.local$$receiver = $receiver_0;
    this.local$pDataPath = pDataPath_0;
    this.local$atlasPath = atlasPath_0;
    this.local$cacheSet = cacheSet_0;
    this.local$maxParticlesScale = maxParticlesScale_0;
  }
  Coroutine$loadParticleEffect.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$loadParticleEffect.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$loadParticleEffect.prototype.constructor = Coroutine$loadParticleEffect;
  Coroutine$loadParticleEffect.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$cacheSet === void 0)
              this.local$cacheSet = cacheSet(this.local$$receiver);
            if (this.local$maxParticlesScale === void 0)
              this.local$maxParticlesScale = 1.0;
            loadAndCacheJsonAsync(this.local$$receiver, TextureAtlasData.Companion.serializer(), this.local$atlasPath, this.local$cacheSet);
            if (endsWith(this.local$pDataPath, 'bin', true)) {
              this.local$tmp$ = ParticleEffect$Companion_getInstance().serializer();
              this.state_0 = 3;
              this.result_0 = loadBinary(this.local$$receiver, this.local$pDataPath, void 0, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.local$tmp$_0 = ParticleEffect$Companion_getInstance().serializer();
              this.state_0 = 2;
              this.result_0 = loadText(this.local$$receiver, this.local$pDataPath, void 0, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.local$tmp$_1 = jsonParse(this.local$tmp$_0, this.result_0);
            this.state_0 = 4;
            continue;
          case 3:
            this.local$tmp$_1 = binaryParse(this.local$tmp$, this.result_0);
            this.state_0 = 4;
            continue;
          case 4:
            var particleEffect = this.local$tmp$_1;
            this.state_0 = 5;
            this.result_0 = loadParticleEffect_0(this.local$$receiver, particleEffect, this.local$atlasPath, this.local$cacheSet, this.local$maxParticlesScale, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 5:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function loadParticleEffect($receiver_0, pDataPath_0, atlasPath_0, cacheSet_0, maxParticlesScale_0, continuation_0, suspended) {
    var instance = new Coroutine$loadParticleEffect($receiver_0, pDataPath_0, atlasPath_0, cacheSet_0, maxParticlesScale_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$loadParticleEffect$lambda(closure$atlasData_0, closure$atlasPath_0, closure$cacheSet_0, this$loadParticleEffect_0, closure$gl_0, emitter_0, imageEntry_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$atlasData = closure$atlasData_0;
    this.local$closure$atlasPath = closure$atlasPath_0;
    this.local$closure$cacheSet = closure$cacheSet_0;
    this.local$this$loadParticleEffect = this$loadParticleEffect_0;
    this.local$closure$gl = closure$gl_0;
    this.local$region = void 0;
    this.local$emitter = emitter_0;
    this.local$imageEntry = imageEntry_0;
  }
  Coroutine$loadParticleEffect$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$loadParticleEffect$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$loadParticleEffect$lambda.prototype.constructor = Coroutine$loadParticleEffect$lambda;
  Coroutine$loadParticleEffect$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            tmp$ = this.local$closure$atlasData.findRegion_61zpoe$(this.local$imageEntry.path);
            if (tmp$ == null) {
              throw Exception_init('Could not find ' + '"' + this.local$imageEntry.path + '"' + ' in the atlas ' + this.local$closure$atlasPath);
            }
            var page = tmp$.component1();
            this.local$page = tmp$.component1(), this.local$region = tmp$.component2();
            this.state_0 = 2;
            this.result_0 = loadAndCacheAtlasPage(this.local$this$loadParticleEffect, this.local$closure$atlasPath, page, this.local$closure$cacheSet, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var texture = this.result_0;
            var sprite = new Sprite(this.local$closure$gl);
            sprite.blendMode = this.local$emitter.blendMode;
            sprite.premultipliedAlpha = this.local$emitter.premultipliedAlpha;
            sprite.texture = texture;
            sprite.region_vyn4n2$(this.local$region.bounds, this.local$region.isRotated);
            return sprite;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function loadParticleEffect$lambda(closure$atlasData_0, closure$atlasPath_0, closure$cacheSet_0, this$loadParticleEffect_0, closure$gl_0) {
    return function (emitter_0, imageEntry_0, continuation_0, suspended) {
      var instance = new Coroutine$loadParticleEffect$lambda(closure$atlasData_0, closure$atlasPath_0, closure$cacheSet_0, this$loadParticleEffect_0, closure$gl_0, emitter_0, imageEntry_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$loadParticleEffect_0($receiver_0, particleEffect_0, atlasPath_0, cacheSet_0, maxParticlesScale_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$particleEffect = particleEffect_0;
    this.local$atlasPath = atlasPath_0;
    this.local$cacheSet = cacheSet_0;
    this.local$maxParticlesScale = maxParticlesScale_0;
  }
  Coroutine$loadParticleEffect_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$loadParticleEffect_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$loadParticleEffect_0.prototype.constructor = Coroutine$loadParticleEffect_0;
  Coroutine$loadParticleEffect_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$cacheSet === void 0)
              this.local$cacheSet = cacheSet(this.local$$receiver);
            if (this.local$maxParticlesScale === void 0)
              this.local$maxParticlesScale = 1.0;
            this.state_0 = 2;
            this.result_0 = loadAndCacheJson(this.local$$receiver, TextureAtlasData.Companion.serializer(), this.local$atlasPath, this.local$cacheSet, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var atlasData = this.result_0;
            var gl = this.local$$receiver.inject_af3212$(CachedGl20.Companion);
            var spriteResolver = loadParticleEffect$lambda(atlasData, this.local$atlasPath, this.local$cacheSet, this.local$$receiver, gl);
            this.state_0 = 3;
            this.result_0 = loadParticleEffect_1(this.local$$receiver, this.local$particleEffect, this.local$cacheSet, spriteResolver, this.local$maxParticlesScale, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function loadParticleEffect_0($receiver_0, particleEffect_0, atlasPath_0, cacheSet_0, maxParticlesScale_0, continuation_0, suspended) {
    var instance = new Coroutine$loadParticleEffect_0($receiver_0, particleEffect_0, atlasPath_0, cacheSet_0, maxParticlesScale_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$loadParticleEffect_1($receiver_0, particleEffect_0, cacheSet_0, spriteResolver_0, maxParticlesScale_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$tmp$ = void 0;
    this.local$tmp$_0 = void 0;
    this.local$emitterRenderers = void 0;
    this.local$effectInstance = void 0;
    this.local$emitterInstance = void 0;
    this.local$emitter = void 0;
    this.local$sprites = void 0;
    this.local$i = void 0;
    this.local$$receiver = $receiver_0;
    this.local$particleEffect = particleEffect_0;
    this.local$cacheSet = cacheSet_0;
    this.local$spriteResolver = spriteResolver_0;
    this.local$maxParticlesScale = maxParticlesScale_0;
  }
  Coroutine$loadParticleEffect_1.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$loadParticleEffect_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$loadParticleEffect_1.prototype.constructor = Coroutine$loadParticleEffect_1;
  Coroutine$loadParticleEffect_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$cacheSet === void 0)
              this.local$cacheSet = cacheSet(this.local$$receiver);
            if (this.local$maxParticlesScale === void 0)
              this.local$maxParticlesScale = 1.0;
            this.local$emitterRenderers = ArrayList_init_0(this.local$particleEffect.emitters.size);
            this.local$effectInstance = this.local$particleEffect.createInstance_mx4ult$(this.local$maxParticlesScale);
            this.local$tmp$ = this.local$effectInstance.emitterInstances.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 7;
              continue;
            }
            this.local$emitterInstance = this.local$tmp$.next();
            this.local$emitter = this.local$emitterInstance.emitter;
            this.local$sprites = ArrayList_init_0(this.local$emitter.imageEntries.size);
            this.local$tmp$_0 = get_lastIndex_0(this.local$emitter.imageEntries);
            this.local$i = 0;
            this.state_0 = 3;
            continue;
          case 3:
            if (this.local$i > this.local$tmp$_0) {
              this.state_0 = 6;
              continue;
            }
            this.state_0 = 4;
            this.result_0 = this.local$spriteResolver(this.local$emitter, this.local$emitter.imageEntries.get_za3lpa$(this.local$i), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            var sprite = this.result_0;
            this.local$sprites.add_11rb$(sprite);
            this.state_0 = 5;
            continue;
          case 5:
            this.local$i++;
            this.state_0 = 3;
            continue;
          case 6:
            this.local$emitterRenderers.add_11rb$(new ParticleEmitterRenderer2d(this.local$emitterInstance, this.local$sprites));
            this.state_0 = 2;
            continue;
          case 7:
            return new LoadedParticleEffect(this.local$$receiver.inject_af3212$(FrameDriverRo.Companion), this.local$effectInstance, this.local$emitterRenderers, this.local$cacheSet);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function loadParticleEffect_1($receiver_0, particleEffect_0, cacheSet_0, spriteResolver_0, maxParticlesScale_0, continuation_0, suspended) {
    var instance = new Coroutine$loadParticleEffect_1($receiver_0, particleEffect_0, cacheSet_0, spriteResolver_0, maxParticlesScale_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function ParticleEmitterRenderer() {
  }
  ParticleEmitterRenderer.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ParticleEmitterRenderer',
    interfaces: []
  };
  function particleEffectComponent$lambda($receiver) {
    return Unit;
  }
  function particleEffectComponent($receiver, init) {
    if (init === void 0)
      init = particleEffectComponent$lambda;
    var p = new ParticleEffectComponent($receiver);
    init(p);
    return p;
  }
  function particleEffectComponent$lambda_0($receiver) {
    return Unit;
  }
  function particleEffectComponent_0($receiver, pDataPath, atlasPath, maxParticlesScale, init) {
    if (maxParticlesScale === void 0)
      maxParticlesScale = 1.0;
    if (init === void 0)
      init = particleEffectComponent$lambda_0;
    var p = new ParticleEffectComponent($receiver);
    p.load_uh5gm4$(pDataPath, atlasPath, void 0, maxParticlesScale);
    init(p);
    return p;
  }
  function ParticleEffectInstance(emitterInstances) {
    this.emitterInstances = emitterInstances;
    this._position_0 = new Vector3();
  }
  Object.defineProperty(ParticleEffectInstance.prototype, 'position', {
    get: function () {
      return this._position_0;
    }
  });
  ParticleEffectInstance.prototype.setPosition_y2kzbl$ = function (x, y, z) {
    this.translatePosition_y2kzbl$(x - this._position_0.x, y - this._position_0.y, z - this._position_0.z);
  };
  ParticleEffectInstance.prototype.translatePosition_y2kzbl$ = function (xD, yD, zD) {
    var tmp$;
    tmp$ = get_lastIndex_0(this.emitterInstances);
    for (var i = 0; i <= tmp$; i++) {
      this.emitterInstances.get_za3lpa$(i).position.add_y2kzbl$(xD, yD, zD);
    }
  };
  ParticleEffectInstance.prototype.rewind = function () {
    var tmp$;
    tmp$ = get_lastIndex_0(this.emitterInstances);
    for (var i = 0; i <= tmp$; i++) {
      this.emitterInstances.get_za3lpa$(i).rewind();
    }
  };
  ParticleEffectInstance.prototype.stop_6taknv$ = function (allowCompletion) {
    var tmp$;
    tmp$ = get_lastIndex_0(this.emitterInstances);
    for (var i = 0; i <= tmp$; i++) {
      this.emitterInstances.get_za3lpa$(i).stop_6taknv$(allowCompletion);
    }
  };
  ParticleEffectInstance.prototype.reset = function () {
    var tmp$;
    tmp$ = get_lastIndex_0(this.emitterInstances);
    for (var i = 0; i <= tmp$; i++) {
      this.emitterInstances.get_za3lpa$(i).reset();
    }
  };
  ParticleEffectInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParticleEffectInstance',
    interfaces: []
  };
  function ParticleEmitterInstance(emitter, maxParticlesScale) {
    this.emitter = emitter;
    this.maxParticlesScale = maxParticlesScale;
    this.position = new Vector3();
    this.particles = null;
    var x = this.emitter.count * this.maxParticlesScale;
    this.count_0 = numberToInt(Math_0.ceil(x));
    this._activeCount_0 = 0;
    this._delayBefore_0 = 0.0;
    this._delayAfter_0 = 0.0;
    this._currentTime_0 = 0.0;
    this._duration_0 = 0.0;
    this._durationInv_0 = 0.0;
    this.endTime_0 = 0.0;
    this._isComplete_0 = false;
    this.loops_0 = this.emitter.loops;
    this.accumulator_0 = 0.0;
    this.emissionRateValue_0 = new PropertyValue();
    this.lifeExpectancyValue_0 = new PropertyValue();
    var size = this.count_0;
    var tmp$;
    var a = ArrayList_init_0(size);
    tmp$ = size - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      var tmp$_0 = a.add_11rb$;
      var $receiver = this.emitter.propertyTimelines;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
      var tmp$_1;
      tmp$_1 = $receiver.iterator();
      while (tmp$_1.hasNext()) {
        var item = tmp$_1.next();
        destination.add_11rb$(timelineInstance(item));
      }
      tmp$_0.call(a, new Particle(destination));
    }
    this.particles = a;
    this.rewind();
  }
  Object.defineProperty(ParticleEmitterInstance.prototype, 'activeCount', {
    get: function () {
      return this._activeCount_0;
    }
  });
  Object.defineProperty(ParticleEmitterInstance.prototype, 'delayBefore', {
    get: function () {
      return this._delayBefore_0;
    }
  });
  Object.defineProperty(ParticleEmitterInstance.prototype, 'delayAfter', {
    get: function () {
      return this._delayAfter_0;
    }
  });
  Object.defineProperty(ParticleEmitterInstance.prototype, 'currentTime', {
    get: function () {
      return this._currentTime_0;
    }
  });
  Object.defineProperty(ParticleEmitterInstance.prototype, 'duration', {
    get: function () {
      return this._duration_0;
    }
  });
  Object.defineProperty(ParticleEmitterInstance.prototype, 'totalTime', {
    get: function () {
      return this._delayBefore_0 + this._duration_0 + this._delayAfter_0;
    }
  });
  Object.defineProperty(ParticleEmitterInstance.prototype, 'progress', {
    get: function () {
      var tmp$ = this._currentTime_0 + this._delayBefore_0;
      var b = this.totalTime;
      return tmp$ / Math_0.max(0.001, b);
    }
  });
  Object.defineProperty(ParticleEmitterInstance.prototype, 'isComplete', {
    get: function () {
      return this._isComplete_0;
    }
  });
  ParticleEmitterInstance.prototype.update_mx4ult$ = function (tickTime) {
    var tmp$, tmp$_0;
    if (this._isComplete_0)
      return;
    if (!this.emitter.enabled)
      return;
    this._currentTime_0 += tickTime;
    if (this._currentTime_0 >= this.endTime_0) {
      if (this.loops_0) {
        var remainder = this._currentTime_0 - this.endTime_0;
        this.rewind();
        this._currentTime_0 += remainder;
      } else if (this._activeCount_0 === 0) {
        this._isComplete_0 = true;
        this.accumulator_0 = 0.0;
        return;
      }}var emitterAlpha = this._currentTime_0 * this._durationInv_0;
    this.emissionRateValue_0.setCurrent_yzjwcb$(this.emitter.emissionRate, emitterAlpha);
    this.lifeExpectancyValue_0.setCurrent_yzjwcb$(this.emitter.particleLifeExpectancy, emitterAlpha);
    if (this._currentTime_0 < this._duration_0 && this._currentTime_0 > 0.0) {
      this.accumulator_0 += this.emissionRateValue_0.current * this.maxParticlesScale * tickTime;
      if (this.accumulator_0 > 1.0) {
        tmp$ = get_lastIndex_0(this.particles);
        for (var i = 0; i <= tmp$; i++) {
          var particle = this.particles.get_za3lpa$(i);
          if (!particle.active)
            this.activateParticle_0(particle);
          if (this._activeCount_0 >= this.count_0)
            this.accumulator_0 = 0.0;
          if (this.accumulator_0 < 1.0)
            break;
        }
      }}var clamp_73gzaq$result;
    clamp_73gzaq$break: do {
      if (Kotlin.compareTo(emitterAlpha, 0.0) <= 0) {
        clamp_73gzaq$result = 0.0;
        break clamp_73gzaq$break;
      }if (Kotlin.compareTo(emitterAlpha, 1.0) >= 0) {
        clamp_73gzaq$result = 1.0;
        break clamp_73gzaq$break;
      }clamp_73gzaq$result = emitterAlpha;
    }
     while (false);
    var alphaClamped = clamp_73gzaq$result;
    tmp$_0 = get_lastIndex_0(this.particles);
    for (var i_0 = 0; i_0 <= tmp$_0; i_0++) {
      var particle_0 = this.particles.get_za3lpa$(i_0);
      if (particle_0.active) {
        particle_0.update_dleff0$(tickTime, alphaClamped);
        if (particle_0.life > particle_0.lifeExpectancy) {
          particle_0.active = false;
          this._activeCount_0 = this._activeCount_0 - 1 | 0;
        }}}
  };
  ParticleEmitterInstance.prototype.activateParticle_0 = function (particle) {
    particle.clear();
    particle.active = true;
    particle.lifeExpectancy = this.lifeExpectancyValue_0.current;
    this._activeCount_0 = this._activeCount_0 + 1 | 0;
    this.accumulator_0 = this.accumulator_0 - 1;
  };
  ParticleEmitterInstance.prototype.clearParticles = function () {
    var tmp$;
    tmp$ = get_lastIndex_0(this.particles);
    for (var i = 0; i <= tmp$; i++) {
      this.particles.get_za3lpa$(i).active = false;
    }
    this._activeCount_0 = 0;
    this.accumulator_0 = 0.0;
  };
  ParticleEmitterInstance.prototype.reset = function () {
    this.clearParticles();
    this.rewind();
  };
  ParticleEmitterInstance.prototype.stop_6taknv$ = function (allowCompletion) {
    this.loops_0 = false;
    this._currentTime_0 = this.endTime_0;
    if (!allowCompletion) {
      this.clearParticles();
      this._isComplete_0 = true;
    }};
  ParticleEmitterInstance.prototype.rewind = function () {
    this._isComplete_0 = false;
    this.loops_0 = this.emitter.loops;
    this._delayBefore_0 = this.emitter.duration.delayBefore.getValue();
    this._delayAfter_0 = this.emitter.duration.delayAfter.getValue();
    this._currentTime_0 = -this._delayBefore_0;
    this._duration_0 = this.emitter.duration.duration.getValue();
    this._durationInv_0 = 1.0 / this._duration_0;
    this.endTime_0 = this._duration_0 + this._delayAfter_0;
    this.emissionRateValue_0.reset_vumshs$(this.emitter.emissionRate);
    this.lifeExpectancyValue_0.reset_vumshs$(this.emitter.particleLifeExpectancy);
  };
  ParticleEmitterInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParticleEmitterInstance',
    interfaces: []
  };
  function Particle(timelineInstances) {
    this.timelineInstances = timelineInstances;
    this.active = false;
    this.life = 0.0;
    this._lifeExpectancy_0 = 0.0;
    this._lifeExpectancyInv_0 = 0.0;
    this.position = new Vector3();
    this.velocity = new Vector3();
    this.scale = new Vector3(1.0, 1.0, 1.0);
    this.rotation = new Vector3();
    this.rotationalVelocity = new Vector3();
    this.forwardDirection = new Vector3();
    this.forwardDirectionVelocity = new Vector3();
    this.forwardVelocity = 0.0;
    this.colorTint = Color.Companion.WHITE.copy();
    this.origin = new Vector3(0.5, 0.5, 0.5);
    this.imageIndex = 0;
  }
  Object.defineProperty(Particle.prototype, 'lifeExpectancy', {
    get: function () {
      return this._lifeExpectancy_0;
    },
    set: function (value) {
      this._lifeExpectancy_0 = value;
      this._lifeExpectancyInv_0 = 1.0 / value;
    }
  });
  Particle.prototype.update_dleff0$ = function (tickTime, emitterAlphaClamped) {
    var tmp$;
    this.life += tickTime;
    var alpha = this.life * this._lifeExpectancyInv_0;
    var clamp_73gzaq$result;
    clamp_73gzaq$break: do {
      if (Kotlin.compareTo(alpha, 0.0) <= 0) {
        clamp_73gzaq$result = 0.0;
        break clamp_73gzaq$break;
      }if (Kotlin.compareTo(alpha, 1.0) >= 0) {
        clamp_73gzaq$result = 1.0;
        break clamp_73gzaq$break;
      }clamp_73gzaq$result = alpha;
    }
     while (false);
    var alphaClamped = clamp_73gzaq$result;
    tmp$ = get_lastIndex_0(this.timelineInstances);
    for (var i = 0; i <= tmp$; i++) {
      this.timelineInstances.get_za3lpa$(i).apply_ivhixc$(this, alphaClamped, emitterAlphaClamped);
    }
    this.position.add_1fv2cb$(this.velocity);
    this.rotation.add_1fv2cb$(this.rotationalVelocity);
    this.forwardDirection.add_1fv2cb$(this.forwardDirectionVelocity);
    if (this.forwardVelocity !== 0.0) {
      if (this.forwardDirection.y === 0.0 && this.forwardDirection.x === 0.0)
        if (this.forwardDirection.z !== 0.0) {
          var theta = this.forwardDirection.z;
          this.position.add_y2kzbl$(Math_0.cos(theta) * this.forwardVelocity, Math_0.sin(theta) * this.forwardVelocity, 0.0);
        }}};
  Particle.prototype.clear = function () {
    var tmp$;
    this.active = false;
    this.life = 0.0;
    this._lifeExpectancy_0 = 0.0;
    this._lifeExpectancyInv_0 = 0.0;
    this.position.clear();
    this.velocity.clear();
    this.scale.set_y2kzbl$(1.0, 1.0, 1.0);
    this.rotation.clear();
    this.rotationalVelocity.clear();
    this.forwardDirection.clear();
    this.forwardDirectionVelocity.clear();
    this.forwardVelocity = 0.0;
    this.colorTint.set_8suw10$(Color.Companion.WHITE);
    this.origin.set_y2kzbl$(0.5, 0.5, 0.5);
    this.imageIndex = 0;
    tmp$ = get_lastIndex_0(this.timelineInstances);
    for (var i = 0; i <= tmp$; i++) {
      this.timelineInstances.get_za3lpa$(i).reset_hvu7lc$(this);
    }
  };
  Particle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Particle',
    interfaces: [Clearable]
  };
  function TimelineInstance() {
  }
  TimelineInstance.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TimelineInstance',
    interfaces: []
  };
  function timelineInstance(timeline) {
    return equals(timeline.property, 'color') ? new ColorTimelineInstance(timeline) : new FloatTimelineInstance(timeline);
  }
  function FloatTimelineInstance(timeline) {
    this.timeline_0 = timeline;
    this.value_0 = new PropertyValue();
    var tmp$, tmp$_0;
    this.offset_0 = (tmp$ = RegisteredParticleSetters_getInstance().offsets.get_11rb$(this.timeline_0.property)) != null ? tmp$ : 0.0;
    tmp$_0 = RegisteredParticleSetters_getInstance().updaters.get_11rb$(this.timeline_0.property);
    if (tmp$_0 == null) {
      throw Exception_init('Could not find property updater with the name ' + this.timeline_0.property);
    }this.updater_0 = tmp$_0;
  }
  FloatTimelineInstance.prototype.apply_ivhixc$ = function (particle, particleAlphaClamped, emitterAlphaClamped) {
    if (this.timeline_0.timeline.length === 0)
      return;
    var previous = this.value_0.current;
    var time = this.timeline_0.useEmitterDuration ? emitterAlphaClamped : particleAlphaClamped;
    this.value_0.setCurrent_yzjwcb$(this.timeline_0, time);
    this.updater_0(particle, this.value_0.current - previous);
  };
  FloatTimelineInstance.prototype.reset_hvu7lc$ = function (particle) {
    this.value_0.reset_vumshs$(this.timeline_0);
    this.updater_0(particle, this.value_0.current - this.offset_0);
  };
  FloatTimelineInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FloatTimelineInstance',
    interfaces: [TimelineInstance]
  };
  function ColorTimelineInstance(timeline) {
    this.timeline_0 = timeline;
    this.previous_0 = new Float32Array(3);
    this.value_0 = new Float32Array(3);
  }
  ColorTimelineInstance.prototype.apply_ivhixc$ = function (particle, particleAlphaClamped, emitterAlphaClamped) {
    var $receiver = this.value_0;
    arrayCopy($receiver, this.previous_0, 0, 0, $receiver.length);
    var time = this.timeline_0.useEmitterDuration ? emitterAlphaClamped : particleAlphaClamped;
    this.timeline_0.getValuesAtTime_f6ygq5$(time, this.value_0);
    particle.colorTint.r = particle.colorTint.r + (this.value_0[0] - this.previous_0[0]);
    particle.colorTint.g = particle.colorTint.g + (this.value_0[1] - this.previous_0[1]);
    particle.colorTint.b = particle.colorTint.b + (this.value_0[2] - this.previous_0[2]);
  };
  ColorTimelineInstance.prototype.reset_hvu7lc$ = function (particle) {
    fill(this.previous_0, 0.0);
    fill(this.value_0, 0.0);
    particle.colorTint.r = 0.0;
    particle.colorTint.g = 0.0;
    particle.colorTint.b = 0.0;
  };
  ColorTimelineInstance.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ColorTimelineInstance',
    interfaces: [TimelineInstance]
  };
  function RegisteredParticleSetters() {
    RegisteredParticleSetters_instance = this;
    this.offsets = hashMapOf([to('scale', 1.0), to('scaleX', 1.0), to('scaleY', 1.0), to('scaleZ', 1.0), to('originX', 0.5), to('originY', 0.5), to('originZ', 0.5), to('colorR', 1.0), to('colorG', 1.0), to('colorB', 1.0), to('colorA', 1.0)]);
    this.updaters = hashMapOf([to('x', RegisteredParticleSetters$updaters$lambda), to('y', RegisteredParticleSetters$updaters$lambda_0), to('z', RegisteredParticleSetters$updaters$lambda_1), to('velocityX', RegisteredParticleSetters$updaters$lambda_2), to('velocityY', RegisteredParticleSetters$updaters$lambda_3), to('velocityZ', RegisteredParticleSetters$updaters$lambda_4), to('originX', RegisteredParticleSetters$updaters$lambda_5), to('originY', RegisteredParticleSetters$updaters$lambda_6), to('originZ', RegisteredParticleSetters$updaters$lambda_7), to('scale', RegisteredParticleSetters$updaters$lambda_8), to('scaleX', RegisteredParticleSetters$updaters$lambda_9), to('scaleY', RegisteredParticleSetters$updaters$lambda_10), to('scaleZ', RegisteredParticleSetters$updaters$lambda_11), to('rotationX', RegisteredParticleSetters$updaters$lambda_12), to('rotationY', RegisteredParticleSetters$updaters$lambda_13), to('rotationZ', RegisteredParticleSetters$updaters$lambda_14), to('rotationalVelocityX', RegisteredParticleSetters$updaters$lambda_15), to('rotationalVelocityY', RegisteredParticleSetters$updaters$lambda_16), to('rotationalVelocityZ', RegisteredParticleSetters$updaters$lambda_17), to('forwardDirectionX', RegisteredParticleSetters$updaters$lambda_18), to('forwardDirectionY', RegisteredParticleSetters$updaters$lambda_19), to('forwardDirectionZ', RegisteredParticleSetters$updaters$lambda_20), to('forwardDirectionVelocityZ', RegisteredParticleSetters$updaters$lambda_21), to('forwardVelocity', RegisteredParticleSetters$updaters$lambda_22), to('colorR', RegisteredParticleSetters$updaters$lambda_23), to('colorG', RegisteredParticleSetters$updaters$lambda_24), to('colorB', RegisteredParticleSetters$updaters$lambda_25), to('colorA', RegisteredParticleSetters$updaters$lambda_26), to('imageIndex', RegisteredParticleSetters$updaters$lambda_27)]);
  }
  function RegisteredParticleSetters$updaters$lambda(target, delta) {
    target.position.x = target.position.x + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_0(target, delta) {
    target.position.y = target.position.y + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_1(target, delta) {
    target.position.z = target.position.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_2(target, delta) {
    target.velocity.x = target.velocity.x + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_3(target, delta) {
    target.velocity.y = target.velocity.y + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_4(target, delta) {
    target.velocity.z = target.velocity.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_5(target, delta) {
    target.origin.x = target.origin.x + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_6(target, delta) {
    target.origin.y = target.origin.y + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_7(target, delta) {
    target.origin.z = target.origin.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_8(target, delta) {
    target.scale.x = target.scale.x + delta;
    target.scale.y = target.scale.y + delta;
    target.scale.z = target.scale.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_9(target, delta) {
    target.scale.x = target.scale.x + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_10(target, delta) {
    target.scale.y = target.scale.y + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_11(target, delta) {
    target.scale.z = target.scale.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_12(target, delta) {
    target.rotation.x = target.rotation.x + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_13(target, delta) {
    target.rotation.y = target.rotation.y + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_14(target, delta) {
    target.rotation.z = target.rotation.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_15(target, delta) {
    target.rotationalVelocity.x = target.rotationalVelocity.x + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_16(target, delta) {
    target.rotationalVelocity.y = target.rotationalVelocity.y + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_17(target, delta) {
    target.rotationalVelocity.z = target.rotationalVelocity.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_18(target, delta) {
    target.forwardDirection.x = target.forwardDirection.x + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_19(target, delta) {
    target.forwardDirection.y = target.forwardDirection.y + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_20(target, delta) {
    target.forwardDirection.z = target.forwardDirection.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_21(target, delta) {
    target.forwardDirectionVelocity.z = target.forwardDirectionVelocity.z + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_22(target, delta) {
    target.forwardVelocity = target.forwardVelocity + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_23(target, delta) {
    target.colorTint.r = target.colorTint.r + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_24(target, delta) {
    target.colorTint.g = target.colorTint.g + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_25(target, delta) {
    target.colorTint.b = target.colorTint.b + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_26(target, delta) {
    target.colorTint.a = target.colorTint.a + delta;
    return Unit;
  }
  function RegisteredParticleSetters$updaters$lambda_27(target, delta) {
    target.imageIndex = target.imageIndex + numberToInt(delta) | 0;
    return Unit;
  }
  RegisteredParticleSetters.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'RegisteredParticleSetters',
    interfaces: []
  };
  var RegisteredParticleSetters_instance = null;
  function RegisteredParticleSetters_getInstance() {
    if (RegisteredParticleSetters_instance === null) {
      new RegisteredParticleSetters();
    }return RegisteredParticleSetters_instance;
  }
  function ParticleEmitterRenderer2d(emitterInstance, sprites) {
    ParticleEmitterRenderer2d$Companion_getInstance();
    LifecycleBase.call(this);
    this.emitterInstance_0 = emitterInstance;
    this.sprites_0 = sprites;
    this.transform_0 = new Matrix4();
    this.tint_0 = new Color();
  }
  ParticleEmitterRenderer2d.prototype.refInc = function () {
    var tmp$, tmp$_0;
    tmp$ = get_lastIndex_0(this.sprites_0);
    for (var i = 0; i <= tmp$; i++) {
      (tmp$_0 = this.sprites_0.get_za3lpa$(i).texture) != null ? (tmp$_0.refInc(), Unit) : null;
    }
  };
  ParticleEmitterRenderer2d.prototype.refDec = function () {
    var tmp$, tmp$_0;
    tmp$ = get_lastIndex_0(this.sprites_0);
    for (var i = 0; i <= tmp$; i++) {
      (tmp$_0 = this.sprites_0.get_za3lpa$(i).texture) != null ? (tmp$_0.refDec(), Unit) : null;
    }
  };
  ParticleEmitterRenderer2d.prototype.render_d6uf88$ = function (transform, tint) {
    var tmp$;
    if (!this.emitterInstance_0.emitter.enabled)
      return;
    var particles = this.emitterInstance_0.particles;
    tmp$ = get_lastIndex_0(particles);
    for (var i = 0; i <= tmp$; i++) {
      var particle = particles.get_za3lpa$(i);
      if (particle.active) {
        this.draw_0(particle, transform, tint);
      }}
  };
  ParticleEmitterRenderer2d.prototype.draw_0 = function ($receiver, emitterTransform, emitterTint) {
    var tmp$;
    tmp$ = getOrNull(this.sprites_0, $receiver.imageIndex);
    if (tmp$ == null) {
      return;
    }var sprite = tmp$;
    var emitter = this.emitterInstance_0.emitter;
    var emitterPosition = this.emitterInstance_0.position;
    if (emitter.orientToForwardDirection) {
      ParticleEmitterRenderer2d$Companion_getInstance().rotationFinal_0.set_1fv2cb$($receiver.rotation).add_1fv2cb$($receiver.forwardDirection);
      ParticleEmitterRenderer2d$Companion_getInstance().rotationFinal_0.z = ParticleEmitterRenderer2d$Companion_getInstance().rotationFinal_0.z + HALF_PI;
    } else {
      ParticleEmitterRenderer2d$Companion_getInstance().rotationFinal_0.set_1fv2cb$($receiver.rotation);
    }
    var rotation = ParticleEmitterRenderer2d$Companion_getInstance().rotationFinal_0;
    var origin = $receiver.origin;
    var $receiver_0 = this.transform_0;
    $receiver_0.idt();
    $receiver_0.trn_y2kzbl$($receiver.position.x + emitterPosition.x, $receiver.position.y + emitterPosition.y, $receiver.position.z + emitterPosition.z);
    if (!rotation.isZero()) {
      ParticleEmitterRenderer2d$Companion_getInstance().quat_0.setEulerAngles_y2kzbl$(rotation.x, rotation.y, rotation.z);
      $receiver_0.rotate_qe7e4j$(ParticleEmitterRenderer2d$Companion_getInstance().quat_0);
    }$receiver_0.scale_1fv2cb$($receiver.scale);
    if (!origin.isZero())
      $receiver_0.translate_y2kzbl$(-origin.x * sprite.naturalWidth, -origin.y * sprite.naturalHeight);
    this.transform_0.mulLeft_pekf88$(emitterTransform);
    this.tint_0.set_8suw10$(emitterTint).mul_8suw10$($receiver.colorTint);
    sprite.updateGlobalVertices_l6ao20$(void 0, void 0, this.transform_0, this.tint_0);
    sprite.render();
  };
  function ParticleEmitterRenderer2d$Companion() {
    ParticleEmitterRenderer2d$Companion_instance = this;
    this.quat_0 = new Quaternion();
    this.rotationFinal_0 = new Vector3();
  }
  ParticleEmitterRenderer2d$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ParticleEmitterRenderer2d$Companion_instance = null;
  function ParticleEmitterRenderer2d$Companion_getInstance() {
    if (ParticleEmitterRenderer2d$Companion_instance === null) {
      new ParticleEmitterRenderer2d$Companion();
    }return ParticleEmitterRenderer2d$Companion_instance;
  }
  ParticleEmitterRenderer2d.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ParticleEmitterRenderer2d',
    interfaces: [ParticleEmitterRenderer, LifecycleBase]
  };
  var HALF_PI;
  function PropertyTimeline(id, property, timeline, numComponents, useEmitterDuration, relative, low, high) {
    PropertyTimeline$Companion_getInstance();
    if (id === void 0)
      id = PropertyTimeline$Companion_getInstance().nextId();
    if (timeline === void 0)
      timeline = new Float32Array([]);
    if (numComponents === void 0)
      numComponents = 1;
    if (useEmitterDuration === void 0)
      useEmitterDuration = false;
    if (relative === void 0)
      relative = false;
    if (low === void 0)
      low = new FloatRange(0.0);
    if (high === void 0)
      high = new FloatRange(0.0);
    this.id = id;
    this.property = property;
    this.timeline = timeline;
    this.numComponents = numComponents;
    this.useEmitterDuration = useEmitterDuration;
    this.relative = relative;
    this.low = low;
    this.high = high;
    this.stride = this.numComponents + 1 | 0;
    if (!(this.timeline.length % this.stride === 0)) {
      var message = 'timeline should be divisible by stride <' + this$PropertyTimeline.stride + '>';
      throw IllegalStateException_init(message.toString());
    }}
  PropertyTimeline.prototype.equals = function (other) {
    return this === other;
  };
  PropertyTimeline.prototype.hashCode = function () {
    return this.id;
  };
  PropertyTimeline.prototype.getValueAtTime_mx4ult$ = function (time) {
    var tmp$;
    if (this.timeline.length === 0)
      return 0.0;
    var offset = 1;
    var indexB = getInsertionIndex(this.timeline, time, this.stride);
    var b = indexB - this.stride | 0;
    var indexA = Math_0.max(0, b);
    if (indexB === this.timeline.length)
      indexB = indexB - this.stride | 0;
    var timeA = this.timeline[indexA];
    var timeB = this.timeline[indexB];
    var valueA = this.timeline[indexA + offset | 0];
    if (timeB - timeA < math.MathUtils.FLOAT_ROUNDING_ERROR) {
      tmp$ = valueA;
    } else {
      var valueB = this.timeline[indexB + offset | 0];
      var valueAlpha = (time - timeA) / (timeB - timeA);
      var valueValue = (valueB - valueA) * valueAlpha + valueA;
      tmp$ = valueValue;
    }
    return tmp$;
  };
  PropertyTimeline.prototype.getValuesAtTime_f6ygq5$ = function (time, out) {
    if (out === void 0)
      out = new Float32Array(this.numComponents);
    var tmp$, tmp$_0;
    if (this.timeline.length === 0) {
      fill(out, 0.0);
      return out;
    }var indexB = getInsertionIndex(this.timeline, time, this.stride);
    var b = indexB - this.stride | 0;
    var indexA = Math_0.max(0, b);
    if (indexB === this.timeline.length)
      indexB = indexB - this.stride | 0;
    var timeA = this.timeline[indexA];
    var timeB = this.timeline[indexB];
    if (timeB - timeA < math.MathUtils.FLOAT_ROUNDING_ERROR) {
      tmp$ = this.numComponents - 1 | 0;
      for (var i = 0; i <= tmp$; i++) {
        out[i] = this.timeline[indexA + i + 1 | 0];
      }
    } else {
      tmp$_0 = this.numComponents - 1 | 0;
      for (var i_0 = 0; i_0 <= tmp$_0; i_0++) {
        var valueA = this.timeline[indexA + i_0 + 1 | 0];
        var valueB = this.timeline[indexB + i_0 + 1 | 0];
        var valueAlpha = (time - timeA) / (timeB - timeA);
        out[i_0] = (valueB - valueA) * valueAlpha + valueA;
      }
    }
    return out;
  };
  PropertyTimeline.prototype.getIndexCloseToTime_dleff0$ = function (time, affordance) {
    if (affordance === void 0)
      affordance = 0.02;
    var closestIndex = this.getIndexClosestToTime_mx4ult$(time);
    if (closestIndex === -1)
      return -1;
    var closestTime = this.timeline[closestIndex];
    return closeTo(closestTime, time, affordance) ? closestIndex : -1;
  };
  PropertyTimeline.prototype.getIndexClosestToTime_mx4ult$ = function (time) {
    var a = getInsertionIndex(this.timeline, time, this.stride);
    if (a <= 0)
      return 0;
    var b = a - this.stride | 0;
    var x = time - this.timeline[a];
    var diffA = Math_0.abs(x);
    var x_0 = time - this.timeline[b];
    var diffB = Math_0.abs(x_0);
    return diffA < diffB ? a : b;
  };
  function PropertyTimeline$Companion() {
    PropertyTimeline$Companion_instance = this;
    this._nextId_0 = 0;
  }
  PropertyTimeline$Companion.prototype.nextId = function () {
    return this._nextId_0 = this._nextId_0 + 1 | 0, this._nextId_0;
  };
  PropertyTimeline$Companion.prototype.serializer = function () {
    return PropertyTimeline$$serializer_getInstance();
  };
  PropertyTimeline$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PropertyTimeline$Companion_instance = null;
  function PropertyTimeline$Companion_getInstance() {
    if (PropertyTimeline$Companion_instance === null) {
      new PropertyTimeline$Companion();
    }return PropertyTimeline$Companion_instance;
  }
  function PropertyTimeline$$serializer() {
    this.descriptor_1xgfcr$_0 = new SerialClassDescImpl('com.acornui.particle.PropertyTimeline', this);
    this.descriptor.addElement_ivxn3r$('id', true);
    this.descriptor.addElement_ivxn3r$('property', false);
    this.descriptor.addElement_ivxn3r$('timeline', true);
    this.descriptor.addElement_ivxn3r$('numComponents', true);
    this.descriptor.addElement_ivxn3r$('useEmitterDuration', true);
    this.descriptor.addElement_ivxn3r$('relative', true);
    this.descriptor.addElement_ivxn3r$('low', true);
    this.descriptor.addElement_ivxn3r$('high', true);
    PropertyTimeline$$serializer_instance = this;
  }
  Object.defineProperty(PropertyTimeline$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_1xgfcr$_0;
    }
  });
  PropertyTimeline$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    if (!equals(obj.id, PropertyTimeline$Companion_getInstance().nextId()) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 0))
      output.encodeIntElement_4wpqag$(this.descriptor, 0, obj.id);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.property);
    if (!equals(obj.timeline, new Float32Array([])) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeSerializableElement_blecud$(this.descriptor, 2, internal.FloatArraySerializer, obj.timeline);
    if (!equals(obj.numComponents, 1) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeIntElement_4wpqag$(this.descriptor, 3, obj.numComponents);
    if (!equals(obj.useEmitterDuration, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 4, obj.useEmitterDuration);
    if (!equals(obj.relative, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 5, obj.relative);
    if (!equals(obj.low, new FloatRange(0.0)) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeSerializableElement_blecud$(this.descriptor, 6, FloatRange$$serializer_getInstance(), obj.low);
    if (!equals(obj.high, new FloatRange(0.0)) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeSerializableElement_blecud$(this.descriptor, 7, FloatRange$$serializer_getInstance(), obj.high);
    output.endStructure_qatsm0$(this.descriptor);
  };
  PropertyTimeline$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeIntElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 2, internal.FloatArraySerializer) : input.updateSerializableElement_ehubvl$(this.descriptor, 2, internal.FloatArraySerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeIntElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 6, FloatRange$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 6, FloatRange$$serializer_getInstance(), local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 7, FloatRange$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 7, FloatRange$$serializer_getInstance(), local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return PropertyTimeline_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, null);
  };
  PropertyTimeline$$serializer.prototype.childSerializers = function () {
    return [internal.IntSerializer, internal.StringSerializer, internal.FloatArraySerializer, internal.IntSerializer, internal.BooleanSerializer, internal.BooleanSerializer, FloatRange$$serializer_getInstance(), FloatRange$$serializer_getInstance()];
  };
  PropertyTimeline$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var PropertyTimeline$$serializer_instance = null;
  function PropertyTimeline$$serializer_getInstance() {
    if (PropertyTimeline$$serializer_instance === null) {
      new PropertyTimeline$$serializer();
    }return PropertyTimeline$$serializer_instance;
  }
  function PropertyTimeline_init(seen1, id, property, timeline, numComponents, useEmitterDuration, relative, low, high, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(PropertyTimeline.prototype);
    if ((seen1 & 1) === 0)
      $this.id = PropertyTimeline$Companion_getInstance().nextId();
    else
      $this.id = id;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('property');
    else
      $this.property = property;
    if ((seen1 & 4) === 0)
      $this.timeline = new Float32Array([]);
    else
      $this.timeline = timeline;
    if ((seen1 & 8) === 0)
      $this.numComponents = 1;
    else
      $this.numComponents = numComponents;
    if ((seen1 & 16) === 0)
      $this.useEmitterDuration = false;
    else
      $this.useEmitterDuration = useEmitterDuration;
    if ((seen1 & 32) === 0)
      $this.relative = false;
    else
      $this.relative = relative;
    if ((seen1 & 64) === 0)
      $this.low = new FloatRange(0.0);
    else
      $this.low = low;
    if ((seen1 & 128) === 0)
      $this.high = new FloatRange(0.0);
    else
      $this.high = high;
    $this.stride = $this.numComponents + 1 | 0;
    if (!($this.timeline.length % $this.stride === 0)) {
      var message = 'timeline should be divisible by stride <' + this$PropertyTimeline.stride + '>';
      throw IllegalStateException_init(message.toString());
    }return $this;
  }
  PropertyTimeline.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PropertyTimeline',
    interfaces: []
  };
  PropertyTimeline.prototype.component1 = function () {
    return this.id;
  };
  PropertyTimeline.prototype.component2 = function () {
    return this.property;
  };
  PropertyTimeline.prototype.component3 = function () {
    return this.timeline;
  };
  PropertyTimeline.prototype.component4 = function () {
    return this.numComponents;
  };
  PropertyTimeline.prototype.component5 = function () {
    return this.useEmitterDuration;
  };
  PropertyTimeline.prototype.component6 = function () {
    return this.relative;
  };
  PropertyTimeline.prototype.component7 = function () {
    return this.low;
  };
  PropertyTimeline.prototype.component8 = function () {
    return this.high;
  };
  PropertyTimeline.prototype.copy_x5th3u$ = function (id, property, timeline, numComponents, useEmitterDuration, relative, low, high) {
    return new PropertyTimeline(id === void 0 ? this.id : id, property === void 0 ? this.property : property, timeline === void 0 ? this.timeline : timeline, numComponents === void 0 ? this.numComponents : numComponents, useEmitterDuration === void 0 ? this.useEmitterDuration : useEmitterDuration, relative === void 0 ? this.relative : relative, low === void 0 ? this.low : low, high === void 0 ? this.high : high);
  };
  PropertyTimeline.prototype.toString = function () {
    return 'PropertyTimeline(id=' + Kotlin.toString(this.id) + (', property=' + Kotlin.toString(this.property)) + (', timeline=' + Kotlin.toString(this.timeline)) + (', numComponents=' + Kotlin.toString(this.numComponents)) + (', useEmitterDuration=' + Kotlin.toString(this.useEmitterDuration)) + (', relative=' + Kotlin.toString(this.relative)) + (', low=' + Kotlin.toString(this.low)) + (', high=' + Kotlin.toString(this.high)) + ')';
  };
  function PropertyValue(low, high, diff, current) {
    if (low === void 0)
      low = 0.0;
    if (high === void 0)
      high = 0.0;
    if (diff === void 0)
      diff = 0.0;
    if (current === void 0)
      current = 0.0;
    this.low = low;
    this.high = high;
    this.diff = diff;
    this.current = current;
  }
  PropertyValue.prototype.reset_vumshs$ = function (timeline) {
    this.low = timeline.low.getValue();
    this.high = timeline.high.getValue();
    if (timeline.relative)
      this.high += this.low;
    this.diff = this.high - this.low;
    this.current = this.low;
  };
  PropertyValue.prototype.setCurrent_yzjwcb$ = function (timeline, time) {
    this.current = timeline.getValueAtTime_mx4ult$(time) * this.diff + this.low;
  };
  PropertyValue.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PropertyValue',
    interfaces: []
  };
  function AStar(width, height) {
    AStar$Companion_getInstance();
    this.width = width;
    this.height = height;
    this.open_674lwz$_0 = null;
    this.nodes_kgr3ak$_0 = null;
    this.runID_8be2vx$ = 0;
    this.closestNode_3adzj6$_0 = null;
    this.closestDistance_627ddd$_0 = 0;
    this.targetX = 0;
    this.targetY = 0;
    this.open_674lwz$_0 = new BinaryHeap(this.width * 4 | 0, false);
    this.nodes_kgr3ak$_0 = Kotlin.newArray(Kotlin.imul(this.width, this.height), null);
  }
  AStar.prototype.calculatePath_3dlsda$ = function (startX, startY, targetX, targetY, out) {
    this.targetX = targetX;
    this.targetY = targetY;
    this.runID_8be2vx$ = this.runID_8be2vx$ + 1 | 0;
    if (this.runID_8be2vx$ < 0)
      this.runID_8be2vx$ = 1;
    var index = Kotlin.imul(startY, this.width) + startX | 0;
    var root = this.nodes_kgr3ak$_0[index];
    if (root == null) {
      root = new AStar$PathNode(0.0);
      root.x_8be2vx$ = startX;
      root.y_8be2vx$ = startY;
      this.nodes_kgr3ak$_0[index] = root;
    }this.closestNode_3adzj6$_0 = root;
    this.closestDistance_627ddd$_0 = abs(startX - targetX | 0) + abs(startY - targetY | 0) | 0;
    root.parent_8be2vx$ = null;
    root.pathCost_8be2vx$ = 0;
    this.open_674lwz$_0.add_moq7bw$(root, 0.0);
    var lastColumn = this.width - 1 | 0;
    var lastRow = this.height - 1 | 0;
    while (this.open_674lwz$_0.size > 0) {
      var node = this.open_674lwz$_0.pop();
      if (node.x_8be2vx$ === targetX && node.y_8be2vx$ === targetY) {
        break;
      }node.closedID_8be2vx$ = this.runID_8be2vx$;
      var x = node.x_8be2vx$;
      var y = node.y_8be2vx$;
      if (x < lastColumn) {
        this.addNode_k00jka$_0(node, x + 1 | 0, y, 10);
        if (y < lastRow)
          this.addNode_k00jka$_0(node, x + 1 | 0, y + 1 | 0, 14);
        if (y > 0)
          this.addNode_k00jka$_0(node, x + 1 | 0, y - 1 | 0, 14);
      }if (x > 0) {
        this.addNode_k00jka$_0(node, x - 1 | 0, y, 10);
        if (y < lastRow)
          this.addNode_k00jka$_0(node, x - 1 | 0, y + 1 | 0, 14);
        if (y > 0)
          this.addNode_k00jka$_0(node, x - 1 | 0, y - 1 | 0, 14);
      }if (y < lastRow)
        this.addNode_k00jka$_0(node, x, y + 1 | 0, 10);
      if (y > 0)
        this.addNode_k00jka$_0(node, x, y - 1 | 0, 10);
    }
    out.clear();
    this.open_674lwz$_0.clear();
    out.add_11rb$(targetX);
    out.add_11rb$(targetY);
    if (this.closestNode_3adzj6$_0 != null) {
      var node_0 = ensureNotNull(this.closestNode_3adzj6$_0);
      while (node_0 !== root) {
        out.add_11rb$(node_0.x_8be2vx$);
        out.add_11rb$(node_0.y_8be2vx$);
        node_0 = ensureNotNull(node_0.parent_8be2vx$);
      }
    }};
  AStar.prototype.addNode_k00jka$_0 = function (parent, x, y, cost) {
    if ((x !== this.targetX || y !== this.targetY) && !this.isValid_vux9f0$(x, y))
      return;
    var pathCost = parent.pathCost_8be2vx$ + cost | 0;
    var distance = abs(x - this.targetX | 0) + abs(y - this.targetY | 0) | 0;
    if (distance > this.closestDistance_627ddd$_0 * AStar$Companion_getInstance().MAX_DEVIATION_PERCENT_0 + AStar$Companion_getInstance().MAX_DEVIATION_0) {
      return;
    }var score = pathCost + distance | 0;
    var index = Kotlin.imul(y, this.width) + x | 0;
    var node = this.nodes_kgr3ak$_0[index];
    if (node != null && node.runID_8be2vx$ === this.runID_8be2vx$) {
      if (node.closedID_8be2vx$ !== this.runID_8be2vx$ && pathCost < node.pathCost_8be2vx$) {
        this.open_674lwz$_0.setValue_moq7bw$(node, score);
        node.parent_8be2vx$ = parent;
        node.pathCost_8be2vx$ = pathCost;
      } else {
        node = null;
      }
    } else {
      if (node == null) {
        node = new AStar$PathNode(0.0);
        node.x_8be2vx$ = x;
        node.y_8be2vx$ = y;
        this.nodes_kgr3ak$_0[index] = node;
      }this.open_674lwz$_0.add_moq7bw$(node, score);
      node.runID_8be2vx$ = this.runID_8be2vx$;
      node.parent_8be2vx$ = parent;
      node.pathCost_8be2vx$ = pathCost;
    }
    if (node != null) {
      if (distance < this.closestDistance_627ddd$_0) {
        this.closestNode_3adzj6$_0 = node;
        this.closestDistance_627ddd$_0 = distance;
      }}};
  AStar.prototype.isValid_vux9f0$ = function (x, y) {
    return true;
  };
  function AStar$PathNode(value) {
    BinaryHeapNode.call(this, value);
    this.runID_8be2vx$ = 0;
    this.closedID_8be2vx$ = 0;
    this.x_8be2vx$ = 0;
    this.y_8be2vx$ = 0;
    this.pathCost_8be2vx$ = 0;
    this.parent_8be2vx$ = null;
  }
  AStar$PathNode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PathNode',
    interfaces: [BinaryHeapNode]
  };
  function AStar$Companion() {
    AStar$Companion_instance = this;
    this.MAX_DEVIATION_PERCENT_0 = 1.5;
    this.MAX_DEVIATION_0 = 4.0;
  }
  AStar$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AStar$Companion_instance = null;
  function AStar$Companion_getInstance() {
    if (AStar$Companion_instance === null) {
      new AStar$Companion();
    }return AStar$Companion_instance;
  }
  AStar.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AStar',
    interfaces: []
  };
  function Physics() {
    Physics$Companion_getInstance();
    ComponentBase.call(this);
    this.position = new Vector3();
    this.velocity = new Vector2();
    this.maxVelocity = 20.0;
    this.acceleration = new Vector2();
    this.scale = new Vector3(1.0, 1.0, 1.0);
    this.rotation = 0.0;
    this.rotationalVelocity = 0.0;
    this.dampening = 1.0;
    this.rotationalDampening = 0.95;
    this.radius = 0.0;
    this.collisionZ = 0.0;
    this.restitution = 0.8;
    this.canCollide = true;
    this.collideGroup = -1;
    this.mass = 1.0;
    this.isFixed = false;
    this.type_1in1w4$_0 = Physics$Companion_getInstance();
  }
  Object.defineProperty(Physics.prototype, 'type', {
    get: function () {
      return this.type_1in1w4$_0;
    }
  });
  function Physics$Companion() {
    Physics$Companion_instance = this;
  }
  Physics$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [ComponentType]
  };
  var Physics$Companion_instance = null;
  function Physics$Companion_getInstance() {
    if (Physics$Companion_instance === null) {
      new Physics$Companion();
    }return Physics$Companion_instance;
  }
  Physics.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Physics',
    interfaces: [ComponentBase]
  };
  function Perimeter(perimeter) {
    Perimeter$Companion_getInstance();
    if (perimeter === void 0)
      perimeter = new Polygon2();
    ComponentBase.call(this);
    this.perimeter = perimeter;
    this.type_k9by0a$_0 = Perimeter$Companion_getInstance();
  }
  Object.defineProperty(Perimeter.prototype, 'type', {
    get: function () {
      return this.type_k9by0a$_0;
    }
  });
  function Perimeter$Companion() {
    Perimeter$Companion_instance = this;
  }
  Perimeter$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [ComponentType]
  };
  var Perimeter$Companion_instance = null;
  function Perimeter$Companion_getInstance() {
    if (Perimeter$Companion_instance === null) {
      new Perimeter$Companion();
    }return Perimeter$Companion_instance;
  }
  Perimeter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Perimeter',
    interfaces: [ComponentBase]
  };
  function PhysicsController(frameDriver, entities) {
    PhysicsController$Companion_getInstance();
    this.frameDriver_8xzqln$_0 = frameDriver;
    this.cmd_0 = commander();
    this.physicsVos_0 = ArrayList_init();
    componentList(entities, this.cmd_0, this.physicsVos_0, Physics$Companion_getInstance());
  }
  Object.defineProperty(PhysicsController.prototype, 'frameDriver', {
    get: function () {
      return this.frameDriver_8xzqln$_0;
    }
  });
  PhysicsController.prototype.update_mx4ult$ = function (dT) {
    var tmp$, tmp$_0, tmp$_1;
    tmp$ = get_lastIndex_0(this.physicsVos_0);
    for (var i = 0; i <= tmp$; i++) {
      var p = this.physicsVos_0.get_za3lpa$(i);
      p.position.add_y2kzbl$(p.velocity.x, p.velocity.y, 0.0);
      p.velocity.add_1fv330$(p.acceleration);
      p.velocity.scl_mx4ult$(p.dampening);
      p.velocity.limit_mx4ult$(p.maxVelocity);
      p.rotation = p.rotation + p.rotationalVelocity;
      p.rotationalVelocity = p.rotationalVelocity * p.rotationalDampening;
    }
    tmp$_0 = get_lastIndex_0(this.physicsVos_0);
    for (var i_0 = 0; i_0 <= tmp$_0; i_0++) {
      var pA = this.physicsVos_0.get_za3lpa$(i_0);
      tmp$_1 = get_lastIndex_0(this.physicsVos_0);
      for (var j = i_0 + 1 | 0; j <= tmp$_1; j++) {
        var pB = this.physicsVos_0.get_za3lpa$(j);
        this.checkCollision_0(pA, pB);
      }
    }
  };
  PhysicsController.prototype.checkCollision_0 = function (pA, pB) {
    if (!pA.canCollide || !pB.canCollide || (pA.isFixed && pB.isFixed) || (pA.collideGroup !== -1 && pA.collideGroup === pB.collideGroup))
      return;
    var impactVelocity = PhysicsController$Companion_getInstance().collision_0.impactVelocity;
    PhysicsController$Companion_getInstance().posDelta_0.set_dleff0$(pA.position.x, pA.position.y).sub_dleff0$(pB.position.x, pB.position.y);
    var dist2 = PhysicsController$Companion_getInstance().posDelta_0.len2();
    var tmp$ = pA.radius;
    var a = pA.scale.x;
    var b = pA.scale.y;
    var tmp$_0 = tmp$ * Math_0.max(a, b);
    var tmp$_1 = pB.radius;
    var a_0 = pB.scale.x;
    var b_0 = pB.scale.y;
    var r2 = tmp$_0 + tmp$_1 * Math_0.max(a_0, b_0);
    if (dist2 < r2 * r2 - 1.0E-4) {
      PhysicsController$Companion_getInstance().tmpMat_0.idt();
      PhysicsController$Companion_getInstance().tmpMat_0.trn_9wm29k$(pA.position);
      PhysicsController$Companion_getInstance().tmpMat_0.scl_1fv2cb$(pA.scale);
      PhysicsController$Companion_getInstance().tmpMat_0.rotate_mx4ult$(pA.rotation);
      var perimA = ensureNotNull(pA.getSibling_7soe6u$(Perimeter$Companion_getInstance())).perimeter;
      PhysicsController$Companion_getInstance().worldPerim1_0.set_14o8gn$(perimA).mul_pekfyx$(PhysicsController$Companion_getInstance().tmpMat_0).invalidate();
      PhysicsController$Companion_getInstance().tmpMat_0.idt();
      PhysicsController$Companion_getInstance().tmpMat_0.trn_9wm29k$(pB.position);
      PhysicsController$Companion_getInstance().tmpMat_0.scl_1fv2cb$(pB.scale);
      PhysicsController$Companion_getInstance().tmpMat_0.rotate_mx4ult$(pB.rotation);
      var perimB = ensureNotNull(pB.getSibling_7soe6u$(Perimeter$Companion_getInstance())).perimeter;
      PhysicsController$Companion_getInstance().worldPerim2_0.set_14o8gn$(perimB).mul_pekfyx$(PhysicsController$Companion_getInstance().tmpMat_0).invalidate();
      if (PhysicsController$Companion_getInstance().worldPerim2_0.intersects_j3rlwr$(PhysicsController$Companion_getInstance().worldPerim1_0, PhysicsController$Companion_getInstance().mTd_0) && !PhysicsController$Companion_getInstance().mTd_0.isZero()) {
        PhysicsController$Companion_getInstance().worldPerim2_0.getContactInfo_1gkzbj$(PhysicsController$Companion_getInstance().worldPerim1_0, PhysicsController$Companion_getInstance().mTd_0, PhysicsController$Companion_getInstance().collisionInfo_0);
        var iMA = 1.0 / pA.mass;
        var iMB = 1.0 / pB.mass;
        var mA = pB.isFixed ? 1.0 : iMA / (iMA + iMB);
        var mB = pA.isFixed ? 1.0 : iMB / (iMA + iMB);
        if (!pA.isFixed)
          pA.position.add_y2kzbl$(PhysicsController$Companion_getInstance().mTd_0.x * mA, PhysicsController$Companion_getInstance().mTd_0.y * mA, 0.0);
        if (!pB.isFixed)
          pB.position.sub_y2kzbl$(PhysicsController$Companion_getInstance().mTd_0.x * mB, PhysicsController$Companion_getInstance().mTd_0.y * mB, 0.0);
        PhysicsController$Companion_getInstance().mTd_0.nor();
        var cA = PhysicsController$Companion_getInstance().collisionInfo_0.midA;
        var cB = PhysicsController$Companion_getInstance().collisionInfo_0.midB;
        PhysicsController$Companion_getInstance().rA_0.set_1fv330$(cA).sub_dleff0$(pA.position.x, pA.position.y);
        PhysicsController$Companion_getInstance().rB_0.set_1fv330$(cB).sub_dleff0$(pB.position.x, pB.position.y);
        impactVelocity.set_1fv330$(pA.velocity).add_dleff0$(-PhysicsController$Companion_getInstance().rA_0.y * pA.rotationalVelocity, PhysicsController$Companion_getInstance().rA_0.x * pA.rotationalVelocity).sub_1fv330$(pB.velocity).sub_dleff0$(-PhysicsController$Companion_getInstance().rB_0.y * pB.rotationalVelocity, PhysicsController$Companion_getInstance().rB_0.x * pB.rotationalVelocity);
        var vN = impactVelocity.dot_1fv330$(PhysicsController$Companion_getInstance().mTd_0);
        if (vN < 0.0) {
          var restitution = pA.restitution * pB.restitution;
          PhysicsController$Companion_getInstance().impulse_0.set_1fv330$(PhysicsController$Companion_getInstance().mTd_0).scl_mx4ult$(-(1.0 + restitution) / (iMA + iMB));
          if (!pA.isFixed)
            pA.velocity.add_dleff0$(PhysicsController$Companion_getInstance().impulse_0.x * iMA * vN, PhysicsController$Companion_getInstance().impulse_0.y * iMA * vN);
          if (!pB.isFixed)
            pB.velocity.sub_dleff0$(PhysicsController$Companion_getInstance().impulse_0.x * iMB * vN, PhysicsController$Companion_getInstance().impulse_0.y * iMB * vN);
          if (!pA.isFixed)
            pA.rotationalVelocity = pA.rotationalVelocity - (PhysicsController$Companion_getInstance().rA_0.x * PhysicsController$Companion_getInstance().mTd_0.y * vN - PhysicsController$Companion_getInstance().rA_0.y * PhysicsController$Companion_getInstance().mTd_0.x * vN) * iMA;
          if (!pB.isFixed)
            pB.rotationalVelocity = pB.rotationalVelocity + (PhysicsController$Companion_getInstance().rB_0.x * PhysicsController$Companion_getInstance().mTd_0.y * vN - PhysicsController$Companion_getInstance().rB_0.y * PhysicsController$Companion_getInstance().mTd_0.x * vN) * iMB;
          PhysicsController$Companion_getInstance().collision_0.z = (pA.collisionZ + pB.collisionZ) * 0.5;
          PhysicsController$Companion_getInstance().collision_0.impactDirection.set_1fv330$(PhysicsController$Companion_getInstance().mTd_0);
          PhysicsController$Companion_getInstance().collision_0.impactStrength = vN;
          PhysicsController$Companion_getInstance().collision_0.entityA = pA.parentEntity;
          PhysicsController$Companion_getInstance().collision_0.entityB = pB.parentEntity;
          invokeCommand(PhysicsController$Companion_getInstance().collision_0);
        }}}};
  PhysicsController.prototype.dispose = function () {
    this.cmd_0.dispose();
  };
  function PhysicsController$Companion() {
    PhysicsController$Companion_instance = this;
    this.collisionInfo_0 = new CollisionInfo();
    this.collision_0 = new Collision(this.collisionInfo_0);
    this.mTd_0 = new Vector2();
    this.posDelta_0 = new Vector2();
    this.rA_0 = new Vector2();
    this.rB_0 = new Vector2();
    this.impulse_0 = new Vector2();
    this.worldPerim1_0 = new Polygon2();
    this.worldPerim2_0 = new Polygon2();
    this.tmpMat_0 = new Matrix3();
  }
  PhysicsController$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PhysicsController$Companion_instance = null;
  function PhysicsController$Companion_getInstance() {
    if (PhysicsController$Companion_instance === null) {
      new PhysicsController$Companion();
    }return PhysicsController$Companion_instance;
  }
  PhysicsController.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PhysicsController',
    interfaces: [Disposable, Updatable]
  };
  function CollisionRo() {
    CollisionRo$Companion_getInstance();
  }
  function CollisionRo$Companion() {
    CollisionRo$Companion_instance = this;
  }
  CollisionRo$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [CommandType]
  };
  var CollisionRo$Companion_instance = null;
  function CollisionRo$Companion_getInstance() {
    if (CollisionRo$Companion_instance === null) {
      new CollisionRo$Companion();
    }return CollisionRo$Companion_instance;
  }
  CollisionRo.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CollisionRo',
    interfaces: [Command]
  };
  function Collision(collisionInfo) {
    this.collisionInfo_cqb6e3$_0 = collisionInfo;
    this.type_4dc1c1$_0 = CollisionRo$Companion_getInstance();
    this.z_3z94kh$_0 = 0.0;
    this.impactVelocity_x3rr6y$_0 = new Vector2();
    this.impactDirection_4gy9eq$_0 = new Vector2();
    this.impactStrength_45ywtu$_0 = 0.0;
    this.entityA_mgvzmr$_0 = null;
    this.entityB_mgvzlw$_0 = null;
  }
  Object.defineProperty(Collision.prototype, 'collisionInfo', {
    get: function () {
      return this.collisionInfo_cqb6e3$_0;
    }
  });
  Object.defineProperty(Collision.prototype, 'type', {
    get: function () {
      return this.type_4dc1c1$_0;
    }
  });
  Object.defineProperty(Collision.prototype, 'z', {
    get: function () {
      return this.z_3z94kh$_0;
    },
    set: function (z) {
      this.z_3z94kh$_0 = z;
    }
  });
  Object.defineProperty(Collision.prototype, 'impactVelocity', {
    get: function () {
      return this.impactVelocity_x3rr6y$_0;
    }
  });
  Object.defineProperty(Collision.prototype, 'impactDirection', {
    get: function () {
      return this.impactDirection_4gy9eq$_0;
    }
  });
  Object.defineProperty(Collision.prototype, 'impactStrength', {
    get: function () {
      return this.impactStrength_45ywtu$_0;
    },
    set: function (impactStrength) {
      this.impactStrength_45ywtu$_0 = impactStrength;
    }
  });
  Object.defineProperty(Collision.prototype, 'entityA', {
    get: function () {
      return this.entityA_mgvzmr$_0;
    },
    set: function (entityA) {
      this.entityA_mgvzmr$_0 = entityA;
    }
  });
  Object.defineProperty(Collision.prototype, 'entityB', {
    get: function () {
      return this.entityB_mgvzlw$_0;
    },
    set: function (entityB) {
      this.entityB_mgvzlw$_0 = entityB;
    }
  });
  Collision.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Collision',
    interfaces: [CollisionRo]
  };
  var package$com = _.com || (_.com = {});
  var package$acornui = package$com.acornui || (package$com.acornui = {});
  var package$ecs = package$acornui.ecs || (package$acornui.ecs = {});
  package$ecs.Component = Component;
  package$ecs.ComponentBase = ComponentBase;
  package$ecs.ComponentType = ComponentType;
  Object.defineProperty(UnknownComponent, 'Companion', {
    get: UnknownComponent$Companion_getInstance
  });
  package$ecs.UnknownComponent = UnknownComponent;
  Object.defineProperty(AddEntity, 'Companion', {
    get: AddEntity$Companion_getInstance
  });
  package$ecs.AddEntity = AddEntity;
  Object.defineProperty(RemoveEntity, 'Companion', {
    get: RemoveEntity$Companion_getInstance
  });
  package$ecs.RemoveEntity = RemoveEntity;
  package$ecs.watchEntities_lit54b$ = watchEntities;
  package$ecs.addEntity_cq6uh1$ = addEntity;
  package$ecs.addEntity_9nsfce$ = addEntity_0;
  package$ecs.removeEntity_cq6uh1$ = removeEntity;
  $$importsForInline$$['acornui-acornui-game'] = _;
  package$ecs.entitiesList_w2v2ff$ = entitiesList;
  package$ecs.componentList_7rb30t$ = componentList;
  Object.defineProperty(Entity, 'Companion', {
    get: Entity$Companion_getInstance
  });
  package$ecs.Entity = Entity;
  package$ecs.entity_i3iobn$ = entity;
  var package$geom = package$acornui.geom || (package$acornui.geom = {});
  package$geom.Polygon2Ro = Polygon2Ro;
  Object.defineProperty(Polygon2, 'Companion', {
    get: Polygon2$Companion_getInstance
  });
  package$geom.Polygon2_init_hcyabg$ = Polygon2_init;
  package$geom.Polygon2 = Polygon2;
  package$geom.basicPolygon_24o109$ = basicPolygon;
  package$geom.CollisionInfoRo = CollisionInfoRo;
  package$geom.CollisionInfo = CollisionInfo;
  var package$graphic = package$acornui.graphic || (package$acornui.graphic = {});
  package$graphic.BestSampler = BestSampler;
  package$graphic.CubeMap = CubeMap;
  Object.defineProperty(package$graphic, 'ExtrudeUtil', {
    get: ExtrudeUtil_getInstance
  });
  package$graphic.calculatePerimeter_9ex35k$ = calculatePerimeter;
  package$graphic.calculatePerimeter_fssa8a$ = calculatePerimeter_0;
  $$importsForInline$$['acornui-acornui-core'] = $module$acornui_acornui_core;
  package$graphic.LightingRenderer = LightingRenderer;
  Object.defineProperty(package$graphic, 'PACK_FLOAT', {
    get: function () {
      return PACK_FLOAT;
    }
  });
  Object.defineProperty(package$graphic, 'UNPACK_FLOAT', {
    get: function () {
      return UNPACK_FLOAT;
    }
  });
  package$graphic.LightingShader = LightingShader;
  package$graphic.PointShadowShader = PointShadowShader;
  package$graphic.DirectionalShadowShader = DirectionalShadowShader;
  package$graphic.LightingShaderWithNormalMap = LightingShaderWithNormalMap;
  package$graphic.Skybox = Skybox;
  package$graphic.SkyboxShader = SkyboxShader;
  var package$lighting = package$graphic.lighting || (package$graphic.lighting = {});
  package$lighting.AmbientLight = AmbientLight;
  package$lighting.ambientLight_349gr$ = ambientLight;
  package$lighting.DirectionalLight = DirectionalLight;
  package$lighting.directionalLight_3cxeqh$ = directionalLight;
  package$lighting.DirectionalLightCamera = DirectionalLightCamera;
  Object.defineProperty(PointLight, 'Companion', {
    get: PointLight$Companion_getInstance
  });
  package$lighting.PointLight = PointLight;
  package$lighting.pointLight_jkdr1v$ = pointLight;
  Object.defineProperty(PointLightCamera, 'Companion', {
    get: PointLightCamera$Companion_getInstance
  });
  package$lighting.PointLightCamera = PointLightCamera;
  Object.defineProperty(FloatRange, 'Companion', {
    get: FloatRange$Companion_getInstance
  });
  Object.defineProperty(FloatRange, '$serializer', {
    get: FloatRange$$serializer_getInstance
  });
  var package$particle = package$acornui.particle || (package$acornui.particle = {});
  package$particle.FloatRange_init_63tz2r$ = FloatRange_init;
  package$particle.FloatRange = FloatRange;
  Object.defineProperty(ParticleEffect, 'Companion', {
    get: ParticleEffect$Companion_getInstance
  });
  Object.defineProperty(ParticleEffect, '$serializer', {
    get: ParticleEffect$$serializer_getInstance
  });
  package$particle.ParticleEffect_init_1uxjbp$ = ParticleEffect_init;
  package$particle.ParticleEffect = ParticleEffect;
  Object.defineProperty(ParticleEmitter, 'Companion', {
    get: ParticleEmitter$Companion_getInstance
  });
  Object.defineProperty(ParticleEmitter, '$serializer', {
    get: ParticleEmitter$$serializer_getInstance
  });
  package$particle.ParticleEmitter_init_xcigkx$ = ParticleEmitter_init;
  package$particle.ParticleEmitter = ParticleEmitter;
  Object.defineProperty(EmitterDuration, 'Companion', {
    get: EmitterDuration$Companion_getInstance
  });
  Object.defineProperty(EmitterDuration, '$serializer', {
    get: EmitterDuration$$serializer_getInstance
  });
  package$particle.EmitterDuration_init_vi537c$ = EmitterDuration_init;
  package$particle.EmitterDuration = EmitterDuration;
  Object.defineProperty(ParticleImageEntry, 'Companion', {
    get: ParticleImageEntry$Companion_getInstance
  });
  Object.defineProperty(ParticleImageEntry, '$serializer', {
    get: ParticleImageEntry$$serializer_getInstance
  });
  package$particle.ParticleImageEntry_init_p8z6pe$ = ParticleImageEntry_init;
  package$particle.ParticleImageEntry = ParticleImageEntry;
  package$particle.ParticleEffectComponent = ParticleEffectComponent;
  package$particle.LoadedParticleEffect = LoadedParticleEffect;
  package$particle.loadParticleEffect_25x3ag$ = loadParticleEffect;
  package$particle.loadParticleEffect_mfe4gr$ = loadParticleEffect_0;
  package$particle.loadParticleEffect_llk5py$ = loadParticleEffect_1;
  package$particle.ParticleEmitterRenderer = ParticleEmitterRenderer;
  package$particle.particleEffectComponent_85jr68$ = particleEffectComponent;
  package$particle.particleEffectComponent_7efrtn$ = particleEffectComponent_0;
  package$particle.ParticleEffectInstance = ParticleEffectInstance;
  $$importsForInline$$['acornui-acornui-utils'] = $module$acornui_acornui_utils;
  package$particle.ParticleEmitterInstance = ParticleEmitterInstance;
  package$particle.Particle = Particle;
  package$particle.TimelineInstance = TimelineInstance;
  package$particle.timelineInstance_vumshs$ = timelineInstance;
  package$particle.FloatTimelineInstance = FloatTimelineInstance;
  package$particle.ColorTimelineInstance = ColorTimelineInstance;
  Object.defineProperty(package$particle, 'RegisteredParticleSetters', {
    get: RegisteredParticleSetters_getInstance
  });
  Object.defineProperty(ParticleEmitterRenderer2d, 'Companion', {
    get: ParticleEmitterRenderer2d$Companion_getInstance
  });
  package$particle.ParticleEmitterRenderer2d = ParticleEmitterRenderer2d;
  Object.defineProperty(PropertyTimeline, 'Companion', {
    get: PropertyTimeline$Companion_getInstance
  });
  Object.defineProperty(PropertyTimeline, '$serializer', {
    get: PropertyTimeline$$serializer_getInstance
  });
  package$particle.PropertyTimeline_init_ewfol4$ = PropertyTimeline_init;
  package$particle.PropertyTimeline = PropertyTimeline;
  package$particle.PropertyValue = PropertyValue;
  Object.defineProperty(AStar, 'Companion', {
    get: AStar$Companion_getInstance
  });
  var package$pathfinding = package$acornui.pathfinding || (package$acornui.pathfinding = {});
  package$pathfinding.AStar = AStar;
  Object.defineProperty(Physics, 'Companion', {
    get: Physics$Companion_getInstance
  });
  var package$physics = package$acornui.physics || (package$acornui.physics = {});
  package$physics.Physics = Physics;
  Object.defineProperty(Perimeter, 'Companion', {
    get: Perimeter$Companion_getInstance
  });
  package$physics.Perimeter = Perimeter;
  Object.defineProperty(PhysicsController, 'Companion', {
    get: PhysicsController$Companion_getInstance
  });
  package$physics.PhysicsController = PhysicsController;
  Object.defineProperty(CollisionRo, 'Companion', {
    get: CollisionRo$Companion_getInstance
  });
  package$physics.CollisionRo = CollisionRo;
  package$physics.Collision = Collision;
  ComponentBase.prototype.getSibling_7soe6u$ = Component.prototype.getSibling_7soe6u$;
  ComponentBase.prototype.remove = Component.prototype.remove;
  ComponentBase.prototype.dispose = Component.prototype.dispose;
  Polygon2.prototype.intersects_j3rlwr$ = Polygon2Ro.prototype.intersects_j3rlwr$;
  CollisionInfo.prototype.copy = CollisionInfoRo.prototype.copy;
  FloatRange$$serializer.prototype.patch_mynpiu$ = GeneratedSerializer.prototype.patch_mynpiu$;
  ParticleEffect$$serializer.prototype.patch_mynpiu$ = GeneratedSerializer.prototype.patch_mynpiu$;
  ParticleEmitter$$serializer.prototype.patch_mynpiu$ = GeneratedSerializer.prototype.patch_mynpiu$;
  EmitterDuration$$serializer.prototype.patch_mynpiu$ = GeneratedSerializer.prototype.patch_mynpiu$;
  ParticleImageEntry$$serializer.prototype.patch_mynpiu$ = GeneratedSerializer.prototype.patch_mynpiu$;
  PropertyTimeline$$serializer.prototype.patch_mynpiu$ = GeneratedSerializer.prototype.patch_mynpiu$;
  PACK_FLOAT = '\nvec4 packFloat(const in float value) {\n\tconst vec4 bit_shift = vec4(256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0);\n\tconst vec4 bit_mask  = vec4(0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);\n\tvec4 res = fract(value * bit_shift);\n\tres -= res.xxyz * bit_mask;\n\treturn res;\n}\n';
  UNPACK_FLOAT = '\nfloat unpackFloat(const in vec4 rgba_depth) {\n\tconst vec4 bit_shift = vec4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1.0);\n\tfloat depth = dot(rgba_depth, bit_shift);\n\treturn depth;\n}\n';
  HALF_PI = math.PI * 0.5;
  Kotlin.defineModule('acornui-acornui-game', _);
  return _;
}));

//# sourceMappingURL=acornui-acornui-game.js.map
