package com.addc.commons.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

/**
 * The JmxBeanImpl supplies a simple StandardMBean implementation of the
 * {@link JmxBean} interface.
 */
public abstract class JmxBeanImpl extends StandardMBean implements JmxBean {

    /**
     * Create a new JmxBeanImpl
     * 
     * @param mbeanInterface
     *            The MBean interface class
     */
    protected JmxBeanImpl(Class<?> mbeanInterface) {
        super(mbeanInterface, false);
    }

    private ObjectName name;

    @Override
    public ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName objName) throws Exception {
        this.name= objName;
        return objName;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        // By default do nothing
    }

    @Override
    public void preDeregister() throws Exception {
        // By default do nothing
    }

    @Override
    public void postDeregister() {
        // By default do nothing
    }
}
