package com.addc.commons.jmx.auth;

import java.security.PrivilegedAction;

/**
 * Utility class to be used by the method <tt>AccessControler.doPrivileged</tt>
 * to get a system property.
 */
public class GetPropertyAction implements PrivilegedAction<String> {
    private final String key;

    /**
     * Create a new GetPropertyAction
     * 
     * @param key
     *            The key
     */
    public GetPropertyAction(String key) {
        this.key= key;
    }

    @Override
    public String run() {
        return System.getProperty(key);
    }
}
