package com.addc.commons.jmx.auth;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

/**
 * 
 * The UserDetails object is used to store details about users
 */
class UserDetails {
    private final String userName;
    private final String passwd;
    private final Set<String> roles;

    /**
     * 
     * Create a new UserDetails
     * 
     * @param userName
     *            The user
     * @param details
     *            the details
     */
    @SuppressWarnings("PMD.AvoidThrowingNullPointerException")
    UserDetails(String userName, String details) {
        if (userName == null) {
            throw new NullPointerException("userName cannot be null");
        }
        if (details == null) {
            throw new NullPointerException("details cannot be null");
        }
        this.userName= userName;
        this.roles= new HashSet<>();
        String[] parts= StringUtils.split(details, ',');
        this.passwd= parts[0];
        for (int i= 1; i < parts.length; i++) {
            roles.add(parts[i]);
        }
    }

    /**
     * Get the userName
     * 
     * @return the userName
     */
    public String getUserName() {
        return userName;
    }

    /**
     * Get the passwd
     * 
     * @return the passwd
     */
    public String getPasswd() {
        return passwd;
    }

    /**
     * Get the roles
     * 
     * @return the roles
     */
    public Set<String> getRoles() {
        return roles;
    }

}
