package com.addc.commons.jmx.configuration;

import javax.management.remote.JMXServiceURL;

/**
 * The IMbJMXConfig interface defines the methods available to JMX
 */
public interface IMbJMXConfig {

    /**
     * Get the registryPort
     * 
     * @return the registryPort
     */
    Integer getRegistryPort();

    /**
     * Get the rmi hostname
     * 
     * @return the rmi hostname
     */
    String getRmiHostname();

    /**
     * Get the usersFileName
     * 
     * @return the usersFileName
     */
    String getUsersFileName();

    /**
     * Query whether SLP is enabled
     * 
     * @return whether SLP is enabled
     */
    boolean isSlpEnabled();

    /**
     * Get the slpLeaseTimeSecs
     * 
     * @return the slpLeaseTimeSecs
     */
    int getSlpLeaseTimeSecs();

    /**
     * Get the slpAgentName
     * 
     * @return the slpAgentName
     */
    String getSlpAgentName();

    /**
     * Query whether authentication will be based on local files
     * 
     * @return whether authentication will be based on local files
     */
    boolean isAuthFileBased();

    /**
     * Get the serviceUrl
     * 
     * @return the serviceUrl
     */
    JMXServiceURL getServiceUrl();

    /**
     * Get the Role name for administration
     * 
     * @return the Role name for administration
     */
    String getAdminRole();

    /**
     * Get the Role name for monitoring
     * 
     * @return the Role name for monitoring
     */
    String getMonitorRole();

}