/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.bark;

import com.addthis.bark.StringSerializer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkGroupMembership {
    private static final Logger log = LoggerFactory.getLogger(ZkGroupMembership.class);
    private static final int zkConnectionTimeout = Integer.parseInt(System.getProperty("zk.connectionTimeout", "60000"));
    private static final int RETRYS = 5;
    private CuratorFramework zkClient;
    private final boolean ephemeral;

    public ZkGroupMembership(CuratorFramework zkClient) {
        this(zkClient, true);
    }

    public ZkGroupMembership(CuratorFramework zkClient, boolean ephemeral) {
        this.zkClient = zkClient;
        this.ephemeral = ephemeral;
    }

    public void addToGroup(String parentPath, String member) {
        this.addToGroup(parentPath, member, "", null);
    }

    public void addToGroup(String parentPath, String member, AtomicBoolean shutdown) {
        this.addToGroup(parentPath, member, "", shutdown);
    }

    public void addToGroup(String parentPath, String member, String data) {
        this.addToGroup(parentPath, member, data, null);
    }

    public void addToGroup(String parentPath, String member, String data, AtomicBoolean shutdown) {
        block12: {
            String path = parentPath + "/" + member;
            int remaining = zkConnectionTimeout;
            try {
                while (!(this.zkClient.checkExists().forPath(path) == null || shutdown != null && shutdown.get())) {
                    if (remaining <= 0) {
                        throw new RuntimeException("cannot overwrite existing path: " + path);
                    }
                    log.info("[group.add] path already exists, retrying: {}", (Object)path);
                    remaining -= zkConnectionTimeout / 5;
                    try {
                        Thread.sleep(zkConnectionTimeout / 5);
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Exception e) {
                throw new RuntimeException("[group.add] unexpected exception adding to group: " + path, e);
            }
            if (shutdown != null && shutdown.get()) {
                return;
            }
            try {
                try {
                    if (this.ephemeral) {
                        ((ACLBackgroundPathAndBytesable)this.zkClient.create().withMode(CreateMode.EPHEMERAL)).forPath(path, StringSerializer.serialize(data));
                        break block12;
                    }
                    this.zkClient.create().forPath(path, StringSerializer.serialize(data));
                }
                catch (KeeperException.NodeExistsException e) {
                    this.zkClient.setData().forPath(path, StringSerializer.serialize(data));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("[group.add] unable to create node", e);
            }
        }
    }

    public void removeFromGroup(String parentPath, String member) {
        try {
            this.zkClient.delete().deletingChildrenIfNeeded().forPath(parentPath + "/" + member);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to remove: " + member + " from group", e);
        }
    }

    public List<String> listenToGroup(String parentPath, PathChildrenCacheListener listener) throws Exception {
        return this.listenToGroup(parentPath, listener, false);
    }

    public List<String> listenToGroup(String parentPath, PathChildrenCacheListener listener, boolean cacheData) throws Exception {
        PathChildrenCache cache = new PathChildrenCache(this.zkClient, parentPath, cacheData);
        cache.getListenable().addListener((Object)listener);
        cache.start();
        return (List)this.zkClient.getChildren().forPath(parentPath);
    }
}

