/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.bark;

import java.io.IOException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.test.TestingServer;
import org.junit.After;
import org.junit.Before;

public class ZkStartUtil {
    protected TestingServer myKeeper;
    protected CuratorFramework zkClient;

    @Before
    public void startKeepers() throws Exception {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        this.myKeeper = new TestingServer(17023);
        String keeperPort = String.valueOf(this.myKeeper.getPort());
        System.setProperty("zk.servers", "localhost:" + keeperPort);
        this.zkClient = CuratorFrameworkFactory.builder().connectString(this.myKeeper.getConnectString()).retryPolicy((RetryPolicy)new RetryOneTime(1)).build();
        this.zkClient.start();
        this.onAfterZKStart();
    }

    @After
    public void stopKeepers() throws IOException {
        this.zkClient.close();
        this.myKeeper.stop();
        this.onAfterZKStop();
    }

    protected void onAfterZKStart() {
    }

    protected void onAfterZKStop() {
    }
}

