/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.bark;

import com.addthis.basis.util.Parameter;
import javax.annotation.Nonnull;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class ZkUtil {
    private static final String zkHosts = Parameter.value((String)"zk.servers", (String)"127.0.0.1:2181");
    private static final String zkChroot = Parameter.value((String)"zk.chroot", (String)"");
    private static final int zkSessionTimeout = Integer.parseInt(System.getProperty("zk.sessionTimeout", "600000"));
    private static final int zkConnectionTimeout = Integer.parseInt(System.getProperty("zk.connectionTimeout", "180000"));
    private static final int baseZkRetryTimeMs = Integer.parseInt(System.getProperty("zk.zkRetryTimeMs", "1000"));
    private static final int zkRetryMaxAttempts = Integer.parseInt(System.getProperty("zk.baseZkRetryMaxAttempts", "25"));

    public static CuratorFramework makeStandardClient() {
        return ZkUtil.makeCustomChrootClient(zkHosts, zkChroot);
    }

    public static CuratorFramework makeStandardClient(String zkHosts, boolean useChroot) {
        String chroot = useChroot ? "/" + zkChroot : "";
        return ZkUtil.makeCustomChrootClient(zkHosts, chroot);
    }

    public static CuratorFramework makeCustomChrootClient(String chroot) {
        return ZkUtil.makeCustomChrootClient(zkHosts, chroot);
    }

    static String stripTrailingSlash(@Nonnull String input) {
        if (input.endsWith("/")) {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }

    public static CuratorFramework makeCustomChrootClient(String zkHosts, String chroot) {
        CuratorFramework framework = CuratorFrameworkFactory.builder().sessionTimeoutMs(zkSessionTimeout).connectionTimeoutMs(zkConnectionTimeout).connectString(ZkUtil.stripTrailingSlash(zkHosts + "/" + chroot)).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(baseZkRetryTimeMs, zkRetryMaxAttempts)).defaultData(null).build();
        framework.start();
        return framework;
    }
}

