/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.oaid;

import android.content.Context;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.oaid.OaidInfo;
import com.bun.miitmdid.core.MdidSdkHelper;
import com.bun.miitmdid.interfaces.IIdentifierListener;
import com.bun.miitmdid.interfaces.IdSupplier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MsaSdkClient {
    public static OaidInfo getOaidInfo(Context context, final ILogger logger, long maxWaitTimeInMilli) {
        final LinkedBlockingQueue oaidInfoHolder = new LinkedBlockingQueue(1);
        try {
            boolean msaInternalLogging = false;
            int result = MdidSdkHelper.InitSdk((Context)context, (boolean)msaInternalLogging, (IIdentifierListener)new IIdentifierListener(){

                public void onSupport(IdSupplier idSupplier) {
                    try {
                        if (idSupplier == null || idSupplier.getOAID() == null) {
                            oaidInfoHolder.offer(new OaidInfo(null, false));
                        } else {
                            oaidInfoHolder.offer(new OaidInfo(idSupplier.getOAID(), !idSupplier.isLimited()));
                        }
                    }
                    catch (Exception e) {
                        logger.error("Fail to add %s", new Object[]{e.getMessage()});
                    }
                }
            });
            if (!MsaSdkClient.isError(result, logger)) {
                return (OaidInfo)oaidInfoHolder.poll(maxWaitTimeInMilli, TimeUnit.MILLISECONDS);
            }
        }
        catch (NoClassDefFoundError ex) {
            logger.error("Couldn't find msa sdk " + ex.getMessage(), new Object[0]);
        }
        catch (InterruptedException e) {
            logger.error("Waiting to read oaid from callback interrupted: %s", new Object[]{e.getMessage()});
        }
        catch (Throwable t) {
            logger.error("Oaid reading process failed %s", new Object[]{t.getMessage()});
        }
        return null;
    }

    private static boolean isError(int result, ILogger logger) {
        switch (result) {
            case 1008616: {
                logger.error("msa sdk error - INIT_ERROR_CERT_ERROR", new Object[0]);
                return true;
            }
            case 1008612: {
                logger.error("msa sdk error - INIT_ERROR_DEVICE_NOSUPPORT", new Object[0]);
                return true;
            }
            case 1008613: {
                logger.error("msa sdk error - INIT_ERROR_LOAD_CONFIGFILE", new Object[0]);
                return true;
            }
            case 1008611: {
                logger.error("msa sdk error - INIT_ERROR_MANUFACTURER_NOSUPPORT", new Object[0]);
                return true;
            }
            case 1008615: {
                logger.error("msa sdk error - INIT_ERROR_SDK_CALL_ERROR", new Object[0]);
                return true;
            }
        }
        return false;
    }
}

