/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.oaid;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.oaid.AdjustOaid;
import com.adjust.sdk.oaid.HmsSdkClient;
import com.adjust.sdk.oaid.MsaSdkClient;
import com.adjust.sdk.oaid.OaidInfo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class Util {
    public static synchronized Map<String, String> getOaidParameters(Context context, ILogger logger) {
        if (!AdjustOaid.isOaidToBeRead) {
            return null;
        }
        if (Util.isManufacturerHuawei(logger)) {
            Map<String, String> oaidParameters = Util.getOaidParametersUsingHms(context, logger);
            if (oaidParameters != null) {
                return oaidParameters;
            }
            return Util.getOaidParametersUsingMsa(context, logger);
        }
        Map<String, String> oaidParameters = Util.getOaidParametersUsingMsa(context, logger);
        if (oaidParameters != null) {
            return oaidParameters;
        }
        return Util.getOaidParametersUsingHms(context, logger);
    }

    private static boolean isManufacturerHuawei(ILogger logger) {
        try {
            String manufacturer = Build.MANUFACTURER;
            if (manufacturer != null && manufacturer.equalsIgnoreCase("huawei")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.debug("Manufacturer not available", new Object[0]);
        }
        return false;
    }

    private static Map<String, String> getOaidParametersUsingHms(Context context, ILogger logger) {
        for (int attempt = 1; attempt <= 2; ++attempt) {
            OaidInfo oaidInfo = HmsSdkClient.getOaidInfo(context, logger, 3000 * attempt);
            if (oaidInfo == null || oaidInfo.getOaid() == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            PackageBuilder.addString(parameters, (String)"oaid", (String)oaidInfo.getOaid());
            PackageBuilder.addBoolean(parameters, (String)"oaid_tracking_enabled", (Boolean)oaidInfo.isTrackingEnabled());
            PackageBuilder.addString(parameters, (String)"oaid_src", (String)"hms");
            PackageBuilder.addLong(parameters, (String)"oaid_attempt", (long)attempt);
            return parameters;
        }
        logger.debug("Fail to read the OAID using HMS", new Object[0]);
        return null;
    }

    private static Map<String, String> getOaidParametersUsingMsa(Context context, ILogger logger) {
        if (!AdjustOaid.isMsaSdkAvailable) {
            return null;
        }
        for (int attempt = 1; attempt <= 2; ++attempt) {
            OaidInfo oaidInfo = MsaSdkClient.getOaidInfo(context, logger, 3000 * attempt);
            if (oaidInfo == null || oaidInfo.getOaid() == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            PackageBuilder.addString(parameters, (String)"oaid", (String)oaidInfo.getOaid());
            PackageBuilder.addBoolean(parameters, (String)"oaid_tracking_enabled", (Boolean)oaidInfo.isTrackingEnabled());
            PackageBuilder.addString(parameters, (String)"oaid_src", (String)"msa");
            PackageBuilder.addLong(parameters, (String)"oaid_attempt", (long)attempt);
            return parameters;
        }
        logger.debug("Fail to read the OAID using MSA", new Object[0]);
        return null;
    }

    public static String readCertFromAssetFile(Context context) {
        try {
            String line;
            String assetFileName = context.getPackageName() + ".cert.pem";
            InputStream is = context.getAssets().open(assetFileName);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
            return builder.toString();
        }
        catch (Exception e) {
            Log.e((String)"Adjust", (String)"readCertFromAssetFile failed");
            return "";
        }
    }
}

