/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk.webbridge;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.adjust.sdk.Adjust;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustEventFailure;
import com.adjust.sdk.AdjustEventSuccess;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustSessionFailure;
import com.adjust.sdk.AdjustSessionSuccess;
import com.adjust.sdk.AdjustThirdPartySharing;
import com.adjust.sdk.LogLevel;
import com.adjust.sdk.OnAttributionChangedListener;
import com.adjust.sdk.OnDeeplinkResponseListener;
import com.adjust.sdk.OnDeviceIdsRead;
import com.adjust.sdk.OnEventTrackingFailedListener;
import com.adjust.sdk.OnEventTrackingSucceededListener;
import com.adjust.sdk.OnSessionTrackingFailedListener;
import com.adjust.sdk.OnSessionTrackingSucceededListener;
import com.adjust.sdk.webbridge.AdjustBridgeUtil;
import com.adjust.sdk.webbridge.FacebookSDKJSInterface;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdjustBridgeInstance {
    private static final String LOG_LEVEL_VERBOSE = "VERBOSE";
    private static final String LOG_LEVEL_DEBUG = "DEBUG";
    private static final String LOG_LEVEL_INFO = "INFO";
    private static final String LOG_LEVEL_WARN = "WARN";
    private static final String LOG_LEVEL_ERROR = "ERROR";
    private static final String LOG_LEVEL_ASSERT = "ASSERT";
    private static final String LOG_LEVEL_SUPPRESS = "SUPPRESS";
    private static final String JAVASCRIPT_INTERFACE_NAME = "AdjustBridge";
    private static final String FB_JAVASCRIPT_INTERFACE_NAME_PREFIX = "fbmq_";
    private WebView webView;
    private Application application;
    private boolean isInitialized = false;
    private boolean shouldDeferredDeeplinkBeLaunched = true;
    private FacebookSDKJSInterface facebookSDKJSInterface = null;

    AdjustBridgeInstance() {
    }

    AdjustBridgeInstance(Application application, WebView webView) {
        this.application = application;
        this.setWebView(webView);
    }

    private boolean isInitialized() {
        if (this.webView == null) {
            AdjustBridgeUtil.getLogger().error("Webview missing. Call AdjustBridge.setWebView before", new Object[0]);
            return false;
        }
        if (this.application == null) {
            AdjustBridgeUtil.getLogger().error("Application context missing. Call AdjustBridge.setApplicationContext before", new Object[0]);
            return false;
        }
        return true;
    }

    public void registerFacebookSDKJSInterface() {
        String fbApplicationId = FacebookSDKJSInterface.getApplicationId(this.application.getApplicationContext());
        AdjustFactory.getLogger().info("AdjustBridgeInstance fbApplicationId: %s", new Object[]{fbApplicationId});
        if (fbApplicationId == null) {
            return;
        }
        this.facebookSDKJSInterface = new FacebookSDKJSInterface();
        if (Build.VERSION.SDK_INT >= 17) {
            this.webView.addJavascriptInterface((Object)this.facebookSDKJSInterface, FB_JAVASCRIPT_INTERFACE_NAME_PREFIX + fbApplicationId);
        }
    }

    @JavascriptInterface
    public void onCreate(String adjustConfigString) {
        if (this.isInitialized) {
            AdjustBridgeUtil.getLogger().warn("Adjust bridge is already initialized. Ignoring further attempts", new Object[0]);
            return;
        }
        if (!this.isInitialized()) {
            return;
        }
        try {
            Boolean coppaCompliantEnabled;
            Boolean playStoreKidsAppEnabled;
            String preinstallFilePath;
            Boolean preinstallTrackingEnabled;
            String fbPixelDefaultEventToken;
            String userAgent;
            Double delayStart;
            String deferredDeeplinkCallbackName;
            Boolean openDeferredDeeplink;
            String sessionFailureCallbackName;
            String sessionSuccessCallbackName;
            String eventFailureCallbackName;
            String eventSuccessCallbackName;
            Boolean needsCost;
            Boolean deviceKnown;
            String attributionCallbackName;
            String externalDeviceId;
            String defaultTracker;
            String processName;
            String sdkPrefix;
            String logLevelString;
            Boolean sendInBackground;
            AdjustBridgeUtil.getLogger().verbose("Web bridge onCreate adjustConfigString: " + adjustConfigString, new Object[0]);
            JSONObject jsonAdjustConfig = new JSONObject(adjustConfigString);
            Object appTokenField = jsonAdjustConfig.get("appToken");
            Object environmentField = jsonAdjustConfig.get("environment");
            Object allowSuppressLogLevelField = jsonAdjustConfig.get("allowSuppressLogLevel");
            Object eventBufferingEnabledField = jsonAdjustConfig.get("eventBufferingEnabled");
            Object sendInBackgroundField = jsonAdjustConfig.get("sendInBackground");
            Object logLevelField = jsonAdjustConfig.get("logLevel");
            Object sdkPrefixField = jsonAdjustConfig.get("sdkPrefix");
            Object processNameField = jsonAdjustConfig.get("processName");
            Object defaultTrackerField = jsonAdjustConfig.get("defaultTracker");
            Object externalDeviceIdField = jsonAdjustConfig.get("externalDeviceId");
            Object attributionCallbackNameField = jsonAdjustConfig.get("attributionCallbackName");
            Object deviceKnownField = jsonAdjustConfig.get("deviceKnown");
            Object needsCostField = jsonAdjustConfig.get("needsCost");
            Object eventSuccessCallbackNameField = jsonAdjustConfig.get("eventSuccessCallbackName");
            Object eventFailureCallbackNameField = jsonAdjustConfig.get("eventFailureCallbackName");
            Object sessionSuccessCallbackNameField = jsonAdjustConfig.get("sessionSuccessCallbackName");
            Object sessionFailureCallbackNameField = jsonAdjustConfig.get("sessionFailureCallbackName");
            Object openDeferredDeeplinkField = jsonAdjustConfig.get("openDeferredDeeplink");
            Object deferredDeeplinkCallbackNameField = jsonAdjustConfig.get("deferredDeeplinkCallbackName");
            Object delayStartField = jsonAdjustConfig.get("delayStart");
            Object userAgentField = jsonAdjustConfig.get("userAgent");
            Object secretIdField = jsonAdjustConfig.get("secretId");
            Object info1Field = jsonAdjustConfig.get("info1");
            Object info2Field = jsonAdjustConfig.get("info2");
            Object info3Field = jsonAdjustConfig.get("info3");
            Object info4Field = jsonAdjustConfig.get("info4");
            Object fbPixelDefaultEventTokenField = jsonAdjustConfig.get("fbPixelDefaultEventToken");
            Object fbPixelMappingField = jsonAdjustConfig.get("fbPixelMapping");
            Object urlStrategyField = jsonAdjustConfig.get("urlStrategy");
            Object preinstallTrackingEnabledField = jsonAdjustConfig.get("preinstallTrackingEnabled");
            Object preinstallFilePathField = jsonAdjustConfig.get("preinstallFilePath");
            Object playStoreKidsAppEnabledField = jsonAdjustConfig.get("playStoreKidsAppEnabled");
            Object coppaCompliantEnabledField = jsonAdjustConfig.get("coppaCompliantEnabled");
            String appToken = AdjustBridgeUtil.fieldToString(appTokenField);
            String environment = AdjustBridgeUtil.fieldToString(environmentField);
            Boolean allowSuppressLogLevel = AdjustBridgeUtil.fieldToBoolean(allowSuppressLogLevelField);
            AdjustConfig adjustConfig = allowSuppressLogLevel == null ? new AdjustConfig(this.application.getApplicationContext(), appToken, environment) : new AdjustConfig(this.application.getApplicationContext(), appToken, environment, allowSuppressLogLevel.booleanValue());
            if (!adjustConfig.isValid()) {
                return;
            }
            Boolean eventBufferingEnabled = AdjustBridgeUtil.fieldToBoolean(eventBufferingEnabledField);
            if (eventBufferingEnabled != null) {
                adjustConfig.setEventBufferingEnabled(eventBufferingEnabled);
            }
            if ((sendInBackground = AdjustBridgeUtil.fieldToBoolean(sendInBackgroundField)) != null) {
                adjustConfig.setSendInBackground(sendInBackground.booleanValue());
            }
            if ((logLevelString = AdjustBridgeUtil.fieldToString(logLevelField)) != null) {
                if (logLevelString.equalsIgnoreCase(LOG_LEVEL_VERBOSE)) {
                    adjustConfig.setLogLevel(LogLevel.VERBOSE);
                } else if (logLevelString.equalsIgnoreCase(LOG_LEVEL_DEBUG)) {
                    adjustConfig.setLogLevel(LogLevel.DEBUG);
                } else if (logLevelString.equalsIgnoreCase(LOG_LEVEL_INFO)) {
                    adjustConfig.setLogLevel(LogLevel.INFO);
                } else if (logLevelString.equalsIgnoreCase(LOG_LEVEL_WARN)) {
                    adjustConfig.setLogLevel(LogLevel.WARN);
                } else if (logLevelString.equalsIgnoreCase(LOG_LEVEL_ERROR)) {
                    adjustConfig.setLogLevel(LogLevel.ERROR);
                } else if (logLevelString.equalsIgnoreCase(LOG_LEVEL_ASSERT)) {
                    adjustConfig.setLogLevel(LogLevel.ASSERT);
                } else if (logLevelString.equalsIgnoreCase(LOG_LEVEL_SUPPRESS)) {
                    adjustConfig.setLogLevel(LogLevel.SUPRESS);
                }
            }
            if ((sdkPrefix = AdjustBridgeUtil.fieldToString(sdkPrefixField)) != null) {
                adjustConfig.setSdkPrefix(sdkPrefix);
            }
            if ((processName = AdjustBridgeUtil.fieldToString(processNameField)) != null) {
                adjustConfig.setProcessName(processName);
            }
            if ((defaultTracker = AdjustBridgeUtil.fieldToString(defaultTrackerField)) != null) {
                adjustConfig.setDefaultTracker(defaultTracker);
            }
            if ((externalDeviceId = AdjustBridgeUtil.fieldToString(externalDeviceIdField)) != null) {
                adjustConfig.setExternalDeviceId(externalDeviceId);
            }
            if ((attributionCallbackName = AdjustBridgeUtil.fieldToString(attributionCallbackNameField)) != null) {
                adjustConfig.setOnAttributionChangedListener(new OnAttributionChangedListener(){

                    public void onAttributionChanged(AdjustAttribution attribution) {
                        AdjustBridgeUtil.execAttributionCallbackCommand(AdjustBridgeInstance.this.webView, attributionCallbackName, attribution);
                    }
                });
            }
            if ((deviceKnown = AdjustBridgeUtil.fieldToBoolean(deviceKnownField)) != null) {
                adjustConfig.setDeviceKnown(deviceKnown.booleanValue());
            }
            if ((needsCost = AdjustBridgeUtil.fieldToBoolean(needsCostField)) != null) {
                adjustConfig.setNeedsCost(needsCost.booleanValue());
            }
            if ((eventSuccessCallbackName = AdjustBridgeUtil.fieldToString(eventSuccessCallbackNameField)) != null) {
                adjustConfig.setOnEventTrackingSucceededListener(new OnEventTrackingSucceededListener(){

                    public void onFinishedEventTrackingSucceeded(AdjustEventSuccess eventSuccessResponseData) {
                        AdjustBridgeUtil.execEventSuccessCallbackCommand(AdjustBridgeInstance.this.webView, eventSuccessCallbackName, eventSuccessResponseData);
                    }
                });
            }
            if ((eventFailureCallbackName = AdjustBridgeUtil.fieldToString(eventFailureCallbackNameField)) != null) {
                adjustConfig.setOnEventTrackingFailedListener(new OnEventTrackingFailedListener(){

                    public void onFinishedEventTrackingFailed(AdjustEventFailure eventFailureResponseData) {
                        AdjustBridgeUtil.execEventFailureCallbackCommand(AdjustBridgeInstance.this.webView, eventFailureCallbackName, eventFailureResponseData);
                    }
                });
            }
            if ((sessionSuccessCallbackName = AdjustBridgeUtil.fieldToString(sessionSuccessCallbackNameField)) != null) {
                adjustConfig.setOnSessionTrackingSucceededListener(new OnSessionTrackingSucceededListener(){

                    public void onFinishedSessionTrackingSucceeded(AdjustSessionSuccess sessionSuccessResponseData) {
                        AdjustBridgeUtil.execSessionSuccessCallbackCommand(AdjustBridgeInstance.this.webView, sessionSuccessCallbackName, sessionSuccessResponseData);
                    }
                });
            }
            if ((sessionFailureCallbackName = AdjustBridgeUtil.fieldToString(sessionFailureCallbackNameField)) != null) {
                adjustConfig.setOnSessionTrackingFailedListener(new OnSessionTrackingFailedListener(){

                    public void onFinishedSessionTrackingFailed(AdjustSessionFailure failureResponseData) {
                        AdjustBridgeUtil.execSessionFailureCallbackCommand(AdjustBridgeInstance.this.webView, sessionFailureCallbackName, failureResponseData);
                    }
                });
            }
            if ((openDeferredDeeplink = AdjustBridgeUtil.fieldToBoolean(openDeferredDeeplinkField)) != null) {
                this.shouldDeferredDeeplinkBeLaunched = openDeferredDeeplink;
            }
            if ((deferredDeeplinkCallbackName = AdjustBridgeUtil.fieldToString(deferredDeeplinkCallbackNameField)) != null) {
                adjustConfig.setOnDeeplinkResponseListener(new OnDeeplinkResponseListener(){

                    public boolean launchReceivedDeeplink(Uri deeplink) {
                        AdjustBridgeUtil.execSingleValueCallback(AdjustBridgeInstance.this.webView, deferredDeeplinkCallbackName, deeplink.toString());
                        return AdjustBridgeInstance.this.shouldDeferredDeeplinkBeLaunched;
                    }
                });
            }
            if ((delayStart = AdjustBridgeUtil.fieldToDouble(delayStartField)) != null) {
                adjustConfig.setDelayStart(delayStart.doubleValue());
            }
            if ((userAgent = AdjustBridgeUtil.fieldToString(userAgentField)) != null) {
                adjustConfig.setUserAgent(userAgent);
            }
            Long secretId = AdjustBridgeUtil.fieldToLong(secretIdField);
            Long info1 = AdjustBridgeUtil.fieldToLong(info1Field);
            Long info2 = AdjustBridgeUtil.fieldToLong(info2Field);
            Long info3 = AdjustBridgeUtil.fieldToLong(info3Field);
            Long info4 = AdjustBridgeUtil.fieldToLong(info4Field);
            if (secretId != null && info1 != null && info2 != null && info3 != null && info4 != null) {
                adjustConfig.setAppSecret(secretId.longValue(), info1.longValue(), info2.longValue(), info3.longValue(), info4.longValue());
            }
            if ((fbPixelDefaultEventToken = AdjustBridgeUtil.fieldToString(fbPixelDefaultEventTokenField)) != null && this.facebookSDKJSInterface != null) {
                this.facebookSDKJSInterface.setDefaultEventToken(fbPixelDefaultEventToken);
            }
            try {
                String[] fbPixelMapping = AdjustBridgeUtil.jsonArrayToArray((JSONArray)fbPixelMappingField);
                if (fbPixelMapping != null && this.facebookSDKJSInterface != null) {
                    for (int i = 0; i < fbPixelMapping.length; i += 2) {
                        String key = fbPixelMapping[i];
                        String value = fbPixelMapping[i + 1];
                        this.facebookSDKJSInterface.addFbPixelEventTokenMapping(key, value);
                    }
                }
            }
            catch (Exception e) {
                AdjustFactory.getLogger().error("AdjustBridgeInstance.configureFbPixel: %s", new Object[]{e.getMessage()});
            }
            String urlStrategy = AdjustBridgeUtil.fieldToString(urlStrategyField);
            if (urlStrategy != null) {
                adjustConfig.setUrlStrategy(urlStrategy);
            }
            if ((preinstallTrackingEnabled = AdjustBridgeUtil.fieldToBoolean(preinstallTrackingEnabledField)) != null) {
                adjustConfig.setPreinstallTrackingEnabled(preinstallTrackingEnabled.booleanValue());
            }
            if ((preinstallFilePath = AdjustBridgeUtil.fieldToString(preinstallFilePathField)) != null) {
                adjustConfig.setPreinstallFilePath(preinstallFilePath);
            }
            if ((playStoreKidsAppEnabled = AdjustBridgeUtil.fieldToBoolean(playStoreKidsAppEnabledField)) != null) {
                adjustConfig.setPlayStoreKidsAppEnabled(playStoreKidsAppEnabled.booleanValue());
            }
            if ((coppaCompliantEnabled = AdjustBridgeUtil.fieldToBoolean(coppaCompliantEnabledField)) != null) {
                adjustConfig.setCoppaCompliantEnabled(coppaCompliantEnabled.booleanValue());
            }
            Adjust.onCreate((AdjustConfig)adjustConfig);
            Adjust.onResume();
            this.isInitialized = true;
            if (Build.VERSION.SDK_INT >= 14) {
                this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AdjustLifecycleCallbacks());
            }
        }
        catch (Exception e) {
            AdjustFactory.getLogger().error("AdjustBridgeInstance onCreate: %s", new Object[]{e.getMessage()});
        }
    }

    @JavascriptInterface
    public void trackEvent(String adjustEventString) {
        if (!this.isInitialized()) {
            return;
        }
        try {
            String callbackId;
            String orderId;
            String[] partnerParameters;
            String[] callbackParameters;
            JSONObject jsonAdjustEvent = new JSONObject(adjustEventString);
            Object eventTokenField = jsonAdjustEvent.get("eventToken");
            Object revenueField = jsonAdjustEvent.get("revenue");
            Object currencyField = jsonAdjustEvent.get("currency");
            Object callbackParametersField = jsonAdjustEvent.get("callbackParameters");
            Object partnerParametersField = jsonAdjustEvent.get("partnerParameters");
            Object orderIdField = jsonAdjustEvent.get("orderId");
            Object callbackIdField = jsonAdjustEvent.get("callbackId");
            String eventToken = AdjustBridgeUtil.fieldToString(eventTokenField);
            AdjustEvent adjustEvent = new AdjustEvent(eventToken);
            if (!adjustEvent.isValid()) {
                return;
            }
            Double revenue = AdjustBridgeUtil.fieldToDouble(revenueField);
            String currency = AdjustBridgeUtil.fieldToString(currencyField);
            if (revenue != null && currency != null) {
                adjustEvent.setRevenue(revenue.doubleValue(), currency);
            }
            if ((callbackParameters = AdjustBridgeUtil.jsonArrayToArray((JSONArray)callbackParametersField)) != null) {
                for (int i = 0; i < callbackParameters.length; i += 2) {
                    String key = callbackParameters[i];
                    String value = callbackParameters[i + 1];
                    adjustEvent.addCallbackParameter(key, value);
                }
            }
            if ((partnerParameters = AdjustBridgeUtil.jsonArrayToArray((JSONArray)partnerParametersField)) != null) {
                for (int i = 0; i < partnerParameters.length; i += 2) {
                    String key = partnerParameters[i];
                    String value = partnerParameters[i + 1];
                    adjustEvent.addPartnerParameter(key, value);
                }
            }
            if ((orderId = AdjustBridgeUtil.fieldToString(orderIdField)) != null) {
                adjustEvent.setOrderId(orderId);
            }
            if ((callbackId = AdjustBridgeUtil.fieldToString(callbackIdField)) != null) {
                adjustEvent.setCallbackId(callbackId);
            }
            Adjust.trackEvent((AdjustEvent)adjustEvent);
        }
        catch (Exception e) {
            AdjustFactory.getLogger().error("AdjustBridgeInstance trackEvent: %s", new Object[]{e.getMessage()});
        }
    }

    @JavascriptInterface
    public void trackAdRevenue(String source, String payload) {
        try {
            String decodedPayload = URLDecoder.decode(payload, "UTF-8");
            JSONObject jsonPayload = new JSONObject(decodedPayload);
            Adjust.trackAdRevenue((String)source, (JSONObject)jsonPayload);
        }
        catch (JSONException je) {
            AdjustFactory.getLogger().debug("Ad revenue payload does not seem to be a valid JSON string", new Object[0]);
        }
        catch (UnsupportedEncodingException ue) {
            AdjustFactory.getLogger().debug("Unable to URL decode given JSON string", new Object[0]);
        }
    }

    @JavascriptInterface
    public void onResume() {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.onResume();
    }

    @JavascriptInterface
    public void onPause() {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.onPause();
    }

    @JavascriptInterface
    public void setEnabled(String isEnabledString) {
        if (!this.isInitialized()) {
            return;
        }
        Boolean isEnabled = AdjustBridgeUtil.fieldToBoolean(isEnabledString);
        if (isEnabled != null) {
            Adjust.setEnabled((boolean)isEnabled);
        }
    }

    @JavascriptInterface
    public void isEnabled(String callback) {
        if (!this.isInitialized()) {
            return;
        }
        boolean isEnabled = Adjust.isEnabled();
        AdjustBridgeUtil.execSingleValueCallback(this.webView, callback, String.valueOf(isEnabled));
    }

    @JavascriptInterface
    public boolean isEnabled() {
        if (!this.isInitialized()) {
            return false;
        }
        return Adjust.isEnabled();
    }

    @JavascriptInterface
    public void appWillOpenUrl(String deeplinkString) {
        if (!this.isInitialized()) {
            return;
        }
        Uri deeplink = null;
        if (deeplinkString != null) {
            deeplink = Uri.parse((String)deeplinkString);
        }
        Adjust.appWillOpenUrl((Uri)deeplink, (Context)this.application.getApplicationContext());
    }

    @JavascriptInterface
    public void setReferrer(String referrer) {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.setReferrer((String)referrer, (Context)this.application.getApplicationContext());
    }

    @JavascriptInterface
    public void setOfflineMode(String isOfflineString) {
        if (!this.isInitialized()) {
            return;
        }
        Boolean isOffline = AdjustBridgeUtil.fieldToBoolean(isOfflineString);
        if (isOffline != null) {
            Adjust.setOfflineMode((boolean)isOffline);
        }
    }

    @JavascriptInterface
    public void sendFirstPackages() {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.sendFirstPackages();
    }

    @JavascriptInterface
    public void addSessionCallbackParameter(String key, String value) {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.addSessionCallbackParameter((String)key, (String)value);
    }

    @JavascriptInterface
    public void addSessionPartnerParameter(String key, String value) {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.addSessionPartnerParameter((String)key, (String)value);
    }

    @JavascriptInterface
    public void removeSessionCallbackParameter(String key) {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.removeSessionCallbackParameter((String)key);
    }

    @JavascriptInterface
    public void removeSessionPartnerParameter(String key) {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.removeSessionPartnerParameter((String)key);
    }

    @JavascriptInterface
    public void resetSessionCallbackParameters() {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.resetSessionCallbackParameters();
    }

    @JavascriptInterface
    public void resetSessionPartnerParameters() {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.resetSessionPartnerParameters();
    }

    @JavascriptInterface
    public void setPushToken(String pushToken) {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.setPushToken((String)pushToken, (Context)this.application.getApplicationContext());
    }

    @JavascriptInterface
    public void gdprForgetMe() {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.gdprForgetMe((Context)this.application.getApplicationContext());
    }

    @JavascriptInterface
    public void disableThirdPartySharing() {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.disableThirdPartySharing((Context)this.application.getApplicationContext());
    }

    @JavascriptInterface
    public void trackThirdPartySharing(String adjustThirdPartySharingString) {
        if (!this.isInitialized()) {
            return;
        }
        try {
            JSONObject jsonAdjustThirdPartySharing = new JSONObject(adjustThirdPartySharingString);
            Object isEnabledField = jsonAdjustThirdPartySharing.get("isEnabled");
            Object granularOptionsField = jsonAdjustThirdPartySharing.get("granularOptions");
            Boolean isEnabled = AdjustBridgeUtil.fieldToBoolean(isEnabledField);
            AdjustThirdPartySharing adjustThirdPartySharing = new AdjustThirdPartySharing(isEnabled);
            String[] granularOptions = AdjustBridgeUtil.jsonArrayToArray((JSONArray)granularOptionsField);
            if (granularOptions != null) {
                for (int i = 0; i < granularOptions.length; i += 3) {
                    String partnerName = granularOptions[i];
                    String key = granularOptions[i + 1];
                    String value = granularOptions[i + 2];
                    adjustThirdPartySharing.addGranularOption(partnerName, key, value);
                }
            }
            Adjust.trackThirdPartySharing((AdjustThirdPartySharing)adjustThirdPartySharing);
        }
        catch (Exception e) {
            AdjustFactory.getLogger().error("AdjustBridgeInstance trackThirdPartySharing: %s", new Object[]{e.getMessage()});
        }
    }

    @JavascriptInterface
    public void trackMeasurementConsent(String consentMeasurementString) {
        if (!this.isInitialized()) {
            return;
        }
        Boolean consentMeasurement = AdjustBridgeUtil.fieldToBoolean(consentMeasurementString);
        if (consentMeasurement != null) {
            Adjust.trackMeasurementConsent((boolean)consentMeasurement);
        }
    }

    @JavascriptInterface
    public void getGoogleAdId(final String callback) {
        if (!this.isInitialized()) {
            return;
        }
        Adjust.getGoogleAdId((Context)this.application.getApplicationContext(), (OnDeviceIdsRead)new OnDeviceIdsRead(){

            public void onGoogleAdIdRead(String googleAdId) {
                AdjustBridgeUtil.execSingleValueCallback(AdjustBridgeInstance.this.webView, callback, googleAdId);
            }
        });
    }

    @JavascriptInterface
    public String getAmazonAdId() {
        if (!this.isInitialized()) {
            return null;
        }
        return Adjust.getAmazonAdId((Context)this.application.getApplicationContext());
    }

    @JavascriptInterface
    public String getAdid() {
        if (!this.isInitialized()) {
            return null;
        }
        return Adjust.getAdid();
    }

    @JavascriptInterface
    public void getAttribution(String callback) {
        if (!this.isInitialized()) {
            return;
        }
        AdjustAttribution attribution = Adjust.getAttribution();
        AdjustBridgeUtil.execAttributionCallbackCommand(this.webView, callback, attribution);
    }

    @JavascriptInterface
    public String getSdkVersion() {
        return Adjust.getSdkVersion();
    }

    @JavascriptInterface
    public void fbPixelEvent(String pixelId, String event_name, String jsonString) {
        this.facebookSDKJSInterface.sendEvent(pixelId, event_name, jsonString);
    }

    @JavascriptInterface
    public void teardown() {
        this.isInitialized = false;
        this.shouldDeferredDeeplinkBeLaunched = true;
    }

    public void setWebView(WebView webView) {
        this.webView = webView;
        if (Build.VERSION.SDK_INT >= 17) {
            webView.addJavascriptInterface((Object)this, JAVASCRIPT_INTERFACE_NAME);
        }
    }

    public void setApplicationContext(Application application) {
        this.application = application;
    }

    public void unregister() {
        if (!this.isInitialized()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.webView.removeJavascriptInterface(JAVASCRIPT_INTERFACE_NAME);
        }
        this.unregisterFacebookSDKJSInterface();
        this.application = null;
        this.webView = null;
        this.isInitialized = false;
    }

    public void unregisterFacebookSDKJSInterface() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.facebookSDKJSInterface == null) {
            return;
        }
        String fbApplicationId = FacebookSDKJSInterface.getApplicationId(this.application.getApplicationContext());
        if (fbApplicationId == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.webView.removeJavascriptInterface(FB_JAVASCRIPT_INTERFACE_NAME_PREFIX + fbApplicationId);
        }
        this.facebookSDKJSInterface = null;
    }

    @TargetApi(value=14)
    private static final class AdjustLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private AdjustLifecycleCallbacks() {
        }

        public void onActivityResumed(Activity activity) {
            Adjust.onResume();
        }

        public void onActivityPaused(Activity activity) {
            Adjust.onPause();
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }
    }
}

