/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideField;
import com.adobe.aemds.guide.utils.AuthoringErrorMessages;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideCaptcha
extends GuideField {
    private static final Logger logger = LoggerFactory.getLogger(GuideCaptcha.class);

    public String getAuthoringAltText() {
        return this.externalize("Captcha");
    }

    @Override
    public String getGuideFieldType() {
        return "guideCaptcha";
    }

    public String getCaptchaService() {
        String captchaService = (String)this.resourceProps.get("captchaService", (Object)"");
        if ("afcaptcha".equals(captchaService)) {
            logger.error(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_DEFAULT_CAPTCHA_0001"));
        }
        return captchaService;
    }

    public String getLocale() {
        return GuideUtils.getAcceptLang(this.slingRequest);
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        String cloudServicePath = (String)this.resourceProps.get("rcCloudServicePath", String.class);
        if (StringUtils.equals((CharSequence)this.getCaptchaService(), (CharSequence)"recaptcha") && StringUtils.isBlank((CharSequence)cloudServicePath)) {
            authoringConfig.put("isRecaptchaConfigMissing", true);
        } else {
            authoringConfig.put("isRecaptchaConfigMissing", false);
        }
        return authoringConfig;
    }
}

