/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.GuideError;
import com.adobe.aemds.guide.common.GuideValidationResult;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideSubmitErrorCause;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideSubmitUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideSubmitUtils.class);
    public static final String REQUEST_ATTR_PDF_NAME = "pdfName";
    public static final String REQUEST_ATTR_REDIRECT_PARAMETER_MAP = "redirectParameters";
    public static final String REQ_ATTR_FORWARD_PATH = "forward.path";
    public static final String REQ_ATTR_FORWARD_OPTIONS = "forward.options";
    public static final String REQ_ATTR_GUIDE_SUBMIT_OPTIONS = "submit.options";

    public static void setForwardPath(SlingHttpServletRequest req, String path, String selector, String suffix) {
        req.setAttribute(REQ_ATTR_FORWARD_PATH, (Object)path);
        if (selector != null || suffix != null) {
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            if (selector != null) {
                options.setReplaceSelectors(selector);
            }
            if (suffix != null) {
                options.setReplaceSuffix(suffix);
            }
            req.setAttribute(REQ_ATTR_FORWARD_OPTIONS, (Object)options);
        }
    }

    public static void setRedirectUrl(SlingHttpServletRequest req, String redirectUrl) {
        req.setAttribute(":redirect", (Object)redirectUrl);
    }

    public static String getUserID(SlingHttpServletRequest request) {
        String userId = ((Session)request.getResourceResolver().adaptTo(Session.class)).getUserID();
        int index = userId.lastIndexOf(58);
        if (index > 0 && index + 1 < userId.length()) {
            userId = userId.substring(index + 1);
        }
        return userId;
    }

    public static Resource getParentResource(Resource resource, String jcrPrimaryType) {
        Resource parentResource = resource;
        String parentResourceType = null;
        if (resource == null) {
            return null;
        }
        if (jcrPrimaryType.isEmpty()) {
            return resource.getParent();
        }
        do {
            if ((parentResource = parentResource.getParent()) == null) continue;
            ValueMap properties = (ValueMap)parentResource.adaptTo(ValueMap.class);
            parentResourceType = (String)properties.get("jcr:primaryType", (Object)"");
        } while (!jcrPrimaryType.equals(parentResourceType));
        return parentResource;
    }

    public static Map<String, String> getRedirectParameters(SlingHttpServletRequest request) {
        HashMap<String, String> redirectParameters = (HashMap<String, String>)request.getAttribute(REQUEST_ATTR_REDIRECT_PARAMETER_MAP);
        if (redirectParameters == null) {
            redirectParameters = new HashMap<String, String>();
        }
        if (!redirectParameters.containsKey("owner")) {
            redirectParameters.put("owner", GuideSubmitUtils.getUserID(request));
        }
        if (!redirectParameters.containsKey("status")) {
            redirectParameters.put("status", "Submitted");
        }
        return redirectParameters;
    }

    private static void populateMap(JSONObject data, Map<String, String> map) throws JSONException {
        Iterator keys = data.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (data.get(key) instanceof JSONObject) {
                GuideSubmitUtils.populateMap((JSONObject)data.get(key), map);
                continue;
            }
            map.put(key, data.getString(key));
        }
    }

    public static String getNameOfCompositeFieldFromChildResource(@Nonnull Resource resource) {
        String name = null;
        Resource parent = resource.getParent();
        if (parent != null && StringUtils.equals((String)parent.getName(), (String)"items") && (parent = parent.getParent()) != null) {
            for (String compositeResourceType : GuideConstants.GUIDE_COMPOSITE_FIELD_RESOURCE_TYPES) {
                if (!parent.isResourceType(compositeResourceType)) continue;
                name = (String)parent.getValueMap().get("name", (Object)"");
                break;
            }
        }
        return name;
    }

    public static Map<String, String> getMappedFieldParameters(String[] fieldParameterMapping) {
        HashMap<String, String> mappedFieldParameters = new HashMap<String, String>();
        if (fieldParameterMapping != null) {
            for (String param : fieldParameterMapping) {
                String fieldName;
                String[] map = StringUtils.split((String)param, (String)"=");
                String mappedParam = fieldName = map[0].trim();
                if (map.length == 2) {
                    mappedParam = map[1].trim();
                }
                mappedFieldParameters.put(fieldName, mappedParam);
            }
        }
        return mappedFieldParameters;
    }

    public static void setRedirectParameters(SlingHttpServletRequest request, Map<String, String> value) {
        request.setAttribute(REQUEST_ATTR_REDIRECT_PARAMETER_MAP, value);
    }

    public static String getReqAttrPdfName(SlingHttpServletRequest request) {
        return (String)request.getAttribute(REQUEST_ATTR_PDF_NAME);
    }

    public static String addContextPath(String url, String contextPath) {
        if (StringUtils.isNotBlank((String)url)) {
            if (url.matches("^(https?)://.+")) {
                return url;
            }
            if (StringUtils.isNotBlank((String)contextPath) && !StringUtils.startsWith((String)url, (String)contextPath) && StringUtils.startsWith((String)url, (String)"/")) {
                url = contextPath + url;
            }
        }
        return url;
    }

    public static void handleValidationError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> submitResult) {
        if (response != null && submitResult != null && submitResult.containsKey("FormSubmissionError") && submitResult.get("FormSubmissionError") instanceof GuideValidationResult) {
            GuideValidationResult submitFailure = (GuideValidationResult)submitResult.get("FormSubmissionError");
            response.setStatus(500);
            request.setAttribute("FormSubmissionError", (Object)submitFailure);
        }
    }

    public static GuideValidationResult getDefaultGuideValidationResult() {
        return new GuideValidationResult(GuideSubmitErrorCause.FORM_SUBMISSION, "Error During Form Submission");
    }

    public static GuideValidationResult getGuideValidationResultFromString(String errorMessage, String status) {
        GuideValidationResult guideValidationResult = new GuideValidationResult(GuideSubmitErrorCause.FORM_SUBMISSION, status, errorMessage);
        try {
            JSONObject jsonObject = new JSONObject(errorMessage);
            GuideSubmitErrorCause errorCausedBy = null;
            String guideValidationErrorMessage = null;
            List errorList = null;
            if (jsonObject.has("errorCausedBy") && StringUtils.isNotEmpty((String)((String)jsonObject.get("errorCausedBy")))) {
                errorCausedBy = Enum.valueOf(GuideSubmitErrorCause.class, (String)jsonObject.get("errorCausedBy"));
            }
            if (jsonObject.has("errorMessage") && StringUtils.isNotEmpty((String)((String)jsonObject.get("errorMessage")))) {
                guideValidationErrorMessage = (String)jsonObject.get("errorMessage");
            }
            if (jsonObject.has("errors") && ((JSONArray)jsonObject.get("errors")).length() > 0) {
                String jsonArray = jsonObject.get("errors").toString();
                Gson gson = new Gson();
                Type type = new TypeToken<List<GuideError>>(){}.getType();
                errorList = (List)gson.fromJson(jsonArray, type);
            }
            if (errorCausedBy != null || errorList != null && !errorList.isEmpty()) {
                if (errorCausedBy == null) {
                    errorCausedBy = GuideSubmitErrorCause.FORM_SUBMISSION;
                }
                GuideValidationResult guideValidationResultParsed = new GuideValidationResult(errorCausedBy, guideValidationErrorMessage, errorList);
                String originMessage = null;
                String originCode = null;
                if (jsonObject.has("originMessage")) {
                    originMessage = (String)jsonObject.get("originMessage");
                }
                if (jsonObject.has("originCode")) {
                    originCode = (String)jsonObject.get("originCode");
                }
                guideValidationResultParsed.setOriginDetails(originCode, originMessage);
                guideValidationResult = guideValidationResultParsed;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return guideValidationResult;
    }

    public static void addValidationErrorToResult(Map<String, Object> result, GuideSubmitErrorCause errorCause, String errorMessage, String originCode) {
        GuideValidationResult guideValidationResult = new GuideValidationResult(errorCause, errorMessage);
        guideValidationResult.setOriginDetails(originCode, null);
        result.put("FormSubmissionError", guideValidationResult);
    }
}

