/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.common.submitutils;

import com.adobe.forms.common.submitutils.ParameterMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;

public class CustomParameterRequest
extends SlingHttpServletRequestWrapper {
    private ParameterMap parameters;
    private String method;

    public CustomParameterRequest(SlingHttpServletRequest request, ParameterMap params, String method) {
        super(request);
        this.parameters = params;
        this.method = method;
    }

    public CustomParameterRequest(SlingHttpServletRequest request, String method) {
        super(request);
        this.method = method;
        this.parameters = new ParameterMap();
        this.parameters.putAll(request.getRequestParameterMap());
    }

    public RequestParameter getRequestParameter(String name) {
        return this.parameters.getValue(name);
    }

    public RequestParameterMap getRequestParameterMap() {
        return this.parameters;
    }

    public RequestParameter[] getRequestParameters(String name) {
        return this.parameters.getValues(name);
    }

    public String getParameter(String name) {
        return this.parameters.getStringValue(name);
    }

    public Map getParameterMap() {
        return this.parameters.getStringParameterMap();
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.getStringValues(name);
    }

    public String getMethod() {
        return this.method;
    }
}

