/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.exception;

import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aemfd.dermis.authentication.exception.DermisLogger;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class DermisValidationException
extends DermisException {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, List<String>> violations;

    public DermisValidationException(Map<String, List<String>> violations) {
        super("AEM-FDM-001-044", 1);
        this.violations = violations;
    }

    public Map<String, List<String>> getViolations() {
        return this.violations;
    }

    @Override
    public JSONObject getJson() {
        JSONObject jsonObject = super.getJson();
        try {
            String violationsStr = objectMapper.writeValueAsString(this.violations);
            jsonObject.put("violations", (Object)new JSONObject(violationsStr));
        }
        catch (JsonProcessingException | JSONException e) {
            DermisLogger.logErrorAndDebug(DermisValidationException.class, "Error while creating json object", (Exception)e);
        }
        return jsonObject;
    }
}

