/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.model.ExtraPropertyType;
import com.adobe.aem.dermis.model.Type;
import com.adobe.aem.dermis.model.value.CustomDate;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public enum PropertyFormatType {
    INT8("int8", Byte.class),
    INT16("int16", Short.class),
    INT32("int32", Integer.class),
    INT64("int64", Long.class),
    FLOAT("float", Float.class),
    DOUBLE("double", Double.class),
    DECIMAL("decimal", BigDecimal.class),
    DATE("date", CustomDate.class),
    DATETIME("date-time", Date.class),
    BINARY("binary", byte[].class),
    BYTE("byte", byte[].class),
    BIGINT("bigint", BigInteger.class),
    UUID("uuid", UUID.class);

    private static final Map<String, PropertyFormatType> typeMap;
    private final String text;
    private final Class classType;

    public static PropertyFormatType lookUp(String name) {
        PropertyFormatType result = null;
        if (StringUtils.isEmpty((String)name)) {
            throw new NullPointerException("Name is null");
        }
        if (typeMap.containsKey(name.toLowerCase())) {
            result = typeMap.get(name.toLowerCase());
        } else {
            try {
                result = Enum.valueOf(PropertyFormatType.class, name.trim().toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static PropertyFormatType getFormatType(Class classType) {
        PropertyFormatType type = null;
        if (classType != null) {
            for (PropertyFormatType formatType : PropertyFormatType.values()) {
                if (!classType.equals(formatType.classType)) continue;
                type = formatType;
                break;
            }
        }
        return type;
    }

    private PropertyFormatType(String text, Class classType) {
        this.text = text;
        this.classType = classType;
    }

    public Class getClassType() {
        return this.classType;
    }

    public String toString() {
        return this.text;
    }

    static {
        typeMap = new HashMap<String, PropertyFormatType>();
        typeMap.put(ExtraPropertyType.file.name(), BINARY);
        typeMap.put(ExtraPropertyType.collection.name(), null);
        typeMap.put(ExtraPropertyType.ref.name(), null);
        typeMap.put(Type.SHORT.toString(), INT16);
        typeMap.put(Type.INTEGER.toString(), INT32);
        typeMap.put(Type.INT.toString(), INT32);
        typeMap.put(Type.UNSIGNEDSHORT.toString(), INT32);
        typeMap.put(Type.UNSIGNEDBYTE.toString(), INT32);
        typeMap.put(Type.LONG.toString(), INT64);
        typeMap.put(Type.UNSIGNEDINT.toString(), INT64);
        typeMap.put(Type.BASE64BINARY.toString(), BINARY);
        typeMap.put(Type.DATE_TIME.toString(), DATETIME);
    }
}

