/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model.value;

import com.adobe.aem.dermis.api.converter.ConverterService;
import com.adobe.aem.dermis.api.util.Assert;
import com.adobe.aem.dermis.api.util.DermisUtils;
import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.PropertyFormatType;
import com.adobe.aem.dermis.model.PropertyType;
import com.adobe.aem.dermis.model.value.AbstractValue;
import com.adobe.aem.dermis.model.value.ITypeValue;

public class TypeValue
extends AbstractValue
implements ITypeValue {
    private Object value;
    private PropertyType type;
    private PropertyFormatType formatType;

    private TypeValue(PropertyType type, Object value) {
        this.type = type;
        this.value = value;
    }

    private TypeValue(PropertyType type, PropertyFormatType formatType, Object value) {
        this(type, value);
        this.formatType = formatType;
    }

    @Override
    public Object get() {
        Object val = null;
        val = this.type != null ? this.get(DermisUtils.getJavaClassForTypeAndFormat((PropertyType)this.type, (PropertyFormatType)this.formatType)) : this.value;
        return val;
    }

    @Override
    public PropertyType getPropertyType() {
        return this.type;
    }

    @Override
    public PropertyFormatType getFormat() {
        return this.formatType;
    }

    @Override
    public <T> T get(Class<T> type) {
        ConverterService converterService = ConverterService.getInstance();
        return converterService.convert(this.value, type);
    }

    @Override
    public <T> T get(Class<T> type, T defaultValue) {
        T value = this.get(type);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Object getResult() {
        return this.value;
    }

    public static TypeValue of(PropertyType type, PropertyFormatType formatType, Object value) throws DermisException {
        Class classType;
        Object missingType = new Object();
        if (type == null && formatType == null) {
            missingType = null;
        }
        Assert.assertNotNull((Object)missingType, (String)"AEM-FDM-001-023");
        if (value != null && !(classType = DermisUtils.getJavaClassForTypeAndFormat((PropertyType)type, (PropertyFormatType)formatType)).isAssignableFrom(value.getClass())) {
            throw new DermisException("AEM-FDM-001-024", new String[]{classType.toString(), value.getClass().toString()});
        }
        TypeValue typeValue = new TypeValue(type, formatType, value);
        return typeValue;
    }

    @Override
    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }
}

