/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.AEMForm;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.Page;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class AdaptiveForm
extends AEMForm {
    public String getFormPagePath() {
        String formPath = super.getFormPath();
        Boolean isMCDocument = super.getIsMCDocument();
        if (isMCDocument.booleanValue()) {
            return GuideUtils.guideRefToDocPath(formPath);
        }
        return GuideUtils.guideRefToGuidePath(formPath);
    }

    @Override
    public String getFormEditPagePath() {
        String formPagePath = this.getFormPagePath();
        return formPagePath.substring(0, formPagePath.indexOf("/jcr:content"));
    }

    public String getFormTitle() {
        String pageTitle = this.getFormPageTitle();
        return pageTitle != null ? pageTitle : this.getFormPageName();
    }

    private String getFormPageTitle() {
        return this.getFormPage().getTitle();
    }

    private String getFormPageName() {
        return this.getFormPage().getName();
    }

    private Page getFormPage() {
        return (Page)this.getFormPageResource().adaptTo(Page.class);
    }

    private Resource getFormPageResource() {
        return this.getGuideContainerResource().getParent().getParent();
    }

    private Resource getGuideContainerResource() {
        return this.getResourceResolver().getResource(this.getFormPagePath());
    }

    public String getFormThemeName() {
        Resource resource = this.getResourceResolver().getResource(this.getFormPagePath());
        String formClientLib = this.getThemeName();
        if (StringUtils.isNotBlank((CharSequence)formClientLib) && resource != null) {
            ValueMap valueMap = resource.getValueMap();
            String formThemeRef = (String)valueMap.get("themeRef", (Object)"");
            formClientLib = this.getClientLibCategory(formThemeRef);
        }
        return formClientLib;
    }

    public String getLocaleString() {
        String lang = null;
        String usePageLocale = (String)this.mResourceProps.get((Object)"usePageLocale");
        if (usePageLocale != null && StringUtils.equals((CharSequence)usePageLocale, (CharSequence)"true")) {
            lang = this.getPageLocale();
        }
        if (StringUtils.isBlank(lang)) {
            lang = GuideUtils.getLocale(this.getRequest(), this.getGuideContainerResource());
        }
        return lang;
    }

    private String getPageLocale() {
        String pagePath = this.getCurrentPage().getPath();
        String pageLocaleRoot = LanguageUtil.getLanguageRoot((String)pagePath);
        String locale = null;
        if (StringUtils.isNotBlank((CharSequence)pageLocaleRoot)) {
            int localeStartIndex = StringUtils.lastIndexOf((CharSequence)pageLocaleRoot, (int)47);
            locale = StringUtils.substring((String)pageLocaleRoot, (int)(localeStartIndex + 1));
        }
        return locale;
    }
}

