/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideItemsContainer;
import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.fdfl.api.GuideIntegrationService;
import com.adobe.aemds.guide.fdfl.api.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuideSchemaType;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.commons.WCMUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.SimpleBindings;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class GuideContainer
extends GuideNode {
    private GuideModelTransformer guideModelTransformer = null;
    private String defaultDataXml = null;
    private boolean renderCall = false;

    public GuideContainer() {
    }

    public GuideContainer(SlingHttpServletRequest request, Resource resource) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("resource", (Object)resource);
        bindings.put("request", (Object)request);
        this.init(bindings);
    }

    public GuideContainer(Resource resource) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("resource", (Object)resource);
        this.init(bindings);
    }

    public String getRedirect() {
        String redirectUrl = (String)this.resourceProps.get("redirect", (Object)"");
        return GuideUtils.getRedirectUrl(redirectUrl, this.getPath());
    }

    private Boolean isOldResponsiveLayoutUsed() {
        Resource rootPanelResource = this.getResource().getChild("rootPanel");
        Boolean isOldResponsiveLayout = GuideUtils.isOldResponsiveLayout(rootPanelResource);
        if (isOldResponsiveLayout != null) {
            return isOldResponsiveLayout;
        }
        return Boolean.FALSE;
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        authoringConfig.put("oldResponsiveLayoutUsed", this.isOldResponsiveLayoutUsed());
        String themePath = this.getThemePath();
        if (!themePath.isEmpty()) {
            authoringConfig.put("themePath", themePath);
            String themeClientLibPath = this.getThemeClientLibPath();
            if (StringUtils.isNotEmpty((CharSequence)themeClientLibPath)) {
                authoringConfig.put("themeClientlibPath", themeClientLibPath);
            }
        }
        String referredSchemaOrXdp = null;
        try {
            String formType;
            String aftargetVersion;
            String afVersion = this.getVersion();
            if (StringUtils.isNotBlank((CharSequence)afVersion)) {
                authoringConfig.put("fd:version", afVersion);
            }
            if (StringUtils.isNotBlank((CharSequence)(aftargetVersion = this.getTargetVersion()))) {
                authoringConfig.put("fd:targetVersion", aftargetVersion);
            }
            if (StringUtils.isNotBlank((CharSequence)(formType = this.getFormType()))) {
                authoringConfig.put("fd:formtype", formType);
            }
            String ddRef = (String)this.resourceProps.get("ddRef", (Object)"");
            String letterRef = (String)this.resourceProps.get("letterRef", (Object)"");
            GuideSchemaType schemaType = this.getSchema();
            String schemaRef = this.getSchemaRef();
            if (StringUtils.isNotBlank((CharSequence)ddRef)) {
                referredSchemaOrXdp = ddRef;
                authoringConfig.put("ddRef", referredSchemaOrXdp);
            } else if (StringUtils.isNotBlank((CharSequence)letterRef)) {
                referredSchemaOrXdp = letterRef;
                authoringConfig.put("letterRef", referredSchemaOrXdp);
            } else if (GuideSchemaType.XDP.equals((Object)schemaType)) {
                referredSchemaOrXdp = schemaRef;
                authoringConfig.put("xdpRef", referredSchemaOrXdp);
            } else if (GuideSchemaType.XSD.equals((Object)schemaType)) {
                referredSchemaOrXdp = schemaRef;
                authoringConfig.put("xsdRef", referredSchemaOrXdp);
            } else if (StringUtils.isBlank((CharSequence)referredSchemaOrXdp) && StringUtils.isNotBlank((CharSequence)schemaRef)) {
                referredSchemaOrXdp = schemaRef;
                authoringConfig.put("schemaRef", referredSchemaOrXdp);
                if (GuideSchemaType.JSON.equals((Object)schemaType)) {
                    authoringConfig.put("schemaType", "jsonschema");
                } else if (GuideSchemaType.FDM.equals((Object)schemaType)) {
                    authoringConfig.put("schemaType", "formdatamodel");
                }
            }
            String dorType = this.getDoRType();
            authoringConfig.put("dorType", this.getDoRType());
            if (StringUtils.equals((CharSequence)dorType, (CharSequence)"generate")) {
                authoringConfig.put("dorTemplateRef", this.getDorTemplateRef());
            }
        }
        catch (Exception e) {
            this.logger.error("AF: Unable to fetch xsdRef or xdpRef" + e.getMessage(), (Throwable)e);
        }
        return authoringConfig;
    }

    public String getDoRType() {
        return (String)this.resourceProps.get("dorType", (Object)"none");
    }

    private String getThemePath() {
        return (String)this.resourceProps.get("themeRef", (Object)"");
    }

    private String getThemeClientLibPath() {
        String themeClientLibRef = "";
        String themePath = this.getThemePath();
        if (!themePath.isEmpty()) {
            themePath = themePath + "/" + "jcr:content";
            ResourceResolver resourceResolver = this.getResource().getResourceResolver();
            Resource themeResource = resourceResolver.getResource(themePath);
            if (themeResource == null) {
                return "";
            }
            themeClientLibRef = this.getClientLibPath(themeResource);
        }
        return themeClientLibRef;
    }

    private String getClientLibPath(Resource themeResource) {
        String path = null;
        if (themeResource != null) {
            path = this.getThemeClientLibPath(themeResource);
        }
        return path;
    }

    private String getThemeClientLibPath(Resource themeResource) {
        String clientLibPath = null;
        if (themeResource != null && themeResource.getParent() != null) {
            String themeNodeName = themeResource.getParent().getName();
            ResourceResolver resolver = themeResource.getResourceResolver();
            ValueMap themeMetaData = (ValueMap)themeResource.getChild("metadata").adaptTo(ValueMap.class);
            if (themeMetaData != null) {
                String path = (String)themeMetaData.get("clientlibRef", String.class) + "/" + themeNodeName;
                Resource clientLibResource = resolver.getResource(path);
                if (clientLibResource != null) {
                    clientLibPath = clientLibResource.getPath();
                } else {
                    this.logger.info("Theme client library missing at {}. Falling back to the default client library", (Object)path);
                }
            }
        }
        return clientLibPath;
    }

    public String getXdpRef() {
        return (String)this.resourceProps.get("xdpRef", (Object)"");
    }

    public String getLetterRef() {
        return (String)this.resourceProps.get("letterRef", (Object)"");
    }

    public String getMetaTemplateRef() {
        return GuideUtils.getMetaTemplateRef(this.getResource());
    }

    public String getAutoSaveStrategyFilePath() {
        String autoSaveStrategyType = (String)this.resourceProps.get("autoSaveStrategyType", (Object)"");
        if (autoSaveStrategyType != null && !autoSaveStrategyType.isEmpty()) {
            return autoSaveStrategyType;
        }
        return null;
    }

    public String getDorTemplateRef() {
        try {
            Resource guideContainer = this.getResource();
            ResourceResolver resourceResolver = guideContainer.getResourceResolver();
            String guideContainerPath = guideContainer.getPath();
            String runtimeLocale = this.slingRequest.getLocale().toString();
            return GuideUtils.getDoRTemplateRef(guideContainerPath, runtimeLocale, resourceResolver);
        }
        catch (Exception e) {
            this.logger.error("Error during fetching dorTemplateRef", (Throwable)e);
            return "";
        }
    }

    public Calendar getLastModifiedTime() {
        ValueMap properties = (ValueMap)this.getResource().getParent().adaptTo(ValueMap.class);
        return (Calendar)properties.get("cq:lastModified", Calendar.class);
    }

    public String getXsdRef() {
        return (String)this.resourceProps.get("xsdRef", (Object)"");
    }

    public String getSchemaRef() {
        String schemaRef = (String)this.resourceProps.get("xsdRef", (Object)"");
        if (StringUtils.isBlank((CharSequence)schemaRef)) {
            schemaRef = this.getPropertyFromContainingPage("xsdRef");
        }
        if (StringUtils.isBlank((CharSequence)schemaRef) && StringUtils.isBlank((CharSequence)(schemaRef = (String)this.resourceProps.get("xdpRef", (Object)"")))) {
            schemaRef = this.getPropertyFromContainingPage("xdpRef");
        }
        if (StringUtils.isBlank((CharSequence)schemaRef) && StringUtils.isBlank((CharSequence)(schemaRef = (String)this.resourceProps.get("schemaRef", (Object)"")))) {
            schemaRef = this.getPropertyFromContainingPage("schemaRef");
        }
        return schemaRef;
    }

    private String getPropertyFromContainingPage(String property) {
        PageManager pageManager;
        ResourceResolver resourceResolver;
        String retVal = null;
        Resource res = this.getResource();
        if (res != null && (resourceResolver = res.getResourceResolver()) != null && (pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class)) != null) {
            Page page = pageManager.getContainingPage(res);
            retVal = WCMUtils.getInheritedProperty((Page)page, (ResourceResolver)resourceResolver, (String)property);
        }
        return retVal;
    }

    public String getSchemaType() {
        return this.getSchema().getValue();
    }

    public String getPrefillService() {
        String prefillService = (String)this.resourceProps.get("prefillService", (Object)"");
        if (StringUtils.isBlank((CharSequence)prefillService)) {
            prefillService = this.getPropertyFromContainingPage("prefillService");
        }
        return prefillService;
    }

    public GuideSchemaType getSchema() {
        GuideSchemaType type = GuideSchemaType.BASIC;
        String schemaType = (String)this.resourceProps.get("schemaType", (Object)"");
        if (StringUtils.isNotBlank((CharSequence)schemaType)) {
            type = GuideSchemaType.getGuideSchemaType(schemaType);
        } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.resourceProps.get("xsdRef", (Object)"")))) {
            type = GuideSchemaType.XSD;
        } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.resourceProps.get("xdpRef", (Object)"")))) {
            type = GuideSchemaType.XDP;
        } else {
            String schemaTypeFromContainingPage = this.getPropertyFromContainingPage("schemaType");
            if (StringUtils.isNotBlank((CharSequence)schemaTypeFromContainingPage)) {
                type = GuideSchemaType.getGuideSchemaType(schemaTypeFromContainingPage);
            }
        }
        return type;
    }

    public String getCssFileRef() {
        return (String)this.resourceProps.get("cssFileRef", String.class);
    }

    @Override
    public String getClientLibRef() {
        return (String)this.resourceProps.get("clientLibRef", String.class);
    }

    public boolean isHasToolbar() {
        return this.getResource().getChild("toolbar") != null;
    }

    public String getAfPath() {
        return (String)this.resourceProps.get("afPath", String.class);
    }

    public GuideItemsContainer getToolbar() {
        Resource toolbarResource = this.getResource().getChild("toolbar");
        if (toolbarResource != null) {
            GuideItemsContainer guideItemsContainer = new GuideItemsContainer();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("resource", (Object)toolbarResource);
            bindings.put("request", (Object)this.slingRequest);
            guideItemsContainer.init(bindings);
            return guideItemsContainer;
        }
        return null;
    }

    public GuidePanel getRootPanel() {
        return GuideUtils.getRootPanel(this.getResource(), this.slingRequest);
    }

    public boolean isGuideSyncRequired() {
        boolean hasXDP = !"".equals(this.getXdpRef());
        return hasXDP && this.resourceProps.containsKey((Object)"formModelChanged");
    }

    private boolean isSignerAuthenticationCorrect(ValueMap signerProperties) {
        return !"PHONE".equals(signerProperties.get("securityOption", (Object)"")) || !StringUtils.isEmpty((CharSequence)((CharSequence)signerProperties.get("countryCode", (Object)""))) && !StringUtils.isEmpty((CharSequence)((CharSequence)signerProperties.get("phone", (Object)"")));
    }

    public boolean isAdobeSignEnabled() {
        return Boolean.valueOf((String)this.resourceProps.get("_useSignedPdf", (Object)Boolean.FALSE.toString()));
    }

    public boolean isDoRSubmissionEnabled() {
        return Boolean.valueOf((String)this.resourceProps.get("enableDoRSubmission", (Object)Boolean.FALSE.toString()));
    }

    public boolean isFormFillerFirstSigner() {
        if (this.isAdobeSignEnabled()) {
            Resource signerInfoResource = this.getResource().getChild("signerInfo");
            ValueMap signerInfoProperties = signerInfoResource.getValueMap();
            return Boolean.valueOf((String)signerInfoProperties.get("firstSignerFormFiller", (Object)Boolean.FALSE.toString()));
        }
        return false;
    }

    public boolean isSignatureConfiguredCorrectly() {
        if (this.isAdobeSignEnabled()) {
            Resource signerInfoResource = this.getResource().getChild("signerInfo");
            ValueMap signerInfoProperties = signerInfoResource.getValueMap();
            if (StringUtils.isEmpty((CharSequence)((CharSequence)signerInfoProperties.get("signConfigPath", (Object)""))) || StringUtils.isEmpty((CharSequence)((CharSequence)signerInfoProperties.get("workflowType", (Object)"")))) {
                return false;
            }
            Iterator signers = signerInfoResource.getChildren().iterator();
            if (!signers.hasNext()) {
                return false;
            }
            Resource firstSigner = (Resource)signers.next();
            ValueMap firstSignerProperties = firstSigner.getValueMap();
            if (!(this.isFormFillerFirstSigner() && "userProfile".equals(firstSignerProperties.get("emailSource", (Object)"")) || !StringUtils.isEmpty((CharSequence)((CharSequence)firstSignerProperties.get("email", (Object)""))))) {
                return false;
            }
            if (!this.isSignerAuthenticationCorrect(firstSignerProperties)) {
                return false;
            }
            while (signers.hasNext()) {
                Resource signer = (Resource)signers.next();
                ValueMap signerProperties = signer.getValueMap();
                if (StringUtils.isEmpty((CharSequence)((CharSequence)signerProperties.get("email", (Object)"")))) {
                    return false;
                }
                if (this.isSignerAuthenticationCorrect(signerProperties)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMetaTemplateUpdated() {
        Resource metaTemplateResource;
        boolean isUpdated = false;
        String metaTemplateRef = this.getMetaTemplateRef();
        Date lmtOfMetaTemplate = new Date();
        Date lmtOfPrint = new Date();
        if (this.getResource() != null) {
            Resource print = this.getResource().getChild("view/print");
            if (print != null) {
                ValueMap map = print.getValueMap();
                lmtOfPrint = (Date)map.get("jcr:lastModified", (Object)lmtOfPrint);
            }
        } else {
            return false;
        }
        ResourceResolver resourceResolver = this.getResource().getResourceResolver();
        Resource resource = metaTemplateResource = StringUtils.isNotBlank((CharSequence)metaTemplateRef) ? resourceResolver.getResource(metaTemplateRef) : null;
        if (metaTemplateResource != null) {
            ValueMap map = metaTemplateResource.getValueMap();
            lmtOfMetaTemplate = (Date)map.get("jcr:created", Date.class);
            Resource jcrContent = metaTemplateResource.getChild("jcr:content");
            if (jcrContent != null && (map = jcrContent.getValueMap()).containsKey((Object)"jcr:lastModified")) {
                lmtOfMetaTemplate = (Date)map.get("jcr:lastModified", Date.class);
            }
        }
        if (lmtOfMetaTemplate.after(lmtOfPrint)) {
            isUpdated = true;
        }
        return isUpdated;
    }

    public boolean isShowAuthoringWarnings() {
        String resourceType = GuideUtils.getNormalizedNodeType(this.getResourceType(), this.getResourceSuperType());
        boolean showWarnings = true;
        if ("fd/adaddon/components/guideDocumentContainer".equals(resourceType) || "fd/ccm/web-channel/components/documentContainer/v1/documentContainer".equals(resourceType)) {
            showWarnings = false;
        }
        return showWarnings;
    }

    public String getStatusBarTitle() {
        I18n i18n = new I18n(this.slingRequest.getResourceBundle(this.slingRequest.getLocale()));
        return i18n.get("Adaptive Form Warnings");
    }

    public String getMobileLayout() {
        String returnLayout = "fd/af/layouts/mobile/simple";
        String mobileLayout = null;
        try {
            mobileLayout = (String)this.getLayoutProperty("mobileLayout");
        }
        catch (PersistenceException e) {
            this.logger.error("Exception while retrieving mobile layout. " + e.getMessage(), (Throwable)e);
        }
        if (mobileLayout != null && !mobileLayout.isEmpty()) {
            returnLayout = mobileLayout;
        }
        return returnLayout;
    }

    public Boolean getParseGridLayoutForMenu() {
        Boolean parseGridLayoutForMenu = null;
        try {
            parseGridLayoutForMenu = Boolean.valueOf(String.valueOf(this.getLayoutProperty("parseGridLayoutForMenu")));
        }
        catch (PersistenceException e) {
            this.logger.error("Exception while retrieving parseGridLayoutForMenu check. " + e.getMessage(), (Throwable)e);
        }
        if (parseGridLayoutForMenu == null) {
            parseGridLayoutForMenu = Boolean.FALSE;
        }
        return parseGridLayoutForMenu;
    }

    public String getXDPName() {
        String xdpRef = this.getXdpRef();
        if (xdpRef != null && xdpRef.length() > 0) {
            return StringUtils.substring((String)xdpRef, (int)(StringUtils.lastIndexOf((CharSequence)xdpRef, (CharSequence)"/") + 1));
        }
        return null;
    }

    public boolean isXDPValid() {
        return GuideUtils.isXDPValid(this.getResource());
    }

    public List<String> getGuideIntegrationServiceScriptPaths() {
        SlingBindings bindings = (SlingBindings)this.slingRequest.getAttribute(SlingBindings.class.getName());
        GuideIntegrationService guideIntegrationService = (GuideIntegrationService)bindings.getSling().getService(GuideIntegrationService.class);
        return guideIntegrationService.getScriptPaths();
    }

    public void setRenderCall(boolean isRenderCall) {
        this.renderCall = isRenderCall;
    }

    public boolean isRenderCall() {
        return this.renderCall;
    }

    public JSONObject getCustomContextPropJson(HttpServletRequest request) {
        Object attr = request.getAttribute("customContextProperty");
        JSONObject customContextPropJson = new JSONObject();
        if (attr != null) {
            try {
                customContextPropJson = new JSONObject(attr.toString());
            }
            catch (JSONException e) {
                this.logger.error("Failed to parse JSON for customContextProperty attribute", (Throwable)e);
            }
        }
        return customContextPropJson;
    }

    public String getPagePath() {
        String path = "";
        Resource parent = this.getResource();
        while ((parent = parent.getParent()) != null) {
            if (!parent.isResourceType("foundation/components/page") && !parent.isResourceType("wcm/foundation/components/page")) continue;
            path = parent.getPath();
        }
        return path;
    }

    public boolean isMetaTemplateValid() {
        String metaTemplateRef = this.getMetaTemplateRef();
        return GuideUtils.isMetaTemplateValid(this.getResource().getResourceResolver(), metaTemplateRef);
    }

    public static GuideContainer from(Resource resource) {
        return new GuideContainer(resource);
    }

    public static GuideContainer from(SlingHttpServletRequest request, Resource resource) {
        return new GuideContainer(request, resource);
    }

    private String getFormType() {
        return (String)this.resourceProps.get("fd:formtype", (Object)"");
    }
}

