/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideError;
import com.adobe.aemds.guide.utils.GuideSubmitErrorCause;
import java.util.List;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideValidationResult {
    private GuideSubmitErrorCause errorCausedBy;
    private String errorMessage;
    private List<GuideError> guideErrorList;
    private String originCode = null;
    private String originMessage = null;
    private static Logger logger = LoggerFactory.getLogger(GuideValidationResult.class);

    public GuideValidationResult() {
    }

    public GuideValidationResult(List<GuideError> guideErrorList) {
        this(guideErrorList, GuideSubmitErrorCause.SERVER_SIDE_VALIDATION);
    }

    public GuideValidationResult(List<GuideError> guideErrorList, GuideSubmitErrorCause errorCausedBy) {
        this.guideErrorList = guideErrorList;
        this.errorCausedBy = errorCausedBy;
    }

    public GuideValidationResult(GuideSubmitErrorCause errorCausedBy, String errorMessage) {
        this.errorCausedBy = errorCausedBy;
        this.errorMessage = errorMessage;
    }

    public GuideValidationResult(GuideSubmitErrorCause errorCausedBy, String errorMessage, List<GuideError> guideErrorList) {
        this.errorCausedBy = errorCausedBy;
        this.errorMessage = errorMessage;
        this.guideErrorList = guideErrorList;
    }

    public GuideValidationResult(GuideSubmitErrorCause errorCausedBy, String originCode, String originMessage) {
        this.errorCausedBy = errorCausedBy;
        this.originCode = originCode;
        this.originMessage = originMessage;
    }

    public GuideValidationResult(GuideSubmitErrorCause errorCausedBy, int originCode, String originMessage) {
        this(errorCausedBy, Integer.toString(originCode), originMessage);
    }

    public List<GuideError> getGuideErrorList() {
        return this.guideErrorList;
    }

    public void setGuideErrorList(List<GuideError> guideErrorList) {
        this.setGuideErrorList(guideErrorList, GuideSubmitErrorCause.SERVER_SIDE_VALIDATION);
    }

    public void setOriginDetails(String originCode, String originDetails) {
        this.originCode = originCode;
        this.originMessage = originDetails;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setOriginCode(String originCode) {
        this.originCode = originCode;
    }

    public void setOriginMessage(String originMessage) {
        this.originMessage = originMessage;
    }

    public void setGuideErrorList(List<GuideError> guideErrorList, GuideSubmitErrorCause errorCausedBy) {
        this.guideErrorList = guideErrorList;
        this.errorCausedBy = errorCausedBy;
    }

    public GuideSubmitErrorCause getErrorCause() {
        return this.errorCausedBy;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getOriginCode() {
        return this.originCode;
    }

    public String getOriginMessage() {
        return this.originMessage;
    }

    public boolean hasErrors() {
        return this.guideErrorList != null && this.guideErrorList.size() > 0;
    }

    public JSONObject getValidationPayload() {
        return this.getErrorJsonObject();
    }

    private JSONObject getErrorJsonObject() {
        JSONObject errorJson = new JSONObject();
        try {
            errorJson.put("errorCausedBy", (Object)this.errorCausedBy);
            errorJson.put("errorMessage", (Object)this.errorMessage);
            errorJson.put("errors", (Object)this.getErrors(this.guideErrorList));
            errorJson.putOpt("originCode", (Object)this.originCode);
            errorJson.putOpt("originMessage", (Object)this.originMessage);
        }
        catch (JSONException e) {
            logger.error("Error while writing JSON.", (Throwable)e);
        }
        return errorJson;
    }

    private JSONArray getErrors(List<GuideError> errorList) {
        JSONArray errors = null;
        if (errorList != null) {
            errors = new JSONArray();
            for (GuideError guideError : errorList) {
                JSONObject object = new JSONObject();
                try {
                    object.putOpt("somExpression", (Object)guideError.getSomExpression());
                    object.putOpt("bindRef", (Object)guideError.getBindRef());
                    object.putOpt("errorMessage", (Object)guideError.getErrorMessage());
                    List<String> messages = guideError.getErrorMessages();
                    if (messages != null && !messages.isEmpty()) {
                        JSONArray jsonArray = new JSONArray();
                        for (String msg : messages) {
                            jsonArray.put((Object)msg);
                        }
                        object.putOpt("errorMessages", (Object)jsonArray);
                    }
                }
                catch (JSONException e) {
                    logger.error("Error while converting into JSON.", (Throwable)e);
                }
                errors.put((Object)object);
            }
        }
        return errors;
    }

    public static interface OriginCodeStatus {
        public static final String OC_BAD_REQUEST = "400";
        public static final String OC_INTERNAL_SERVER_ERROR = "500";
    }
}

