/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.workflow.api;

import com.adobe.aemfd.docmanager.Document;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Component(immediate=true)
@Service(value={XPathUtils.class})
public class XPathUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> query(Document xmlDoc, Map<String, QName> queries) throws ParserConfigurationException, IOException, SAXException, XPathException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        HashMap<String, Object> res = new HashMap<String, Object>(queries.size());
        try (InputStream is = xmlDoc.getInputStream();){
            org.w3c.dom.Document doc = builder.parse(is);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            for (Map.Entry<String, QName> me : queries.entrySet()) {
                String xpathQuery = me.getKey();
                QName type = me.getValue();
                XPathExpression expr = xpath.compile(xpathQuery);
                Object val = type == null ? expr.evaluate(doc) : expr.evaluate(doc, type);
                res.put(xpathQuery, val);
            }
        }
        return res;
    }

    public Object query(Document xmlDoc, String xpathQuery, QName type) throws ParserConfigurationException, IOException, SAXException, XPathException {
        Map<String, Object> res = this.query(xmlDoc, Collections.singletonMap(xpathQuery, type));
        return res.values().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> query(String xmlJcrPath, ResourceResolver rr, Map<String, QName> queries) throws ParserConfigurationException, IOException, SAXException, XPathException {
        Document xmlDoc = new Document(xmlJcrPath, rr);
        try {
            Map<String, Object> map = this.query(xmlDoc, queries);
            return map;
        }
        finally {
            xmlDoc.dispose();
        }
    }

    public Object query(String xmlJcrPath, ResourceResolver rr, String xpathQuery, QName type) throws ParserConfigurationException, IOException, SAXException, XPathException {
        Map<String, Object> res = this.query(xmlJcrPath, rr, Collections.singletonMap(xpathQuery, type));
        return res.values().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document update(Document xmlDoc, Map<String, String> values) throws ParserConfigurationException, IOException, SAXException, XPathException, TransformerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (InputStream is = xmlDoc.getInputStream();){
            org.w3c.dom.Document doc = builder.parse(is);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            for (Map.Entry<String, String> me : values.entrySet()) {
                String xpathQuery = me.getKey();
                XPathExpression expr = xpath.compile(xpathQuery);
                Object n = expr.evaluate(doc, XPathConstants.NODE);
                if (n == null || !(n instanceof Node)) {
                    throw new XPathException("Value " + n + " at query path " + xpathQuery + " does not resolve to a Node object!");
                }
                Node node = (Node)n;
                node.setTextContent(me.getValue());
            }
            DOMSource domSource = new DOMSource(doc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            Document document = new Document(baos.toByteArray());
            return document;
        }
    }

    public Document update(Document xmlDoc, String xpathQuery, String value) throws ParserConfigurationException, IOException, SAXException, XPathException, TransformerException {
        return this.update(xmlDoc, Collections.singletonMap(xpathQuery, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String xmlJcrPath, ResourceResolver rr, Map<String, String> values, boolean save) throws ParserConfigurationException, IOException, SAXException, XPathException, TransformerException, RepositoryException {
        Document origDoc = new Document(xmlJcrPath, rr);
        try {
            Document newDoc = this.update(origDoc, values);
            try {
                Session sess = (Session)rr.adaptTo(Session.class);
                javax.jcr.Node xmlNode = sess.getNode(xmlJcrPath);
                javax.jcr.Node resNode = xmlNode.getNode("jcr:content");
                try (InputStream is = newDoc.getInputStream();){
                    Binary bin = sess.getValueFactory().createBinary(is);
                    resNode.setProperty("jcr:data", bin);
                    if (save) {
                        sess.save();
                    }
                }
            }
            finally {
                newDoc.dispose();
            }
        }
        finally {
            origDoc.dispose();
        }
    }

    public void update(String xmlJcrPath, ResourceResolver rr, String xpathQuery, String value, boolean save) throws ParserConfigurationException, IOException, SAXException, XPathException, TransformerException, RepositoryException {
        this.update(xmlJcrPath, rr, Collections.singletonMap(xpathQuery, value), save);
    }
}

