/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.common.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class XFAUtils {
    private static final String FORMS_MANAGER_RESOURCE_TYPE = "fd/fm/xfaforms/render";
    private static final String METADATA = "metadata";
    private static final String SUBMIT_URL = "submitUrl";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String PROTOCOL_CRX = "crx://";

    private static boolean isResourceFormsManager(Resource resource) {
        if (resource != null) {
            String resourceType = resource.getResourceType();
            return StringUtils.isNotBlank((CharSequence)resourceType) && resourceType.equals(FORMS_MANAGER_RESOURCE_TYPE);
        }
        return false;
    }

    private static String getRequestAttribute(SlingHttpServletRequest slingRequest, String param) {
        Object valObj = slingRequest.getAttribute(SUBMIT_URL);
        String value = "";
        if (valObj != null && valObj instanceof String) {
            value = (String)valObj;
        }
        return value;
    }

    private static Resource getFormsManagerResource(SlingHttpServletRequest slingRequest, String contentRoot, String template) {
        Resource formManagerResource = null;
        if (StringUtils.isNotBlank((CharSequence)contentRoot) && StringUtils.isNotBlank((CharSequence)template)) {
            String resourcePath = contentRoot.replace(PROTOCOL_CRX, "") + "/" + template;
            Resource resource = slingRequest.getResourceResolver().getResource(resourcePath);
            if (resource != null) {
                formManagerResource = resource.getChild(JCR_CONTENT);
            }
        }
        return formManagerResource;
    }

    public static String getSubmitUrl(SlingHttpServletRequest slingRequest, String contentRoot, String template) {
        String formsManagerSubmitUrl = null;
        Resource formManagerResource = XFAUtils.getFormsManagerResource(slingRequest, contentRoot, template);
        String submitUrlParameter = slingRequest.getParameter(SUBMIT_URL);
        String submitUrlAttribute = XFAUtils.getRequestAttribute(slingRequest, SUBMIT_URL);
        String submitUrl = "";
        if (XFAUtils.isResourceFormsManager(formManagerResource)) {
            ValueMap managerProperties = (ValueMap)formManagerResource.getChild(METADATA).adaptTo(ValueMap.class);
            formsManagerSubmitUrl = (String)managerProperties.get(SUBMIT_URL, (Object)"");
        }
        if (StringUtils.isNotBlank((CharSequence)submitUrlAttribute) && !submitUrlAttribute.equals(formsManagerSubmitUrl)) {
            submitUrl = submitUrlAttribute;
        } else if (StringUtils.isNotBlank((CharSequence)submitUrlParameter)) {
            submitUrl = submitUrlParameter;
        }
        return submitUrl;
    }
}

