/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.model.AbstractAsset;
import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.IOperation;
import com.adobe.aem.dermis.model.ISchema;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;

public class Schema
extends AbstractAsset
implements ISchema {
    private String $schema;
    private List<IDataModel> definitions;
    private List<IOperation> operations;
    private String[] oneOf;

    public Schema() {
    }

    public Schema(String name) {
        super(name);
    }

    public Schema(String name, List<IDataModel> dataModels) {
        this(name);
        this.definitions = dataModels;
    }

    public String[] getOneOf() {
        return this.oneOf;
    }

    public void setOneOf(String[] oneOf) {
        this.oneOf = oneOf;
    }

    public String get$schema() {
        return this.$schema;
    }

    public void set$schema(String $schema) {
        this.$schema = $schema;
    }

    public List<IDataModel> getDataModels() {
        return this.definitions;
    }

    public void setDataModels(List<IDataModel> dataModels) {
        this.definitions = dataModels;
    }

    public List<IOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<IOperation> operations) {
        this.operations = operations;
    }

    @JsonIgnore
    public int getDataModelCount() {
        int count = 0;
        if (this.getDataModels() != null) {
            count = this.getDataModels().size();
        }
        return count;
    }

    @JsonIgnore
    public String[] getDataModelNames() {
        String[] names = null;
        if (this.getDataModels() != null) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (IDataModel dataModel : this.getDataModels()) {
                if (dataModel == null) continue;
                nameList.add(dataModel.getName());
            }
            names = nameList.toArray(new String[0]);
        }
        return names;
    }

    public IDataModel getDataModelByName(String dataModelName) {
        IDataModel dataModel = null;
        if (this.getDataModels() != null) {
            ArrayList nameList = new ArrayList();
            for (IDataModel dm : this.getDataModels()) {
                if (dm == null || !dm.getName().equals(dataModelName)) continue;
                dataModel = dm;
                break;
            }
        }
        return dataModel;
    }
}

