/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model;

import com.adobe.aemds.guide.fdfl.utils.XMLUtils;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.service.FormDataWrapper;
import com.adobe.forms.foundation.utils.DocumentBuilderUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FormSubmitInfo
extends FormDataWrapper {
    private Resource formContainerResource;
    private String formContainerPath;
    private String locale;
    private String fileAttachmentMap;
    private FileAttachmentWrapper documentOfRecord;
    private String formSubmitter;
    private byte[] signData;
    private String agreementId;
    private PortalRecordInfo portalRecordInfo;
    private String draftId;
    private static final Logger logger = LoggerFactory.getLogger(FormSubmitInfo.class);

    public String getFormContainerPath() {
        return this.formContainerPath;
    }

    public void setFormContainerPath(String formContainerPath) {
        this.formContainerPath = formContainerPath;
    }

    @Override
    public void setData(String data) {
        data = this.addMetaInfoInData(data);
        super.setData(data);
    }

    public FileAttachmentWrapper getDocumentOfRecord() {
        return this.documentOfRecord;
    }

    public void setDocumentOfRecord(FileAttachmentWrapper documentOfRecord) {
        this.documentOfRecord = documentOfRecord;
    }

    public String getFileAttachmentMap() {
        return this.fileAttachmentMap;
    }

    public void setFileAttachmentMap(String fileAttachmentMap) {
        this.fileAttachmentMap = fileAttachmentMap;
    }

    public Resource getFormContainerResource() {
        return this.formContainerResource;
    }

    public void setFormContainerResource(Resource formContainerResource) {
        this.formContainerResource = formContainerResource;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getDraftId() {
        return this.draftId;
    }

    public void setDraftId(String draftId) {
        this.draftId = draftId;
    }

    public String getFormSubmitter() {
        return this.formSubmitter;
    }

    public void setFormSubmitter(String formSubmitter) {
        this.formSubmitter = formSubmitter;
    }

    public byte[] getSignData() {
        return this.signData;
    }

    public void setSignData(byte[] signData) {
        this.signData = signData;
    }

    public String getAgreementId() {
        return this.agreementId;
    }

    public void setAgreementId(String agreementId) {
        this.agreementId = agreementId;
        super.setData(this.addAgreementIdInFormData(this.getData()));
    }

    private String addAgreementIdInFormData(String formData) {
        String response = formData;
        try {
            if (this.agreementId != null) {
                ValueMap properties = ResourceUtil.getValueMap((Resource)this.formContainerResource);
                String agreementIdBindRef = null;
                if (properties != null) {
                    String agreementIdBindRefField = "_agreementIdBindRef";
                    agreementIdBindRef = (String)properties.get(agreementIdBindRefField, (Object)"");
                }
                switch (MimeContentType.getMimeType(this.getContentType())) {
                    case APPLICATION_XML: {
                        String updatePath;
                        Document dataDoc = FormSubmitInfo.getDomFromXMLString(formData);
                        XPath xPath = XPathFactory.newInstance().newXPath();
                        if (dataDoc == null) break;
                        if (!StringUtils.isEmpty((CharSequence)agreementIdBindRef)) {
                            updatePath = String.format("%s%s", "afBoundData", agreementIdBindRef);
                            XMLUtils.addToDocument((Document)dataDoc, (XPath)xPath, (Node)dataDoc.getDocumentElement(), (String)updatePath, (Object)this.agreementId);
                        }
                        updatePath = String.format("%s/%s", "afSubmissionInfo", "agreementId");
                        XMLUtils.addToDocument((Document)dataDoc, (XPath)xPath, (Node)dataDoc.getDocumentElement(), (String)updatePath, (Object)this.agreementId);
                        response = GuideUtils.nodeToString(dataDoc, false);
                        break;
                    }
                    case APPLICATION_JSON: {
                        String updatePath;
                        JSONObject dataJsonObject = new JSONObject(formData);
                        if (!StringUtils.isEmpty((CharSequence)agreementIdBindRef)) {
                            updatePath = String.format("%s/%s/%s%s", "afData", "afBoundData", "data", agreementIdBindRef);
                            this.updateJsonObject(dataJsonObject, updatePath, this.agreementId);
                        }
                        updatePath = String.format("%s/%s/%s", "afData", "afSubmissionInfo", "agreementId");
                        this.updateJsonObject(dataJsonObject, updatePath, this.agreementId);
                        response = dataJsonObject.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in adding agreement id in form data json", (Throwable)e);
        }
        return response;
    }

    private void updateJsonObject(JSONObject dataJsonObject, String updatePath, String value) throws JSONException {
        if (StringUtils.isEmpty((CharSequence)updatePath) || updatePath.startsWith("/") || updatePath.endsWith("/")) {
            return;
        }
        int lastSlashIdx = updatePath.lastIndexOf("/");
        if (lastSlashIdx != -1) {
            String key = updatePath.substring(lastSlashIdx + 1);
            String path = updatePath.substring(0, lastSlashIdx);
            JSONObject nodeToUpdate = dataJsonObject;
            for (String node : path.split("/")) {
                if (!nodeToUpdate.has(node)) {
                    nodeToUpdate.put(node, (Object)new JSONObject());
                }
                nodeToUpdate = nodeToUpdate.getJSONObject(node);
            }
            nodeToUpdate.put(key, (Object)value);
        }
    }

    public PortalRecordInfo getPortalRecordInfo() {
        return this.portalRecordInfo;
    }

    public void setPortalRecordInfo(PortalRecordInfo portalRecordInfo) {
        this.portalRecordInfo = portalRecordInfo;
    }

    private String addMetaInfoInData(String data) {
        String messagedData = data;
        switch (MimeContentType.getMimeType(this.getContentType())) {
            case APPLICATION_XML: {
                messagedData = FormSubmitInfo.addSubmissionInfoMetaDataToXML(data, this.formContainerPath, this.getDateForSubmissionTime());
                break;
            }
            case APPLICATION_JSON: {
                messagedData = this.addSubmissionInfoMetaDataToJson(data);
            }
        }
        return messagedData;
    }

    private String addSubmissionInfoMetaDataToJson(String data) {
        String messagedData = data;
        try {
            JSONObject dataJsonObject = new JSONObject(data);
            JSONObject submissionInfoRootTag = dataJsonObject.optJSONObject("afData").optJSONObject("afSubmissionInfo");
            if (submissionInfoRootTag != null) {
                if (this.formContainerPath != null) {
                    String formDamPath = GuideUtils.convertGuideContainerPathToFMAssetPath(this.formContainerPath);
                    submissionInfoRootTag.put("afPath", (Object)formDamPath);
                }
                submissionInfoRootTag.put("afSubmissionTime", (Object)this.getDateForSubmissionTime());
            }
            messagedData = dataJsonObject.toString();
        }
        catch (Exception e) {
            logger.error("Error in adding submission meta data to JSON " + e.getMessage(), (Throwable)e);
        }
        return messagedData;
    }

    private static String addSubmissionInfoMetaDataToXML(String data, String formContainerPath, String submissionTime) {
        String submissionData = data;
        Document dataDoc = FormSubmitInfo.getDomFromXMLString(data);
        Element submissionInfoRootTag = null;
        XPath xPath = XPathFactory.newInstance().newXPath();
        if (dataDoc != null) {
            String xPathString = "afSubmissionInfo";
            Node afSubmissionInfo = null;
            try {
                afSubmissionInfo = (Node)xPath.evaluate(xPathString, dataDoc.getDocumentElement(), XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                throw new GuideException("AF: FormSubmitInfo Error in getting bound xml part " + e.getMessage(), e);
            }
            submissionInfoRootTag = (Element)afSubmissionInfo;
        }
        if (submissionInfoRootTag != null) {
            try {
                Element node;
                if (formContainerPath != null) {
                    String formDamPath = GuideUtils.convertGuideContainerPathToFMAssetPath(formContainerPath);
                    Element node2 = (Element)xPath.evaluate("afSubmissionInfo/afPath", dataDoc.getDocumentElement(), XPathConstants.NODE);
                    if (node2 == null) {
                        submissionInfoRootTag.appendChild(FormSubmitInfo.createXMLTag(dataDoc, "afPath", formDamPath));
                    } else {
                        node2.setTextContent(formDamPath);
                    }
                }
                if ((node = (Element)xPath.evaluate("afSubmissionInfo/afSubmissionTime", dataDoc.getDocumentElement(), XPathConstants.NODE)) == null) {
                    submissionInfoRootTag.appendChild(FormSubmitInfo.createXMLTag(dataDoc, "afSubmissionTime", submissionTime));
                } else {
                    node.setTextContent(submissionTime);
                }
                submissionData = GuideUtils.nodeToString(dataDoc, false);
            }
            catch (XPathExpressionException e) {
                logger.debug("[AF]XMLUtils error in adding submission metaInfo", (Throwable)e);
            }
        }
        return submissionData;
    }

    private static Element createXMLTag(Document dataDoc, String key, String value) {
        Element childTag = dataDoc.createElement(key);
        childTag.setTextContent(value);
        return childTag;
    }

    private static Document getDomFromXMLString(String xmlString) {
        Document dataDoc = null;
        if (StringUtils.isNotEmpty((CharSequence)xmlString)) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilderUtil.disableExternalEntities(dbf);
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                dataDoc = db.parse(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.debug("[AF]:[XMLUtils] failed to get XML Document from data");
            }
        }
        return dataDoc;
    }

    private String getDateForSubmissionTime() {
        return new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
    }

    private static enum MimeContentType {
        APPLICATION_XML("application/xml"),
        APPLICATION_JSON("application/json");

        private final String mimeType;

        private MimeContentType(String mimeType) {
            this.mimeType = mimeType;
        }

        static MimeContentType getMimeType(String mimeType) {
            MimeContentType retVal = APPLICATION_XML;
            for (MimeContentType mimeContentType : MimeContentType.values()) {
                if (!StringUtils.equals((CharSequence)mimeContentType.mimeType, (CharSequence)mimeType)) continue;
                retVal = mimeContentType;
                break;
            }
            return retVal;
        }
    }
}

