/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fmdita.api.maps;

import com.adobe.dxml.util.DynamicBaselineUtils;
import com.adobe.fmdita.common.DependencyParser;
import com.adobe.fmdita.common.ExportDitamap;
import com.adobe.fmdita.common.ExportDitamapUtils;
import com.adobe.fmdita.common.MiscUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtilities {
    private static final Logger log = LoggerFactory.getLogger(MapUtilities.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipMapWithDependents(Session session, String sourcePath, String baseline, OutputStream outputStream, boolean flatFS) throws RepositoryException, IOException {
        DynamicBaselineUtils.getInstance().checkDynamicBaseline(sourcePath, baseline, session);
        long startTime = System.nanoTime();
        ExportDitamap executor = new ExportDitamap(sourcePath, baseline, session, flatFS);
        Path tempFolder = executor.execute();
        long stopTime = System.nanoTime();
        log.debug("time take to exportditamap {} {} {}", new Object[]{sourcePath, baseline, (stopTime - startTime) / 1000000L});
        try {
            MiscUtils.zipFiles((Path)tempFolder, (OutputStream)outputStream, null);
        }
        catch (Exception e) {
            log.error("Export Failed", (Throwable)e);
        }
        finally {
            FileUtils.deleteDirectory((File)tempFolder.toFile());
        }
    }

    public static void zipMapWithDependents(Session session, String sourcePath, String baseline, OutputStream outputStream) throws RepositoryException, IOException {
        MapUtilities.zipMapWithDependents(session, sourcePath, baseline, outputStream, false);
    }

    public static List<HashMap<String, String>> getBaselineList(Session session, String sourcePath) throws RepositoryException {
        return com.adobe.fmdita.ditamaputils.MapUtilities.getBaselineList((Session)session, (String)sourcePath);
    }

    public static List<HashMap<String, String>> getConditionalPresetList(Session session, String sourcePath) throws RepositoryException {
        return com.adobe.fmdita.ditamaputils.MapUtilities.getConditionalPresetList((Session)session, (String)sourcePath);
    }

    public static String getDitavalFromConditionalPreset(Session session, String sourcePath, String cpName) throws RepositoryException {
        return com.adobe.fmdita.ditamaputils.MapUtilities.getDitavalFromConditionalPreset((Session)session, (String)sourcePath, (String)cpName);
    }

    public static List<Node> getAllDependencies(Node rootNode) throws Exception {
        DependencyParser parser = new DependencyParser(rootNode);
        return parser.bfsTraversal(rootNode.getSession());
    }

    public static CompletableFuture<Node> zipMapWithDependencies(Session session, String sourcePath, String baseline, boolean flatFS) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                DynamicBaselineUtils.getInstance().checkDynamicBaseline(sourcePath, baseline, session);
                long startTime = System.nanoTime();
                ExportDitamap executor = new ExportDitamap(sourcePath, baseline, session, flatFS);
                Path diskPath = executor.execute();
                long stopTime = System.nanoTime();
                log.debug("time take to export ditamap {} {} {}", new Object[]{sourcePath, baseline, (stopTime - startTime) / 1000000L});
                ExportDitamapUtils exportDitamapUtils = new ExportDitamapUtils();
                Node resultNode = exportDitamapUtils.exportMapAsZipNode(diskPath, session);
                FileUtils.deleteDirectory((File)diskPath.toFile());
                return resultNode;
            }
            catch (IOException | RepositoryException e) {
                throw new CompletionException(e);
            }
        });
    }
}

